/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.factedoutput;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.business.config.service.CostObjectService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.dto.OutSourcePrice;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ImportInitCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.factedoutput.AbstractCompletionAction;
import kd.macc.cad.mservice.factedoutput.CompletionArgs;
import kd.macc.cad.mservice.factedoutput.CompletionCheckAbsorbAction;
import kd.macc.cad.mservice.factedoutput.CompletionContext;
import kd.macc.cad.mservice.factedoutput.ScaCompletionWriteCostChangeConfigAction;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CompletionImportDataConfigAction
extends AbstractCompletionAction {
    private Log logger = LogFactory.getLog(CompletionImportDataConfigAction.class);

    @Override
    protected void doExecute() {
        CompletionContext completionContext = this.getCompletionContext();
        CompletionArgs completionArgs = completionContext.getCompletionArgs();
        Map<Long, Set<Long>> acctOrgCostCentersMap = completionContext.getAcctOrgCostCentersMap();
        Map<String, List<Long>> orgMethodCostCenters = completionContext.getOrgMethodCostCenters();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = completionContext.getConfigSrcAndTargetBillsMap();
        Map<Long, String> dimensionAndRuleMap = completionContext.getDimensionAndRuleMap();
        Map<Long, Map<String, String>> collConfigMappingMap = completionContext.getCollConfigMappingMap();
        Map<Long, Map<String, String>> collConfigRuleMappingMap = completionContext.getCollConfigRuleMappingMap();
        for (Map.Entry<Long, Set<Long>> orgAndCostCenter : acctOrgCostCentersMap.entrySet()) {
            String sourcebill;
            DynamicObject config;
            Long accountOrg = orgAndCostCenter.getKey();
            List<Long> orderCostCenters = orgMethodCostCenters.get(String.valueOf(accountOrg).concat(CostObjectEnum.BIZTYPE_RO.getValue()));
            if (CadEmptyUtils.isEmpty(orderCostCenters)) {
                this.logger.info("\u672a\u627e\u5230\u5de5\u5355\u6cd5\u6210\u672c\u4e2d\u5fc3\uff0c\u5de5\u5355\u6cd5\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u7ed3\u675f");
                return;
            }
            Map<Long, String> outSourcePrice = null;
            Map<String, Long> accountManuorgAndCosttype = null;
            Map<Long, Map<Long, Set<OutSourcePrice>>> costtypeAndMaterialAndOutPrice = null;
            this.getCompletionContext().getCollectReport().setReProCostCenters(orderCostCenters);
            boolean isContainsOmBill = false;
            for (Map.Entry<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
                config = configSrcAndTargetBill.getKey();
                sourcebill = config.getString("sourcebill.id");
                if (!"im_mdc_omcmplinbill".equals(sourcebill)) continue;
                isContainsOmBill = true;
                break;
            }
            if ("sca".equals(completionArgs.getAppNum()) && isContainsOmBill) {
                outSourcePrice = this.getOutSourcePrice(accountOrg, completionArgs.getAppNum());
                accountManuorgAndCosttype = this.getCosttypeMap(completionArgs.getManuOrgs());
                costtypeAndMaterialAndOutPrice = this.getOurPriceMap(accountManuorgAndCosttype);
                if (!completionContext.isCheckGenResourceAbsoub()) {
                    CompletionCheckAbsorbAction checkAbsorbAction = new CompletionCheckAbsorbAction(orderCostCenters, accountManuorgAndCosttype, costtypeAndMaterialAndOutPrice);
                    checkAbsorbAction.setContext(this.getCompletionContext());
                    checkAbsorbAction.execute();
                    completionContext.setCheckGenResourceAbsoub(true);
                }
            }
            for (Map.Entry<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
                config = configSrcAndTargetBill.getKey();
                sourcebill = config.getString("sourcebill.id");
                String sourcebillName = config.getString("sourcebill.name");
                if (!CostObjectEnum.BIZTYPE_RO.getValue().equals(config.getString("calmethod"))) continue;
                TreeMap<String, String> configRuleMappingMap = new TreeMap<String, String>(collConfigRuleMappingMap.get(config.getLong("id")));
                Map<String, String> configMappingMap = collConfigMappingMap.get(config.getLong("id"));
                Map<DynamicObject, DynamicObject> srcAndTargetBillsMap = configSrcAndTargetBill.getValue();
                ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
                Set<Long> manuIds = this.getCollectManuEntryIds(configRuleMappingMap, srcBills);
                if (CadEmptyUtils.isEmpty(completionArgs.getMftOrderEntryIds())) {
                    CostObjectService.autoGenerateCostobject((Long)accountOrg, orderCostCenters, completionArgs.getManuOrgs(), (CollectReport)this.getCompletionContext().getCollectReport(), (String)completionArgs.getAppNum(), manuIds);
                }
                this.getCompletionContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%s", (String)"CompletionImportDataConfigAction_49", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName));
                this.getCompletionContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u201c%1$s\u201d%2$s\u6761\u6570\u636e\u3002", (String)"CompletionImportDataConfigAction_50", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName, srcBills.size()));
                long costcalcdimension = config.getLong("costcalcdimension.id");
                String dimension = dimensionAndRuleMap.get(costcalcdimension);
                if (CadEmptyUtils.isEmpty((String)dimension)) {
                    this.getCompletionContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"CompletionImportDataConfigAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u6ca1\u6709\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ef4\u5ea6\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"CompletionImportDataConfigAction_26", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                    continue;
                }
                String costObjectFields = "probill";
                Map existCostObjectMap = CostObjectHelper.getExistCostObjectMap((Long)accountOrg, null, (String)costObjectFields, (String)completionArgs.getAppNum(), new ArrayList<Long>(manuIds));
                this.getCompletionContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\uff0c\u5904\u7406\u6e90\u5355\u3002", (String)"CompletionImportDataConfigAction_30", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                List<DynamicObject> factnedBills = this.dealManuInBill(accountOrg, orderCostCenters, srcAndTargetBillsMap, existCostObjectMap, accountManuorgAndCosttype, costtypeAndMaterialAndOutPrice, configRuleMappingMap, configMappingMap, this.getCompletionContext().getIdEntryIdCompleteMap(), outSourcePrice, this.getCompletionContext().getExistBillNos(), sourcebill, completionArgs.getAppNum());
                this.getCompletionContext().getCollectReport().logCheckDesc(String.format(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u6570\u636e\u201c%s\u201d\u6761\u3002", (String)"CompletionImportDataConfigAction_31", (String)"macc-cad-mservice", (Object[])new Object[0]), factnedBills.size()), config.getString("number"), factnedBills.size()));
                if (!"sca".equals(this.getCompletionContext().getCompletionArgs().getAppNum())) continue;
                ScaCompletionWriteCostChangeConfigAction completionWriteCostChangeConfigAction = new ScaCompletionWriteCostChangeConfigAction();
                completionWriteCostChangeConfigAction.setContext(this.getCompletionContext());
                completionWriteCostChangeConfigAction.doExecute();
            }
        }
    }

    private Set<Long> getCollectManuEntryIds(Map<String, String> configRuleMappingMap, List<DynamicObject> srcBills) {
        HashSet manuIds = Sets.newHashSetWithExpectedSize((int)10);
        String srcBillField = configRuleMappingMap.get("probill");
        if (StringUtils.isEmpty((CharSequence)srcBillField)) {
            return manuIds;
        }
        for (DynamicObject dyn : srcBills) {
            manuIds.add(dyn.getLong(srcBillField));
        }
        return manuIds;
    }

    private List<DynamicObject> dealManuInBill(Long accountOrg, List<Long> costCenters, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, Map<String, DynamicObject>> existCostObjectMap, Map<String, Long> accountManuorgAndCosttype, Map<Long, Map<Long, Set<OutSourcePrice>>> costtypeAndMaterialAndOutPrice, TreeMap<String, String> collConfigRuleMappingMap, Map<String, String> configMappingMap, Map<String, DynamicObject> idEntryIdCompleteMap, Map<Long, String> outSourcePrice, Set<String> existBillNos, String sourceEntity, String appNum) {
        ArrayList<DynamicObject> factnedBills = new ArrayList<DynamicObject>(200);
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return factnedBills;
        }
        DynamicObject[] sourceBill = srcAndTargetBillsMap.keySet().toArray(new DynamicObject[0]);
        HashMap<String, DynamicObject> changeFactMap = new HashMap<String, DynamicObject>(16);
        String sourceBillEntity = sourceBill[0].getString("billtype");
        this.dealExitsData(idEntryIdCompleteMap, sourceBill, changeFactMap, appNum);
        Map costSyncInfoMap = ImportInitCostHelper.getCostRecordMap((DynamicObject[])sourceBill);
        List<DynamicObject> factnedBillList = this.getCompletionContext().getFactnedBills();
        Set willSaveBillNoSet = factnedBillList.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
        int updNum = 0;
        int addNum = 0;
        HashSet<Long> materialSet = new HashSet<Long>(200);
        Set<String> existsIds = idEntryIdCompleteMap.keySet();
        HashMap orgCostaccountMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap accountCurrencyMap = Maps.newHashMapWithExpectedSize((int)10);
        Map<String, List<Map<String, Object>>> bizentryCostInfoMap = null;
        if ("sca".equals(appNum)) {
            bizentryCostInfoMap = this.getMatCostInfo(srcAndTargetBillsMap, sourceEntity, changeFactMap, existsIds);
        }
        HashMap<String, DynamicObject> needDelDynMap = new HashMap<String, DynamicObject>(10);
        HashMap<Long, Tuple2> costobjectKeyColMap = new HashMap<Long, Tuple2>(10);
        HashSet<Long> keycolfieldUpdateSet = new HashSet<Long>(10);
        for (Map.Entry<DynamicObject, DynamicObject> dynamicObjectEntry : srcAndTargetBillsMap.entrySet()) {
            DynamicObject srcBill = dynamicObjectEntry.getKey();
            DynamicObject targetBill = dynamicObjectEntry.getValue();
            if (!sourceEntity.equals(srcBill.getString("billtype"))) continue;
            if (targetBill == null) {
                this.getCompletionContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u3002", (String)"CompletionImportDataConfigAction_52", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            String sourceId = srcBill.getString("id") + "-" + srcBill.getString("entryId");
            boolean isNeedChangeData = changeFactMap.containsKey(sourceId);
            if (existsIds.contains(sourceId) && !isNeedChangeData) {
                this.logger.info("\u6e90\u5355{}\u5df2\u5f15\u5165\u4e14\u6ca1\u6709\u53d8\u66f4\u3002", (Object)srcBill.getString("billno"));
                idEntryIdCompleteMap.remove(sourceId);
                continue;
            }
            String billNo = targetBill.getString("billno");
            if (willSaveBillNoSet.contains(billNo)) {
                this.getCompletionContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"CompletionImportDataConfigAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"CompletionImportDataConfigAction_54", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-\u6e90\u5355{}\u884c\u53f7{}\u5df2\u5728\u5176\u4ed6\u6210\u672c\u4e2d\u5fc3\u4e0b\u5f15\u5165\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"), (Object)srcBill.getString("entryseq"));
                continue;
            }
            if (!existsIds.contains(sourceId) && existBillNos.contains(srcBill.getString("billno") + "-" + srcBill.getString("entryseq"))) {
                this.getCompletionContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"CompletionImportDataConfigAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"CompletionImportDataConfigAction_54", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                this.logger.info("\u6e90\u5355{}\u884c\u53f7{}\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"), (Object)srcBill.getString("entryseq"));
                continue;
            }
            List costSyncInfos = (List)costSyncInfoMap.get(srcBill.getLong("entryId"));
            if (CollectionUtils.isEmpty((Collection)costSyncInfos)) {
                this.getCompletionContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u751f\u6210\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"CompletionImportDataConfigAction_62", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                this.logger.info("\u6e90\u5355{}\u6ca1\u6709\u751f\u6210\u6838\u7b97\u6210\u672c\u8bb0\u5f55!", (Object)srcBill.getString("billno"));
                continue;
            }
            Long costCenterId = targetBill.getLong("costcenter.id");
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                this.getCompletionContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"CompletionImportDataConfigAction_56", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            if (!costCenters.contains(costCenterId)) continue;
            String srcBillField = collConfigRuleMappingMap.get("probill");
            if (srcBillField == null) {
                this.getCompletionContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"CompletionImportDataConfigAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d,\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u4e2d\u7684\u5339\u914d\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4fe1\u606f\u672a\u7ef4\u62a4\u6e90\u5355\u5206\u5f55ID\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"CompletionImportDataConfigAction_57", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            DynamicObject costObject = null;
            if (targetBill.containsProperty("costobject") && !CadEmptyUtils.isEmpty((DynamicObjectCollection)targetBill.getDynamicObjectCollection("entryentity")) && ((DynamicObject)targetBill.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("costobject") != null) {
                costObject = ((DynamicObject)targetBill.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("costobject");
            } else {
                String srcStr = srcBill.getString(srcBillField);
                Map<String, DynamicObject> matInfoList = existCostObjectMap.get(String.valueOf(accountOrg));
                DynamicObject dynamicObject = costObject = matInfoList == null ? null : matInfoList.get(srcStr);
            }
            if (costObject == null) {
                if ("sca".equals(appNum)) {
                    this.getCompletionContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u4e14\u672a\u7ed3\u7b97\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CompletionImportDataConfigAction_58", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                    continue;
                }
                this.getCompletionContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CompletionImportDataConfigAction_59", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            Long keycol = costObject.getLong("calckeycol");
            String keycolfield = costObject.getString("keycolfield");
            if (CadEmptyUtils.isEmpty((Long)keycol) || StringUtils.isEmpty((CharSequence)keycolfield)) {
                if (StringUtils.isEmpty((CharSequence)keycolfield)) {
                    keycolfieldUpdateSet.add(costObject.getLong("id"));
                }
                costobjectKeyColMap.putIfAbsent(costObject.getLong("id"), new Tuple2((Object)((DynamicObject)costSyncInfos.get(0)).getString("caldimension"), (Object)((DynamicObject)costSyncInfos.get(0)).getString("noupdatecalfields")));
            }
            if (isNeedChangeData) {
                DynamicObject factned = idEntryIdCompleteMap.remove(sourceId);
                if (factned != null) {
                    needDelDynMap.put(sourceId, factned);
                }
                ++addNum;
            } else {
                ++addNum;
            }
            DynamicObjectCollection entryentity = targetBill.getDynamicObjectCollection("entryentity");
            DynamicObject newEntity = null;
            newEntity = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity) ? entryentity.addNew() : (DynamicObject)entryentity.get(0);
            newEntity.set("costobject", (Object)costObject.getLong("id"));
            targetBill.set("version", (Object)costObject.getLong("bomversion"));
            targetBill.set("auxpty", (Object)costObject.getLong("auxpty"));
            targetBill.set("configuredcode", (Object)costObject.getLong("configuredcode"));
            targetBill.set("tracknumber", (Object)costObject.getLong("tracknumber"));
            targetBill.set("project", (Object)costObject.getLong("projectnumber"));
            targetBill.set("lot", (Object)costObject.getString("lot"));
            targetBill.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
            targetBill.set("createtime", (Object)TimeServiceHelper.now());
            targetBill.set("auditor", (Object)Long.valueOf(RequestContext.get().getUserId()));
            targetBill.set("auditdate", (Object)TimeServiceHelper.now());
            materialSet.add(targetBill.getLong("material"));
            if ("sca".equals(appNum)) {
                BigDecimal completeqty = targetBill.getBigDecimal("completeqty");
                HashMap<Long, Boolean> outSourceMaterialMap = new HashMap<Long, Boolean>(16);
                DynamicObjectCollection entryEntity = targetBill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryEntity) {
                    long materialId = costObject.getLong("material");
                    boolean isOutSource = costObject.getBoolean("isoutsource");
                    outSourceMaterialMap.put(materialId, isOutSource);
                    if (entry.get("qty") != null && entry.getBigDecimal("qty").compareTo(BigDecimal.ZERO) != 0) continue;
                    entry.set("qty", (Object)completeqty);
                }
                this.createEntryCost(srcBill, targetBill, bizentryCostInfoMap, costSyncInfos, outSourcePrice, outSourceMaterialMap, orgCostaccountMap, accountCurrencyMap);
                DynamicObjectCollection entrycost = targetBill.getDynamicObjectCollection("entrycost");
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrycost)) {
                    this.getCompletionContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u672a\u627e\u5230\u6e90\u5355\u5bf9\u5e94\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u3002", (String)"CompletionImportDataConfigAction_60", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                    this.logger.info("\u672a\u627e\u5230\u6e90\u5355\u5bf9\u5e94\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\uff0c\u521b\u5efaentrycost\u5931\u8d25\uff0c\u5f15\u5165\u5931\u8d25\uff0c\u6e90\u5355:{}", (Object)srcBill.getString("billno"));
                    continue;
                }
                if ("im_mdc_omcmplinbill".equals(sourceEntity)) {
                    DynamicObject entryDyn;
                    Long keycolid = 0L;
                    Iterator<Map.Entry<String, Long>> iterator = entrycost.iterator();
                    while (iterator.hasNext() && CadEmptyUtils.isEmpty((Long)(keycolid = Long.valueOf((entryDyn = (DynamicObject)iterator.next()).getLong("entrykeycolid"))))) {
                    }
                    for (Map.Entry<String, Long> ele : accountManuorgAndCosttype.entrySet()) {
                        String[] split = ele.getKey().split("-");
                        Long costaccount = Long.valueOf(split[0]);
                        Long manuorg = Long.valueOf(split[1]);
                        if (manuorg != 0L && !manuorg.equals(targetBill.getLong("manuorg"))) continue;
                        Long costtype = ele.getValue();
                        Map<Long, Set<OutSourcePrice>> materialAndOutPrice = costtypeAndMaterialAndOutPrice.get(costtype);
                        Set outSourcePrices = materialAndOutPrice.computeIfAbsent(keycolid, v -> new HashSet(16));
                        DynamicObject resourceAbsorb = this.buildResourceAbsorbBill(targetBill, targetBill.getDynamicObjectCollection("entryentity"), costaccount, outSourcePrices);
                        if (resourceAbsorb == null) continue;
                        DynamicObjectCollection entryEntities = resourceAbsorb.getDynamicObjectCollection("entryentity");
                        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntities)) {
                            this.getCompletionContext().getFeeAbsorbs().add(resourceAbsorb);
                            continue;
                        }
                        this.getCompletionContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u4ea7\u54c1\u59d4\u5916\u6807\u51c6\u4ef7\u76ee\u8868\uff0c\u63090\u8d39\u7387\u8ba1\u7b97\u5438\u6536\u8d39\u7528\u3002", (String)"CompletionImportDataConfigAction_63", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    }
                    this.getCompletionContext().getWwCompletions().add(targetBill);
                    continue;
                }
                factnedBills.add(targetBill);
                continue;
            }
            factnedBills.add(targetBill);
        }
        if (!needDelDynMap.isEmpty()) {
            this.deleteFactnedBillForNoSrource(needDelDynMap);
        }
        if ("aca".equals(appNum) && !materialSet.isEmpty()) {
            this.setGradeProdGroup(materialSet, factnedBills);
        }
        CalcKeycolHelper.costobjectGenKeyCol((Long)accountOrg, null, (String)appNum, costobjectKeyColMap, keycolfieldUpdateSet);
        if (CadEmptyUtils.isEmpty(factnedBills) || factnedBills.size() <= 0) {
            this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-\u6ca1\u6709\u9700\u8981\u5f15\u5165\u7684\u5355\u636e");
            return factnedBills;
        }
        this.getCompletionContext().setAddNum(this.getCompletionContext().getAddNum() + addNum);
        this.getCompletionContext().setUpdateNum(this.getCompletionContext().getUpdateNum() + updNum);
        this.getCompletionContext().getFactnedBills().addAll(factnedBills);
        return factnedBills;
    }

    private void createEntryCost(DynamicObject srcBill, DynamicObject targetBill, Map<String, List<Map<String, Object>>> bizentryCostInfoMap, List<DynamicObject> costSyncInfos, Map<Long, String> outSourcePrice, Map<Long, Boolean> outSourceMaterialMap, Map<Long, List<DynamicObject>> orgCostaccountMap, Map<Long, Tuple2<Long, Integer>> accountCurrencyMap) {
        DynamicObjectCollection entryCostEntity = targetBill.getDynamicObjectCollection("entrycost");
        entryCostEntity.clear();
        Long org = CadEmptyUtils.isEmpty((Long)targetBill.getLong("org".concat("_id"))) ? 0L : targetBill.getLong("org".concat("_id"));
        String key = String.format("%s@%s", org, srcBill.getLong("entryId"));
        if (bizentryCostInfoMap != null && bizentryCostInfoMap.containsKey(key)) {
            ImportInitCostHelper.initEntryCost((DynamicObject)targetBill, bizentryCostInfoMap.get(key), accountCurrencyMap);
        } else {
            this.logger.info("\u5b8c\u5de5\u5f52\u96c6\u5355-\u5355\u636e\u53f7\uff1a{}\uff0c\u672a\u83b7\u53d6\u6838\u7b97\u7684\u53d6\u4ef7\u4fe1\u606f\uff0c\u4f7f\u7528\u6210\u672c\u7684\u53d6\u4ef7", (Object)targetBill.getString("billno"));
            ImportInitCostHelper.createEntryCost((DynamicObject)targetBill, costSyncInfos, outSourcePrice, outSourceMaterialMap, orgCostaccountMap);
        }
    }

    private Map<String, List<Map<String, Object>>> getMatCostInfo(Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, String sourceEntity, Map<String, DynamicObject> changeFactMap, Set<String> existsIds) {
        HashMap bizentryCostInfoMap = Maps.newHashMapWithExpectedSize((int)10);
        HashSet entryIds = Sets.newHashSetWithExpectedSize((int)10);
        HashSet matcostids = Sets.newHashSetWithExpectedSize((int)10);
        HashMap matCostEleListMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap orgCostaccountMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry<DynamicObject, DynamicObject> dynamicObjectEntry : srcAndTargetBillsMap.entrySet()) {
            DynamicObject srcBill = dynamicObjectEntry.getKey();
            DynamicObject targetBill = dynamicObjectEntry.getValue();
            if (!sourceEntity.equals(srcBill.getString("billtype")) || targetBill == null) continue;
            String sourceId = srcBill.getString("id") + "-" + srcBill.getString("entryId");
            boolean isNeedChangeData = changeFactMap.containsKey(sourceId);
            if (existsIds.contains(sourceId) && !isNeedChangeData) continue;
            Long org = CadEmptyUtils.isEmpty((Long)targetBill.getLong("org".concat("_id"))) ? 0L : targetBill.getLong("org".concat("_id"));
            if (!orgCostaccountMap.containsKey(org)) {
                QFilter qFilter = new QFilter("org", "=", (Object)org);
                qFilter.and("appnum", "=", (Object)"sca");
                qFilter.and("entryentity.isenabled", "=", (Object)Boolean.TRUE);
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"StartCostHelper_getCostAccountComboItemListBy", (String)"sca_startstdcost", (String)"entryentity.costaccount.id id", (QFilter[])qFilter.toArray(), null);
                HashSet ids = Sets.newHashSetWithExpectedSize((int)10);
                for (Row row : dataSet) {
                    ids.add(row.getLong("id"));
                }
                orgCostaccountMap.put(org, ids);
            }
            entryIds.add(srcBill.getLong("entryId"));
        }
        if (entryIds.isEmpty()) {
            return bizentryCostInfoMap;
        }
        String fields = "calorg,bizdate, costaccount,period, bizbillid, entry.bizbillentryid bizbillentryid,entry.matcostid matcostid";
        QFilter costRecordFilter = new QFilter("entry.bizbillentryid", "in", (Object)entryIds);
        costRecordFilter.and("billstatus", "=", (Object)"C");
        DataSet costRecords = QueryServiceHelper.queryDataSet((String)"CAL_COSTRECORD_SUBENTITY", (String)"cal_costrecord_subentity", (String)fields, (QFilter[])costRecordFilter.toArray(), null);
        for (Row row : costRecords) {
            Long matcostid = row.getLong("matcostid");
            if (CadEmptyUtils.isEmpty((Long)matcostid)) continue;
            Long costaccount = row.getLong("costaccount");
            Long calorg = row.getLong("calorg");
            Set costaccountIds = (Set)orgCostaccountMap.get(calorg);
            if (CadEmptyUtils.isEmpty((Set)costaccountIds) || !costaccountIds.contains(costaccount)) continue;
            String key = String.format("%s@%s", calorg, row.getLong("bizbillentryid"));
            List entryCostInfoMapList = bizentryCostInfoMap.computeIfAbsent(key, t -> new ArrayList(10));
            HashMap costInfoMap = Maps.newHashMapWithExpectedSize((int)10);
            costInfoMap.put("costaccount", costaccount);
            costInfoMap.put("period", row.getLong("period"));
            costInfoMap.put("matcostinfoid", row.getLong("matcostid"));
            entryCostInfoMapList.add(costInfoMap);
            matcostids.add(matcostid);
        }
        QFilter idFilter = new QFilter("id", "in", (Object)matcostids);
        DataSet matCostInfoDs = QueryServiceHelper.queryDataSet((String)"getSubItemStdDataSet", (String)"cad_matcostinfo", (String)"id ,keycol,keycolid,costtype,entryentity.element.masterid element,entryentity.subelement.masterid subelement,entryentity.standardcost amount", (QFilter[])new QFilter[]{idFilter}, null);
        for (Row row : matCostInfoDs) {
            List matCostEleList = matCostEleListMap.computeIfAbsent(row.getLong("id"), t -> new ArrayList(10));
            HashMap costInfo = Maps.newHashMapWithExpectedSize((int)10);
            costInfo.put("costtype", row.getLong("costtype"));
            costInfo.put("keycol", row.getString("keycol"));
            costInfo.put("keycolid", row.getLong("keycolid"));
            costInfo.put("element", row.getLong("element"));
            costInfo.put("subelement", row.getLong("subelement"));
            costInfo.put("standardcost", row.getBigDecimal("amount"));
            matCostEleList.add(costInfo);
        }
        HashSet removeKeys = new HashSet(10);
        for (Map.Entry entry : bizentryCostInfoMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] keyArr = key.split("@");
            Long org = Long.valueOf(keyArr[0]);
            Set costaccountIds = (Set)orgCostaccountMap.get(org);
            if (costaccountIds == null) {
                removeKeys.add(entry.getKey());
                continue;
            }
            if (costaccountIds.size() != ((List)entry.getValue()).size()) {
                removeKeys.add(entry.getKey());
                continue;
            }
            for (Map costInfo : (List)entry.getValue()) {
                Long matcostid = (Long)costInfo.get("matcostinfoid");
                if (matCostEleListMap.containsKey(matcostid)) {
                    costInfo.put("matcostinfo", matCostEleListMap.get(matcostid));
                    continue;
                }
                removeKeys.add(entry.getKey());
            }
        }
        if (!removeKeys.isEmpty()) {
            for (String key : removeKeys) {
                bizentryCostInfoMap.remove(key);
            }
        }
        return bizentryCostInfoMap;
    }

    private Map<String, Long> getCosttypeMap(List<Long> manuOrgs) {
        HashMap<String, Long> accountManuorgAndCosttype = new HashMap<String, Long>();
        Long acctOrgId = this.getCompletionContext().getCompletionArgs().getAcctOrgId();
        QFilter startQF = new QFilter("org", "=", (Object)acctOrgId);
        startQF.and("entryentity.isinit", "=", (Object)true);
        DynamicObjectCollection sca_startstdcost = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount costaccount", (QFilter[])startQF.toArray());
        Set costaccountSet = sca_startstdcost.stream().map(v -> v.getLong("costaccount")).collect(Collectors.toSet());
        for (Long costaccount : costaccountSet) {
            if (!manuOrgs.isEmpty()) {
                for (Long manuOrg : manuOrgs) {
                    Long costtypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)costaccount, (Long)acctOrgId, (Long)manuOrg);
                    if (costtypeId == null) continue;
                    accountManuorgAndCosttype.put(costaccount + "-" + manuOrg, costtypeId);
                }
                continue;
            }
            Long costtypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)costaccount, (Long)acctOrgId, null);
            if (costtypeId == null) continue;
            accountManuorgAndCosttype.put(costaccount + "-0", costtypeId);
        }
        return accountManuorgAndCosttype;
    }

    private Map<Long, Map<Long, Set<OutSourcePrice>>> getOurPriceMap(Map<String, Long> accountManuorgAndCosttype) {
        HashMap<Long, Map<Long, Set<OutSourcePrice>>> costtypeAndMaterialAndOutPrice = new HashMap<Long, Map<Long, Set<OutSourcePrice>>>(16);
        for (Long costtype : accountManuorgAndCosttype.values()) {
            QFilter filter = QFilter.of((String)"billstatus ='C' and costtype =?", (Object[])new Object[]{costtype});
            DynamicObjectCollection allOutSourcePrice = QueryServiceHelper.query((String)"cad_outsourceprice", (String)"id,material,element,subelement,price,effectdate,expdate,keycol,keycolid,entryentity.extelement extelement,entryentity.extsubelement extsubelement,entryentity.amount amount", (QFilter[])new QFilter[]{filter});
            HashMap<Long, Set> map = new HashMap<Long, Set>();
            for (DynamicObject outPriceDO : allOutSourcePrice) {
                long material = outPriceDO.getLong("material");
                Long keycolid = outPriceDO.getLong("keycolid");
                Set set = map.computeIfAbsent(keycolid, s -> new HashSet());
                Long element = outPriceDO.getLong("element");
                Long subElement = outPriceDO.getLong("subelement");
                BigDecimal price = outPriceDO.getBigDecimal("price");
                Date effectDate = outPriceDO.getDate("effectdate");
                Date expDate = outPriceDO.getDate("expdate");
                String keycol = outPriceDO.getString("keycol");
                OutSourcePrice outSource = new OutSourcePrice(Long.valueOf(material), Integer.valueOf(1), element, subElement, price, effectDate, expDate, keycol, keycolid);
                set.add(outSource);
                Long extElement = outPriceDO.getLong("extelement");
                if (CadEmptyUtils.isEmpty((Long)extElement)) continue;
                Long extSubElement = outPriceDO.getLong("extsubelement");
                BigDecimal extPrice = outPriceDO.getBigDecimal("amount");
                OutSourcePrice extOutPrice = new OutSourcePrice(Long.valueOf(material), Integer.valueOf(2), extElement, extSubElement, extPrice, effectDate, expDate, keycol, keycolid);
                set.add(extOutPrice);
            }
            costtypeAndMaterialAndOutPrice.put(costtype, map);
        }
        return costtypeAndMaterialAndOutPrice;
    }
}

