/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.factedoutput;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.mservice.factedoutput.AbstractCompletionAction;

public class CompletionSaveAction
extends AbstractCompletionAction {
    private static final Log logger = LogFactory.getLog(CompletionSaveAction.class);

    @Override
    protected void doExecute() {
        this.getCompletionContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f52\u96c6\u5230\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355", (String)"CompletionSaveAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]));
        List<DynamicObject> factnedBills = this.getCompletionContext().getFactnedBills();
        boolean saveValidate = "1".equals(CadBgParamUtils.getCadBgParamForString((String)"factImportSaveValid", (String)"1"));
        int saveSize = factnedBills.size();
        int batchSize = 300;
        int successSize = 0;
        if (saveSize <= batchSize * 3) {
            Object[] obj;
            successSize = saveValidate ? (successSize += this.save(factnedBills, this.getCompletionContext().getCollectReport())) : (successSize += (obj = SaveServiceHelper.save((DynamicObject[])factnedBills.toArray(new DynamicObject[0]))) == null ? 0 : obj.length);
        } else {
            int batchCount = saveSize / batchSize + 1;
            for (int i = 0; i < batchCount; ++i) {
                int startCount = i * batchSize;
                int endCount = (i + 1) * batchSize;
                if (i == batchCount - 1) {
                    endCount = saveSize;
                }
                List<DynamicObject> batchBillList = factnedBills.subList(startCount, endCount);
                if (saveValidate) {
                    successSize += this.save(batchBillList, this.getCompletionContext().getCollectReport());
                    continue;
                }
                Object[] obj = SaveServiceHelper.save((DynamicObject[])batchBillList.toArray(new DynamicObject[0]));
                successSize += obj == null ? 0 : obj.length;
            }
        }
        try (TXHandle txHandle = TX.required();){
            try {
                List<DynamicObject> wwCompletions = this.getCompletionContext().getWwCompletions();
                if (wwCompletions.size() > 0) {
                    List partitions = Lists.partition(wwCompletions, (int)batchSize);
                    for (List partition : partitions) {
                        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_factnedoutputbill", (DynamicObject[])partition.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                        if (operateResult.isSuccess()) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u5355\u5931\u8d25\u3002", (String)"CompletionSaveAction_27", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    }
                    List<DynamicObject> feeAbsorbs = this.getCompletionContext().getFeeAbsorbs();
                    List feePartitions = Lists.partition(feeAbsorbs, (int)batchSize);
                    for (List feePartition : feePartitions) {
                        SaveServiceHelper.save((DynamicObject[])feePartition.toArray(new DynamicObject[0]));
                    }
                    this.getCompletionContext().setSuccessNum(successSize += wwCompletions.size());
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                logger.info("\u59d4\u5916\u5b8c\u5de5\u5165\u5e93\u3001\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u4fdd\u5b58\u5931\u8d25!{}", (Object)e);
                this.getCompletionContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u4fdd\u5b58\u9519\u8bef", (String)"CompletionSaveAction_28", (String)"macc-cad-mservice", (Object[])new Object[0]), e.getMessage());
            }
        }
        this.getCompletionContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"%s\u6761\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u4fdd\u5b58\u6210\u529f\u3002", (String)"CompletionSaveAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]), successSize));
    }
}

