/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.factedoutput;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.FactnedOutPutServiceImpl;
import kd.macc.cad.mservice.factedoutput.AbstractCompletionAction;
import org.apache.commons.collections4.CollectionUtils;

public class ScaCompletionWriteCostChangeConfigAction
extends AbstractCompletionAction {
    private static final Log logger = LogFactory.getLog(FactnedOutPutServiceImpl.class);

    @Override
    protected void doExecute() {
        List<DynamicObject> factnedBills = this.getCompletionContext().getFactnedBills();
        List<DynamicObject> delFactnedBills = this.getCompletionContext().getDelFactnedBills();
        if (CollectionUtils.isEmpty(factnedBills) && CollectionUtils.isEmpty(delFactnedBills)) {
            return;
        }
        this.getCompletionContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u5199\u6210\u672c\u53d8\u66f4\u8bb0\u5f55", (String)"ScaCompletionWriteCostChangeConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        int changeCount = 0;
        if (CollectionUtils.isNotEmpty(factnedBills)) {
            changeCount += this.writeToCostChangeRecords(factnedBills, false);
        }
        if (CollectionUtils.isNotEmpty(delFactnedBills)) {
            changeCount += this.writeToCostChangeRecords(delFactnedBills, true);
        }
        this.getCompletionContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5199\u6210\u672c\u53d8\u66f4\u8bb0\u5f55%s\u6761\u3002", (String)"ScaCompletionWriteCostChangeConfigAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), changeCount));
    }

    private int writeToCostChangeRecords(List<DynamicObject> factnedBills, Boolean isDeleted) {
        try {
            ArrayList<DynamicObject> costChangeRecords = new ArrayList<DynamicObject>(10);
            ArrayList<Long> srcbillIds = new ArrayList<Long>(10);
            ArrayList<Long> exitCostObject = new ArrayList<Long>(10);
            for (DynamicObject factnedBill : factnedBills) {
                DynamicObject entryEntity = (DynamicObject)factnedBill.getDynamicObjectCollection("entryentity").get(0);
                Long costObjectId = entryEntity.get("costobject") instanceof DynamicObject ? entryEntity.getLong("costobject.id") : entryEntity.getLong("costobject");
                exitCostObject.add(costObjectId);
                srcbillIds.add(factnedBill.getLong("sourcebill"));
            }
            List<Long> settlChangeRecords = this.getChangeRecordBySettled(srcbillIds);
            List settlCostObjects = CostObjectHelper.getSettlCostObject(exitCostObject);
            for (DynamicObject factnedBill : factnedBills) {
                DynamicObject entryEntity = (DynamicObject)factnedBill.getDynamicObjectCollection("entryentity").get(0);
                Long costObjectId = entryEntity.get("costobject") instanceof DynamicObject ? entryEntity.getLong("costobject.id") : entryEntity.getLong("costobject");
                if (!settlCostObjects.contains(costObjectId) || isDeleted.booleanValue() && !settlChangeRecords.contains(factnedBill.getLong("sourcebill"))) continue;
                DynamicObject costChange = BusinessDataServiceHelper.newDynamicObject((String)"sca_costchangerecord");
                Long org = 0L;
                org = factnedBill.get("org") instanceof DynamicObject ? Long.valueOf(factnedBill.getLong("org.id")) : Long.valueOf(factnedBill.getLong("org"));
                Long costcenter = 0L;
                costcenter = factnedBill.get("costcenter") instanceof DynamicObject ? Long.valueOf(factnedBill.getLong("costcenter.id")) : Long.valueOf(factnedBill.getLong("costcenter"));
                Long matId = 0L;
                matId = factnedBill.get("material") instanceof DynamicObject ? Long.valueOf(factnedBill.getLong("material.id")) : Long.valueOf(factnedBill.getLong("material"));
                costChange.set("org", (Object)org);
                costChange.set("costobject", (Object)costObjectId);
                costChange.set("costcenter", (Object)costcenter);
                costChange.set("businessbill", (Object)"cad_factnedoutputbill");
                costChange.set("sourcebiztime", (Object)factnedBill.getDate("bookdate"));
                costChange.set("changecontext", (Object)(factnedBill.getString("billno") + "@" + matId + "@" + factnedBill.getString("completeqty")));
                costChange.set("sourcebill", (Object)factnedBill.getLong("sourcebill"));
                costChange.set("creator", (Object)RequestContext.get().getUserId());
                costChange.set("createtime", (Object)TimeServiceHelper.now());
                costChangeRecords.add(costChange);
            }
            if (CadEmptyUtils.isEmpty(costChangeRecords) || costChangeRecords.size() <= 0) {
                return 0;
            }
            SaveServiceHelper.save((DynamicObject[])costChangeRecords.toArray(new DynamicObject[0]));
            return costChangeRecords.size();
        }
        catch (Exception e) {
            logger.error("\u586b\u5199\u53d8\u66f4\u8bb0\u5f55\u8868\u5931\u8d25\u3002" + e.getMessage());
            return 0;
        }
    }

    private List<Long> getChangeRecordBySettled(List<Long> srcbillIds) {
        QFilter filter = new QFilter("sourcebill", "in", srcbillIds);
        filter.and("bizstatus", "=", (Object)"B");
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)"sca_costchangerecord", (String)"sourcebill", (QFilter[])new QFilter[]{filter});
        srcbillIds.clear();
        for (DynamicObject sourceBill : sourceBills) {
            srcbillIds.add(sourceBill.getLong("sourcebill"));
        }
        return srcbillIds;
    }
}

