/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matalloc;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.matalloc.IMatAllocAction;
import kd.macc.cad.mservice.matalloc.MatAllocContext;

public abstract class AbstractMatAllocAction
implements IMatAllocAction {
    protected Integer totalNum = 8;
    private MatAllocContext matAllocContext;

    protected abstract void doExecute();

    @Override
    public void execute() {
        if (this.matAllocContext.isContinueExecute()) {
            this.doExecute();
        }
    }

    @Override
    public void setContext(MatAllocContext matAllocContext) {
        this.matAllocContext = matAllocContext;
    }

    public MatAllocContext getMatAllocContext() {
        return this.matAllocContext;
    }

    protected void refreshProgress(String opContent, int nowComplete, int total, Boolean isAddNum) {
        MatAllocContext matAllocContext = this.getMatAllocContext();
        String progressId = matAllocContext.getMatAllocArgs().getProgressId();
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (isAddNum.booleanValue()) {
            Integer complete = paramDto.getComplete();
            paramDto.setComplete(Integer.valueOf(complete + nowComplete));
        } else {
            paramDto.setComplete(Integer.valueOf(nowComplete));
        }
        if (!CadEmptyUtils.isEmpty((Integer)total)) {
            paramDto.setTotal(Integer.valueOf(total));
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"AbstractMatAllocAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        paramDto.setDurationTimes(Integer.valueOf(0));
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam((String)progressId, (ProgressParamDto)paramDto);
    }

    protected DynamicObject getCostObjectBySrcBillInfo(DynamicObject srcBillData, TreeMap<String, String> collConfigRuleMappingMap, String sourceBillEntity, Map<Long, DynamicObject> proBillEntryIdCostObjectMap, Map<String, DynamicObject> existCostObjectMap) {
        DynamicObject costObject = null;
        if ("im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity) || "im_mdc_mftfeedorder".equals(sourceBillEntity) || "im_mdc_omoutbill".equals(sourceBillEntity) || "im_mdc_omreturnbill".equals(sourceBillEntity) || "im_mdc_omfeedbill".equals(sourceBillEntity)) {
            String coField = collConfigRuleMappingMap.get("material");
            if (coField != null && coField.contains("manuentryid") && proBillEntryIdCostObjectMap != null) {
                long manuentryid = srcBillData.getLong(coField);
                costObject = proBillEntryIdCostObjectMap.get(manuentryid);
            } else {
                String srcStr = CostObjectHelper.getCostObjectHashCodeBySrcBill((DynamicObject)srcBillData, collConfigRuleMappingMap);
                costObject = existCostObjectMap == null ? null : existCostObjectMap.get(srcStr);
            }
        } else {
            String srcStr = CostObjectHelper.getCostObjectHashCodeBySrcBill((DynamicObject)srcBillData, collConfigRuleMappingMap);
            costObject = existCostObjectMap == null ? null : existCostObjectMap.get(srcStr);
        }
        return costObject;
    }

    protected Map<Long, DynamicObject> getProBillEntryIdCostObjectMap(Long acctOrg, List<Long> costCenters, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, String> collConfigRuleMappingMap, String sourceBillEntity, String appNum) {
        HashMap proBillEntryIdCostObjectMap = Maps.newHashMap();
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return proBillEntryIdCostObjectMap;
        }
        HashSet<Long> proBillEntryIds = new HashSet<Long>(16);
        HashMap<Long, Object> entryIdCostCenterIdMap = new HashMap<Long, Object>(16);
        String calmethod = "";
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBill : srcAndTargetBillsMap.entrySet()) {
            String coField;
            DynamicObject srcBill = srcAndTargetBill.getKey();
            DynamicObject target = srcAndTargetBill.getValue();
            if (("im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity) || "im_mdc_mftfeedorder".equals(sourceBillEntity) || "im_mdc_omoutbill".equals(sourceBillEntity) || "im_mdc_omreturnbill".equals(sourceBillEntity) || "im_mdc_omfeedbill".equals(sourceBillEntity)) && (coField = collConfigRuleMappingMap.get("material")) != null && coField.contains("manuentryid")) {
                proBillEntryIds.add(srcBill.getLong(coField));
                String costCenterId = target.getString("costcenter.id");
                if (!CadEmptyUtils.isEmpty((String)costCenterId)) {
                    entryIdCostCenterIdMap.put(srcBill.getLong(coField), costCenterId);
                }
            }
            calmethod = srcBill.getString("calmethod");
        }
        if (!CadEmptyUtils.isEmpty(proBillEntryIds)) {
            Map existCostObjectMaterialMap = CostObjectHelper.getExistCostObjectMapForMaterial((Long)acctOrg, costCenters, (String)appNum);
            QFilter filter = new QFilter("treeentryentity.id", "in", proBillEntryIds);
            String selectFields = "id,treeentryentity.id entryid,treeentryentity.material.masterid as material,treeentryentity.bomid.version as bomversion,treeentryentity.auxproperty as auxpty,treeentryentity.material.masterid.isenablematerialversion as isenablematerialversion,treeentryentity.material.masterid.isuseauxpty as isuseauxpty";
            DynamicObjectCollection manuBills = "im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity) || "im_mdc_mftfeedorder".equals(sourceBillEntity) ? QueryServiceHelper.query((String)"pom_mftorder", (String)selectFields, (QFilter[])filter.toArray()) : QueryServiceHelper.query((String)"om_mftorder", (String)selectFields, (QFilter[])filter.toArray());
            HashSet<Long> materialIds = new HashSet<Long>(10);
            for (DynamicObject manuBill : manuBills) {
                if (!manuBill.getBoolean("isuseauxpty")) continue;
                materialIds.add(manuBill.getLong("material"));
            }
            Map materialMap = CostObjectHelper.getAssistMap(materialIds, (Long)acctOrg);
            for (DynamicObject manuBill : manuBills) {
                DynamicObject costObject;
                long entryId = manuBill.getLong("entryid");
                String costCenterId = (String)entryIdCostCenterIdMap.get(entryId);
                if (CadEmptyUtils.isEmpty((String)costCenterId)) continue;
                String key = costCenterId.concat("@").concat(manuBill.getString("material"));
                key = manuBill.getBoolean("isenablematerialversion") ? key.concat("@").concat(manuBill.getString("bomversion")) : key.concat("@").concat("0");
                if (manuBill.getBoolean("isuseauxpty")) {
                    Long material = manuBill.getLong("material");
                    Long auxpty = manuBill.getLong("auxpty");
                    Long effectCostAuxpty = this.getEffectCostAuxpty(material, auxpty, materialMap, calmethod);
                    key = key.concat("@").concat(String.valueOf(effectCostAuxpty));
                } else {
                    key = key.concat("@").concat("0");
                }
                if ((costObject = (DynamicObject)existCostObjectMaterialMap.get(key)) == null) continue;
                proBillEntryIdCostObjectMap.put(manuBill.getLong("entryid"), costObject);
            }
        }
        return proBillEntryIdCostObjectMap;
    }

    private Long getEffectCostAuxpty(Long material, Long auxpty, Map<Long, Boolean> materialMap, String calmethod) {
        if (CadEmptyUtils.isEmpty((Long)auxpty)) {
            return 0L;
        }
        DynamicObject auxptyObj = BusinessDataServiceHelper.loadSingleFromCache((Object)auxpty, (String)"bd_flexauxprop");
        return CostObjectHelper.getEffectCostAuxptyNew((DynamicObject)CostObjectHelper.getMaterialById((Long)material), (DynamicObject)auxptyObj, materialMap, (String)calmethod);
    }

    protected void dealExitsData(Map<Long, DynamicObject> idEntryIdCompleteMap, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<Long, DynamicObject> changeMatAllocMap, Set<String> selectFields, String appNum) {
        if (CadEmptyUtils.isEmpty(idEntryIdCompleteMap) || CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return;
        }
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTartgetBill : srcAndTargetBillsMap.entrySet()) {
            DynamicObject newBill = srcAndTartgetBill.getValue();
            Long entryId = newBill.getLong("sourcebillentryid");
            DynamicObject oldBill = idEntryIdCompleteMap.get(entryId);
            if (oldBill == null) continue;
            Date nsrcAuditDate = newBill.getDate("nsrcauditdate");
            Date oldNsrcAuditDate = oldBill.getDate("nsrcauditdate");
            if (nsrcAuditDate == null || oldNsrcAuditDate == null || nsrcAuditDate.compareTo(oldNsrcAuditDate) == 0) continue;
            changeMatAllocMap.put(entryId, newBill);
        }
    }

    protected Map<Long, DynamicObject> getSrcBillEntryIdAndSrcDataMap(Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, String sourceBillEntity, Set<String> ruleMappings, Set<String> fieldMappings) {
        HashMap<Long, DynamicObject> SrcBillEntryIdAndSrcDataMap = new HashMap<Long, DynamicObject>(16);
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return SrcBillEntryIdAndSrcDataMap;
        }
        HashSet srcIds = new HashSet(16);
        srcAndTargetBillsMap.keySet().forEach(p -> srcIds.add(p.getLong("id")));
        HashSet<Object> selectFields = new HashSet<Object>(16);
        String entryEntity = "";
        if (!CadEmptyUtils.isEmpty(fieldMappings)) {
            for (String string : fieldMappings) {
                Object[] splitValue = string.split(",");
                if (CadEmptyUtils.isEmpty((Object[])splitValue)) continue;
                selectFields.addAll(Arrays.asList(splitValue));
            }
        }
        for (String string : selectFields) {
            if (!CadEmptyUtils.isEmpty((String)entryEntity) || !string.contains(".")) continue;
            entryEntity = string.split("\\.")[0];
        }
        if (!CadEmptyUtils.isEmpty(ruleMappings)) {
            for (String string : ruleMappings) {
                if (CadEmptyUtils.isEmpty((String)string)) continue;
                selectFields.add(string);
            }
        }
        if (CadEmptyUtils.isEmpty(selectFields)) {
            return SrcBillEntryIdAndSrcDataMap;
        }
        String selectFieldStr = entryEntity + ".id," + String.join((CharSequence)",", selectFields);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)sourceBillEntity, (String)selectFieldStr, (QFilter[])new QFilter[]{new QFilter("id", "in", srcIds)});
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            SrcBillEntryIdAndSrcDataMap.put(dynamicObject.getLong(entryEntity + ".id"), dynamicObject);
        }
        return SrcBillEntryIdAndSrcDataMap;
    }

    protected Map<Long, DynamicObject> getCalCostRecord(Long costAccountId, Set<Long> sourceBillEntryIds) {
        DynamicObjectCollection costRecords = this.getCalCostRecordData(costAccountId, sourceBillEntryIds);
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(8);
        costRecords.forEach(e -> {
            long bizBillEntryId = e.getLong("bizbillentryid");
            resultMap.computeIfAbsent(bizBillEntryId, s -> e);
        });
        return resultMap;
    }

    protected DynamicObjectCollection getCalCostRecordData(Long costAccountId, Set<Long> sourceBillIds) {
        String fields = "bizbillid,entry.bizbillentryid bizbillentryid,entry.actualcost actualcost,entry.material material,entry.subentrycostelement.sub_actualcost subactualcost,entry.subentrycostelement.sub_unitactualcost subunitactualcost,entry.subentrycostelement.costelement costelement,entry.subentrycostelement.costsubelement costsubelement";
        return QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)fields, (QFilter[])new QFilter[]{new QFilter("entry.bizbillentryid", "in", sourceBillIds), new QFilter("costaccount", "=", (Object)costAccountId)});
    }

    protected Long getDynamicPropLong(DynamicObject targetObject, String prop) {
        if (targetObject.containsProperty(prop)) {
            Object propObj = targetObject.get(prop);
            if (propObj != null) {
                if (propObj instanceof DynamicObject) {
                    return ((DynamicObject)propObj).getLong("id");
                }
                return Long.parseLong(propObj.toString());
            }
            return 0L;
        }
        return 0L;
    }

    protected String getStrKey(String materialId, Long matVersionId, Long auxptyId, Long manuorg, Date createDate) {
        materialId = CadEmptyUtils.isEmpty((Long)matVersionId) ? materialId + "@0" : materialId + "@" + matVersionId;
        materialId = CadEmptyUtils.isEmpty((Long)auxptyId) ? materialId + "@0" : materialId + "@" + auxptyId;
        String string = materialId = CadEmptyUtils.isEmpty((Long)manuorg) ? materialId + "@0" : materialId + "@" + manuorg;
        if (createDate != null) {
            materialId = materialId + "@" + createDate.getTime();
        }
        return materialId;
    }

    protected Map<String, Pair<Long, Long>> getStringPairMap(Collection<DynamicObject> bills, Date createTime, Long orgId) {
        Set materialToDateThreeTuple = bills.stream().map(e -> new Tuple((Object)new FourTuple((Object)e.getLong("material"), (Object)e.getLong("matversion"), (Object)e.getLong("auxpty"), (Object)e.getLong("manuorg")), (Object)createTime)).collect(Collectors.toSet());
        return (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getAcaSubElementByOrg", (Object[])new Object[]{orgId, materialToDateThreeTuple});
    }
}

