/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matalloc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.olap.util.Pair;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MatAllocDataHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.matalloc.AbstractMatAllocAction;
import kd.macc.cad.mservice.matalloc.MatAllocArgs;
import kd.macc.cad.mservice.matalloc.MatAllocContext;

public class MatAllocImportFlAction
extends AbstractMatAllocAction {
    private static final Log logger = LogFactory.getLog(MatAllocImportFlAction.class);

    @Override
    protected void doExecute() {
        MatAllocArgs matAllocArgs = this.getMatAllocContext().getMatAllocArgs();
        Long accountOrgId = matAllocArgs.getAcctOrgId();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getMatAllocContext().getConfigSrcAndTargetBillsMap();
        Map<Long, String> dimensionAndRuleMap = this.getMatAllocContext().getDimensionAndRuleMap();
        Map<Long, Map<String, String>> collConfigMappingMap = this.getMatAllocContext().getCollConfigMappingMap();
        Map<Long, Map<String, String>> collConfigRuleMappingMap = this.getMatAllocContext().getCollConfigRuleMappingMap();
        String key = accountOrgId + CostObjectEnum.BIZTYPE_FL.getValue();
        List<Long> flCostCenters = this.getMatAllocContext().getOrgMethodCostCentersMap().get(key);
        if (CadEmptyUtils.isEmpty(flCostCenters)) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u5206\u7c7b\u6cd5\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f15\u5165\u7ed3\u675f\uff01", (Object)accountOrgId);
            return;
        }
        this.getMatAllocContext().getCollectReport().setFlCostCenters(flCostCenters);
        for (Map.Entry<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
            DynamicObject config = configSrcAndTargetBill.getKey();
            String sourcebill = config.getString("sourcebill.id");
            String sourcebillName = config.getString("sourcebill.name");
            if (!CostObjectEnum.BIZTYPE_FL.getValue().equals(config.getString("calmethod"))) continue;
            this.refreshProgress(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u7684\u6570\u636e\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"MatAllocImportFlAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")), 1, 0, true);
            this.refreshProgress(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u7684\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"MatAllocImportFlAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")), 3, 0, false);
            Map<DynamicObject, DynamicObject> srcAndTargetBillsMap = configSrcAndTargetBill.getValue();
            ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
            this.getMatAllocContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%s", (String)"MatAllocImportFlAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName));
            this.getMatAllocContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230%1$s\u201c%2$s\u201d\u6761\u6570\u636e\u3002", (String)"MatAllocImportFlAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName, srcBills.size()));
            long costcalcdimension = config.getLong("costcalcdimension.id");
            String dimension = dimensionAndRuleMap.get(costcalcdimension);
            if (CadEmptyUtils.isEmpty((String)dimension)) {
                this.getMatAllocContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"MatAllocImportFlAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u6ca1\u6709\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ef4\u5ea6\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"MatAllocImportFlAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                continue;
            }
            TreeMap<String, String> configRuleMappingMap = new TreeMap<String, String>(collConfigRuleMappingMap.get(config.getLong("id")));
            String costObjectFields = String.join((CharSequence)",", configRuleMappingMap.keySet());
            Map existCostObjectMap = CostObjectHelper.getExistCostObjectMap((Long)accountOrgId, flCostCenters, (String)costObjectFields, (String)matAllocArgs.getAppNum());
            Map<String, String> configMappingMap = collConfigMappingMap.get(config.getLong("id"));
            this.getMatAllocContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d,\u5904\u7406\u6e90\u5355\u3002", (String)"MatAllocImportFlAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
            List<DynamicObject> matAllocBill = this.getMatAllocBill(accountOrgId, flCostCenters, config, srcAndTargetBillsMap, existCostObjectMap, configRuleMappingMap, configMappingMap, this.getMatAllocContext().getEntryIdAllocMap(), sourcebill, matAllocArgs.getAppNum());
            this.getMatAllocContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u6570\u636e%s\u6761\u3002", (String)"MatAllocImportFlAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]), matAllocBill.size()));
            this.refreshProgress(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u7684\u6570\u636e\u5904\u7406\u5b8c\u6210\u3002", (String)"MatAllocImportFlAction_8", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")), 5, 0, true);
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u5206\u7c7b\u6cd5\u7684\u6570\u636e\u5904\u7406\u5b8c\u6210\u3002", (String)"MatAllocImportFlAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]), 13, 0, false);
    }

    private List<DynamicObject> getMatAllocBill(Long accountOrgId, List<Long> flCostCenters, DynamicObject config, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, Map<String, DynamicObject>> existCostObjectMap, TreeMap<String, String> configRuleMappingMap, Map<String, String> configMappingMap, Map<Long, DynamicObject> entryIdAllocMap, String sourceBill, String appNum) {
        ArrayList<DynamicObject> matAllocBills = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> updateAllocBills = new ArrayList<DynamicObject>();
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return matAllocBills;
        }
        Date createTime = TimeServiceHelper.now();
        Collection<DynamicObject> bills = srcAndTargetBillsMap.values();
        Map<String, Pair<Long, Long>> matIdToPairMap = this.getStringPairMap(bills, createTime, accountOrgId);
        Map matAllocStdMap = MatAllocDataHelper.getMatAllocStdMap((Long)accountOrgId, (String)"aca");
        Map<Long, DynamicObject> entryIdCostObjectMap = this.getProBillEntryIdCostObjectMap(accountOrgId, flCostCenters, srcAndTargetBillsMap, configRuleMappingMap, sourceBill, appNum);
        HashMap<Long, DynamicObject> changeMatAllocMap = new HashMap<Long, DynamicObject>(16);
        this.dealExitsData(entryIdAllocMap, srcAndTargetBillsMap, changeMatAllocMap, new HashSet<String>(configMappingMap.keySet()), appNum);
        Map<Long, DynamicObject> srcBillEntryIdAndSrcDataMap = this.getSrcBillEntryIdAndSrcDataMap(srcAndTargetBillsMap, sourceBill, new HashSet<String>(configRuleMappingMap.values()), new HashSet<String>(configMappingMap.values()));
        int updNum = 0;
        int addNum = 0;
        MatAllocContext context = this.getMatAllocContext();
        Set<Long> existsIds = entryIdAllocMap.keySet();
        boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)accountOrgId);
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBill : srcAndTargetBillsMap.entrySet()) {
            DynamicObject srcBill = srcAndTargetBill.getKey();
            DynamicObject targetBill = srcAndTargetBill.getValue();
            if (!sourceBill.equals(srcBill.getString("billtype"))) continue;
            if (targetBill == null) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat("0").concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u3002", (String)"MatAllocImportFlAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                continue;
            }
            Long entryId = srcBill.getLong("entryId");
            boolean isNeedChangeData = changeMatAllocMap.containsKey(entryId);
            if (existsIds.contains(entryId) && !isNeedChangeData) {
                entryIdAllocMap.remove(entryId);
                continue;
            }
            Long costCenterId = targetBill.getLong("costcenter.id");
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat("0").concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"MatAllocImportFlAction_11", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                continue;
            }
            if (!flCostCenters.contains(costCenterId)) continue;
            if ("im_materialreqoutbill".equals(sourceBill)) {
                List manuorgList;
                long bizorg;
                String manuorgField = configMappingMap.get("manuorg");
                long l = bizorg = manuorgField == null ? 0L : srcBill.getLong(manuorgField);
                if (isEnableMultiFactory && CadEmptyUtils.isEmpty((List)(manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)bizorg, (String)"aca_matalloc", (String)appNum)))) {
                    this.getMatAllocContext().logErrorMsg(srcBill.getString("billno").concat("@").concat("0"), ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\u65e0\u751f\u4ea7\u7ec4\u7ec7\u804c\u80fd\uff0c\u6216\u65e0\u59d4\u6258\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MatAllocImportFlAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"MatAllocImportFlAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u7684\u9700\u6c42\u7ec4\u7ec7\u65e0\u751f\u4ea7\u7ec4\u7ec7\u804c\u80fd\uff0c\u6216\u65e0\u59d4\u6258\u751f\u4ea7\u7ec4\u7ec7\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"MatAllocImportFlAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                    logger.info("\u6e90\u5355:{}\u9700\u6c42\u7ec4\u7ec7\u65e0\u751f\u4ea7\u7ec4\u7ec7\u804c\u80fd\u6216\u6ca1\u6709\u59d4\u6258\u751f\u4ea7\u7ec4\u7ec7\uff0c\u8df3\u8fc7\u6b64\u5355", (Object)bizorg);
                    continue;
                }
            }
            Map<String, DynamicObject> matInfoList = existCostObjectMap.get(String.valueOf(accountOrgId).concat(String.valueOf(costCenterId)));
            if (!isNeedChangeData) {
                ++addNum;
            } else {
                DynamicObject matAlloc = entryIdAllocMap.remove(entryId);
                for (Map.Entry<String, String> configMapping : configMappingMap.entrySet()) {
                    String cost = configMapping.getKey();
                    matAlloc.set(cost, targetBill.get(cost));
                }
                matAlloc.set("useamount", targetBill.get("useamount"));
                matAlloc.set("nsrcauditdate", targetBill.get("nsrcauditdate"));
                String useType = matAlloc.getString("usetype");
                if (ScaAllocEnum.USETYPE_DRIECT.getValue().equals(useType)) {
                    DynamicObjectCollection entryEntity = matAlloc.getDynamicObjectCollection("entryentity");
                    DynamicObject row = (DynamicObject)entryEntity.get(0);
                    row.set("amount", targetBill.get("useamount"));
                    if (targetBill.containsProperty("useqty")) {
                        row.set("qty", (Object)targetBill.getBigDecimal("useqty"));
                    }
                } else {
                    DynamicObjectCollection entryentity = matAlloc.getDynamicObjectCollection("entryentity");
                    if (entryentity != null) {
                        entryentity.clear();
                    }
                    matAlloc.set("allocstatus", (Object)" ");
                }
                updateAllocBills.add(matAlloc);
                ++updNum;
                continue;
            }
            long sourcebillEntryId = targetBill.getLong("sourcebillentryid");
            DynamicObject srcBillData = srcBillEntryIdAndSrcDataMap.get(sourcebillEntryId);
            DynamicObject costObject = this.getCostObjectBySrcBillInfo(srcBillData, configRuleMappingMap, sourceBill, entryIdCostObjectMap, matInfoList);
            DynamicObjectCollection entryentity = targetBill.getDynamicObjectCollection("entryentity");
            DynamicObject entryRow = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity) ? entryentity.addNew() : (DynamicObject)entryentity.get(0);
            if (costObject == null && !"im_materialreqoutbill".equals(sourceBill)) {
                this.getMatAllocContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u5206\u5f55\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"MatAllocImportFlAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            if (CostObjectEnum.BIZTYPE_SO.getValue().equals(config.getString("calmethod")) && "im_materialreqoutbill".equals(sourceBill) && (CadEmptyUtils.isEmpty((Long)targetBill.getLong("material")) || CadEmptyUtils.isEmpty((String)targetBill.getString("productnum")))) {
                costObject = null;
            }
            if (costObject == null && "im_materialreqoutbill".equals(sourceBill)) {
                if (CadEmptyUtils.isEmpty((Map)matAllocStdMap)) {
                    this.getMatAllocContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), ResManager.loadKDString((String)"\u672a\u627e\u5230\u5171\u8017\u6750\u6599\u7684\u5206\u914d\u6807\u51c6\u3002", (String)"MatAllocImportFlAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    continue;
                }
                Long costDriverId = MatAllocDataHelper.getMatAllocStdCostDriver((Long)this.getMatAllocContext().getMatAllocArgs().getAcctOrgId(), (Long)this.getDynamicPropLong(targetBill, "manuorg"), (Long)this.getDynamicPropLong(targetBill, "costcenter"), (Long)this.getDynamicPropLong(targetBill, "material"), (Long)this.getDynamicPropLong(targetBill, "matversion"), (Long)this.getDynamicPropLong(targetBill, "auxpty"), (Long)0L, (Map)matAllocStdMap);
                if (CadEmptyUtils.isEmpty((Long)costDriverId)) {
                    this.getMatAllocContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), ResManager.loadKDString((String)"\u672a\u627e\u5230\u5171\u8017\u6750\u6599\u7684\u5206\u914d\u6807\u51c6\u3002", (String)"MatAllocImportFlAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    continue;
                }
                targetBill.set("costdriver", (Object)costDriverId);
                targetBill.set("usetype", (Object)ScaAllocEnum.USETYPE_PUBLIC.getValue());
            }
            entryRow.set("costobejctentry", (Object)(costObject == null ? 0L : costObject.getLong("id")));
            entryRow.set("costobejctentry_id", (Object)(costObject == null ? 0L : costObject.getLong("id")));
            if (costObject != null) {
                if (targetBill.containsProperty("useqty")) {
                    entryRow.set("qty", (Object)targetBill.getBigDecimal("useqty"));
                }
                Long materialId = targetBill.getLong("material");
                Long matVersionId = targetBill.getLong("matversion");
                Long auxptyId = targetBill.getLong("auxpty");
                Long manuorg = targetBill.getLong("manuorg");
                String strKey = this.getStrKey(String.valueOf(materialId), matVersionId, auxptyId, manuorg, createTime);
                Pair<Long, Long> eleSubElePair = matIdToPairMap.get(strKey);
                if (eleSubElePair != null) {
                    entryRow.set("subelemententry", eleSubElePair.getValue1());
                    entryRow.set("elemententry", eleSubElePair.getValue0());
                }
                entryRow.set("amount", targetBill.get("useamount"));
            } else {
                entryentity.clear();
            }
            targetBill.set("costobject", (Object)(costObject == null ? 0L : costObject.getLong("id")));
            targetBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("createtime", (Object)createTime);
            targetBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("modifytime", (Object)createTime);
            targetBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("auditdate", (Object)createTime);
            targetBill.set("billstatus", (Object)"A");
            if (targetBill.get("usetype") == null) {
                targetBill.set("usetype", (Object)ScaAllocEnum.USETYPE_DRIECT.getValue());
                targetBill.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
            }
            targetBill.set("alloctor", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("allocatedate", (Object)createTime);
            targetBill.set("alloctype", (Object)ScaAllocEnum.ALLOCTYP_AUTO.getValue());
            matAllocBills.add(targetBill);
        }
        this.getMatAllocContext().setAddNum(this.getMatAllocContext().getAddNum() + addNum);
        this.getMatAllocContext().setUpdateNum(this.getMatAllocContext().getUpdateNum() + updNum);
        this.getMatAllocContext().getNeedAddList().addAll(matAllocBills);
        this.getMatAllocContext().getNeedUpdateList().addAll(updateAllocBills);
        logger.info("\u65b0\u589e\u6750\u6599\u8017\u7528\u5206\u914d\u5355:{}\u66f4\u65b0\u7684\u6750\u6599\u8017\u7528\u5206\u914d\u5355:{}", (Object)matAllocBills.size(), (Object)updateAllocBills.size());
        return matAllocBills;
    }
}

