/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matalloc;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.mservice.matalloc.AbstractMatAllocAction;
import kd.macc.cad.mservice.matalloc.MatAllocArgs;
import kd.macc.cad.mservice.matalloc.MatAllocImportPzAction;

public class MatAllocSaveAction
extends AbstractMatAllocAction {
    private static final Log logger = LogFactory.getLog(MatAllocImportPzAction.class);
    private static final Integer BATCH_SIZE = 5000;

    @Override
    protected void doExecute() {
        this.getMatAllocContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f52\u96c6\u5230\u7684\u6750\u6599\u8017\u7528\u5206\u914d\u5355", (String)"MatAllocSaveAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        MatAllocArgs matAllocArgs = this.getMatAllocContext().getMatAllocArgs();
        DynamicObject costAccount = CostAccountHelper.getCostAccountInfo((Long)matAllocArgs.getCostAccountId(), (String)matAllocArgs.getAppNum());
        if (costAccount == null) {
            this.getMatAllocContext().getCollectReport().logError(new Throwable(), ResManager.loadKDString((String)"\u672a\u627e\u5230\u542f\u52a8\u5b9e\u9645\u6210\u672c\u7684\u6210\u672c\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"MatAllocSaveAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]));
            return;
        }
        List<DynamicObject> matAllocBills = this.getMatAllocContext().getNeedAddList();
        long costAccountId = costAccount.getLong("id");
        String costAccountNum = costAccount.getString("canumber");
        long currencyId = costAccount.getLong("currency");
        long currentPeriodId = costAccount.getLong("currentperiod");
        for (DynamicObject dynamicObject : matAllocBills) {
            dynamicObject.set("billno", (Object)costAccountNum.concat("-").concat(dynamicObject.getString("billno")));
            dynamicObject.set("costaccount", (Object)costAccountId);
            dynamicObject.set("currency", (Object)currencyId);
            dynamicObject.set("period", (Object)currentPeriodId);
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f52\u96c6\u7684\u6570\u636e", (String)"MatAllocSaveAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, 0, true);
        List partAllocBills = Lists.partition(matAllocBills, (int)BATCH_SIZE);
        for (List partAllocBill : partAllocBills) {
            SaveServiceHelper.save((DynamicObject[])partAllocBill.toArray(new DynamicObject[0]));
        }
        List list = Lists.partition(this.getMatAllocContext().getNeedUpdateList(), (int)BATCH_SIZE);
        for (List needUpdateList : list) {
            SaveServiceHelper.save((DynamicObject[])needUpdateList.toArray(new DynamicObject[0]));
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u5f52\u96c6\u5355\u4fdd\u5b58\u6210\u529f\u3002", (String)"MatAllocSaveAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, 0, true);
        this.getMatAllocContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6761\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u4fdd\u5b58\u6210\u529f\u3002", (String)"MatAllocSaveAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), matAllocBills.size()));
    }
}

