/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matalloc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.config.costcenter.CostCenterRelationService;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.engine.CollConifgContext;
import kd.macc.cad.business.config.engine.CollConifgParam;
import kd.macc.cad.business.config.engine.IBillTransfer;
import kd.macc.cad.business.config.engine.filter.CollConfigFilterService;
import kd.macc.cad.business.config.engine.mapping.CollConfigMappingService;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.BatchUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.matalloc.AbstractMatAllocAction;
import kd.macc.cad.mservice.matalloc.IMatAllocAction;
import kd.macc.cad.mservice.matalloc.MatAllocArgs;
import kd.macc.cad.mservice.matalloc.MatAllocContext;
import kd.macc.cad.mservice.matalloc.MatAllocImportDiyAction;
import kd.macc.cad.mservice.matalloc.MatAllocImportFlAction;
import kd.macc.cad.mservice.matalloc.MatAllocImportFpAction;
import kd.macc.cad.mservice.matalloc.MatAllocImportGdAction;
import kd.macc.cad.mservice.matalloc.MatAllocImportPzAction;
import kd.macc.cad.mservice.matalloc.MatAllocSaveAction;

public class MatAllocTransferAction
extends AbstractMatAllocAction {
    private static final Log logger = LogFactory.getLog(MatAllocTransferAction.class);
    private CollConifgContext configContext = new CollConifgContext();
    private List<DynamicObject> collConfigList = new ArrayList<DynamicObject>();
    private CollConfigFilterService filterService;
    private CollConfigMappingService mappingService;
    private CostCenterRelationService costCenterRelationService;

    @Override
    protected void doExecute() {
        MatAllocContext matAllocContext = this.getMatAllocContext();
        MatAllocArgs allocArgs = matAllocContext.getMatAllocArgs();
        String appNum = allocArgs.getAppNum();
        CollectReport collectReport = matAllocContext.getCollectReport();
        List<IMatAllocAction> matAllocActions = this.initializeActions(appNum);
        this.configContext = new CollConifgContext();
        CollConifgParam param = new CollConifgParam();
        param.setAppnum(allocArgs.getAppNum());
        param.setCalOrgId(allocArgs.getAcctOrgId());
        param.setCostAccountId(allocArgs.getCostAccountId());
        param.setCostCenterIds(allocArgs.getCostCenterIds().toArray(new Long[0]));
        param.setTargetEntity(allocArgs.getEntityId());
        this.configContext.setParam(param);
        this.collConfigList = this.getValidCollConfigList(matAllocContext, allocArgs.getEntityId());
        if (!CadEmptyUtils.isEmpty(this.collConfigList)) {
            this.mappingService = new CollConfigMappingService();
            this.filterService = new CollConfigFilterService();
            this.costCenterRelationService = new CostCenterRelationService();
            Map collConfigMappingMap = this.mappingService.getCollConfigMappingMap(this.collConfigList);
            Map collSelectValueMappingMap = this.mappingService.getCollSelectValueMappingMap(this.collConfigList);
            Map collConfigRuleMappingMap = this.mappingService.getCollConfigRuleMappingMap(this.collConfigList);
            Map collConfigFilterMap = this.filterService.getCollConfigFilterMap(this.collConfigList);
            List importScopeDate = CostAccountHelper.getImportScopeDate((Long)allocArgs.getCostAccountId(), (String)allocArgs.getAppNum());
            Map costCenterSourceDataMap = this.costCenterRelationService.getCostCenterSourceDataMap(allocArgs.getCostCenterIds().toArray(new Long[0]), importScopeDate);
            this.configContext.setCostCenterSourceDataMap(costCenterSourceDataMap);
            HashMap costCentersourceTypeDataMap = new HashMap(16);
            costCenterSourceDataMap.forEach((ccs, obj) -> {
                String[] srcDataStr = ccs.split("@");
                if (srcDataStr.length < 2) {
                    return;
                }
                String sourceType = srcDataStr[0];
                Long sourceData = Long.parseLong(srcDataStr[1]);
                costCentersourceTypeDataMap.computeIfAbsent(sourceType, p -> new HashSet(10)).add(sourceData);
            });
            matAllocContext.getCollConfigMappingMap().putAll(collConfigMappingMap);
            matAllocContext.getCollConfigRuleMappingMap().putAll(collConfigRuleMappingMap);
            boolean disableCollectReport = CollectReportHelper.disableCollectReport();
            this.collConfigList.forEach(config -> {
                Map<Long, DynamicObject> existsEntryIdAllocMap;
                this.getMatAllocContext().getEntryIdAllocMap().clear();
                this.getMatAllocContext().getNeedAddList().clear();
                this.getMatAllocContext().getNeedUpdateList().clear();
                long configId = config.getLong("id");
                String targetBillEntity = config.getString("costbill.id");
                String sourceBillEntity = config.getString("sourcebill.id");
                DataSet existsMatAllocBill = this.getExistMatAllocBill(allocArgs.getAcctOrgId(), allocArgs.getCostAccountId(), allocArgs.getCostCenterIds(), sourceBillEntity, targetBillEntity, allocArgs.getAppNum());
                String entryEntityName = "";
                Map fieldMappingMap = (Map)collConfigMappingMap.get(configId);
                if (!CadEmptyUtils.isEmpty((Map)fieldMappingMap)) {
                    for (String value : fieldMappingMap.values()) {
                        String[] split;
                        for (String fieldName : split = org.apache.commons.lang3.StringUtils.split((String)value, (String)",")) {
                            String[] fieldNames = org.apache.commons.lang3.StringUtils.split((String)fieldName, (String)".");
                            if (fieldNames.length <= 1) continue;
                            entryEntityName = fieldNames[0];
                            break;
                        }
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entryEntityName)) continue;
                        break;
                    }
                }
                Map selectValueMappingMap = (Map)collSelectValueMappingMap.get(configId);
                Map ruleMappingMap = (Map)collConfigRuleMappingMap.get(configId);
                List<QFilter> collConfigFilter = this.getSrcQFilters((DynamicObject)config, collConfigFilterMap, fieldMappingMap, selectValueMappingMap, costCentersourceTypeDataMap, collectReport);
                String selectFields = this.getSrcSelectFields((DynamicObject)config, fieldMappingMap, ruleMappingMap);
                if (CadEmptyUtils.isEmpty((String)selectFields)) {
                    return;
                }
                logger.info("\u67e5\u8be2\u6e90\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", collConfigFilter);
                if (!CadEmptyUtils.isEmpty((String)entryEntityName)) {
                    entryEntityName = entryEntityName.concat(".id");
                }
                DataSet sourceBills = QueryServiceHelper.queryDataSet((String)"MatAllocTransferAction_doExecute", (String)sourceBillEntity, (String)"id,auditdate,".concat(entryEntityName), (QFilter[])collConfigFilter.toArray(new QFilter[0]), (String)"id desc");
                logger.info("\u5dee\u91cf\u5f52\u96c6\u5224\u65ad:\u5f52\u96c6\u62a5\u544a\u5f00\u542f\u72b6\u6001{}", (Object)disableCollectReport);
                long diffTime = System.currentTimeMillis();
                if (!disableCollectReport) {
                    DataSet notChangeDs;
                    boolean isChanged = this.checkConfigChanged((DynamicObject)config, targetBillEntity);
                    logger.info("\u5dee\u91cf\u5f52\u96c6\u5224\u65ad:\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u65b9\u6848:{},\u6539\u53d8\u72b6\u6001:{}", (Object)config.getString("number"), (Object)isChanged);
                    if (!(isChanged || existsMatAllocBill == null || existsMatAllocBill.isEmpty() || (notChangeDs = sourceBills.copy().join(existsMatAllocBill.copy(), JoinType.INNER).on(entryEntityName, "sourcebillentryid").on("auditdate", "nsrcauditdate").select(new String[]{entryEntityName}, new String[]{"id as matAllocId"}).finish()) == null || notChangeDs.isEmpty())) {
                        final HashSet<Long> sourceEntryIds = new HashSet<Long>(512);
                        final HashSet<Long> targetIds = new HashSet<Long>(512);
                        for (Row notChangeD : notChangeDs) {
                            sourceEntryIds.add(notChangeD.getLong(entryEntityName));
                            targetIds.add(notChangeD.getLong("matAllocId"));
                        }
                        logger.info("\u5dee\u91cf\u5f52\u96c6\u5224\u65ad\uff1a\u65b9\u6848\uff1a{}\u6709{}\u6761\u5206\u5f55\u6570\u636e\u672a\u6539\u53d8\uff0c\u5254\u9664", (Object)config.getString("number"), (Object)sourceEntryIds.size());
                        if (!sourceEntryIds.isEmpty()) {
                            final String finalEntryEntityName = entryEntityName;
                            sourceBills = sourceBills.filter(new FilterFunction(){

                                public boolean test(Row row) {
                                    return !sourceEntryIds.contains(row.getLong(finalEntryEntityName));
                                }
                            });
                        }
                        if (!targetIds.isEmpty()) {
                            existsMatAllocBill = existsMatAllocBill.filter(new FilterFunction(){

                                public boolean test(Row row) {
                                    return !targetIds.contains(row.getLong("id"));
                                }
                            });
                        }
                    }
                }
                logger.info("\u5dee\u91cf\u5f52\u96c6\u5224\u65ad\uff1a\u5dee\u91cf\u5904\u7406,\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - diffTime));
                if (this.getMatAllocContext().getEntryIdAllocMap().isEmpty() && !CadEmptyUtils.isEmpty(existsEntryIdAllocMap = this.getEntryIdAllocMap(existsMatAllocBill, fieldMappingMap))) {
                    this.getMatAllocContext().getEntryIdAllocMap().putAll(existsEntryIdAllocMap);
                }
                List partitionIds = BatchUtils.batchDataByEntryId((DataSet)sourceBills, (Integer)50000, (String)entryEntityName);
                logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u5206\u6279\uff1a\u65b9\u6848\u7f16\u53f7\uff1a{}\uff0c\u5206\u6279id\u7ed3\u675f\uff0c\u5171:{}\u6279", (Object)config.getString("number"), (Object)partitionIds.size());
                for (int i = 0; i < partitionIds.size(); ++i) {
                    this.getMatAllocContext().getNeedAddList().clear();
                    this.getMatAllocContext().getNeedUpdateList().clear();
                    this.getMatAllocContext().getConfigSrcAndTargetBillsMap().clear();
                    long start = TimeServiceHelper.now().getTime();
                    List entryIdList = (List)partitionIds.get(i);
                    logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u5206\u6279\uff1a\u5f00\u59cb\u5206\u6279\u4f5c\u4e1a:\u7b2c{}\u6279\uff0c\u5355\u636e\u6570\u91cf{}", (Object)i, (Object)entryIdList.size());
                    if (CadEmptyUtils.isEmpty((List)entryIdList)) continue;
                    QFilter entryIdQf = new QFilter(entryEntityName, "in", (Object)entryIdList);
                    DynamicObjectCollection resResults = QueryServiceHelper.query((String)sourceBillEntity, (String)selectFields, (QFilter[])new QFilter[]{entryIdQf});
                    IBillTransfer billTransfer = IBillTransfer.getTransferInstance((String)allocArgs.getEntityId(), (String)allocArgs.getAppNum());
                    BillTransferResult result = billTransfer.doTransfer((DynamicObject[])resResults.toArray((Object[])new DynamicObject[0]), config, this.configContext);
                    logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u5206\u6279\uff1a\u8f6c\u6362\u7ed3\u679c\uff1a{},\u8017\u65f6:{}", (Object)this.getMatAllocContext().getConfigSrcAndTargetBillsMap().size(), (Object)(TimeServiceHelper.now().getTime() - start));
                    this.getMatAllocContext().getConfigSrcAndTargetBillsMap().put((DynamicObject)config, result.getSrcAndTargetBillsMap());
                    for (IMatAllocAction matAllocAction : matAllocActions) {
                        long actionTime = System.currentTimeMillis();
                        matAllocAction.setContext(this.getMatAllocContext());
                        matAllocAction.execute();
                        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u5206\u6279\uff1a\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-action\uff1a{},\u8017\u65f6\uff1a{}ms", (Object)matAllocAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                    }
                    long end = TimeServiceHelper.now().getTime();
                    logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u5206\u6279\uff1a\u7b2c{}\u6279\u4f5c\u4e1a\u7ed3\u675f,\u8017\u65f6\uff1a{}", (Object)i, (Object)(end - start));
                }
                this.getMatAllocContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u5220\u9664\u6e90\u5355\u4e0d\u5b58\u5728\u7684\u5355\u636e\u3002", (String)"MatAllocTransferAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
                int delNum = this.deleteMatAllocNoSource(this.getMatAllocContext().getEntryIdAllocMap(), config.getString("number"));
                this.getMatAllocContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"MatAllocTransferAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), delNum));
            });
        }
    }

    private int deleteMatAllocNoSource(Map<Long, DynamicObject> entryIdAllocMap, String configNumber) {
        if (CadEmptyUtils.isEmpty(entryIdAllocMap)) {
            return 0;
        }
        Collection<DynamicObject> deleteSrcData = entryIdAllocMap.values();
        this.getMatAllocContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u4e2d\uff0c\u662f\u5426\u6709\u9700\u8981\u5220\u9664\u7684\u5355\u636e\uff1f", (String)"MatAllocTransferAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), configNumber));
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"aca_matalloc"), (Object[])deleteSrcData.toArray(new DynamicObject[0]));
        this.getMatAllocContext().setDelNum(this.getMatAllocContext().getDelNum() + deleteSrcData.size());
        this.getMatAllocContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"MatAllocTransferAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), deleteSrcData.size()));
        return deleteSrcData.size();
    }

    private Map<Long, DynamicObject> getEntryIdAllocMap(DataSet existsMatAllocBill, Map<String, String> fieldMappingMap) {
        HashMap<Long, DynamicObject> idDynamicObjMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Long> existIds = new HashSet<Long>(32);
        if (existsMatAllocBill != null && !existsMatAllocBill.isEmpty()) {
            for (Row row : existsMatAllocBill) {
                Long id = row.getLong("id");
                existIds.add(id);
            }
        }
        if (!CadEmptyUtils.isEmpty(existIds)) {
            DynamicObject[] matAllocs;
            QFilter idQf = new QFilter("id", "in", existIds);
            if (fieldMappingMap == null || fieldMappingMap.isEmpty()) {
                return idDynamicObjMap;
            }
            Set<String> fieldSet = fieldMappingMap.keySet();
            StringBuilder selectFields = new StringBuilder();
            for (String field : fieldSet) {
                selectFields.append(field);
                selectFields.append(",");
            }
            selectFields.append("id,useamount,sourcebillentryid,nsrcauditdate,usetype,entryentity.amount,entryentity.qty,allocstatus");
            for (DynamicObject matAlloc : matAllocs = BusinessDataServiceHelper.load((String)"aca_matalloc", (String)selectFields.toString(), (QFilter[])new QFilter[]{idQf})) {
                long sourceBillEntryId = matAlloc.getLong("sourcebillentryid");
                if (CadEmptyUtils.isEmpty((Long)sourceBillEntryId)) continue;
                idDynamicObjMap.put(sourceBillEntryId, matAlloc);
            }
        }
        return idDynamicObjMap;
    }

    private DataSet getExistMatAllocBill(Long acctOrgId, Long costAccountId, List<Long> costCenterIds, String srcBillType, String targetBillEntity, String appNum) {
        QFilter orgQf = new QFilter("org", "in", (Object)acctOrgId);
        orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
        QFilter costObjectQf = new QFilter("costcenter", "in", costCenterIds);
        QFilter appNumQf = new QFilter("appnum", "=", (Object)appNum);
        QFilter bookDateQf = CostAccountHelper.getImportScopeDateQf((Long)costAccountId, (String)"bizdate", (String)appNum);
        QFilter createDateQf = new QFilter("createtime", "<", (Object)this.getMatAllocContext().getCollectReport().getCollectDate());
        return QueryServiceHelper.queryDataSet((String)"MatAllocTransferAction_getExistMatAllocBill", (String)targetBillEntity, (String)"id,sourcebillentryid,nsrcauditdate", (QFilter[])new QFilter[]{orgQf, costObjectQf, bookDateQf, appNumQf, createDateQf}, (String)"id desc");
    }

    public List<DynamicObject> getValidCollConfigList(MatAllocContext context, String targetEntity) {
        if (this.collConfigList != null && this.collConfigList.size() > 0) {
            return this.collConfigList;
        }
        ArrayList<DynamicObject> values = new ArrayList<DynamicObject>(context.getRulesMap().values());
        HashSet calcDimensionIds = new HashSet(10);
        values.forEach(p -> calcDimensionIds.add(p.getLong("costcalcdimension")));
        return CommonCollConfigService.getCollConfigs((Long)context.getMatAllocArgs().getAcctOrgId(), null, calcDimensionIds, (String)targetEntity, (String)context.getMatAllocArgs().getAppNum());
    }

    private List<IMatAllocAction> initializeActions(String appNum) {
        ArrayList<IMatAllocAction> matAllocActions = new ArrayList<IMatAllocAction>();
        if ("aca".equals(appNum)) {
            matAllocActions.add(new MatAllocImportGdAction());
            matAllocActions.add(new MatAllocImportPzAction());
            matAllocActions.add(new MatAllocImportFpAction());
            matAllocActions.add(new MatAllocImportFlAction());
            matAllocActions.add(new MatAllocImportDiyAction());
            matAllocActions.add(new MatAllocSaveAction());
        }
        return matAllocActions;
    }

    private List<QFilter> getSrcQFilters(DynamicObject config, Map<Long, List<QFilter>> collConfigFilterMap, Map<String, String> fieldMappingMap, Map<String, String> selectValueMappingMap, Map<String, Set<Long>> costCentersourceTypeDataMap, CollectReport collectReport) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        QFilter speFilter = new QFilter("1", "!=", (Object)1);
        if (config == null) {
            filters.add(speFilter);
            return filters;
        }
        Long configId = config.getLong("id");
        String sourceBillEntity = config.getString("sourcebill.id");
        String manuOrgField = fieldMappingMap.getOrDefault("manuorg", "");
        String costCenterField = fieldMappingMap.get("costcenter");
        String timeField = "";
        timeField = "aca_matalloc".equals(this.configContext.getParam().getTargetEntity()) ? fieldMappingMap.get("bizdate") : fieldMappingMap.get("bookdate");
        List<Object> collConfigFilter = collConfigFilterMap.get(configId) == null ? new ArrayList(10) : collConfigFilterMap.get(configId);
        QFilter ccFilter = null;
        if (costCenterField == null) {
            logger.info("\u914d\u7f6e\u65b9\u6848{}\uff0c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb-\u6210\u672c\u4e2d\u5fc3\u5bf9\u5e94\u6e90\u5355\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u67e5\u8be2\u6e90\u5355\u5931\u8d25\u3002", (Object)config.getString("number"));
            filters.add(speFilter);
            return filters;
        }
        Object[] splitCostCenterField = costCenterField.split(",");
        if (splitCostCenterField.length == 1 && Arrays.asList(splitCostCenterField).contains("costcenter")) {
            ccFilter = new QFilter((String)splitCostCenterField[0], "in", (Object)this.configContext.getParam().getCostCenterIds());
        } else if (!CadEmptyUtils.isEmpty((Object[])splitCostCenterField)) {
            Set<Long> workCenterIds = costCentersourceTypeDataMap.get("mpdm_workcentre");
            Set<Long> adminOrgIds = costCentersourceTypeDataMap.get("bos_adminorg");
            Set<Long> bosOrgIds = costCentersourceTypeDataMap.get("bos_org");
            for (Object splitCostCenter : splitCostCenterField) {
                if (CadEmptyUtils.isEmpty((String)splitCostCenter)) continue;
                ccFilter = ccFilter == null ? this.costCenterRelationService.getWcOrOrgOrAoQFByWay(workCenterIds, adminOrgIds, bosOrgIds, (String)splitCostCenter, sourceBillEntity) : ccFilter.or(this.costCenterRelationService.getWcOrOrgOrAoQFByWay(workCenterIds, adminOrgIds, bosOrgIds, (String)splitCostCenter, sourceBillEntity));
                if (!((String)splitCostCenter).contains("costcenter")) continue;
                ccFilter = ccFilter == null ? new QFilter((String)splitCostCenter, "in", (Object)this.configContext.getParam().getCostCenterIds()) : ccFilter.or(new QFilter((String)splitCostCenter, "in", (Object)this.configContext.getParam().getCostCenterIds()));
            }
        }
        if (!"2".equals(selectValueMappingMap.get("costcenter"))) {
            filters.add(ccFilter);
        }
        if (!CadEmptyUtils.isEmpty(costCentersourceTypeDataMap.get("mpdm_workcentre")) && ("pom_mftorder".equals(sourceBillEntity) || "om_mftorder".equals(sourceBillEntity))) {
            HashMap entryIdWorkCenterMap = new HashMap(16);
            Set<Long> workCenter = costCentersourceTypeDataMap.get("mpdm_workcentre");
            String manfethEntity = "pom_mftorder".equals(sourceBillEntity) ? "sfc_manftech" : "om_mfttechnics";
            List entryIds = CostCenterHelper.getOrderEntryIds(new ArrayList<Long>(workCenter), (String)manfethEntity, entryIdWorkCenterMap, null);
            QFilter wcFilter = new QFilter("treeentryentity.id", "in", (Object)entryIds);
            if ("aca".equals(this.configContext.getParam().getAppnum())) {
                wcFilter.or(new QFilter("treeentryentity.pid", "in", (Object)entryIds));
            }
            ccFilter = ccFilter == null ? wcFilter : ccFilter.or(wcFilter);
            this.configContext.getConfigProEntryIdWorkCenterMap().computeIfAbsent(config, p -> new HashMap()).putAll(entryIdWorkCenterMap);
        }
        collConfigFilter.add(ccFilter);
        QFilter manuOrgFilter = null;
        if (!CadEmptyUtils.isEmpty((Object[])this.configContext.getParam().getManuOrgIds()) && !CadEmptyUtils.isEmpty((String)manuOrgField)) {
            manuOrgFilter = new QFilter(manuOrgField, "in", (Object)this.configContext.getParam().getManuOrgIds());
            collConfigFilter.add(manuOrgFilter);
        }
        QFilter importTimeScopeFilter = null;
        if (!CadEmptyUtils.isEmpty((String)timeField)) {
            if ("cad_mfgfeebill".equals(this.configContext.getParam().getTargetEntity()) || "aca_matalloc".equals(this.configContext.getParam().getTargetEntity())) {
                DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)this.configContext.getParam().getCostAccountId());
                HashSet<Long> periodIds = new HashSet<Long>(2);
                periodIds.add(currentPeriod == null ? 0L : currentPeriod.getLong("id"));
                Map dateByPeriod = PeriodHelper.getDateByPeriod(periodIds);
                if (!CadEmptyUtils.isEmpty((Map)dateByPeriod)) {
                    QFilter timeQFilter = new QFilter(timeField, ">=", dateByPeriod.get("begindate"));
                    timeQFilter.and(new QFilter(timeField, "<=", dateByPeriod.get("enddate")));
                    collConfigFilter.add(timeQFilter);
                }
            } else {
                importTimeScopeFilter = SysParamHelper.getImportTimeScope((Long)this.configContext.getParam().getCalOrgId(), (String)timeField, (String)this.configContext.getParam().getAppnum(), (CollectReport)collectReport);
                collConfigFilter.add(importTimeScopeFilter);
            }
        }
        return collConfigFilter;
    }

    /*
     * WARNING - void declaration
     */
    private String getSrcSelectFields(DynamicObject config, Map<String, String> fieldMappingMap, Map<String, String> ruleMappingMap) {
        void var11_24;
        void var11_22;
        if (config == null) {
            return null;
        }
        HashSet<String> srcFields = new HashSet<String>(10);
        String sourceBillEntity = config.getString("sourcebill.id");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBillEntity);
        srcFields.add("id");
        if (mainEntityType.findProperty("billno") != null) {
            srcFields.add("billno");
        } else if (mainEntityType.findProperty("number") != null) {
            srcFields.add("number AS billno");
        } else {
            srcFields.add("'' AS billno");
        }
        if (mainEntityType.findProperty("bookdate") != null) {
            srcFields.add("bookdate");
        }
        if (mainEntityType.findProperty("auditdate") != null) {
            srcFields.add("auditdate");
        }
        if (mainEntityType.findProperty("billtype") != null && mainEntityType.findProperty("billtype").getPropertyType().getName().endsWith("DynamicObject")) {
            srcFields.add("billtype.billformid AS billtype ");
        } else if (mainEntityType.findProperty("docbilltype") != null && mainEntityType.findProperty("docbilltype").getPropertyType().getName().endsWith("DynamicObject")) {
            srcFields.add("docbilltype.billformid AS billtype ");
        } else {
            srcFields.add("'" + sourceBillEntity + "' AS billtype ");
        }
        if (mainEntityType.findProperty("bomid") != null) {
            IDataEntityProperty bomid = mainEntityType.findProperty("bomid");
            IDataEntityType parentType = bomid.getParent();
            String name = bomid.getName();
            if (!(parentType instanceof MainEntityType)) {
                Iterator<Object> extendName = bomid.getParent().getExtendName();
                name = extendName + "." + name;
            }
            srcFields.add(name + " AS bomid");
            srcFields.add(name + ".version AS bomversion");
        }
        HashSet<String> values = new HashSet<String>(16);
        String entryEntity = "";
        String subEntryEntity = "";
        for (Map.Entry entry : fieldMappingMap.entrySet()) {
            String string = (String)entry.getValue();
            String[] splitValue = string.split(",");
            values.addAll(Arrays.asList(splitValue));
        }
        for (String string : values) {
            if (CadEmptyUtils.isEmpty((String)entryEntity) && string.contains(".")) {
                entryEntity = string.split("\\.")[0];
            }
            if (CadEmptyUtils.isEmpty((String)subEntryEntity) && string.split("\\.").length >= 3) {
                String[] stringArray = string.split("\\.");
                String subEntry = stringArray[1];
                Map allEntities = mainEntityType.getAllEntities();
                EntityType childreportentity = (EntityType)allEntities.get(subEntry);
                if (childreportentity != null && childreportentity.getParent() != null && entryEntity.equals(childreportentity.getParent().getName())) {
                    subEntryEntity = subEntry;
                }
            }
            if (!CadEmptyUtils.isEmpty((String)string)) {
                srcFields.add(string);
            }
            if (string.endsWith("material.masterid") || string.endsWith("material")) {
                if (!"material".equals(string)) {
                    srcFields.add(string + " AS material");
                }
                srcFields.add(string + ".number AS materialNumber");
                srcFields.add(string + ".name AS materialName");
            }
            if (string.endsWith("repactivity")) {
                srcFields.add(string + ".unit AS repactivityunit");
            }
            if (!"productworkshop".equals(string)) continue;
            srcFields.add(string + ".workshoporg");
        }
        if (!CadEmptyUtils.isEmpty(ruleMappingMap)) {
            for (Map.Entry entry : ruleMappingMap.entrySet()) {
                String string = (String)entry.getValue();
                if (CadEmptyUtils.isEmpty((String)string)) continue;
                srcFields.add(string);
            }
        }
        Map formulaFieldMap = CostConfigService.getFormulaFieldMap((DynamicObject)config);
        for (Map.Entry entry : formulaFieldMap.entrySet()) {
            srcFields.addAll((Collection)entry.getValue());
        }
        srcFields.remove(entryEntity);
        srcFields.remove(subEntryEntity);
        String string = String.join((CharSequence)",", srcFields);
        if (!CadEmptyUtils.isEmpty((String)entryEntity)) {
            String string2 = string + "," + entryEntity + ".id AS entryId," + entryEntity + ".seq AS entryseq";
        } else {
            String string3 = string + ",id AS entryId,1 AS entryseq";
        }
        if (!CadEmptyUtils.isEmpty((String)subEntryEntity)) {
            void var11_20;
            String string4 = (String)var11_20 + "," + entryEntity + "." + subEntryEntity + ".id AS subentryId," + entryEntity + "." + subEntryEntity + ".seq AS subentryseq";
        }
        if (("im_materialreqoutbill".equals(sourceBillEntity) || "im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity) || "im_mdc_mftfeedorder".equals(sourceBillEntity) || "im_mdc_omoutbill".equals(sourceBillEntity) || "im_mdc_omreturnbill".equals(sourceBillEntity) || "im_mdc_omfeedbill".equals(sourceBillEntity)) && !var11_22.contains("billentry.isrework")) {
            String string5 = (String)var11_22 + ",billentry.isrework";
        }
        return var11_24;
    }

    private boolean checkConfigChanged(DynamicObject config, String entityId) {
        QFilter appNumQf;
        QFilter colObjQf;
        if (StringUtils.isEmpty((String)entityId)) {
            return true;
        }
        Date modifyTime = config.getDate("modifytime");
        String appNum = config.getString("appnum");
        QFilter orgQf = new QFilter("org", "=", (Object)this.getMatAllocContext().getMatAllocArgs().getAcctOrgId());
        DynamicObjectCollection collectReports = QueryServiceHelper.query((String)"cad_colreport", (String)"coldate", (QFilter[])new QFilter[]{orgQf, colObjQf = new QFilter("colobj", "=", (Object)CollectObjectEnum.MAT_ALLOC.getObj()), appNumQf = new QFilter("appnum", "=", (Object)appNum)}, (String)"coldate desc");
        if (collectReports != null && collectReports.size() > 0) {
            return ((DynamicObject)collectReports.get(0)).getDate("coldate").compareTo(modifyTime) <= 0;
        }
        return true;
    }
}

