/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.matuse.IMatUseAction;
import kd.macc.cad.mservice.matuse.MatUseContext;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractMatUseAction
implements IMatUseAction {
    private Log logger = LogFactory.getLog(AbstractMatUseAction.class);
    private MatUseContext matUseContext;

    protected abstract void doExecute();

    @Override
    public void execute() {
        if (this.matUseContext.isContinueExecute()) {
            this.doExecute();
        }
    }

    @Override
    public void setContext(MatUseContext matUseContext) {
        this.matUseContext = matUseContext;
    }

    public MatUseContext getMatUseContext() {
        return this.matUseContext;
    }

    protected void save(List<DynamicObject> sourceBills) {
        int successQty;
        if (CollectionUtils.isEmpty(sourceBills)) {
            return;
        }
        List billNos = sourceBills.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toList());
        this.logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6-\u5f15\u5165\u7684\u5f52\u96c6\u5355\u7f16\u53f7\uff1a{}", (Object)JSON.toJSONString(billNos));
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)this.getMatUseContext().getMatUseArgs().getEntityId(), (DynamicObject[])sourceBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        int n = successQty = operateResult.getSuccessPkIds() == null ? 0 : operateResult.getSuccessPkIds().size();
        if (!operateResult.isSuccess()) {
            String errorInfo = OperationResultHelper.errorMsgHandle((OperationResult)operateResult);
            this.logger.error("\u4fdd\u5b58\u5931\u8d25\u3002" + errorInfo);
            this.getMatUseContext().setValidate(true);
            throw new KDBizException(errorInfo);
        }
    }

    protected void refreshProgress(String opContent, int nowComplete, int total, Boolean isAddNum) {
        MatUseContext matUseContext = this.getMatUseContext();
        String progressId = matUseContext.getMatUseArgs().getProgressId();
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (isAddNum.booleanValue()) {
            Integer complete = paramDto.getComplete();
            paramDto.setComplete(Integer.valueOf(complete + nowComplete));
        } else {
            paramDto.setComplete(Integer.valueOf(nowComplete));
        }
        if (!CadEmptyUtils.isEmpty((Integer)total)) {
            paramDto.setTotal(Integer.valueOf(total));
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"AbstractMatUseAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        paramDto.setDurationTimes(Integer.valueOf(0));
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam((String)progressId, (ProgressParamDto)paramDto);
        this.setReportPressAndDur(progressId);
    }

    private void setReportPressAndDur(String progressId) {
        Date coldate;
        int progress = this.getProgress(progressId);
        Long id = this.getMatUseContext().getCollectReport().getId();
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_colreport", (String)"coldate", (QFilter[])qFilter.toArray());
        String duration = "";
        if (dynamicObject != null && (coldate = dynamicObject.getDate("coldate")) != null) {
            double time = (double)(System.currentTimeMillis() - coldate.getTime()) / 1000.0;
            if (0.0 < time && time < 1.0) {
                time = 1.0;
            }
            duration = String.valueOf((int)time);
        }
        try (TXHandle handle = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cad_colreport set fprogress=" + progress + ",fduration=" + duration + " where fid =" + id));
        }
    }

    public int getProgress(String progressId) {
        if (StringUtils.isEmpty((CharSequence)progressId)) {
            return 0;
        }
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return 0;
        }
        if (CadEmptyUtils.isEmpty((Integer)paramDto.getTotal()) || CadEmptyUtils.isEmpty((Integer)paramDto.getComplete())) {
            return 0;
        }
        return (int)((double)paramDto.getComplete().intValue() / (double)paramDto.getTotal().intValue() * 100.0);
    }
}

