/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.MultiPartCcHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.mservice.matuse.AbstractMatUseAction;

public class CompletionSaveAction
extends AbstractMatUseAction {
    private static final Log logger = LogFactory.getLog(CompletionSaveAction.class);

    @Override
    protected void doExecute() {
        this.getMatUseContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f52\u96c6\u5230\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\u3002", (String)"CompletionSaveAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]));
        String progressId = this.getMatUseContext().getMatUseArgs().getProgressId();
        List<DynamicObject> matUseBills = this.getMatUseContext().getNewBillList();
        List billNos = matUseBills.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toList());
        logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5185\u90e8\u7cfb\u7edf\u5f15\u5165-\u5f15\u5165\u7684\u5f52\u96c6\u5355\u7f16\u53f7\uff1a{}", billNos);
        TXHandle txHandle = TX.requiresNew();
        try {
            this.refreshProgress(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f52\u96c6\u7684\u6570\u636e", (String)"CompletionSaveAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, 0, true);
            int saveSize = matUseBills.size();
            int batchSize = 300;
            if (saveSize <= batchSize * 3) {
                SaveServiceHelper.save((DynamicObject[])matUseBills.toArray(new DynamicObject[0]));
            } else {
                int batchCount = saveSize / batchSize + 1;
                for (int i = 0; i < batchCount; ++i) {
                    int startCount = i * batchSize;
                    int endCount = (i + 1) * batchSize;
                    if (i == batchCount - 1) {
                        endCount = saveSize;
                    }
                    List<DynamicObject> batchBillList = matUseBills.subList(startCount, endCount);
                    SaveServiceHelper.save((DynamicObject[])batchBillList.toArray(new DynamicObject[0]));
                }
            }
            this.refreshProgress(ResManager.loadKDString((String)"\u5f52\u96c6\u5355\u4fdd\u5b58\u6210\u529f\u3002", (String)"CompletionSaveAction_26", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, 0, true);
        }
        catch (Exception e) {
            txHandle.markRollback();
            ProgressHelper.showError((String)progressId, (String)e.getMessage());
            throw e;
        }
        finally {
            txHandle.commit();
            txHandle.close();
        }
        MultiPartCcHelper.resolveMultipartCc(this.getMatUseContext().getCostObjCcSet());
        this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"%s\u6761\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\u4fdd\u5b58\u6210\u529f\u3002", (String)"CompletionSaveAction_21", (String)"macc-cad-mservice", (Object[])new Object[0]), matUseBills.size()));
    }
}

