/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.business.numcheck.CollNumCheckHelper;
import kd.macc.cad.common.dto.CollectDiff;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.matuse.BaseImportDataAction;
import kd.macc.cad.mservice.matuse.MatUseContext;

public class EcaMatDiffAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(EcaMatDiffAction.class);

    @Override
    protected void doExecute() {
        if (!CollectReportHelper.disableCollectReport()) {
            MatUseContext matUseContext = this.getMatUseContext();
            CollectReport collectReport = this.getMatUseContext().getCollectReport();
            matUseContext.getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u68c0\u67e5\u6750\u6599\u8017\u7528\u5f52\u96c6\u5dee\u5f02", (String)"EcaMatDiffAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            Map billNoReasonMap = matUseContext.getErrorInfMap();
            Map billNoSuggestMap = matUseContext.getBillNoSuggestMap();
            ArrayList diffs = Lists.newArrayListWithExpectedSize((int)8);
            for (Map.Entry billNoReason : billNoReasonMap.entrySet()) {
                String key = (String)billNoReason.getKey();
                String[] split = key.split("@");
                String value = (String)billNoReason.getValue();
                String billNo = split[0];
                int seqInt = Integer.parseInt(CadEmptyUtils.isEmpty((String)split[1]) ? "0" : split[1]);
                try {
                    int lastIndex = billNo.lastIndexOf("-");
                    String seq = billNo.substring(lastIndex + 1);
                    seqInt = Integer.parseInt(seq);
                    billNo = billNo.substring(0, lastIndex);
                }
                catch (Exception e) {
                    logger.error("deal billno error -> {}, {}", (Object)billNo, (Object)e.getMessage());
                }
                CollectDiff collectDiff = new CollectDiff(billNo, Integer.valueOf(seqInt), split[2], value);
                collectDiff.setSrcbillType(split[2]);
                if (value.length() > 0) {
                    collectDiff.setReason(value);
                }
                collectDiff.setSuggest((String)billNoSuggestMap.get(key));
                diffs.add(collectDiff);
            }
            this.getDiffReason(collectReport.getDateRange(), diffs);
            if (diffs.size() > 0) {
                matUseContext.getCollectReport().getCollectDiffs().addAll(diffs);
                matUseContext.getCollectReport().setError(true);
            }
            this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"EcaMatDiffAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
            String desc = ResManager.loadKDString((String)"\u5171\u6709\u5dee\u5f02\u6570\u636e%s\u6761\u3002", (String)"EcaMatDiffAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]);
            matUseContext.getCollectReport().logCheckDesc(String.format(desc, diffs.size()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{collectReport.transfer2Dynamic(Boolean.FALSE)});
        }
    }

    private void getDiffReason(String daterange, List<CollectDiff> diffs) {
        Long accountOrgId = this.getMatUseContext().getMatUseArgs().getAcctOrgId();
        String appNum = this.getMatUseContext().getMatUseArgs().getAppNum();
        List<Long> costCenterIds = this.getMatUseContext().getMatUseArgs().getCostCenterIds();
        CollNumCheckHelper.getCostCenterDiff((String)"F", (String)daterange, (Long)accountOrgId, (String)appNum, costCenterIds, diffs, null);
    }
}

