/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.mservice.matuse.BaseImportDataAction;

public class EcaMatUseToCarryAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(EcaMatUseToCarryAction.class);

    @Override
    protected void doExecute() {
        this.refreshProgress(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u4e0b\u63a8\u6210\u672c\u7ed3\u8f6c\u5355\u5f00\u59cb\u3002", (String)"EcaMatUseToCarryAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 9, 10, true);
        DynamicObjectCollection matUseBills = this.getMatUseContext().getMatUseBills();
        logger.info("\u5f85\u751f\u6210\u7ed3\u8f6c\u5355\u6570\u91cf\uff1a{}", (Object)(matUseBills == null ? -1 : matUseBills.size()));
        if (matUseBills == null || matUseBills.isEmpty()) {
            return;
        }
        HashSet allocIds = new HashSet(16);
        matUseBills.forEach(p -> allocIds.add(p.getPkValue()));
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", allocIds), new QFilter("allocstatus", "=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())};
        List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"aca_matalloc", (QFilter[])filters, null, (int)-1);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(10);
        for (Object primaryKey : primaryKeys) {
            selectedRows.add(new ListSelectedRow(primaryKey));
        }
        logger.info("\u5b58\u5728{}\u6750\u6599\u5206\u914d\u5355\u636e\u4e0b\u63a8\u5230\u6210\u672c\u7ed3\u8f6c\u5355", (Object)selectedRows.size());
        if (selectedRows.isEmpty()) {
            return;
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("aca_matalloc");
        pushArgs.setTargetEntityNumber("eca_costcarrybill");
        pushArgs.setHasRight(true);
        pushArgs.setBuildConvReport(true);
        pushArgs.setSelectedRows(selectedRows);
        try (TXHandle h = TX.required();){
            try {
                ConvertOperationResult pushResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
                if (!pushResult.isSuccess()) {
                    StringBuilder errMessage = this.pushErrorMsgHandle(pushResult);
                    this.getMatUseContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u4e0b\u63a8\u6210\u672c\u7ed3\u8f6c\u5355", (String)"EcaMatUseToCarryAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5931\u8d25\uff1a%s\u3002", (String)"EcaMatUseToCarryAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), errMessage.toString());
                    this.getMatUseContext().getCollectReport().logCheckDesc(errorMsg);
                    throw new KDBizException(errorMsg);
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private StringBuilder pushErrorMsgHandle(ConvertOperationResult pushResult) {
        StringBuilder errMessage = new StringBuilder();
        errMessage.append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isSuccess()) continue;
            String billMessage = billReport.getFailMessage();
            logger.error("\u4e0b\u63a8\u6210\u672c\u7ed3\u8f6c\u5355\u5931\u8d25\uff1a{}", (Object)billMessage);
            errMessage.append(billMessage);
        }
        return errMessage;
    }
}

