/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.olap.util.Pair;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.mservice.matuse.BaseImportDataAction;
import kd.macc.cad.mservice.matuse.MatUseArgs;

public class MatUseAllocDirectAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(MatUseAllocDirectAction.class);

    @Override
    protected void doExecute() {
        this.refreshProgress(ResManager.loadKDString((String)"\u76f4\u63a5\u6750\u6599\u8017\u7528\u5206\u914d\u5f00\u59cb\u3002", (String)"MatUseAllocDirectAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 5, 10, true);
        DynamicObjectCollection matUseBills = this.getMatUseContext().getMatUseBills();
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u603b\u6761\u6570\uff1a{}", (Object)matUseBills.size());
        HashMap<Long, ArrayList<DynamicObject>> directBills = new HashMap<Long, ArrayList<DynamicObject>>(matUseBills.size());
        ArrayList<Long> sourceBillIds = new ArrayList<Long>(1);
        for (DynamicObject matUseBill : matUseBills) {
            Long costObjectId = matUseBill.getLong("costobject");
            Long costAccountId = matUseBill.getLong("costaccount");
            if (costObjectId == null || costObjectId == 0L) continue;
            sourceBillIds.add(matUseBill.getLong("matcollect"));
            ArrayList<DynamicObject> allocBills = (ArrayList<DynamicObject>)directBills.get(costAccountId);
            if (allocBills == null) {
                allocBills = new ArrayList<DynamicObject>(1);
            }
            allocBills.add(matUseBill);
            directBills.put(costAccountId, allocBills);
        }
        long billSize = 0L;
        long batch = 0L;
        MatUseArgs matUseArgs = this.getMatUseContext().getMatUseArgs();
        for (Map.Entry directBill : directBills.entrySet()) {
            ++batch;
            ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(16);
            Map<Long, Map<Long, List<DynamicObject>>> costRecords = this.getCalCostRecord((Long)directBill.getKey(), sourceBillIds);
            Date date = TimeServiceHelper.now();
            Map<String, Pair<Long, Long>> matIdToPairMap = this.getStringPairMap((List)directBill.getValue(), date, this.getMatUseContext().getMatUseArgs().getAcctOrgId());
            for (DynamicObject bill : (List)directBill.getValue()) {
                bill.set("appnum", (Object)matUseArgs.getAppNum());
                Long sourcebillid = bill.getLong("matcollect");
                Long sourcebillentryid = bill.getLong("matusesrcbillentryid");
                Map<Long, List<DynamicObject>> entryIdActualCostMap = costRecords.get(sourcebillid);
                if (entryIdActualCostMap == null) {
                    this.getMatUseContext().logErrorMsg(bill.getString("billno").concat("@").concat(" ").concat("@").concat("cal_costrecord_subentity"), ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u672a\u627e\u5230\u5173\u8054\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"MatUseAllocDirectAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c\u672a\u627e\u5230\u5173\u8054\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (Object)bill.getString("billno"));
                    continue;
                }
                List<DynamicObject> calCostRecList = entryIdActualCostMap.get(sourcebillentryid);
                bill.set("useamount", (Object)(calCostRecList == null || calCostRecList.isEmpty() ? BigDecimal.ZERO : calCostRecList.get(0).getBigDecimal("actualcost")));
                DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
                DynamicObject entry = entryentity.addNew();
                entry.set("costobejctentry", (Object)bill.getLong("costobject"));
                entry.set("qty", (Object)bill.getBigDecimal("useqty"));
                entry.set("amount", bill.get("useamount"));
                BigDecimal price = BigDecimal.ZERO;
                if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("useqty")) != 0) {
                    price = bill.getBigDecimal("useamount").divide(bill.getBigDecimal("useqty"), 10, RoundingMode.HALF_UP);
                }
                entry.set("price", (Object)price);
                Long materialId = bill.getLong("material");
                Long matVersionId = bill.getLong("matversion");
                Long auxptyId = bill.getLong("auxpty");
                Long manuorg = bill.getLong("manuorg");
                String strKey = this.getStrKey(String.valueOf(materialId), matVersionId, auxptyId, manuorg, date);
                Pair<Long, Long> eleSubElePair = matIdToPairMap.get(strKey);
                if (eleSubElePair != null) {
                    entry.set("subelemententry", eleSubElePair.getValue1());
                    entry.set("elemententry", eleSubElePair.getValue0());
                }
                bill.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
                bill.set("alloctype", (Object)ScaAllocEnum.ALLOCTYP_AUTO.getValue());
                bill.set("billstatus", (Object)"C");
                bill.set("alloctor", (Object)RequestContext.get().getCurrUserId());
                bill.set("allocatedate", (Object)TimeServiceHelper.now());
                bill.set("usetype", (Object)ScaAllocEnum.USETYPE_DRIECT.getValue());
                billList.add(bill);
            }
            long time = System.currentTimeMillis();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"aca_matalloc");
            Object[] saveAllocBill = billList.toArray(new DynamicObject[0]);
            SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])saveAllocBill);
            billSize += (long)saveAllocBill.length;
            logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u6279\u6b21\uff1a{}\u4fdd\u5b58\u5355\u636e\u6570\uff1a{},\u8017\u65f6\uff1a{}ms", new Object[]{batch, billList.size(), System.currentTimeMillis() - time});
        }
        logger.info("\u5171{}\u6761\u5206\u914d\u5355\u4fdd\u5b58", (Object)billSize);
    }

    private Map<String, Pair<Long, Long>> getStringPairMap(List<DynamicObject> bills, Date createTime, Long orgId) {
        Set materialToDateThreeTuple = bills.stream().map(e -> new Tuple((Object)new FourTuple((Object)e.getLong("material"), (Object)e.getLong("matversion"), (Object)e.getLong("auxpty"), (Object)e.getLong("manuorg")), (Object)createTime)).collect(Collectors.toSet());
        return (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getAcaSubElementByOrg", (Object[])new Object[]{orgId, materialToDateThreeTuple});
    }

    private String getStrKey(String materialId, Long matVersionId, Long auxptyId, Long manuorg, Date createDate) {
        materialId = this.isEmpty(matVersionId) ? materialId + "@0" : materialId + "@" + matVersionId;
        materialId = this.isEmpty(auxptyId) ? materialId + "@0" : materialId + "@" + auxptyId;
        String string = materialId = this.isEmpty(manuorg) ? materialId + "@0" : materialId + "@" + manuorg;
        if (createDate != null) {
            materialId = materialId + "@" + createDate.getTime();
        }
        return materialId;
    }

    private boolean isEmpty(Long item) {
        return item == null || item == 0L;
    }
}

