/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.MatAllocDataHelper;
import kd.macc.cad.mservice.matuse.BaseImportDataAction;
import kd.macc.cad.mservice.matuse.MatUseArgs;

public class MatUseAllocPublicAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(MatUseAllocPublicAction.class);
    private String classPath = "kd.macc.aca.algox.alloc.AcaMatAllocHelper";
    private String methodName = "doAlloc";

    @Override
    protected void doExecute() {
        this.refreshProgress(ResManager.loadKDString((String)"\u5171\u8017\u6750\u6599\u5206\u914d\u5f00\u59cb\u3002", (String)"MatUseAllocPublicAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 6, 10, true);
        DynamicObjectCollection matUseBills = this.getMatUseContext().getMatUseBills();
        HashMap<Long, ArrayList<DynamicObject>> publicBills = new HashMap<Long, ArrayList<DynamicObject>>(matUseBills.size());
        ArrayList<Long> sourceBillIds = new ArrayList<Long>(1);
        for (DynamicObject matUseBill : matUseBills) {
            Long costObjectId = matUseBill.getLong("costobject");
            Long costAccountId = matUseBill.getLong("costaccount");
            if (costObjectId != null && costObjectId != 0L) continue;
            sourceBillIds.add(matUseBill.getLong("matcollect"));
            ArrayList<DynamicObject> allocBills = (ArrayList<DynamicObject>)publicBills.get(costAccountId);
            if (allocBills == null) {
                allocBills = new ArrayList<DynamicObject>(1);
            }
            allocBills.add(matUseBill);
            publicBills.put(costAccountId, allocBills);
        }
        logger.info("\u5171\u8017\u6750\u6599\u5206\u914d\u6570\u91cf\uff1a{}", (Object)publicBills.size());
        if (publicBills.isEmpty()) {
            return;
        }
        long billSize = 0L;
        MatUseArgs matUseArgs = this.getMatUseContext().getMatUseArgs();
        Map matAllocStdMap = MatAllocDataHelper.getMatAllocStdMap((Long)matUseArgs.getAcctOrgId(), (String)matUseArgs.getAppNum());
        long batch = 0L;
        for (Map.Entry publicBill : publicBills.entrySet()) {
            ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(16);
            ++batch;
            Map<Long, Map<Long, List<DynamicObject>>> costRecords = this.getCalCostRecord((Long)publicBill.getKey(), sourceBillIds);
            for (DynamicObject bill : (List)publicBill.getValue()) {
                Long costdriverId = MatAllocDataHelper.getMatAllocStdCostDriver((Long)bill.getLong("org"), (Long)bill.getLong("manuorg"), (Long)bill.getLong("costcenter.id"), (Long)bill.getLong("material"), (Long)bill.getLong("matversion"), (Long)bill.getLong("auxpty"), (Long)bill.getLong("material.group"), (Map)matAllocStdMap);
                bill.set("costdriver", (Object)costdriverId);
                if (costdriverId == null || costdriverId == 0L) {
                    this.getMatUseContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u5171\u8017\u6750\u6599\u5206\u914d\u6807\u51c6", (String)"MatUseAllocPublicAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u201c%s\u201d\u4e0d\u5b58\u5728\u5206\u914d\u6807\u51c6\u3002", (String)"MatUseAllocPublicAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), bill.getString("billno")));
                    this.getMatUseContext().setAddNum(this.getMatUseContext().getAddNum() - 1);
                    logger.info(String.format("\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u636e\u7f16\u53f7\uff1a%s \u65e0\u5171\u8017\u6750\u6599\u5206\u914d\u6807\u51c6\u3002", bill.getString("billno")));
                    continue;
                }
                bill.set("appnum", (Object)matUseArgs.getAppNum());
                Long sourcebillid = bill.getLong("matcollect");
                Long sourcebillentryid = bill.getLong("matusesrcbillentryid");
                Map<Long, List<DynamicObject>> entryIdActualCostMap = costRecords.get(sourcebillid);
                if (entryIdActualCostMap == null) {
                    this.getMatUseContext().logErrorMsg(bill.getString("billno").concat("@").concat(" ").concat("@").concat("cal_costrecord_subentity"), ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u672a\u627e\u5230\u5173\u8054\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"MatUseAllocPublicAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c\u672a\u627e\u5230\u5173\u8054\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (Object)bill.getString("billno"));
                    continue;
                }
                if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("useqty")) == 0) {
                    this.getMatUseContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u5171\u8017\u6750\u6599\u5206\u914d", (String)"MatUseAllocPublicAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u636e\u7f16\u53f7\uff1a%s\uff0c\u9886\u6599\u6570\u91cf\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f15\u5165\u3002", (String)"MatUseAllocPublicAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), bill.getString("billno")));
                    logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c\u9886\u6599\u6570\u91cf\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f15\u5165\u3002", (Object)bill.getString("billno"));
                    continue;
                }
                List<DynamicObject> calCostRecList = entryIdActualCostMap.get(sourcebillentryid);
                bill.set("useamount", (Object)(calCostRecList == null || calCostRecList.isEmpty() ? BigDecimal.ZERO : calCostRecList.get(0).getBigDecimal("actualcost")));
                bill.set("id", (Object)MatUseAllocPublicAction.genDbLongId());
                billList.add(bill);
            }
            long time = System.currentTimeMillis();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"aca_matalloc");
            Object[] saveAllocBill = billList.toArray(new DynamicObject[0]);
            SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])saveAllocBill);
            billSize += (long)saveAllocBill.length;
            logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u6279\u6b21\uff1a{}\u4fdd\u5b58\u5355\u636e\u6570\uff1a{},\u8017\u65f6\uff1a{}ms", new Object[]{batch, billList.size(), System.currentTimeMillis() - time});
            time = System.currentTimeMillis();
            this.coAlloc(billList);
            logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u6279\u6b21\uff1a{}\u5f15\u5165\u65f6\u5bf9\u5171\u8017\u6750\u6599\u8fdb\u884c\u81ea\u52a8\u5206\u914d\u548c\u786e\u8ba4,\u8017\u65f6\uff1a{}ms", (Object)batch, (Object)(System.currentTimeMillis() - time));
        }
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u603b\u6761\u6570\uff1a{}", (Object)billSize);
    }

    private static long genDbLongId() {
        return DB.genGlobalLongId();
    }

    private void coAlloc(List<DynamicObject> dyns) {
        HashSet toAllocBills = new HashSet();
        dyns.forEach(t -> {
            if (!"2".equals(t.getString("allocstatus")) && t.getLong("costdriver") > 0L) {
                toAllocBills.add(t.getLong("id"));
            }
        });
        if (toAllocBills.isEmpty()) {
            return;
        }
        try {
            Class<?> doClass = Class.forName(this.classPath);
            Object obj = doClass.newInstance();
            Method method = doClass.getMethod(this.methodName, Set.class, String.class);
            method.invoke(obj, toAllocBills, "2");
        }
        catch (ClassNotFoundException e) {
            logger.error("ClassNotFoundException\uff1a{}", (Object)e.getMessage());
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("InstantiationException\uff1a{}", (Object)e.getMessage());
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.error("NoSuchMethodException\uff1a{}", (Object)e.getMessage());
        }
        catch (IllegalArgumentException | InvocationTargetException e) {
            logger.error("IllegalArgumentException\uff1a{}", (Object)e.getMessage());
        }
    }
}

