/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.business.config.service.CostObjectService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.matuse.AbstractMatUseAction;
import kd.macc.cad.mservice.matuse.MatUseArgs;

public class MatUseConditionAction
extends AbstractMatUseAction {
    private static final Log logger = LogFactory.getLog(MatUseConditionAction.class);
    private static String[] bill = new String[]{"PRO_GET", "PRO_FALLBACK", "PRO_ADD"};
    private static final String RO = "RO";
    private static final String SO = "SO";
    private static final String PZ = "PZ";
    private static final String FL = "FL";

    @Override
    protected void doExecute() {
        ArrayList<Long> adminOrgList;
        MatUseArgs matUseArgs = this.getMatUseContext().getMatUseArgs();
        Long acctOrgId = matUseArgs.getAcctOrgId();
        List<Long> costCenterIds = matUseArgs.getCostCenterIds();
        List<Long> manuOrgIds = matUseArgs.getManuOrgs();
        String appNum = matUseArgs.getAppNum();
        String importType = matUseArgs.getImportType();
        int totalNum = "aca".equals(appNum) ? 24 : 16;
        this.refreshProgress(ResManager.loadKDString((String)"\u6784\u5efa\u6761\u4ef6\uff0c\u5f52\u96c6\u5f00\u59cb\u3002", (String)"MatUseConditionAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, totalNum, false);
        List<Long> mftOrderEntryIds = matUseArgs.getMftOrderEntryIds();
        Map<String, String> responseInfo = this.getMatUseContext().getResponseInfo();
        Map notNeedCollectBillBizIdsMap = SysParamHelper.getNotNeedCollectBillBizIdsMap((Long)acctOrgId, (String)("sca".equals(appNum) ? "sca_matusecollect" : "aca_matusecollect"), (String)appNum);
        this.getMatUseContext().getNotNeedCollectBillBizIdsMap().putAll(notNeedCollectBillBizIdsMap);
        logger.info("\u6750\u6599\u8017\u7528\u91cf\u5f52\u96c6\u8986\u76d6\u5f15\u5165-\u53c2\u6570\uff1a" + acctOrgId + "#" + manuOrgIds.size() + "#" + costCenterIds.size() + "#" + importType + "#" + appNum);
        if (!this.checkPerm(appNum, responseInfo)) {
            MsgUtils.putMsg2Map((String)"tip", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"MatUseConditionAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), responseInfo);
            this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"MatUseConditionAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
            this.getMatUseContext().setContinueExecute(false);
            return;
        }
        Map<Long, Long> workCenterMap = this.getMatUseContext().getWorkCenterMap();
        Map<Long, List<Long>> costCenterBizUnitMap = this.getCostCenterBizUnitMap(acctOrgId, costCenterIds, appNum, workCenterMap, adminOrgList = new ArrayList<Long>(8));
        if (costCenterBizUnitMap == null) {
            MsgUtils.putMsg2Map((String)"tip", (String)ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"MatUseConditionAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), (String)"BuildConditionAction_0"), this.getMatUseContext().getResponseInfo());
            this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"MatUseConditionAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
            this.getMatUseContext().setContinueExecute(false);
            return;
        }
        this.getMatUseContext().getCostCenterBizUnitMap().putAll(costCenterBizUnitMap);
        if (CadEmptyUtils.isEmpty(mftOrderEntryIds) && CadEmptyUtils.isEmpty(matUseArgs.getCollectParamMap()) && "1".equals(CadBgParamUtils.getCadBgParamForString((String)"autoGenCostObject", (String)"1"))) {
            CostObjectService.generateCostObject((Long)acctOrgId, costCenterIds, matUseArgs.getManuOrgs(), null, (String)appNum, (CollectReport)this.getMatUseContext().getCollectReport());
        }
    }

    private boolean checkPerm(String appId, Map<String, String> responseInfo) {
        boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)this.getEntity(appId), (String)"47156aff000000ac");
        if (!hasPerm) {
            MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"MatUseConditionAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), new Object[0]), responseInfo);
            return false;
        }
        return true;
    }

    private String getEntity(String appNum) {
        if ("sca".equals(appNum)) {
            return "sca_matusecollect";
        }
        if ("aca".equals(appNum)) {
            return "aca_matusecollect";
        }
        return "sca_matusecollect";
    }

    private Map<Long, List<Long>> getCostCenterBizUnitMap(Long acctOrgId, List<Long> costCenterIds, String appId, Map<Long, Long> workCenterMap, List<Long> adminOrgList) {
        HashMap<Long, List<Long>> costcenterBizunitMap = new HashMap<Long, List<Long>>();
        if (CadEmptyUtils.isEmpty(costCenterIds)) {
            QFilter orgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
            QFilter orgFilter = new QFilter("accountorg", "=", (Object)acctOrgId);
            List allCostCenterIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])new QFilter[]{orgFilter, orgDutyFilter}, null, (int)9999);
            costCenterIds = new ArrayList<Long>(10);
            for (Object costCenterId2 : allCostCenterIds) {
                costCenterIds.add((Long)costCenterId2);
            }
        }
        List<Long> sysImpCostCenterIds = this.filterByAddWay(costCenterIds, acctOrgId, appId);
        Set dyDataRuleCostCenterIds = ImportServiceHelper.getDyDataRuleCostCenter((Long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)this.getEntity(appId), (String)"4730fc9f000003ae", Collections.singletonList(acctOrgId));
        if (!CadEmptyUtils.isEmpty((Set)dyDataRuleCostCenterIds)) {
            ArrayList notInDataRules = new ArrayList(10);
            sysImpCostCenterIds.forEach(p -> {
                if (!dyDataRuleCostCenterIds.contains(Long.parseLong(p.toString()))) {
                    notInDataRules.add(p);
                }
            });
            if (!CadEmptyUtils.isEmpty(sysImpCostCenterIds)) {
                sysImpCostCenterIds.removeAll(notInDataRules);
            }
        }
        if (!CollectionUtils.isEmpty(sysImpCostCenterIds)) {
            Map rulesMap = CostObjectHelper.getRulesMap((Long)acctOrgId, sysImpCostCenterIds);
            if (CadEmptyUtils.isEmpty((Map)rulesMap)) {
                return null;
            }
            this.getMatUseContext().getCostObjectRuleMap().putAll(rulesMap);
            Map<String, List<Long>> costCenterMap = this.getMatUseContext().getCostCenterMap();
            ArrayList roCostCenter = new ArrayList();
            ArrayList soCostCenter = new ArrayList();
            ArrayList pzCostCenter = new ArrayList();
            ArrayList flCostCenter = new ArrayList();
            sysImpCostCenterIds.forEach(costCenterId -> {
                DynamicObject costObjectRule = (DynamicObject)rulesMap.get(String.valueOf(acctOrgId) + costCenterId);
                if (costObjectRule == null) {
                    costObjectRule = (DynamicObject)rulesMap.get(String.valueOf(acctOrgId));
                }
                if (costObjectRule != null) {
                    String bizType;
                    switch (bizType = costObjectRule.getString("biztype")) {
                        case "RO": {
                            roCostCenter.add(costCenterId);
                            break;
                        }
                        case "SO": {
                            soCostCenter.add(costCenterId);
                            break;
                        }
                        case "PZ": {
                            pzCostCenter.add(costCenterId);
                            break;
                        }
                        case "FL": {
                            flCostCenter.add(costCenterId);
                            break;
                        }
                    }
                }
            });
            costCenterMap.put(RO, roCostCenter);
            costCenterMap.put(SO, soCostCenter);
            costCenterMap.put(PZ, pzCostCenter);
            costCenterMap.put(FL, flCostCenter);
            List importScopeDate = SysParamHelper.getImportScopeDate((Long)acctOrgId, (String)appId);
            this.getMatUseContext().getOrgImportScopeDate().put(acctOrgId, importScopeDate);
            workCenterMap.putAll(CostCenterHelper.getWorkCenterAndCostCenter(sysImpCostCenterIds, (List)importScopeDate));
            CostCenterHelper.getWorkCenter(sysImpCostCenterIds, (List)importScopeDate, (CollectReport)this.getMatUseContext().getCollectReport());
            adminOrgList.addAll(CostCenterHelper.getAdminOrg(sysImpCostCenterIds, (List)importScopeDate, (CollectReport)this.getMatUseContext().getCollectReport()));
            QFilter costCenterFilter = new QFilter("costcenter", "in", sysImpCostCenterIds);
            QFilter sourcetypeFilter = new QFilter("entryentity.sourcetype", "=", (Object)"bos_org");
            QFilter dateFilter = CostCenterHelper.getImportScopeDateFilter((List)importScopeDate);
            DynamicObjectCollection centerSourceMap = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"id,costcenter,entryentity.sourcedata", (QFilter[])new QFilter[]{costCenterFilter, sourcetypeFilter, dateFilter});
            for (DynamicObject sourceMap : centerSourceMap) {
                Long costCenterId3 = sourceMap.getLong("costcenter");
                Long bizUnitId = sourceMap.getLong("entryentity.sourcedata");
                costcenterBizunitMap.computeIfAbsent(costCenterId3, s -> new ArrayList()).add(bizUnitId);
            }
            this.getMatUseContext().getCollectReport().logOrgMap(costcenterBizunitMap);
        }
        return costcenterBizunitMap;
    }

    private List<Long> filterByAddWay(List<Long> costCenters, Long orgId, String appId) {
        if ("aca".equals(appId)) {
            return costCenters;
        }
        List<Object> centers = this.getCostCenterByCollectWay(Lists.newArrayList((Object[])new Long[]{orgId}), "matcollectway", "INNERSYSIMPORT", appId);
        costCenters.retainAll(centers);
        return costCenters;
    }

    public List<Object> getCostCenterByCollectWay(List<Long> acctOrgIds, String collectWayKey, String collectWay, String appId) {
        ArrayList<Object> ids = new ArrayList<Object>();
        QFilter orgFilter = null;
        orgFilter = CollectionUtils.isEmpty(acctOrgIds) ? new QFilter("accountorg", ">", (Object)0) : new QFilter("accountorg", "in", acctOrgIds);
        QFilter wayFitler = new QFilter(collectWayKey, "=", (Object)collectWay);
        QFilter appFilter = new QFilter("appnum", "=", (Object)appId);
        DynamicObjectCollection params = QueryServiceHelper.query((String)"cad_sysparam", (String)"accountorg,costcenter", (QFilter[])new QFilter[]{orgFilter, wayFitler, appFilter});
        for (DynamicObject param : params) {
            Object costcenter = param.get("costcenter");
            Object accountorg = param.get("accountorg");
            if (costcenter != null && (Long)costcenter != 0L) {
                ids.add(costcenter);
                continue;
            }
            List<Object> costcenters = this.getAllCostCenterByAcctOrg(accountorg);
            ids.addAll(costcenters);
        }
        return ids;
    }

    private List<Object> getAllCostCenterByAcctOrg(Object acctOrgId) {
        List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])new QFilter[]{new QFilter("accountorg", "=", acctOrgId)}, null, (int)9999999);
        return primaryKeys;
    }

    private String getOrgName(Long orgId) {
        return QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)}).getString("name");
    }

    private DynamicObjectCollection getExistCostObjects(Long orgId, Set<Long> impCostCenters, List<Long> proBillEntryIds, String manuorg) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        if (orgId != null) {
            qfList.add(new QFilter("org", "=", (Object)orgId));
        }
        if (impCostCenters != null) {
            qfList.add(new QFilter("costcenter", "in", impCostCenters));
        }
        if (!CadEmptyUtils.isEmpty((String)manuorg)) {
            qfList.add(new QFilter("manuorg", "=", (Object)Long.valueOf(manuorg)));
        }
        qfList.add(new QFilter("billstatus", "=", (Object)"C"));
        qfList.add(new QFilter("sotype", "=", (Object)"PB"));
        qfList.add(new QFilter("probill", "in", proBillEntryIds));
        return QueryServiceHelper.query((String)"cad_costobject", (String)"id, org, manuorg, costcenter, probill, srcbillnumber, srcbillrow", (QFilter[])qfList.toArray(new QFilter[0]));
    }

    private void wrapCostObjectCollection(DynamicObjectCollection existCostObjects, Map<Long, Map<Long, List<DynamicObject>>> costObjectToOrgMap, Set<Long> costCenterIds) {
        existCostObjects.forEach(e -> {
            Long orgId = e.getLong("org");
            Long costCenterId = e.getLong("costcenter");
            Map costCenter2CostObjectMap = costObjectToOrgMap.computeIfAbsent(orgId, s -> new HashMap());
            costCenter2CostObjectMap.computeIfAbsent(costCenterId, s -> new ArrayList()).add(e);
            costCenterIds.add(costCenterId);
        });
    }

    private Map<Long, Map<Long, List<DynamicObject>>> filterCostObjectBySysParam(Map<Long, Map<Long, List<DynamicObject>>> costObjectToOrgMap, Set<Long> costCenterIds, String appId) {
        ArrayList<QFilter> sysParamQf = new ArrayList<QFilter>();
        sysParamQf.add(new QFilter("appnum", "=", (Object)appId));
        sysParamQf.add(new QFilter("matcollectway", "!=", (Object)"INNERSYSIMPORT"));
        sysParamQf.add(new QFilter("costcenter", "in", costCenterIds));
        DynamicObjectCollection sysParamsToNotSysImp = QueryServiceHelper.query((String)"cad_sysparam", (String)"costcenter", (QFilter[])sysParamQf.toArray(new QFilter[0]));
        HashSet notSysImpCostCenterIds = new HashSet(16);
        sysParamsToNotSysImp.forEach(e -> notSysImpCostCenterIds.add(e.getLong("costcenter")));
        costCenterIds.removeAll(notSysImpCostCenterIds);
        sysParamQf.clear();
        sysParamQf.add(new QFilter("appnum", "=", (Object)appId));
        sysParamQf.add(new QFilter("matcollectway", "=", (Object)"INNERSYSIMPORT"));
        sysParamQf.add(new QFilter("costcenter", "in", costCenterIds).or("costcenter", "=", (Object)0L));
        DynamicObjectCollection sysParams = QueryServiceHelper.query((String)"cad_sysparam", (String)"accountorg AS org, costcenter, matcollectrange", (QFilter[])sysParamQf.toArray(new QFilter[0]));
        HashMap sysPamraToOrgMap = new HashMap(16);
        sysParams.forEach(e -> sysPamraToOrgMap.put(e.getLong("org"), e));
        HashSet<String> billNums = new HashSet<String>(Arrays.asList(bill));
        HashSet<Long> costCenters = new HashSet<Long>();
        HashMap<Long, Map<Long, List<DynamicObject>>> costObjectQfSysParamMap = new HashMap<Long, Map<Long, List<DynamicObject>>>(16);
        for (Map.Entry<Long, Map<Long, List<DynamicObject>>> orgToCostObjectMapEntry : costObjectToOrgMap.entrySet()) {
            Long orgId = orgToCostObjectMapEntry.getKey();
            DynamicObject sysParam = (DynamicObject)sysPamraToOrgMap.get(orgId);
            if (sysParam == null) continue;
            String matcollectrange = sysParam.getString("matcollectrange");
            String[] ranges = matcollectrange.split(",");
            boolean isProRange = false;
            for (String range : ranges) {
                if (!billNums.contains(range)) continue;
                isProRange = true;
                break;
            }
            if (!isProRange) continue;
            Map<Long, List<DynamicObject>> costCenterToMap = orgToCostObjectMapEntry.getValue();
            for (Map.Entry<Long, List<DynamicObject>> costCenterToMapEntry : costCenterToMap.entrySet()) {
                Long costCenterId = costCenterToMapEntry.getKey();
                if (!costCenterIds.contains(costCenterId)) continue;
                Map costCenter2CostObjectMap = costObjectQfSysParamMap.computeIfAbsent(orgId, s -> new HashMap());
                costCenter2CostObjectMap.put(costCenterId, costCenterToMapEntry.getValue());
                costCenters.add(costCenterId);
            }
        }
        logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u6210\u672c\u4e2d\u5fc3\u5217\u8868:" + costCenters);
        return costObjectQfSysParamMap;
    }

    private Map<Long, DynamicObject> filterCostObjectByDataRule(Map<Long, Map<Long, List<DynamicObject>>> costObjectQfSysParamMap, String appId) {
        Set<Long> sysImpOrgIds = costObjectQfSysParamMap.keySet();
        ArrayList<Long> sysImpOrgIdList = new ArrayList<Long>(sysImpOrgIds);
        Set dataRuleCostCenterIds = ImportServiceHelper.getDyDataRuleCostCenter((Long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)this.getEntity(appId), (String)"4730fc9f000003ae", sysImpOrgIdList);
        logger.info("\u6570\u636e\u89c4\u5219\u8bbe\u7f6e\u7684\u6210\u672c\u4e2d\u5fc3\u8fc7\u6ee4,\u6210\u672c\u4e2d\u5fc3\u8303\u56f4:" + dataRuleCostCenterIds);
        HashMap<Long, DynamicObject> mfgEntryIdToCostObjectMap = new HashMap<Long, DynamicObject>(16);
        for (Map<Long, List<DynamicObject>> costCenterToMap : costObjectQfSysParamMap.values()) {
            for (Map.Entry<Long, List<DynamicObject>> costCenterToMapEntry : costCenterToMap.entrySet()) {
                Long costCenterId = costCenterToMapEntry.getKey();
                if (!dataRuleCostCenterIds.isEmpty() && !dataRuleCostCenterIds.contains(costCenterId)) continue;
                List<DynamicObject> costObjects = costCenterToMapEntry.getValue();
                for (DynamicObject costObject : costObjects) {
                    mfgEntryIdToCostObjectMap.put(costObject.getLong("probill"), costObject);
                }
            }
        }
        return mfgEntryIdToCostObjectMap;
    }
}

