/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.matuse.BaseImportDataAction;
import kd.macc.cad.mservice.matuse.MatUseArgs;

public class MatUseCostObjectCreateAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(MatUseCostObjectCreateAction.class);

    @Override
    protected void doExecute() {
        Map<String, DynamicObject> createCostObjectBillMap = this.getMatUseContext().getCreateCostObjectBillMap();
        if (CadEmptyUtils.isEmpty(createCostObjectBillMap)) {
            return;
        }
        this.getMatUseContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"MatUseCostObjectCreateAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        HashSet<DynamicObject> saveItems = new HashSet<DynamicObject>();
        HashSet<String> createCostObjectSet = new HashSet<String>();
        MatUseArgs matUseArgs = this.getMatUseContext().getMatUseArgs();
        Long acctOrgId = matUseArgs.getAcctOrgId();
        List<Long> manuOrgIds = matUseArgs.getManuOrgs();
        Set<Long> materialIds = this.getMatUseContext().getCreateCostObjectMaterials();
        logger.info("\u9700\u8981\u65b0\u589e\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u6570\u91cf:{}", (Object)materialIds.size());
        DynamicObjectCollection noCostObjectMaterials = this.getNoCostObjectMaterials(materialIds);
        Map<String, DynamicObject> costObjectRuleMap = this.getMatUseContext().getCostObjectRuleMap();
        HashSet impCostCenters = Sets.newHashSetWithExpectedSize((int)200);
        for (Map.Entry<String, DynamicObject> entry : createCostObjectBillMap.entrySet()) {
            String costObjectKey = entry.getKey();
            String[] arr = costObjectKey.split("@");
            String bizType = arr[0];
            Long costCenterId = Long.valueOf(arr[2]);
            impCostCenters.add(costCenterId);
            Long productId = Long.valueOf(arr[3]);
            DynamicObject costObjectRule = costObjectRuleMap.get(String.valueOf(acctOrgId) + costCenterId);
            if (costObjectRule == null) {
                costObjectRule = costObjectRuleMap.get(String.valueOf(acctOrgId));
            }
            DynamicObject costObject = null;
            Long manuOrg = StringUtils.isNotBlank(manuOrgIds) && manuOrgIds.size() == 1 ? manuOrgIds.get(0) : Long.valueOf(0L);
            HashMap<Long, Long> costCenterAndManuOrgMap = new HashMap<Long, Long>(2);
            costCenterAndManuOrgMap.put(costCenterId, manuOrg);
            for (DynamicObject mat : noCostObjectMaterials) {
                if (mat.getLong("id") != productId.longValue()) continue;
                if (CostObjectEnum.BIZTYPE_SO.getValue().equals(bizType)) {
                    String productNum = arr[4];
                    HashMap<String, String> params = new HashMap<String, String>(16);
                    params.put("producenum", productNum);
                    costObject = CostObjectHelper.wrapMaterialObject4Save(costCenterAndManuOrgMap, (Long)costCenterId, (DynamicObject)costObjectRule, params, (DynamicObject)mat);
                    break;
                }
                if (!CostObjectEnum.BIZTYPE_PZ.getValue().equals(bizType)) continue;
                costObject = CostObjectHelper.wrapMaterialObject4Save(costCenterAndManuOrgMap, (Long)costCenterId, (DynamicObject)costObjectRule, null, (DynamicObject)mat);
                break;
            }
            if (costObject == null || createCostObjectSet.contains(costObject.getString("billno"))) continue;
            saveItems.add(costObject);
            createCostObjectSet.add(costObject.getString("billno"));
        }
        this.save(saveItems);
        this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u751f\u6210%s\u4e2a\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"MatUseCostObjectCreateAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), saveItems.size()));
        DynamicObjectCollection existCostObjects = this.getExistCostObjectsByProduct(acctOrgId, impCostCenters, materialIds, this.getMatUseContext().getMatUseArgs().getManuOrgs());
        Map<String, DynamicObject> pzExistCostObjectMap = this.wrapCostObjectMapByProduct(existCostObjects);
        Map<String, DynamicObject> roExistCostObjectMap = this.wrapCostObjectMapByProductAndPno(existCostObjects);
        for (Map.Entry<String, DynamicObject> entry : createCostObjectBillMap.entrySet()) {
            String costObjectKey = entry.getKey();
            String[] arr = costObjectKey.split("@");
            String bizType = arr[0];
            Long costCenterId = Long.valueOf(arr[2]);
            Long productId = Long.valueOf(arr[3]);
            String productNum = arr[4];
            Long srcEntryId = Long.valueOf(arr[5]);
            DynamicObject srcBill = entry.getValue();
            Long sourceBillId = (Long)srcBill.getPkValue();
            List<DynamicObject> newBillList = this.getMatUseContext().getNewBillList();
            for (DynamicObject matUseCollect : newBillList) {
                if (matUseCollect.getLong("sourcebillid") != sourceBillId.longValue()) continue;
                DynamicObjectCollection matUseEntry = matUseCollect.getDynamicObjectCollection("entryentity");
                for (DynamicObject matUse : matUseEntry) {
                    long costObjectId;
                    if (matUse.getLong("sourcebillentryid") != srcEntryId.longValue() || !CadEmptyUtils.isEmpty((Long)matUse.getLong("costobject"))) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append(bizType).append("@").append(acctOrgId).append("@").append(costCenterId).append("@").append(productId);
                    if (CostObjectEnum.BIZTYPE_SO.getValue().equals(bizType)) {
                        sb.append("@").append(productNum);
                        costObjectId = roExistCostObjectMap.get(sb.toString()) == null ? 0L : roExistCostObjectMap.get(sb.toString()).getLong("id");
                        matUse.set("costobject", (Object)costObjectId);
                        continue;
                    }
                    if (!CostObjectEnum.BIZTYPE_PZ.getValue().equals(bizType)) continue;
                    costObjectId = pzExistCostObjectMap.get(sb.toString()) == null ? 0L : pzExistCostObjectMap.get(sb.toString()).getLong("id");
                    matUse.set("costobject", (Object)costObjectId);
                }
            }
        }
    }

    private DynamicObjectCollection getNoCostObjectMaterials(Set<Long> materialIds) {
        ArrayList<QFilter> matFilters = new ArrayList<QFilter>();
        matFilters.add(new QFilter("enable", "=", (Object)true));
        matFilters.add(new QFilter("status", "=", (Object)"C"));
        matFilters.add(new QFilter("id", "in", materialIds));
        DynamicObjectCollection mats = QueryServiceHelper.query((String)"bd_material", (String)"id,masterid,isuseauxpty,isenablematerialversion,name,number,modelnum", (QFilter[])matFilters.toArray(new QFilter[0]));
        return mats;
    }

    protected void save(Set<DynamicObject> saveItems) {
        if (saveItems.isEmpty()) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cad_costobject");
        SaveServiceHelper.save((IDataEntityType)type, (Object[])saveItems.toArray(new DynamicObject[0]));
    }
}

