/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.CollectDiff;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.DiffHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.factedoutput.CompletionDiffAction;
import kd.macc.cad.mservice.matuse.AbstractMatUseAction;

public class MatUseDiffAction
extends AbstractMatUseAction {
    private final Log logger = LogFactory.getLog(CompletionDiffAction.class);
    private List<Long> roCostCenters = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzCostCenters = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> notRoWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> notRoOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> notRoAdmin = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> roWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> roOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> roAdmin = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzAdmin = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> selectedWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> selectedOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> selectedAdminOrg = Lists.newArrayListWithExpectedSize((int)8);
    private Map<Long, String> costCenterNameMap = Maps.newHashMapWithExpectedSize((int)32);

    @Override
    protected void doExecute() {
        if (!CollectReportHelper.disableCollectReport() && CadEmptyUtils.isEmpty(this.getMatUseContext().getMatUseArgs().getMftOrderEntryIds())) {
            Map unNeedBillInvSchemesMap;
            Map unNeedBillBizTypesMap;
            List flmCostCenters;
            List fpmCostCenters;
            List pzmCostCenters;
            Map calMethodCostCenters;
            List enableCostCenters;
            String appNum;
            CollectReport collectReport = this.getMatUseContext().getCollectReport();
            Long orgId = this.getMatUseContext().getCollectReport().getOrg();
            QFilter timeQf = DiffHelper.getCollectTimeRange((Long)orgId, (String)"bookdate", (String)(appNum = this.getMatUseContext().getMatUseArgs().getAppNum()), (CollectReport)collectReport);
            if (timeQf == null) {
                this.logger.info("\u672a\u83b7\u53d6\u5230\u6838\u7b97\u7ec4\u7ec7\u914d\u7f6e\u7684\u5f52\u96c6\u65f6\u95f4\u8303\u56f4");
                return;
            }
            this.getMatUseContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u68c0\u67e5\u6750\u6599\u8017\u7528\u5f52\u96c6\u5dee\u5f02", (String)"MatUseDiffAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            if ("sca".equals(appNum)) {
                enableCostCenters = DiffHelper.getEnableCostCenters((Long)orgId, (String)"sca_matusecollect", (String)appNum);
                calMethodCostCenters = DiffHelper.getCalMethodCostCenters((Long)orgId, (String)"sca_matusecollect", (String)appNum);
            } else {
                enableCostCenters = DiffHelper.getEnableCostCenters((Long)orgId, (String)"aca_matusecollect", (String)appNum);
                calMethodCostCenters = DiffHelper.getCalMethodCostCenters((Long)orgId, (String)"aca_matusecollect", (String)appNum);
            }
            List<Long> costCenters = this.getMatUseContext().getMatUseArgs().getCostCenterIds();
            List<Map<String, Date>> importScopeDate = this.getMatUseContext().getOrgImportScopeDate().get(orgId);
            if (costCenters != null && !costCenters.isEmpty() && enableCostCenters.size() != costCenters.size()) {
                this.getMatUseContext().setSingleSelected(true);
                this.selectedWc = CostCenterHelper.getWorkCenter(costCenters, importScopeDate);
                this.selectedOrg = CostCenterHelper.getBosOrgs(costCenters, importScopeDate);
                this.selectedAdminOrg = CostCenterHelper.getAdminOrg(costCenters, importScopeDate);
            }
            if (calMethodCostCenters == null || calMethodCostCenters.isEmpty()) {
                this.logger.info("\u672a\u83b7\u53d6\u5230\u8ba1\u7b97\u65b9\u6cd5\u4e0e\u6210\u672c\u4e2d\u5fc3\u7684\u5bf9\u5e94\u5173\u7cfb");
                return;
            }
            ArrayList allCostCenters = Lists.newArrayListWithExpectedSize((int)32);
            ArrayList fpflCostCenters = Lists.newArrayListWithExpectedSize((int)8);
            List roCostCenters = (List)calMethodCostCenters.get(orgId + CostObjectEnum.BIZTYPE_RO.getValue());
            if (roCostCenters != null && !roCostCenters.isEmpty()) {
                this.roCostCenters.addAll(roCostCenters);
                allCostCenters.addAll(roCostCenters);
                this.roWc = CostCenterHelper.getWorkCenter(this.roCostCenters, importScopeDate, (CollectReport)collectReport);
                this.roOrg = CostCenterHelper.getBosOrgs(this.roCostCenters, importScopeDate, (CollectReport)collectReport);
                this.roAdmin = CostCenterHelper.getAdminOrg(this.roCostCenters, importScopeDate, (CollectReport)collectReport);
            }
            if ((pzmCostCenters = (List)calMethodCostCenters.get(orgId + CostObjectEnum.BIZTYPE_PZ.getValue())) != null && !pzmCostCenters.isEmpty()) {
                this.pzCostCenters.addAll(pzmCostCenters);
                allCostCenters.addAll(pzmCostCenters);
                this.pzWc = CostCenterHelper.getWorkCenter(this.pzCostCenters, importScopeDate, (CollectReport)collectReport);
                this.pzOrg = CostCenterHelper.getBosOrgs(this.pzCostCenters, importScopeDate, (CollectReport)collectReport);
                this.pzAdmin = CostCenterHelper.getAdminOrg(this.pzCostCenters, importScopeDate, (CollectReport)collectReport);
            }
            if ((fpmCostCenters = (List)calMethodCostCenters.get(orgId + CostObjectEnum.BIZTYPE_SO.getValue())) != null && !fpmCostCenters.isEmpty()) {
                fpflCostCenters.addAll(fpmCostCenters);
                allCostCenters.addAll(fpmCostCenters);
            }
            if ((flmCostCenters = (List)calMethodCostCenters.get(orgId + CostObjectEnum.BIZTYPE_FL.getValue())) != null && !flmCostCenters.isEmpty()) {
                fpflCostCenters.addAll(flmCostCenters);
                allCostCenters.addAll(flmCostCenters);
            }
            if (fpflCostCenters != null && !fpflCostCenters.isEmpty()) {
                this.notRoWc = CostCenterHelper.getWorkCenter((Collection)fpflCostCenters, importScopeDate, (CollectReport)collectReport);
                this.notRoOrg = CostCenterHelper.getBosOrgs((Collection)fpflCostCenters, importScopeDate, (CollectReport)collectReport);
                this.notRoAdmin = CostCenterHelper.getAdminOrg((Collection)fpflCostCenters, importScopeDate, (CollectReport)collectReport);
            }
            this.costCenterNameMap = DiffHelper.getCostCenterNameMap((List)allCostCenters);
            collectReport.setTimeQf(timeQf);
            if ("sca".equals(appNum)) {
                unNeedBillBizTypesMap = DiffHelper.getUnNeedBillBizTypesMap((Long)orgId, (String)"sca_matusecollect", (String)appNum);
                unNeedBillInvSchemesMap = DiffHelper.getUnNeedBillInvSchemesMap((Long)orgId, (String)"sca_matusecollect", (String)appNum);
            } else {
                unNeedBillBizTypesMap = DiffHelper.getUnNeedBillBizTypesMap((Long)orgId, (String)"aca_matusecollect", (String)appNum);
                unNeedBillInvSchemesMap = DiffHelper.getUnNeedBillInvSchemesMap((Long)orgId, (String)"aca_matusecollect", (String)appNum);
            }
            if (unNeedBillBizTypesMap != null && !unNeedBillBizTypesMap.isEmpty()) {
                for (Map.Entry billBizTypes : unNeedBillBizTypesMap.entrySet()) {
                    Set bizTypesConf = (Set)billBizTypes.getValue();
                    collectReport.getBizTypeIds().addAll(bizTypesConf);
                }
            }
            if (unNeedBillInvSchemesMap != null && !unNeedBillInvSchemesMap.isEmpty()) {
                for (Map.Entry billInvSchemes : unNeedBillInvSchemesMap.entrySet()) {
                    Set invSchemesConfig = (Set)billInvSchemes.getValue();
                    collectReport.getInvSchemeIds().addAll(invSchemesConfig);
                }
            }
            Map costCenterRangeMap = DiffHelper.getCostCenterRangeBillMap((Long)orgId, (List)allCostCenters, (String)"matcollectrange", (String)appNum);
            int scllSize = this.diffScll(unNeedBillBizTypesMap, unNeedBillInvSchemesMap, costCenterRangeMap);
            int wwllSize = this.diffWwll(unNeedBillBizTypesMap, unNeedBillInvSchemesMap, costCenterRangeMap);
            int llckSize = this.diffLlck(unNeedBillBizTypesMap, unNeedBillInvSchemesMap, costCenterRangeMap);
            this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u9886/\u9000/\u8865\u6599\u5355\u5dee\u5f02%1$s\u6761\u6570\u636e\uff0c\u59d4\u5916\u9886\u9000\u8865\u6599\u5dee\u5f02%2$s\u6761\u6570\u636e\u3002\u9886\u6599\u51fa\u5e93\u5355\u5dee\u5f02%3$s\u6761\u6570\u636e\u3002", (String)"MatUseDiffAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), scllSize, wwllSize, llckSize));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getMatUseContext().getCollectReport().transfer2Dynamic()});
        }
    }

    private int diffLlck(Map<String, Set<Long>> unNeedBillBizTypesMap, Map<String, Set<Long>> unNeedBillInvSchemesMap, Map<Long, String> costCenterRangeMap) {
        DataSet llckData;
        ArrayList llckDiffs = Lists.newArrayListWithExpectedSize((int)8);
        Set<Object> bizTypeIds = Sets.newHashSetWithExpectedSize((int)8);
        if (unNeedBillBizTypesMap != null && unNeedBillBizTypesMap.containsKey("im_materialreqoutbill")) {
            bizTypeIds = unNeedBillBizTypesMap.get("im_materialreqoutbill");
        }
        Set<Object> invSchemeIds = Sets.newHashSetWithExpectedSize((int)8);
        if (unNeedBillInvSchemesMap != null && unNeedBillInvSchemesMap.containsKey("im_materialreqoutbill")) {
            invSchemeIds = unNeedBillInvSchemesMap.get("im_materialreqoutbill");
        }
        if ((llckData = this.getLlckData()) != null && !llckData.isEmpty()) {
            DataSet llckCopy = llckData.copy();
            HashSet entryIds = Sets.newHashSetWithExpectedSize((int)8);
            for (Row row : llckCopy) {
                entryIds.add(row.getLong("entryid"));
            }
            DataSet matUseData = this.getMatUseData(entryIds);
            DataSet allData = llckData.leftJoin(matUseData).on("entryid", "sourcebillentryid").select(llckData.getRowMeta().getFieldNames(), matUseData.getRowMeta().getFieldNames()).finish();
            DataSet unMatchedData = allData.filter("sourcebillentryid is null or sourcebillentryid = 0").orderBy(new String[]{"id desc"});
            for (Row row : unMatchedData) {
                Map billNoReasonMap;
                String srcErrorMsg;
                String billStatus = row.getString("billstatus");
                Long bizType = row.getLong("biztype");
                Long invScheme = row.getLong("invscheme");
                StringBuilder reasonStr = new StringBuilder();
                CollectDiff collectDiff = new CollectDiff(row.getString("billno"), row.getInteger("seq"), row.getString("billtype"), row.getDate("bookdate"));
                if (!"C".equals(billStatus)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"MatUseDiffAction_2", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (bizTypeIds != null && bizTypeIds.contains(bizType)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5f52\u96c6\u201d\u3002", (String)"MatUseDiffAction_3", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (invSchemeIds != null && invSchemeIds.contains(invScheme)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5f52\u96c6\u201d\u3002", (String)"MatUseDiffAction_4", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (!StringUtils.isEmpty((Object)(srcErrorMsg = this.checkCostCenterSrcLlck(row, costCenterRangeMap)))) {
                    reasonStr.append(srcErrorMsg).append("\uff1b");
                }
                if (!(billNoReasonMap = this.getMatUseContext().getErrorInfMap()).isEmpty() && billNoReasonMap.containsKey(row.getString("billno").concat("@").concat(row.getString("seq")))) {
                    reasonStr.append((String)billNoReasonMap.get(row.getString("billno").concat("@").concat(row.getString("seq"))));
                }
                collectDiff.setBillType(row.getString("billtype"));
                if (reasonStr.length() > 0) {
                    collectDiff.setReason(reasonStr.toString());
                } else {
                    collectDiff.setReason(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0", (String)"MatUseDiffAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]));
                }
                llckDiffs.add(collectDiff);
            }
        }
        if (llckDiffs.size() > 0) {
            this.getMatUseContext().getCollectReport().getCollectDiffs().addAll(llckDiffs);
            this.getMatUseContext().getCollectReport().setError(true);
        }
        return llckDiffs.size();
    }

    private int diffWwll(Map<String, Set<Long>> unNeedBillBizTypesMap, Map<String, Set<Long>> unNeedBillInvSchemesMap, Map<Long, String> costCenterRangeMap) {
        ArrayList wwllDiffs = Lists.newArrayListWithExpectedSize((int)8);
        DataSet wwllData = this.getWwllData();
        if (wwllData != null && !wwllData.isEmpty()) {
            DataSet scllCopy = wwllData.copy();
            HashSet entryIds = Sets.newHashSetWithExpectedSize((int)8);
            for (Row row : scllCopy) {
                entryIds.add(row.getLong("entryid"));
            }
            DataSet matUseData = this.getMatUseData(entryIds);
            DataSet allData = wwllData.leftJoin(matUseData).on("entryid", "sourcebillentryid").select(wwllData.getRowMeta().getFieldNames(), matUseData.getRowMeta().getFieldNames()).finish();
            DataSet unMatchedData = allData.filter("sourcebillentryid is null or sourcebillentryid = 0").orderBy(new String[]{"id desc"});
            for (Row row : unMatchedData) {
                Map billNoReasonMap;
                String srcErrorMsg;
                String billStatus = row.getString("billstatus");
                Long bizType = row.getLong("biztype");
                Long invScheme = row.getLong("invscheme");
                String entityId = row.getString("entityid");
                StringBuilder reasonStr = new StringBuilder();
                CollectDiff collectDiff = new CollectDiff(row.getString("billno"), row.getInteger("seq"), row.getString("billtype"), row.getDate("bookdate"));
                if (!"C".equals(billStatus)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"MatUseDiffAction_2", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (unNeedBillBizTypesMap != null && unNeedBillBizTypesMap.containsKey(entityId) && unNeedBillBizTypesMap.get(entityId).contains(bizType)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5f52\u96c6\u201d\u3002", (String)"MatUseDiffAction_3", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (unNeedBillInvSchemesMap != null && unNeedBillInvSchemesMap.containsKey(entityId) && unNeedBillInvSchemesMap.get(entityId).contains(invScheme)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5f52\u96c6\u201d\u3002", (String)"MatUseDiffAction_4", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (!StringUtils.isEmpty((Object)(srcErrorMsg = this.checkCostCenterSrcScWw(row, costCenterRangeMap, "WLL", ResManager.loadKDString((String)"\u59d4\u5916\u9886/\u9000/\u8865\u6599\u5355", (String)"MatUseDiffAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]))))) {
                    reasonStr.append(srcErrorMsg).append("\uff1b");
                }
                if (!(billNoReasonMap = this.getMatUseContext().getErrorInfMap()).isEmpty() && billNoReasonMap.containsKey(row.getString("billno").concat("@").concat(row.getString("seq")))) {
                    reasonStr.append((String)billNoReasonMap.get(row.getString("billno").concat("@").concat(row.getString("seq"))));
                }
                collectDiff.setBillType(row.getString("billtype"));
                if (reasonStr.length() > 0) {
                    collectDiff.setReason(reasonStr.toString());
                } else {
                    collectDiff.setReason(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0", (String)"MatUseDiffAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]));
                }
                wwllDiffs.add(collectDiff);
            }
        }
        if (wwllDiffs.size() > 0) {
            this.getMatUseContext().getCollectReport().getCollectDiffs().addAll(wwllDiffs);
            this.getMatUseContext().getCollectReport().setError(true);
        }
        return wwllDiffs.size();
    }

    private int diffScll(Map<String, Set<Long>> unNeedBillBizTypesMap, Map<String, Set<Long>> unNeedBillInvSchemesMap, Map<Long, String> costCenterRangeMap) {
        ArrayList scllDiffs = Lists.newArrayListWithExpectedSize((int)8);
        DataSet scllData = this.getScllData();
        if (!scllData.isEmpty()) {
            DataSet scllCopy = scllData.copy();
            HashSet entryIds = Sets.newHashSetWithExpectedSize((int)8);
            for (Row row : scllCopy) {
                entryIds.add(row.getLong("entryid"));
            }
            DataSet matUseData = this.getMatUseData(entryIds);
            DataSet allData = scllData.leftJoin(matUseData).on("entryid", "sourcebillentryid").select(scllData.getRowMeta().getFieldNames(), matUseData.getRowMeta().getFieldNames()).finish();
            DataSet unMatchedData = allData.filter("sourcebillentryid is null or sourcebillentryid = 0").orderBy(new String[]{"id desc"});
            for (Row row : unMatchedData) {
                Map billNoReasonMap;
                String srcErrorMsg;
                String billStatus = row.getString("billstatus");
                Long bizType = row.getLong("biztype");
                String entityId = row.getString("entityid");
                Long invScheme = row.getLong("invscheme");
                StringBuilder reasonStr = new StringBuilder();
                CollectDiff collectDiff = new CollectDiff(row.getString("billno"), row.getInteger("seq"), row.getString("billtype"), row.getDate("bookdate"));
                if (!"C".equals(billStatus)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"MatUseDiffAction_2", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (unNeedBillBizTypesMap != null && unNeedBillBizTypesMap.containsKey(entityId) && unNeedBillBizTypesMap.get(entityId).contains(bizType)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5f52\u96c6\u201d\u3002", (String)"MatUseDiffAction_3", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (unNeedBillInvSchemesMap != null && unNeedBillInvSchemesMap.containsKey(entityId) && unNeedBillInvSchemesMap.get(entityId).contains(invScheme)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5f52\u96c6\u201d\u3002", (String)"MatUseDiffAction_4", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (!StringUtils.isEmpty((Object)(srcErrorMsg = this.checkCostCenterSrcScWw(row, costCenterRangeMap, "PRO_GET", ResManager.loadKDString((String)"\u751f\u4ea7\u9886/\u9000/\u8865\u6599\u5355", (String)"MatUseDiffAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]))))) {
                    reasonStr.append(srcErrorMsg).append("\uff1b");
                }
                if (!(billNoReasonMap = this.getMatUseContext().getErrorInfMap()).isEmpty() && billNoReasonMap.containsKey(row.getString("billno").concat("@").concat(row.getString("seq")))) {
                    reasonStr.append((String)billNoReasonMap.get(row.getString("billno").concat("@").concat(row.getString("seq"))));
                }
                collectDiff.setBillType(row.getString("billtype"));
                if (reasonStr.length() > 0) {
                    collectDiff.setReason(reasonStr.toString());
                } else {
                    collectDiff.setReason(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0", (String)"MatUseDiffAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]));
                }
                scllDiffs.add(collectDiff);
            }
        }
        if (scllDiffs.size() > 0) {
            this.getMatUseContext().getCollectReport().getCollectDiffs().addAll(scllDiffs);
            this.getMatUseContext().getCollectReport().setError(true);
        }
        return scllDiffs.size();
    }

    private String checkCostCenterSrcLlck(Row row, Map<Long, String> costCenterRangeMap) {
        boolean adminOrgFlag;
        Long workCenter = row.getLong("workcenter");
        Long org = row.getLong("org");
        Long produceDept = row.getLong("adminorg");
        boolean workCenterFlag = this.roWc.contains(workCenter) || this.pzWc.contains(workCenter) || this.notRoWc.contains(workCenter);
        boolean orgFlag = this.roOrg.contains(org) || this.pzOrg.contains(org) || this.notRoOrg.contains(org);
        boolean bl = adminOrgFlag = this.roAdmin.contains(produceDept) || this.pzAdmin.contains(produceDept) || this.notRoAdmin.contains(produceDept);
        if (workCenterFlag || orgFlag || adminOrgFlag) {
            Map srcCostCenterMap = this.getMatUseContext().getCollectReport().getSrcCostCenterMap();
            Long cc = 0L;
            if (srcCostCenterMap != null && costCenterRangeMap != null) {
                if (srcCostCenterMap.containsKey(workCenter)) {
                    cc = (Long)srcCostCenterMap.get(workCenter);
                }
                if (srcCostCenterMap.containsKey(org)) {
                    cc = (Long)srcCostCenterMap.get(org);
                }
                if (srcCostCenterMap.containsKey(produceDept)) {
                    cc = (Long)srcCostCenterMap.get(produceDept);
                }
            }
            if (!CadEmptyUtils.isEmpty((Long)cc) && costCenterRangeMap != null) {
                String range = costCenterRangeMap.get(cc);
                if (CadEmptyUtils.isEmpty(costCenterRangeMap) || !StringUtils.isEmpty((Object)range) && range.indexOf("GET_OUTSTORAGE") == -1) {
                    String ccName = this.costCenterNameMap.get(cc);
                    if (!StringUtils.isEmpty((Object)ccName)) {
                        return String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%s\u201d\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6\u9886\u6599\u51fa\u5e93\u5355\u3002", (String)"MatUseDiffAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]), ccName);
                    }
                    return ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6\u9886\u6599\u51fa\u5e93\u5355\u3002", (String)"MatUseDiffAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]);
                }
            }
            if (this.getMatUseContext().isSingleSelected()) {
                if (this.selectedWc.contains(workCenter) || this.selectedOrg.contains(org) || this.selectedAdminOrg.contains(produceDept)) {
                    return null;
                }
                return ResManager.loadKDString((String)"\u672a\u5339\u914d\u4e0a\u9009\u4e2d\u7684\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u8bf7\u9009\u62e9\u4e0d\u9650\u8fdb\u884c\u5bfc\u5165\u3002", (String)"MatUseDiffAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]);
            }
            return null;
        }
        return ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\u5339\u914d\u5931\u8d25\u3002", (String)"MatUseDiffAction_11", (String)"macc-cad-mservice", (Object[])new Object[0]);
    }

    private String checkCostCenterSrcScWw(Row row, Map<Long, String> costCenterRangeMap, String billStr, String desc) {
        boolean adminOrgFlag;
        boolean orgFlag;
        boolean workCenterFlag;
        Long workCenter = row.getLong("workcenter");
        Long org = row.getLong("org");
        Long produceDept = row.getLong("adminorg");
        boolean bl = workCenterFlag = this.roWc.contains(workCenter) || this.pzWc.contains(workCenter);
        if (!workCenterFlag && this.notRoWc.contains(workCenter)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279/\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u751f\u4ea7\u5165/\u9000\u5e93\u5355", (String)"MatUseDiffAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean bl2 = orgFlag = this.roOrg.contains(org) || this.pzOrg.contains(org);
        if (!orgFlag && this.notRoOrg.contains(org)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279/\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u751f\u4ea7\u5165/\u9000\u5e93\u5355", (String)"MatUseDiffAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean bl3 = adminOrgFlag = this.roAdmin.contains(produceDept) || this.pzAdmin.contains(produceDept);
        if (!adminOrgFlag && this.notRoAdmin.contains(produceDept)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279/\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u751f\u4ea7\u5165/\u9000\u5e93\u5355", (String)"MatUseDiffAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        if (workCenterFlag || orgFlag || adminOrgFlag) {
            Map srcCostCenterMap = this.getMatUseContext().getCollectReport().getSrcCostCenterMap();
            Long cc = 0L;
            if (srcCostCenterMap != null && costCenterRangeMap != null) {
                if (srcCostCenterMap.containsKey(workCenter)) {
                    cc = (Long)srcCostCenterMap.get(workCenter);
                }
                if (srcCostCenterMap.containsKey(org)) {
                    cc = (Long)srcCostCenterMap.get(org);
                }
                if (srcCostCenterMap.containsKey(produceDept)) {
                    cc = (Long)srcCostCenterMap.get(produceDept);
                }
            }
            if (!CadEmptyUtils.isEmpty((Long)cc) && costCenterRangeMap != null) {
                String range = costCenterRangeMap.get(cc);
                if (CadEmptyUtils.isEmpty(costCenterRangeMap) || !StringUtils.isEmpty((Object)range) && range.indexOf(billStr) == -1) {
                    String ccName = this.costCenterNameMap.get(cc);
                    if (!StringUtils.isEmpty((Object)ccName)) {
                        return String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6%2$s\u3002", (String)"MatUseDiffAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), ccName, desc);
                    }
                    return String.format(ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6%s\u3002", (String)"MatUseDiffAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]), desc);
                }
            }
            if (this.getMatUseContext().isSingleSelected()) {
                if (this.selectedWc.contains(workCenter) || this.selectedOrg.contains(org) || this.selectedAdminOrg.contains(produceDept)) {
                    return null;
                }
                return ResManager.loadKDString((String)"\u672a\u5339\u914d\u4e0a\u9009\u4e2d\u7684\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u8bf7\u9009\u62e9\u4e0d\u9650\u8fdb\u884c\u5bfc\u5165\u3002", (String)"MatUseDiffAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]);
            }
            return null;
        }
        return ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\u5339\u914d\u5931\u8d25\u3002", (String)"MatUseDiffAction_11", (String)"macc-cad-mservice", (Object[])new Object[0]);
    }

    private DataSet getScllData() {
        Long orgId = this.getMatUseContext().getCollectReport().getOrg();
        String appNum = this.getMatUseContext().getMatUseArgs().getAppNum();
        List hasPermInvOrgs = "sca".equals(this.getMatUseContext().getMatUseArgs().getAppNum()) ? OrgHelper.getUserHasPermStoreOrgsByAccOrg((Long)orgId, (String)"sca_matusecollect", (String)appNum) : OrgHelper.getUserHasPermStoreOrgsByAccOrg((Long)orgId, (String)"aca_matusecollect", (String)appNum);
        if (hasPermInvOrgs == null || hasPermInvOrgs.isEmpty()) {
            hasPermInvOrgs = Lists.newArrayListWithExpectedSize((int)0);
        }
        QFilter orgQf = new QFilter("org", "in", (Object)hasPermInvOrgs);
        QFilter timeQf = this.getMatUseContext().getCollectReport().getTimeQf();
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_mdc_mftproorder", (String)"id,billno,biztype,invscheme,billentry.oprworkcenter workcenter,bizorg org,bizdept adminorg,billstatus,billentry.id entryid,billentry.Seq seq,bookdate,'scll' as billtype,invscheme.billform.number entityid", (QFilter[])new QFilter[]{orgQf, timeQf}, (String)"id asc");
    }

    private DataSet getWwllData() {
        Long orgId = this.getMatUseContext().getCollectReport().getOrg();
        String appNum = this.getMatUseContext().getMatUseArgs().getAppNum();
        List hasPermInvOrgs = "sca".equals(this.getMatUseContext().getMatUseArgs().getAppNum()) ? OrgHelper.getUserHasPermStoreOrgsByAccOrg((Long)orgId, (String)"sca_matusecollect", (String)appNum) : OrgHelper.getUserHasPermStoreOrgsByAccOrg((Long)orgId, (String)"aca_matusecollect", (String)appNum);
        if (hasPermInvOrgs == null || hasPermInvOrgs.isEmpty()) {
            hasPermInvOrgs = Lists.newArrayListWithExpectedSize((int)0);
        }
        QFilter orgQf = new QFilter("org", "in", (Object)hasPermInvOrgs);
        QFilter timeQf = this.getMatUseContext().getCollectReport().getTimeQf();
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_mdc_omoutbill", (String)"id,billno,biztype,invscheme,billentry.oprworkcenter workcenter,bizorg org,bizdept adminorg,billstatus,billentry.id entryid,billentry.Seq seq,bookdate,'wwll' as billtype,invscheme.billform.number entityid", (QFilter[])new QFilter[]{orgQf, timeQf}, (String)"id asc");
    }

    private DataSet getLlckData() {
        Long orgId = this.getMatUseContext().getCollectReport().getOrg();
        String appNum = this.getMatUseContext().getMatUseArgs().getAppNum();
        List hasPermInvOrgs = "sca".equals(this.getMatUseContext().getMatUseArgs().getAppNum()) ? OrgHelper.getUserHasPermStoreOrgsByAccOrg((Long)orgId, (String)"sca_matusecollect", (String)appNum) : OrgHelper.getUserHasPermStoreOrgsByAccOrg((Long)orgId, (String)"aca_matusecollect", (String)appNum);
        if (hasPermInvOrgs == null || hasPermInvOrgs.isEmpty()) {
            hasPermInvOrgs = Lists.newArrayListWithExpectedSize((int)0);
        }
        QFilter orgQf = new QFilter("org", "in", (Object)hasPermInvOrgs);
        QFilter timeQf = this.getMatUseContext().getCollectReport().getTimeQf();
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_materialreqoutbill", (String)"id,billno,biztype,invscheme,0 workcenter,bizorg org,bizdept adminorg,billstatus,billentry.id entryid,billentry.Seq seq,bookdate,'llck' as billtype", (QFilter[])new QFilter[]{orgQf, timeQf}, (String)"id asc");
    }

    private DataSet getMatUseData(Set<Long> entryIds) {
        Long orgId = this.getMatUseContext().getMatUseArgs().getAcctOrgId();
        String appNum = this.getMatUseContext().getMatUseArgs().getAppNum();
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter entryIdQf = new QFilter("entryentity.sourcebillentryid", "in", entryIds);
        if ("sca".equals(appNum)) {
            return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sca_matusecollect", (String)"entryentity.sourcebillentryid sourcebillentryid", (QFilter[])new QFilter[]{orgQf, entryIdQf}, null);
        }
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"aca_matusecollect", (String)"entryentity.sourcebillentryid sourcebillentryid", (QFilter[])new QFilter[]{orgQf, entryIdQf}, null);
    }
}

