/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.CostChangeRecHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.MultiPartCcHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.matuse.BaseImportDataAction;
import kd.macc.cad.mservice.matuse.MatUseResultArgs;

public class MatUseSourceBillSaveAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(MatUseSourceBillSaveAction.class);

    @Override
    protected void doExecute() {
        this.getMatUseContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f52\u96c6\u5230\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355", (String)"MatUseSourceBillSaveAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        int count = 0;
        Map<String, MatUseResultArgs> matUseResultMap = this.getMatUseContext().getMatUseResultMap();
        this.refreshProgress(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f52\u96c6\u7684\u6570\u636e\u3002", (String)"MatUseSourceBillSaveAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, 0, true);
        for (Map.Entry<String, MatUseResultArgs> entry : matUseResultMap.entrySet()) {
            String mapKey = entry.getKey();
            String[] arr = mapKey.split("@");
            String entity = arr[1];
            MatUseResultArgs useResultArgs = entry.getValue();
            List<DynamicObject> newBillList = useResultArgs.getNewBillList();
            DynamicObject[] matUseCollects = useResultArgs.getOldMatUseCollects();
            this.countCostUpdate(newBillList, matUseCollects);
            this.dealMatAlloc(entity);
            String appNum = this.getMatUseContext().getMatUseArgs().getAppNum();
            if ("sca".equals(appNum) && !"im_materialreqoutbill".equals(entity)) {
                DynamicObjectCollection costObjectAccounts = this.getCostObjectAccount(useResultArgs.getExistCostObjects(), "id");
                this.writeCostChangeRecForNewAndUpdate(costObjectAccounts, newBillList, matUseCollects);
            }
            List newBillLists = Lists.partition(newBillList, (int)1000);
            for (List tempList : newBillLists) {
                SaveServiceHelper.save((DynamicObject[])tempList.toArray(new DynamicObject[0]));
            }
            Set<Long> impCostCenters = useResultArgs.getImpCostCenters();
            this.delMatUseAndAllocBillByCostCenter(entity, impCostCenters, this.getMatUseContext().getMatUseArgs().getMftOrderEntryIds(), this.getMatUseContext().getMatUseArgs().getCollectParamMap());
            count += newBillList.size();
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"MatUseSourceBillSaveAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
        MultiPartCcHelper.resolveMultipartCc(this.getMatUseContext().getCostObjCcSet());
        this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"%s\u6761\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\u4fdd\u5b58\u6210\u529f\u3002", (String)"MatUseSourceBillSaveAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), count));
    }

    private void writeCostChangeRecForNewAndUpdate(DynamicObjectCollection costObjectAccounts, List<DynamicObject> newBillList, DynamicObject[] matUseCollects) {
        HashMap<Long, Set<Long>> costObjectAccountMap = new HashMap<Long, Set<Long>>(16);
        costObjectAccounts.forEach(e -> costObjectAccountMap.computeIfAbsent(e.getLong("costobject"), s -> new HashSet()).add(e.getLong("costaccount")));
        List<DynamicObject> costUpdateRecs = this.wrapRecs(costObjectAccountMap, newBillList, matUseCollects);
        SaveServiceHelper.save((DynamicObject[])costUpdateRecs.toArray(new DynamicObject[0]));
    }

    private List<DynamicObject> wrapRecs(Map<Long, Set<Long>> costObjectAccountMap, List<DynamicObject> newBillList, DynamicObject[] matUseCollects) {
        ArrayList<DynamicObject> costChangedRecs = new ArrayList<DynamicObject>(10);
        if (newBillList == null || newBillList.isEmpty()) {
            return costChangedRecs;
        }
        Map<Long, Set<Long>> changeEntryIdMap = this.getMatUseContext().getChangeEntryIdMap();
        Set<Long> changeIds = changeEntryIdMap.keySet();
        for (DynamicObject newBill : newBillList) {
            if (!CadEmptyUtils.isEmpty((Long)newBill.getLong("id")) && !changeIds.contains(newBill.getLong("sourcebillid"))) continue;
            DynamicObjectCollection rows = newBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                Set<Long> costAccounts;
                Object costobject = row.get("costobject");
                Long costObjectId = null;
                if (costobject == null || (costAccounts = costObjectAccountMap.get(costObjectId = costobject instanceof DynamicObject ? (Long)((DynamicObject)costobject).getPkValue() : (Long)costobject)) == null) continue;
                for (Long costAccountId : costAccounts) {
                    DynamicObject rec = this.generateRec(newBill, matUseCollects, row.getInt("seq"));
                    if (rec == null) continue;
                    rec.set("costobject", (Object)costObjectId);
                    rec.set("costaccount", (Object)costAccountId);
                    costChangedRecs.add(rec);
                }
            }
        }
        return costChangedRecs;
    }

    private DynamicObject generateRec(DynamicObject newBill, DynamicObject[] matUseCollects, int seq) {
        Long srcId = newBill.getLong("sourcebillid");
        DynamicObject costChange = null;
        for (DynamicObject oldBill : matUseCollects) {
            if (srcId.longValue() == oldBill.getLong("sourcebillid")) {
                costChange = this.getCostChangeRec(newBill, oldBill, seq);
                break;
            }
            if (!CadEmptyUtils.isEmpty((Long)newBill.getLong("id"))) continue;
            costChange = this.getCostChangeRec(newBill, null, seq);
            break;
        }
        return costChange;
    }

    private DynamicObject getCostChangeRec(DynamicObject newBill, DynamicObject oldBill, int seq) {
        DynamicObject costChange;
        block4: {
            block5: {
                costChange = this.getCostChangeObject(newBill);
                if (oldBill == null || newBill == null) break block5;
                DynamicObjectCollection newRows = newBill.getDynamicObjectCollection("entryentity");
                DynamicObjectCollection oldRows = oldBill.getDynamicObjectCollection("entryentity");
                int size = newRows.size() > oldRows.size() ? newRows.size() : oldRows.size();
                for (int i = 0; i < size; ++i) {
                    String changeText;
                    if (((DynamicObject)newRows.get(i)).getInt("seq") != seq) continue;
                    StringBuilder sb = new StringBuilder();
                    if (i < newRows.size()) {
                        changeText = this.getChangeText(newBill, (DynamicObject)newRows.get(i));
                        sb.append(changeText);
                    }
                    sb.append("||");
                    if (i < oldRows.size()) {
                        changeText = this.getChangeText(oldBill, (DynamicObject)oldRows.get(i));
                        sb.append(changeText);
                    }
                    costChange.set("changecontext", (Object)sb.toString());
                    break block4;
                }
                break block4;
            }
            if (newBill == null && oldBill != null || newBill == null || oldBill != null) break block4;
            DynamicObjectCollection newRows = newBill.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < newRows.size(); ++i) {
                if (((DynamicObject)newRows.get(i)).getInt("seq") != seq) continue;
                String changeText = this.getChangeText(newBill, (DynamicObject)newRows.get(i));
                costChange.set("changecontext", (Object)(changeText + "||"));
                break;
            }
        }
        return costChange;
    }

    private void dealMatAlloc(String entity) {
        Map<Long, Set<Long>> changeEntryIdMap = this.getMatUseContext().getChangeEntryIdMap();
        if (changeEntryIdMap == null || changeEntryIdMap.isEmpty()) {
            return;
        }
        HashSet<Long> allocSrcBillIds = new HashSet<Long>();
        for (Set<Long> changeEntryIdSet : changeEntryIdMap.values()) {
            allocSrcBillIds.addAll(changeEntryIdSet);
        }
        String appNum = this.getMatUseContext().getMatUseArgs().getAppNum();
        ArrayList<QFilter> qf = new ArrayList<QFilter>();
        qf.add(new QFilter("matcollect", "in", allocSrcBillIds));
        qf.add(new QFilter("appnum", "=", (Object)appNum));
        if ("sca".equals(this.getMatUseContext().getMatUseArgs().getAppNum())) {
            DynamicObjectCollection allocBills = QueryServiceHelper.query((String)"sca_matalloc", (String)"id", (QFilter[])qf.toArray(new QFilter[0]));
            if (!"im_materialreqoutbill".equals(entity) && allocBills != null && allocBills.size() > 0) {
                Set allocBillIds = DynamicObjectHelper.getIdSet((DynamicObjectCollection)allocBills, (String)"id");
                logger.info("\u8bb0\u5f55\u5220\u9664\u7684\u5206\u914d\u5355\u7684\u6210\u672c\u53d8\u66f4\u8bb0\u5f55\uff08\u5305\u542b\u5220\u9664\u672a\u7ed3\u7b97\u7684\u6210\u672c\u53d8\u66f4\u8bb0\u5f55\uff09");
                CostChangeRecHelper.writeCostChangeRecForAllocDel((Set)allocBillIds);
            }
            DeleteServiceHelper.delete((String)"sca_matalloc", (QFilter[])qf.toArray(new QFilter[0]));
        } else {
            DeleteServiceHelper.delete((String)"aca_matalloc", (QFilter[])qf.toArray(new QFilter[0]));
        }
    }

    private void countCostUpdate(List<DynamicObject> newMatUseCollects, DynamicObject[] oldMatUseCollects) {
        if (newMatUseCollects == null || newMatUseCollects.isEmpty()) {
            return;
        }
        Map<Long, Map<Integer, String>> oldRowEffeValueMap = this.getRowEffeValueMap(oldMatUseCollects);
        Map<Long, Map<Integer, String>> newRowEffeValueMap = this.getRowEffeValueMap(newMatUseCollects.toArray(new DynamicObject[0]));
        for (Map.Entry<Long, Map<Integer, String>> currOldBillEntry : oldRowEffeValueMap.entrySet()) {
            Map<Integer, String> currOldBillMap = currOldBillEntry.getValue();
            Map<Integer, String> currNewBillMap = newRowEffeValueMap.get(currOldBillEntry.getKey());
            if (currNewBillMap == null) continue;
            int rowCount = currOldBillMap.size();
            for (int i = 0; i < rowCount; ++i) {
                boolean isChanged;
                int seq = i + 1;
                String oldValueStr = currOldBillMap.get(seq) == null ? "" : currOldBillMap.get(seq);
                String newValueStr = "";
                if (i < newRowEffeValueMap.size()) {
                    newValueStr = currNewBillMap.get(seq);
                }
                boolean bl = isChanged = !oldValueStr.equals(newValueStr);
                if (!isChanged) continue;
                Set entryIds = this.getMatUseContext().getChangeEntryIdMap().computeIfAbsent(currOldBillEntry.getKey(), s -> new HashSet());
                String[] oldValueArr = oldValueStr.split("@");
                if (oldValueArr == null || oldValueArr.length <= 0) continue;
                Long entryId = Long.parseLong(StringUtils.isEmpty((Object)oldValueArr[0]) ? "0" : oldValueArr[0]);
                entryIds.add(entryId);
            }
        }
    }

    private Map<Long, Map<Integer, String>> getRowEffeValueMap(DynamicObject[] matUseCollects) {
        HashMap<Long, Map<Integer, String>> rowEffeValueMap = new HashMap<Long, Map<Integer, String>>(16);
        if (matUseCollects == null) {
            return rowEffeValueMap;
        }
        for (DynamicObject matUseBill : matUseCollects) {
            HashMap<Integer, String> currBillMap = new HashMap<Integer, String>(16);
            DynamicObjectCollection rows = matUseBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                String changeText = this.getChangeText(matUseBill, row);
                changeText = row.getLong("id") + "@" + changeText;
                currBillMap.put(row.getInt("seq"), changeText);
            }
            rowEffeValueMap.put(matUseBill.getLong("sourcebillid"), currBillMap);
        }
        return rowEffeValueMap;
    }

    private String getChangeText(DynamicObject bill, DynamicObject row) {
        String join = "@";
        StringBuilder sg = new StringBuilder(bill.getString("billno"));
        sg.append(join);
        sg.append(bill.getDate("bizdate"));
        sg.append(join);
        sg.append(row.getString("seq"));
        sg.append(join);
        sg.append(row.getString("matversion.id"));
        sg.append(join);
        sg.append(row.getString("unit.id"));
        sg.append(join);
        sg.append(row.getString("qty"));
        sg.append(join);
        sg.append(row.getString("location.id"));
        sg.append(join);
        sg.append(row.getString("warehouse.id"));
        return sg.toString();
    }
}

