/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.business.config.service.CostObjectService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.matuse.BaseImportDataAction;
import kd.macc.cad.mservice.matuse.MatUseArgs;
import kd.macc.cad.mservice.matuse.MatUseContext;
import org.apache.commons.lang3.StringUtils;

public class MaterialImportDataConfigAction
extends BaseImportDataAction {
    private Log logger = LogFactory.getLog(MaterialImportDataConfigAction.class);

    @Override
    protected void doExecute() {
        MatUseArgs matUseArgs = this.getMatUseContext().getMatUseArgs();
        Long accountOrgId = matUseArgs.getAcctOrgId();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getMatUseContext().getConfigSrcAndTargetBillsMap();
        Map<Long, String> dimensionAndRuleMap = this.getMatUseContext().getDimensionAndRuleMap();
        Map<Long, Map<String, String>> collConfigMappingMap = this.getMatUseContext().getCollConfigMappingMap();
        Map<Long, Map<String, String>> collConfigRuleMappingMap = this.getMatUseContext().getCollConfigRuleMappingMap();
        String key = accountOrgId + CostObjectEnum.BIZTYPE_RO.getValue();
        List<Long> reProduceCostCenters = this.getMatUseContext().getOrgMethodCostCenters().get(key);
        if (CadEmptyUtils.isEmpty(reProduceCostCenters)) {
            this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u5de5\u5355\u6210\u672c\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f15\u5165\u7ed3\u675f\uff01", (Object)accountOrgId);
            return;
        }
        this.getMatUseContext().getCollectReport().setReProCostCenters(reProduceCostCenters);
        for (Map.Entry<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
            DynamicObject config = configSrcAndTargetBill.getKey();
            String sourcebill = config.getString("sourcebill.id");
            String sourcebillName = config.getString("sourcebill.name");
            if (!CostObjectEnum.BIZTYPE_RO.getValue().equals(config.getString("calmethod"))) continue;
            this.refreshProgress(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u7684\u6570\u636e\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"MaterialImportDataConfigAction_34", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")), 1, 0, true);
            this.refreshProgress(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u7684\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"MaterialImportDataConfigAction_35", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")), 3, 0, false);
            Map<DynamicObject, DynamicObject> srcAndTargetBillsMap = configSrcAndTargetBill.getValue();
            ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
            this.getMatUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%s", (String)"MaterialImportDataConfigAction_32", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName));
            this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u201c%1$s\u201d%2$s\u6761\u6570\u636e\u3002", (String)"MaterialImportDataConfigAction_33", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName, srcBills.size()));
            long costcalcdimension = config.getLong("costcalcdimension.id");
            String dimension = dimensionAndRuleMap.get(costcalcdimension);
            if (CadEmptyUtils.isEmpty((String)dimension)) {
                this.getMatUseContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"MaterialImportDataConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u6ca1\u6709\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ef4\u5ea6\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"MaterialImportDataConfigAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                continue;
            }
            List<Long> costcenterIds = this.getMatUseContext().getOrgMethodCostCenters().get(String.valueOf(accountOrgId).concat(CostObjectEnum.BIZTYPE_RO.getValue()));
            TreeMap<String, String> configRuleMappingMap = new TreeMap();
            Set<Object> manuIds = new HashSet(16);
            if (!CadEmptyUtils.isEmpty(collConfigRuleMappingMap) && collConfigRuleMappingMap.containsKey(config.getLong("id"))) {
                configRuleMappingMap = new TreeMap<String, String>(collConfigRuleMappingMap.get(config.getLong("id")));
                manuIds = this.getCollectManuEntryIds(configRuleMappingMap, srcBills);
                if (CadEmptyUtils.isEmpty(matUseArgs.getMftOrderEntryIds())) {
                    CostObjectService.autoGenerateCostobject((Long)accountOrgId, costcenterIds != null ? costcenterIds : matUseArgs.getCostCenterIds(), matUseArgs.getManuOrgs(), (CollectReport)this.getMatUseContext().getCollectReport(), (String)matUseArgs.getAppNum(), manuIds);
                }
            }
            String costObjectFields = "probill";
            Map existCostObjectMap = CostObjectHelper.getExistCostObjectMap((Long)accountOrgId, null, (String)costObjectFields, (String)matUseArgs.getAppNum(), new ArrayList(manuIds));
            Map<String, String> configMappingMap = collConfigMappingMap.get(config.getLong("id"));
            this.getMatUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u3010%s\u3011,\u5904\u7406\u6e90\u5355", (String)"MaterialImportDataConfigAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
            List<DynamicObject> materialBills = this.getMaterialUseBill(accountOrgId, reProduceCostCenters, config, srcAndTargetBillsMap, existCostObjectMap, configRuleMappingMap, configMappingMap, this.getMatUseContext().getIdEntryIdCompleteMap(), this.getMatUseContext().getExistBillNos(), sourcebill, matUseArgs.getAppNum());
            this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u6570\u636e\u201c%s\u201d\u6761\u3002", (String)"MaterialImportDataConfigAction_19", (String)"macc-cad-mservice", (Object[])new Object[0]), materialBills.size()));
            this.refreshProgress(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u7684\u6570\u636e\u5904\u7406\u5b8c\u6210\u3002", (String)"MaterialImportDataConfigAction_36", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")), 5, 0, true);
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u5de5\u5355\u6210\u672c\u6cd5\u7684\u6570\u636e\u5904\u7406\u5b8c\u6210\u3002", (String)"MaterialImportDataConfigAction_37", (String)"macc-cad-mservice", (Object[])new Object[0]), 7, 0, false);
    }

    private Set<Long> getCollectManuEntryIds(Map<String, String> configRuleMappingMap, List<DynamicObject> srcBills) {
        HashSet manuIds = Sets.newHashSetWithExpectedSize((int)10);
        String srcBillField = configRuleMappingMap.get("probill");
        if (StringUtils.isEmpty((CharSequence)srcBillField)) {
            return manuIds;
        }
        for (DynamicObject dyn : srcBills) {
            manuIds.add(dyn.getLong(srcBillField));
        }
        return manuIds;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DynamicObject> getMaterialUseBill(Long acctOrg, List<Long> costCenters, DynamicObject config, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, Map<String, DynamicObject>> existCostObjectMap, TreeMap<String, String> collConfigRuleMappingMap, Map<String, String> configMappingMap, Map<String, DynamicObject> idEntryIdCompleteMap, Set<String> existBillNos, String sourceBillEntity, String appNum) {
        ArrayList<DynamicObject> materialBills = new ArrayList<DynamicObject>(10);
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return materialBills;
        }
        HashMap<String, DynamicObject> changeMaterialMap = new HashMap<String, DynamicObject>(16);
        this.dealExitsData(idEntryIdCompleteMap, srcAndTargetBillsMap, changeMaterialMap, new HashSet<String>(configMappingMap.keySet()), appNum);
        this.logger.info("\u5df2\u7ecf\u5b58\u5728\u7684\u6750\u6599\u8017\u7528\u91cf\u5f52\u96c6\u5355:{}", existBillNos);
        Map<Long, DynamicObject> srcBillEntryIdAndSrcDataMap = this.getSrcBillEntryIdAndSrcDataMap(srcAndTargetBillsMap, sourceBillEntity, new HashSet<String>(collConfigRuleMappingMap.values()), new HashSet<String>(configMappingMap.values()));
        int updNum = 0;
        int addNum = 0;
        MatUseContext context = this.getMatUseContext();
        List<DynamicObject> planOutPutList = this.getMatUseContext().getNewBillList();
        Set willSaveBillNoSet = planOutPutList.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
        Set<String> existsIds = idEntryIdCompleteMap.keySet();
        HashMap<String, DynamicObject> existMaterialBills = new HashMap<String, DynamicObject>(idEntryIdCompleteMap);
        boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)acctOrg);
        Set<Long> sourceEntryIds = context.getSourceEntryIds();
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBill : srcAndTargetBillsMap.entrySet()) {
            Object manuorgList;
            DynamicObjectCollection entryentity;
            DynamicObject srcBill = srcAndTargetBill.getKey();
            DynamicObject targetBill = srcAndTargetBill.getValue();
            if (!sourceBillEntity.equals(srcBill.getString("billtype"))) continue;
            if (targetBill == null) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u3002", (String)"MaterialImportDataConfigAction_22", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                continue;
            }
            String billnoAndSrcId = targetBill.getString("billno") + "-" + srcBill.getString("id");
            boolean isNeedChangeData = changeMaterialMap.containsKey(billnoAndSrcId);
            if (existsIds.contains(billnoAndSrcId) && !isNeedChangeData) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"MaterialImportDataConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u5df2\u5b58\u5728\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"MaterialImportDataConfigAction_23", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                this.logger.info("\u6e90\u5355{}\u5df2\u5b58\u5728\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"));
                idEntryIdCompleteMap.remove(billnoAndSrcId);
                continue;
            }
            if (!existsIds.contains(billnoAndSrcId) && existBillNos.contains(targetBill.getString("billno"))) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"MaterialImportDataConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"MaterialImportDataConfigAction_24", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                this.logger.info("\u6e90\u5355{}\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"));
                continue;
            }
            if (sourceEntryIds != null && (entryentity = targetBill.getDynamicObjectCollection("entryentity")) != null && !entryentity.isEmpty() && sourceEntryIds.contains(((DynamicObject)entryentity.get(0)).getLong("sourcebillentryid"))) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"MaterialImportDataConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u5728\u5176\u5b83\u65b9\u6848\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"MaterialImportDataConfigAction_38", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                this.logger.info("\u6e90\u5355{}\u5728\u5176\u5b83\u65b9\u6848\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"));
                continue;
            }
            if (context.getLastSourceEntryIds() != null && (entryentity = targetBill.getDynamicObjectCollection("entryentity")) != null && !entryentity.isEmpty() && context.getLastSourceEntryIds().contains(((DynamicObject)entryentity.get(0)).getLong("sourcebillentryid"))) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"MaterialImportDataConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u5728\u4e0a\u6708\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"MaterialImportDataConfigAction_39", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                this.logger.info("\u6e90\u5355{}\u5728\u5176\u5b83\u65b9\u6848\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"));
                continue;
            }
            if (willSaveBillNoSet.contains(targetBill.getString("billno"))) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"MaterialImportDataConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u5df2\u5bfc\u5165\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"MaterialImportDataConfigAction_25", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                continue;
            }
            Long costCenterId = targetBill.getLong("costcenter.id");
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"MaterialImportDataConfigAction_26", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                continue;
            }
            if (!costCenters.contains(costCenterId)) continue;
            if ("im_materialreqoutbill".equals(sourceBillEntity)) {
                long bizorg;
                String manuorgField = configMappingMap.get("manuorg");
                long l = bizorg = manuorgField == null ? 0L : srcBill.getLong(manuorgField);
                if (isEnableMultiFactory && CadEmptyUtils.isEmpty((List)(manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)bizorg, (String)this.getEntityId(appNum), (String)appNum)))) {
                    this.getMatUseContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\u65e0\u751f\u4ea7\u7ec4\u7ec7\u804c\u80fd\uff0c\u6216\u65e0\u59d4\u6258\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MaterialImportDataConfigAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"MaterialImportDataConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u7684\u9700\u6c42\u7ec4\u7ec7\u65e0\u751f\u4ea7\u7ec4\u7ec7\u804c\u80fd\uff0c\u6216\u65e0\u59d4\u6258\u751f\u4ea7\u7ec4\u7ec7\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"MaterialImportDataConfigAction_28", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                    this.logger.info("\u6e90\u5355:{}\u9700\u6c42\u7ec4\u7ec7\u65e0\u751f\u4ea7\u7ec4\u7ec7\u804c\u80fd\u6216\u6ca1\u6709\u59d4\u6258\u751f\u4ea7\u7ec4\u7ec7\uff0c\u8df3\u8fc7\u6b64\u5355", (Object)bizorg);
                    continue;
                }
            }
            Map<String, DynamicObject> matInfoList = existCostObjectMap.get(String.valueOf(acctOrg));
            if (!isNeedChangeData) {
                ++addNum;
            } else {
                DynamicObject materialUse = idEntryIdCompleteMap.remove(billnoAndSrcId);
                String entryField = "";
                manuorgList = configMappingMap.entrySet().iterator();
                while (manuorgList.hasNext()) {
                    Map.Entry configMapping = (Map.Entry)manuorgList.next();
                    String cost = (String)configMapping.getKey();
                    if (!cost.contains(".")) continue;
                    entryField = cost.split("\\.")[0];
                    break;
                }
                DynamicObjectCollection entry = materialUse.getDynamicObjectCollection(entryField);
                DynamicObjectCollection srcentry = targetBill.getDynamicObjectCollection(entryField);
                for (Map.Entry entry2 : configMappingMap.entrySet()) {
                    String cost = (String)entry2.getKey();
                    if (cost.contains(".")) {
                        String field = cost.split("\\.")[1];
                        for (DynamicObject row : entry) {
                            for (DynamicObject srcrow : srcentry) {
                                if (row.getLong("sourcebillentryid") != srcrow.getLong("sourcebillentryid")) continue;
                                row.set(field, srcrow.get(field));
                                row.set("isrework", srcrow.get("isrework"));
                            }
                        }
                        continue;
                    }
                    materialUse.set(cost, targetBill.get(cost));
                }
                materialUse.set("srcauditdate", targetBill.get("srcauditdate"));
                materialUse.set("nsrcauditdate", targetBill.get("nsrcauditdate"));
                targetBill = materialUse;
                ++updNum;
            }
            DynamicObjectCollection entryentity2 = targetBill.getDynamicObjectCollection("entryentity");
            boolean isNoCostObject = false;
            for (DynamicObject entry : entryentity2) {
                void var37_45;
                DynamicObject costObject;
                if (entry.get("costobject") != null) {
                    costObject = entry.getDynamicObject("costobject");
                } else {
                    long l = entry.getLong("sourcebillentryid");
                    DynamicObject srcBillData = srcBillEntryIdAndSrcDataMap.get(l);
                    HashMap<String, String> newRuleMappingMap = new HashMap<String, String>(16);
                    newRuleMappingMap.put("probill", collConfigRuleMappingMap.get("probill"));
                    costObject = this.getCostObjectBySrcBillInfo(srcBillData, new TreeMap<String, String>(newRuleMappingMap), sourceBillEntity, null, matInfoList);
                }
                if (costObject == null && !"im_materialreqoutbill".equals(sourceBillEntity) && !"cal_costadjust_subentity".equals(sourceBillEntity)) {
                    isNoCostObject = true;
                    continue;
                }
                entry.set("costobject", (Object)(costObject == null ? 0L : costObject.getLong("id")));
                entry.set("costobject_id", (Object)(costObject == null ? 0L : costObject.getLong("id")));
                if (costObject == null) continue;
                Long l = 0L;
                if (costObject.get("bomversion") instanceof DynamicObject) {
                    Long l2 = costObject.getLong("bomversion.id");
                } else if (costObject.get("bomversion") instanceof Long) {
                    Long l3 = costObject.getLong("bomversion");
                }
                entry.set("matversion", (Object)var37_45);
            }
            if (isNoCostObject) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"MaterialImportDataConfigAction_31", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                continue;
            }
            if (!isNeedChangeData) {
                targetBill.set("creator", (Object)RequestContext.get().getCurrUserId());
                targetBill.set("createtime", (Object)TimeServiceHelper.now());
            }
            targetBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("modifytime", (Object)TimeServiceHelper.now());
            targetBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("auditdate", (Object)TimeServiceHelper.now());
            materialBills.add(targetBill);
        }
        this.getMatUseContext().setAddNum(this.getMatUseContext().getAddNum() + addNum);
        this.getMatUseContext().setUpdateNum(this.getMatUseContext().getUpdateNum() + updNum);
        this.getMatUseContext().getNewBillList().addAll(materialBills);
        this.setMatUseResultArgs(acctOrg, costCenters, config.getLong("id"), materialBills, existCostObjectMap, existMaterialBills);
        this.logger.info("\u65b0\u589e\u6216\u66f4\u65b0\u7684\u6750\u6599\u8017\u7528\u91cf\u5f52\u96c6\u5355:{}", (Object)materialBills.size());
        return materialBills;
    }
}

