/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.matuse.BaseImportDataAction;
import kd.macc.cad.mservice.matuse.MatUseArgs;

public class MaterialImportDataForFPConfigAction
extends BaseImportDataAction {
    private Log logger = LogFactory.getLog(MaterialImportDataForFPConfigAction.class);

    @Override
    protected void doExecute() {
        MatUseArgs matUseArgs = this.getMatUseContext().getMatUseArgs();
        Long accountOrgId = matUseArgs.getAcctOrgId();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getMatUseContext().getConfigSrcAndTargetBillsMap();
        Map<Long, String> dimensionAndRuleMap = this.getMatUseContext().getDimensionAndRuleMap();
        Map<Long, Map<String, String>> collConfigMappingMap = this.getMatUseContext().getCollConfigMappingMap();
        Map<Long, Map<String, String>> collConfigRuleMappingMap = this.getMatUseContext().getCollConfigRuleMappingMap();
        String key = accountOrgId + CostObjectEnum.BIZTYPE_SO.getValue();
        List<Long> fpCostCenters = this.getMatUseContext().getOrgMethodCostCenters().get(key);
        if (CadEmptyUtils.isEmpty(fpCostCenters)) {
            this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u5206\u6279\u6cd5\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f15\u5165\u7ed3\u675f\uff01", (Object)accountOrgId);
            return;
        }
        this.getMatUseContext().getCollectReport().setFpCostCenters(fpCostCenters);
        for (Map.Entry<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
            DynamicObject config = configSrcAndTargetBill.getKey();
            String sourcebill = config.getString("sourcebill.id");
            String sourcebillName = config.getString("sourcebill.name");
            if (!CostObjectEnum.BIZTYPE_SO.getValue().equals(config.getString("calmethod"))) continue;
            this.refreshProgress(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u7684\u6570\u636e\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"MaterialImportDataForFPConfigAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")), 1, 0, true);
            this.refreshProgress(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u7684\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"MaterialImportDataForFPConfigAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")), 3, 0, false);
            Map<DynamicObject, DynamicObject> srcAndTargetBillsMap = configSrcAndTargetBill.getValue();
            ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
            this.getMatUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%s", (String)"MaterialImportDataForFPConfigAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName));
            this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u201c%1$s\u201d%2$s\u6761\u6570\u636e\u3002", (String)"MaterialImportDataForFPConfigAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName, srcBills.size()));
            long costcalcdimension = config.getLong("costcalcdimension.id");
            String dimension = dimensionAndRuleMap.get(costcalcdimension);
            if (CadEmptyUtils.isEmpty((String)dimension)) {
                this.getMatUseContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"MaterialImportDataForFPConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u6ca1\u6709\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ef4\u5ea6\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"MaterialImportDataForFPConfigAction_8", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                continue;
            }
            TreeMap<String, String> configRuleMappingMap = new TreeMap();
            if (collConfigRuleMappingMap.containsKey(config.getLong("id"))) {
                configRuleMappingMap = new TreeMap<String, String>(collConfigRuleMappingMap.get(config.getLong("id")));
            }
            String costObjectFields = String.join((CharSequence)",", configRuleMappingMap.keySet());
            Map existCostObjectMap = CostObjectHelper.getExistCostObjectMap((Long)accountOrgId, fpCostCenters, (String)costObjectFields, (String)matUseArgs.getAppNum());
            Map<String, String> configMappingMap = collConfigMappingMap.get(config.getLong("id"));
            this.getMatUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\uff0c\u5904\u7406\u6e90\u5355\u3002", (String)"MaterialImportDataForFPConfigAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
            List<DynamicObject> materialBills = this.getMaterialUseBill(accountOrgId, fpCostCenters, config, srcAndTargetBillsMap, existCostObjectMap, configRuleMappingMap, configMappingMap, this.getMatUseContext().getIdEntryIdCompleteMap(), this.getMatUseContext().getExistBillNos(), sourcebill, matUseArgs.getAppNum());
            this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u6570\u636e%s\u6761\u3002", (String)"MaterialImportDataForFPConfigAction_11", (String)"macc-cad-mservice", (Object[])new Object[0]), materialBills.size()));
            this.refreshProgress(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u7684\u6570\u636e\u5904\u7406\u5b8c\u6210\u3002", (String)"MaterialImportDataForFPConfigAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")), 5, 0, true);
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u5206\u6279\u6cd5\u7684\u6570\u636e\u5904\u7406\u5b8c\u6210\u3002", (String)"MaterialImportDataForFPConfigAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]), 9, 0, false);
    }
}

