/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.config.costcenter.CostCenterRelationService;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.engine.CollConfigEngine;
import kd.macc.cad.business.config.engine.CollConifgContext;
import kd.macc.cad.business.config.engine.CollConifgParam;
import kd.macc.cad.business.config.engine.IBillTransfer;
import kd.macc.cad.business.config.engine.TransferResult;
import kd.macc.cad.business.config.engine.filter.CollConfigFilterService;
import kd.macc.cad.business.config.engine.helper.CollectEngineHelper;
import kd.macc.cad.business.config.engine.mapping.CollConfigMappingService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostChangeRecHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.BatchUtils;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MaterialPropHelper;
import kd.macc.cad.mservice.matuse.AbstractMatUseAction;
import kd.macc.cad.mservice.matuse.CompletionSaveAction;
import kd.macc.cad.mservice.matuse.DealMaterialAllocBillAction;
import kd.macc.cad.mservice.matuse.IMatUseAction;
import kd.macc.cad.mservice.matuse.MatUseArgs;
import kd.macc.cad.mservice.matuse.MatUseContext;
import kd.macc.cad.mservice.matuse.MaterialImportDataConfigAction;
import kd.macc.cad.mservice.matuse.MaterialImportDataForCUConfigAction;
import kd.macc.cad.mservice.matuse.MaterialImportDataForFLConfigAction;
import kd.macc.cad.mservice.matuse.MaterialImportDataForFPConfigAction;
import kd.macc.cad.mservice.matuse.MaterialImportDataForPZConfigAction;
import kd.macc.cad.mservice.matuse.ScaMaterialWritCostChangeAction;

public class MaterialTransferAction
extends AbstractMatUseAction {
    private static final Log logger = LogFactory.getLog(MaterialTransferAction.class);
    private static final String MFTORDER_SELECTFIELDS = ",treeentryentity.id AS nodeId, treeentryentity.pid AS pnodeId,treeentryentity.producttype AS producttype,treeentryentity.auxproperty AS auxpty,transactiontype.isprocedure AS isprocedure,transactiontype.isrework AS isrework,treeentryentity.planstatus AS planstatus,treeentryentity.bizstatus AS bizstatus,treeentryentity.taskstatus AS taskstatus,treeentryentity.closetime AS closetime";
    private static final String MFTMANUBILL_SELECTFIELDS = ",billentry.manubill AS manubill,billentry.manuentry AS manuentry";
    private static final String IMPRODUCEBILL_SELECTFIELDS = ",invscheme.number invschemenum";
    private static final String PROCESSREPORTBILL_SELECTFIELDS = ",sumentry.repsubentryentity.id as sonid,sumentry.repsubentryentity.seq as sonseq";
    private CollConifgContext configContext = new CollConifgContext();
    private List<DynamicObject> collConfigList = new ArrayList<DynamicObject>();
    private CollConfigFilterService filterService;
    private CollConfigMappingService mappingService;
    private CostCenterRelationService costCenterRelationService;

    @Override
    protected void doExecute() {
        MatUseContext context = this.getMatUseContext();
        MatUseArgs collectionArgs = context.getMatUseArgs();
        String appNum = context.getMatUseArgs().getAppNum();
        Map<Long, Long> costAccountPeriodMap = collectionArgs.getCostAccountPeriodMap();
        CollectReport collectReport = context.getCollectReport();
        List<Long> manuOrgs = collectionArgs.getManuOrgs();
        Long[] manuOrgIds = new Long[]{};
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            manuOrgIds = manuOrgs.toArray(new Long[0]);
        }
        TransferResult transferResult = null;
        if ("eca".equals(appNum)) {
            logger.info("\u670d\u52a1\u6210\u672c");
            this.refreshProgress(ResManager.loadKDString((String)"\u5f00\u59cb\u5b57\u6bb5\u6620\u5c04\u65b9\u6848\u8f6c\u6362\u3002", (String)"MaterialTransferAction_19", (String)"macc-cad-mservice", (Object[])new Object[0]), 2, 10, true);
            manuOrgIds = new Long[]{};
            logger.info("\u6210\u672c\u8d26\u7c3f\u4e0e\u5f53\u524d\u671f\u95f4\uff1a{}", costAccountPeriodMap);
            for (Map.Entry<Long, Long> costAccountPeriod : costAccountPeriodMap.entrySet()) {
                logger.info("\u5f53\u524d\u6210\u672c\u8d26\u7c3f\u4e0e\u671f\u95f4\uff1a{}", costAccountPeriod);
                collectionArgs.setCostAccountId(costAccountPeriod.getKey());
                CollConfigEngine configEngine = CollConfigEngine.buildEngine((Long)collectionArgs.getAcctOrgId(), (Long)costAccountPeriod.getKey(), (Long)costAccountPeriod.getValue(), (Long[])manuOrgIds, (Long[])collectionArgs.getCostCenterIds().toArray(new Long[0]), (String)"aca_matalloc", context.getAcctOrgObjRules(), (String)collectionArgs.getAppNum());
                transferResult = configEngine.getTargetDynamicObject(context.getCollectReport(), null, null);
                Map configSrcAndTargetBillsMap = transferResult.getConfigSrcAndTargetBillMap();
                logger.info("configSrcAndTargetBillsMap\u7684\u5927\u5c0f\uff1a{}", (Object)configSrcAndTargetBillsMap.size());
                context.getConfigSrcAndTargetBillsMap().putAll(configSrcAndTargetBillsMap);
                context.getCollConfigMappingMap().putAll(transferResult.getCollConfigMappingMap());
                context.getCollConfigRuleMappingMap().putAll(transferResult.getCollConfigRuleMappingMap());
                this.dealCostAccountInfo(collectionArgs.getOrgCostAccountList(), configSrcAndTargetBillsMap);
            }
        } else {
            List<IMatUseAction> matUseActions = this.initializeActions(appNum);
            this.configContext = new CollConifgContext();
            CollConifgParam param = new CollConifgParam();
            param.setAppnum(collectionArgs.getAppNum());
            param.setCalOrgId(collectionArgs.getAcctOrgId());
            param.setCostAccountId(null);
            param.setManuOrgIds(manuOrgIds);
            param.setCostCenterIds(collectionArgs.getCostCenterIds().toArray(new Long[0]));
            param.setTargetEntity(collectionArgs.getEntityId());
            this.configContext.setParam(param);
            HashSet<Long> allCollconfigIds = new HashSet<Long>(10);
            allCollconfigIds.add(0L);
            this.collConfigList = this.getValidCollConfigList(context, collectionArgs.getEntityId(), allCollconfigIds);
            if (!CadEmptyUtils.isEmpty(this.collConfigList)) {
                this.mappingService = new CollConfigMappingService();
                this.filterService = new CollConfigFilterService();
                this.costCenterRelationService = new CostCenterRelationService();
                Map collConfigMappingMap = this.mappingService.getCollConfigMappingMap(this.collConfigList);
                Map collSelectValueMappingMap = this.mappingService.getCollSelectValueMappingMap(this.collConfigList);
                Map collConfigRuleMappingMap = this.mappingService.getCollConfigRuleMappingMap(this.collConfigList);
                Map collConfigFilterMap = this.filterService.getCollConfigFilterMap(this.collConfigList);
                List importScopeDate = SysParamHelper.getImportScopeDate((Long)context.getMatUseArgs().getAcctOrgId(), (String)context.getMatUseArgs().getAppNum());
                Map costCenterSourceDataMap = this.costCenterRelationService.getCostCenterSourceDataMap(context.getMatUseArgs().getCostCenterIds().toArray(new Long[0]), importScopeDate);
                this.configContext.setCostCenterSourceDataMap(costCenterSourceDataMap);
                HashMap costCentersourceTypeDataMap = new HashMap(16);
                costCenterSourceDataMap.forEach((ccs, obj) -> {
                    String[] srcDataStr = ccs.split("@");
                    if (srcDataStr.length < 2) {
                        return;
                    }
                    String sourceType = srcDataStr[0];
                    Long sourceData = Long.parseLong(srcDataStr[1]);
                    costCentersourceTypeDataMap.computeIfAbsent(sourceType, p -> new HashSet(10)).add(sourceData);
                });
                Boolean isOldUserForSysParamBizRange = ImportServiceHelper.isOldUserForSysParamBizRange();
                Map<String, List<Long>> billRangeMap = isOldUserForSysParamBizRange != false ? this.getBillRangeMap(context.getMatUseArgs().getAcctOrgId(), context.getMatUseArgs().getCostCenterIds(), collectionArgs.getEntityId(), context.getMatUseArgs().getAppNum(), collectReport) : null;
                context.getCollConfigMappingMap().putAll(collConfigMappingMap);
                context.getCollConfigRuleMappingMap().putAll(collConfigRuleMappingMap);
                boolean disableCollectReport = CollectReportHelper.disableCollectReport();
                this.delHistoryCollConfigData(this.collConfigList, collectionArgs, collConfigRuleMappingMap, allCollconfigIds);
                HashMap souCollConfigsMap = Maps.newHashMapWithExpectedSize((int)10);
                for (DynamicObject config2 : this.collConfigList) {
                    String sourcebill = config2.getString("sourcebill.id") + "@" + config2.getString("calmethod");
                    souCollConfigsMap.computeIfAbsent(sourcebill, t -> new ArrayList()).add(config2);
                }
                Set<Long> lastSourceEntryIds = this.getlastMonthSourceEntryIds(this.collConfigList.get(0).getString("costbill.id"));
                context.setLastSourceEntryIds(lastSourceEntryIds);
                int batchSize = CadBgParamUtils.getCadParamForInt((String)"matUseCollBatch", (int)50000);
                for (List cofigList : souCollConfigsMap.values()) {
                    if (cofigList.size() > 1) {
                        this.getMatUseContext().setSourceEntryIds(new HashSet<Long>());
                    } else {
                        this.getMatUseContext().setSourceEntryIds(null);
                    }
                    int[] execIndex = new int[]{0};
                    cofigList.forEach(config -> {
                        Map<String, DynamicObject> existsEntryIdCompleteMap;
                        execIndex[0] = execIndex[0] + 1;
                        this.getMatUseContext().getIdEntryIdCompleteMap().clear();
                        this.getMatUseContext().getExistBillNos().clear();
                        this.getMatUseContext().getNewBillList().clear();
                        long configId = config.getLong("id");
                        String targetBillEntity = config.getString("costbill.id");
                        String sourceBillEntity = config.getString("sourcebill.id");
                        DataSet existsMatUseBill = this.getExistsMatUseBill(collectionArgs.getAcctOrgId(), collectionArgs.getCostCenterIds(), collectionArgs.getManuOrgs(), collectionArgs.getMftOrderEntryIds(), (Map)collConfigRuleMappingMap.get(config.getLong("id")), sourceBillEntity, targetBillEntity, collectionArgs.getAppNum(), collectionArgs.getCollectParamMap(), config.getLong("id"), null);
                        String entryEntityName = "";
                        Map fieldMappingMap = (Map)collConfigMappingMap.get(configId);
                        if (!CadEmptyUtils.isEmpty((Map)fieldMappingMap)) {
                            for (String value : fieldMappingMap.values()) {
                                String[] split;
                                for (String fieldName : split = org.apache.commons.lang3.StringUtils.split((String)value, (String)",")) {
                                    String[] fieldNames = org.apache.commons.lang3.StringUtils.split((String)fieldName, (String)".");
                                    if (fieldNames.length <= 1) continue;
                                    entryEntityName = fieldNames[0];
                                }
                            }
                        }
                        Map selectValueMappingMap = (Map)collSelectValueMappingMap.get(configId);
                        Map ruleMappingMap = (Map)collConfigRuleMappingMap.get(configId);
                        if (isOldUserForSysParamBizRange.booleanValue() && billRangeMap != null && !billRangeMap.containsKey("norange")) {
                            if (!billRangeMap.containsKey(sourceBillEntity)) {
                                logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u4e0d\u5728\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\u8bbe\u7f6e\u7684\u5f52\u96c6\u5355\u636e\u8303\u56f4\u5185");
                                return;
                            }
                            List ccsIds = (List)billRangeMap.get(sourceBillEntity);
                            if (CadEmptyUtils.isEmpty((List)ccsIds)) {
                                logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\uff0c\u6ca1\u6709\u9700\u8981\u5f52\u96c6\u7684\u6210\u672c\u4e2d\u5fc3");
                                return;
                            }
                            this.configContext.getParam().setCostCenterIds(ccsIds.toArray(new Long[0]));
                        }
                        List collConfigFilter = ImportServiceHelper.getSrcQFilters((Long)this.configContext.getParam().getCalOrgId(), Arrays.asList(this.configContext.getParam().getCostCenterIds()), Arrays.asList(this.configContext.getParam().getManuOrgIds()), (DynamicObject)config, (Map)collConfigFilterMap, (Map)fieldMappingMap, (Map)selectValueMappingMap, (Map)costCentersourceTypeDataMap, collectionArgs.getMftOrderEntryIds(), collectionArgs.getCollectParamMap(), (Long)this.configContext.getParam().getCostAccountId(), (Long)this.configContext.getParam().getCurPeriodId(), (String)this.configContext.getParam().getAppnum(), (Map)this.configContext.getConfigProEntryIdWorkCenterMap(), (CollectReport)collectReport);
                        String selectFields = CollectEngineHelper.getSrcSelectFields((DynamicObject)config, (Map)fieldMappingMap, (Map)ruleMappingMap);
                        if (CadEmptyUtils.isEmpty((String)selectFields)) {
                            return;
                        }
                        logger.info("\u67e5\u8be2\u6e90\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", (Object)collConfigFilter);
                        if (!CadEmptyUtils.isEmpty((String)entryEntityName)) {
                            entryEntityName = entryEntityName.concat(".id");
                        }
                        DataSet sourceBills = QueryServiceHelper.queryDataSet((String)"MaterialTransferAction_doExecute", (String)sourceBillEntity, (String)"id,auditdate,".concat(entryEntityName), (QFilter[])collConfigFilter.toArray(new QFilter[0]), (String)"id desc");
                        logger.info("\u5dee\u91cf\u5f52\u96c6\u5224\u65ad:\u5f52\u96c6\u62a5\u544a\u5f00\u542f\u72b6\u6001{}", (Object)disableCollectReport);
                        long diffTime = System.currentTimeMillis();
                        if (!disableCollectReport) {
                            DataSet notChangeDs;
                            boolean isChanged = this.checkConfigChanged((DynamicObject)config, targetBillEntity);
                            logger.info("\u5dee\u91cf\u5f52\u96c6\u5224\u65ad:\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u65b9\u6848:{},\u6539\u53d8\u72b6\u6001:{}", (Object)config.getString("number"), (Object)isChanged);
                            if (!(isChanged || existsMatUseBill == null || existsMatUseBill.isEmpty() || (notChangeDs = sourceBills.copy().join(existsMatUseBill.copy(), JoinType.INNER).on(entryEntityName, "sourcebillentryid").on("auditdate", "nsrcauditdate").select(new String[]{entryEntityName}, new String[]{"id as matUseId"}).finish()) == null || notChangeDs.isEmpty())) {
                                final HashSet<Long> sourceEntryIds = new HashSet<Long>(512);
                                final HashSet<Long> targetIds = new HashSet<Long>(512);
                                for (Row notChangeD : notChangeDs) {
                                    sourceEntryIds.add(notChangeD.getLong(entryEntityName));
                                    targetIds.add(notChangeD.getLong("matUseId"));
                                }
                                logger.info("\u5dee\u91cf\u5f52\u96c6\u5224\u65ad\uff1a\u65b9\u6848\uff1a{}\u6709{}\u6761\u5206\u5f55\u6570\u636e\u672a\u6539\u53d8\uff0c\u5254\u9664", (Object)config.getString("number"), (Object)sourceEntryIds.size());
                                if (!sourceEntryIds.isEmpty()) {
                                    final String finalEntryEntityName = entryEntityName;
                                    sourceBills = sourceBills.filter(new FilterFunction(){

                                        public boolean test(Row row) {
                                            return !sourceEntryIds.contains(row.getLong(finalEntryEntityName));
                                        }
                                    });
                                }
                                if (!targetIds.isEmpty()) {
                                    existsMatUseBill = existsMatUseBill.filter(new FilterFunction(){

                                        public boolean test(Row row) {
                                            return !targetIds.contains(row.getLong("id"));
                                        }
                                    });
                                }
                            }
                        }
                        logger.info("\u5dee\u91cf\u5f52\u96c6\u5224\u65ad\uff1a\u5dee\u91cf\u5904\u7406,\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - diffTime));
                        if (this.getMatUseContext().getIdEntryIdCompleteMap().isEmpty() && !CadEmptyUtils.isEmpty(existsEntryIdCompleteMap = this.groupEntryIdCompleteMap(existsMatUseBill, this.getMatUseContext().getExistBillNos()))) {
                            this.getMatUseContext().getIdEntryIdCompleteMap().putAll(existsEntryIdCompleteMap);
                        }
                        List partitionIds = BatchUtils.batchDataByEntryId((DataSet)sourceBills, (Integer)batchSize, (String)entryEntityName);
                        logger.info("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5206\u6279\uff1a\u65b9\u6848\u7f16\u53f7\uff1a{}\uff0c\u5206\u6279id\u7ed3\u675f\uff0c\u5171:{}\u6279", (Object)config.getString("number"), (Object)partitionIds.size());
                        for (int i = 0; i < partitionIds.size(); ++i) {
                            context.getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u3010%s\u3011\u5206\u6279\u5904\u7406", (String)"MaterialTransferAction_24", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                            context.getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c\u3010%1$s\u3011\u6279\uff0c\u5171\u3010%2$s\u3011\u6279\u3002", (String)"MaterialTransferAction_25", (String)"macc-cad-mservice", (Object[])new Object[0]), i + 1, partitionIds.size()));
                            this.getMatUseContext().getNewBillList().clear();
                            this.getMatUseContext().getConfigSrcAndTargetBillsMap().clear();
                            long start = TimeServiceHelper.now().getTime();
                            List entryIdList = (List)partitionIds.get(i);
                            logger.info("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5206\u6279\uff1a\u5f00\u59cb\u5206\u6279\u4f5c\u4e1a:\u7b2c{}\u6279\uff0c\u5355\u636e\u6570\u91cf{}", (Object)i, (Object)entryIdList.size());
                            if (CadEmptyUtils.isEmpty((List)entryIdList)) continue;
                            QFilter entryIdQf = new QFilter(entryEntityName, "in", (Object)entryIdList);
                            DynamicObjectCollection resResults = QueryServiceHelper.query((String)sourceBillEntity, (String)selectFields, (QFilter[])new QFilter[]{entryIdQf});
                            MaterialPropHelper.queryMaterialPropAndSet((DynamicObjectCollection)resResults, (String)selectFields);
                            IBillTransfer billTransfer = IBillTransfer.getTransferInstance((String)collectionArgs.getEntityId(), (String)collectionArgs.getAppNum());
                            BillTransferResult result = billTransfer.doTransfer((DynamicObject[])resResults.toArray((Object[])new DynamicObject[0]), config, this.configContext);
                            logger.info("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5206\u6279\uff1a\u8f6c\u6362\u7ed3\u679c\uff1a{},\u8017\u65f6:{}", (Object)context.getConfigSrcAndTargetBillsMap().size(), (Object)(TimeServiceHelper.now().getTime() - start));
                            context.getConfigSrcAndTargetBillsMap().put((DynamicObject)config, result.getSrcAndTargetBillsMap());
                            for (IMatUseAction matUseAction : matUseActions) {
                                long actionTime = System.currentTimeMillis();
                                matUseAction.setContext(context);
                                matUseAction.execute();
                                logger.info("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5206\u6279\uff1a\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f15\u5165-action\uff1a{},\u8017\u65f6\uff1a{}ms", (Object)matUseAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                            }
                            long end = TimeServiceHelper.now().getTime();
                            logger.info("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5206\u6279\uff1a\u7b2c{}\u6279\u4f5c\u4e1a\u7ed3\u675f,\u8017\u65f6\uff1a{}", (Object)i, (Object)(end - start));
                        }
                        if (CadEmptyUtils.isEmpty((List)partitionIds)) {
                            this.getMatUseContext().getNewBillList().clear();
                            this.getMatUseContext().getConfigSrcAndTargetBillsMap().clear();
                            for (IMatUseAction matUseAction : matUseActions) {
                                long actionTime = System.currentTimeMillis();
                                matUseAction.setContext(context);
                                matUseAction.execute();
                                logger.info("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5206\u6279\uff1a\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f15\u5165-action\uff1a{},\u8017\u65f6\uff1a{}ms", (Object)matUseAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                            }
                        }
                        String sourcebill = config.getString("sourcebill.id");
                        this.getMatUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d,\u6570\u636e\u5904\u7406\u5b8c\u6210\u3002", (String)"MaterialTransferAction_20", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                        int delNum = this.deleteMaterialBillForNoSrource(this.getMatUseContext().getIdEntryIdCompleteMap(), sourcebill, config.getString("number"));
                        this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"MaterialTransferAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), delNum));
                        if (this.getMatUseContext().getSourceEntryIds() != null && execIndex[0] < cofigList.size()) {
                            DataSet existUseBill = this.getExistsMatUseBill(collectionArgs.getAcctOrgId(), collectionArgs.getCostCenterIds(), collectionArgs.getManuOrgs(), collectionArgs.getMftOrderEntryIds(), (Map)collConfigRuleMappingMap.get(config.getLong("id")), sourceBillEntity, targetBillEntity, collectionArgs.getAppNum(), collectionArgs.getCollectParamMap(), config.getLong("id"), null);
                            Set<Long> sourceEntryIds = this.getMatUseContext().getSourceEntryIds();
                            for (Row row : existUseBill) {
                                sourceEntryIds.add(row.getLong("sourcebillentryid"));
                            }
                        }
                    });
                }
            }
            this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"MaterialTransferAction_21", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
            this.getMatUseContext().getIdEntryIdCompleteMap().clear();
            this.getMatUseContext().getExistBillNos().clear();
            this.getMatUseContext().getNewBillList().clear();
            this.getMatUseContext().getConfigSrcAndTargetBillsMap().clear();
        }
    }

    private Set<Long> getlastMonthSourceEntryIds(String entityId) {
        HashSet ids = Sets.newHashSetWithExpectedSize((int)10);
        if (1 != CadBgParamUtils.getScmParamForInt((String)"matcollectlastck", (int)1)) {
            return ids;
        }
        MatUseArgs collectionArgs = this.getMatUseContext().getMatUseArgs();
        List listDateMap = SysParamHelper.getImportScopeDate((Long)collectionArgs.getAcctOrgId(), (String)collectionArgs.getAppNum());
        if (CadEmptyUtils.isEmpty((List)listDateMap) || ((Map)listDateMap.get(0)).get("start") == null) {
            return ids;
        }
        Date colStartDate = (Date)((Map)listDateMap.get(0)).get("start");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(colStartDate);
        calendar.add(2, -1);
        Date startDate = calendar.getTime();
        calendar.setTime(colStartDate);
        calendar.add(5, -1);
        Date endDate = calendar.getTime();
        if (startDate.after(endDate)) {
            return ids;
        }
        QFilter orgQf = new QFilter("org", "=", (Object)collectionArgs.getAcctOrgId());
        orgQf.and(new QFilter("costcenter", "in", collectionArgs.getCostCenterIds()));
        QFilter appnumQf = new QFilter("appnum", "=", (Object)collectionArgs.getAppNum());
        if (!CadEmptyUtils.isEmpty(collectionArgs.getManuOrgs())) {
            orgQf.and(new QFilter("manuorg", "in", collectionArgs.getManuOrgs()));
        }
        if (!CadEmptyUtils.isEmpty(collectionArgs.getMftOrderEntryIds())) {
            orgQf.and("entryentity.costobject.probill", "in", collectionArgs.getMftOrderEntryIds());
        }
        QFilter bookDateQf = new QFilter("bookdate", ">=", (Object)startDate);
        bookDateQf.and(new QFilter("bookdate", "<=", (Object)endDate));
        DataSet ds = QueryServiceHelper.queryDataSet((String)"ExistsMatUseBill", (String)entityId, (String)"entryentity.sourcebillentryid sourcebillentryid", (QFilter[])new QFilter[]{orgQf, bookDateQf, appnumQf}, null);
        for (Row row : ds) {
            ids.add(row.getLong("sourcebillentryid"));
        }
        return ids;
    }

    private void delHistoryCollConfigData(List<DynamicObject> collConfigList, MatUseArgs collectionArgs, Map<Long, Map<String, String>> collConfigRuleMappingMap, Set<Long> allCollconfigIds) {
        if (collConfigList.isEmpty()) {
            return;
        }
        DynamicObject config = collConfigList.get(0);
        String targetBillEntity = config.getString("costbill.id");
        String sourceBillEntity = config.getString("sourcebill.id");
        DataSet existsMatUseBill = this.getExistsMatUseBill(collectionArgs.getAcctOrgId(), collectionArgs.getCostCenterIds(), collectionArgs.getManuOrgs(), collectionArgs.getMftOrderEntryIds(), collConfigRuleMappingMap.get(config.getLong("id")), sourceBillEntity, targetBillEntity, collectionArgs.getAppNum(), collectionArgs.getCollectParamMap(), -1L, allCollconfigIds);
        if (existsMatUseBill == null || existsMatUseBill.isEmpty()) {
            return;
        }
        Map<String, DynamicObject> existsEntryIdCompleteMap = this.groupEntryIdCompleteMap(existsMatUseBill, null);
        logger.info("\u9700\u8981\u5220\u9664\u7684\u5386\u53f2\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u7684\u5355\u636e\u6570\u91cf\uff1a{}", (Object)existsEntryIdCompleteMap.size());
        if (!CadEmptyUtils.isEmpty(existsEntryIdCompleteMap)) {
            this.getMatUseContext().getIdEntryIdCompleteMap().putAll(existsEntryIdCompleteMap);
        }
        int delNum = this.deleteMaterialBillForNoSrource(this.getMatUseContext().getIdEntryIdCompleteMap(), null, ResManager.loadKDString((String)"\u5386\u53f2\u65b9\u6848", (String)"MaterialTransferAction_22", (String)"macc-cad-mservice", (Object[])new Object[0]));
        this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5386\u53f2\u65b9\u6848\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"MaterialTransferAction_23", (String)"macc-cad-mservice", (Object[])new Object[0]), delNum));
    }

    private boolean checkConfigChanged(DynamicObject config, String entityId) {
        QFilter appNumQf;
        QFilter colObjQf;
        if (StringUtils.isEmpty((String)entityId)) {
            return true;
        }
        Date modifyTime = config.getDate("modifytime");
        String appNum = config.getString("appnum");
        QFilter orgQf = new QFilter("org", "=", (Object)this.getMatUseContext().getMatUseArgs().getAcctOrgId());
        DynamicObjectCollection collectReports = QueryServiceHelper.query((String)"cad_colreport", (String)"coldate", (QFilter[])new QFilter[]{orgQf, colObjQf = new QFilter("colobj", "=", (Object)"mat"), appNumQf = new QFilter("appnum", "=", (Object)appNum)}, (String)"coldate desc", (int)1);
        if (collectReports != null && collectReports.size() > 0) {
            return ((DynamicObject)collectReports.get(0)).getDate("coldate").compareTo(modifyTime) <= 0;
        }
        return true;
    }

    private void dealCostAccountInfo(List<Map<String, Object>> orgCostAccountList, Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap) {
        char splitSign = '@';
        HashSet<String> costAccountInfos = new HashSet<String>(orgCostAccountList.size());
        ArrayList<String> needFields = new ArrayList<String>(4);
        needFields.add("org");
        needFields.add("costaccountId");
        needFields.add("currencyId");
        for (Map<String, Object> map : orgCostAccountList) {
            StringBuilder sg = new StringBuilder();
            for (String needField : needFields) {
                sg.append(map.get(needField));
                sg.append(splitSign);
            }
            costAccountInfos.add(sg.toString());
        }
        needFields.clear();
        needFields.add("calorg");
        needFields.add("costaccount");
        needFields.add("localcurrency");
        for (Map.Entry entry : configSrcAndTargetBillsMap.entrySet()) {
            Map srcAndTargetBills = (Map)entry.getValue();
            Iterator it = srcAndTargetBills.entrySet().iterator();
            while (it.hasNext()) {
                DynamicObject srcBill = (DynamicObject)it.next().getKey();
                StringBuilder sg = new StringBuilder();
                for (String needField : needFields) {
                    if (!srcBill.containsProperty(needField)) continue;
                    sg.append(srcBill.getString(needField));
                    sg.append(splitSign);
                }
                if (costAccountInfos.contains(sg.toString())) continue;
                logger.info("remove\u7684\u5185\u5bb9\u4e3a\uff1a{}", (Object)sg);
                it.remove();
            }
        }
    }

    public List<DynamicObject> getValidCollConfigList(MatUseContext context, String targetEntity, Set<Long> collconfigIds) {
        if (this.collConfigList != null && this.collConfigList.size() > 0) {
            return this.collConfigList;
        }
        ArrayList<DynamicObject> values = new ArrayList<DynamicObject>(context.getRulesMap().values());
        HashSet<String> calMethodTypes = new HashSet<String>(10);
        for (Map.Entry<String, DynamicObject> ruleMap : context.getRulesMap().entrySet()) {
            String key = ruleMap.getKey();
            String[] split = key.split("@");
            if (split.length == 3) {
                calMethodTypes.add(split[1]);
                continue;
            }
            if (split.length != 4) continue;
            calMethodTypes.add(split[2]);
        }
        HashSet calcDimensionIds = new HashSet(10);
        values.forEach(p -> calcDimensionIds.add(p.getLong("costcalcdimension")));
        return ImportServiceHelper.getCollConfigs((Long)context.getMatUseArgs().getAcctOrgId(), (Long)context.getMatUseArgs().getCostAccountId(), calMethodTypes, calcDimensionIds, (String)targetEntity, (String)context.getMatUseArgs().getAppNum(), collconfigIds);
    }

    private Map<String, List<Long>> getBillRangeMap(Long accountOrg, List<Long> costCenters, String targetEntity, String appNum, CollectReport collectReport) {
        Map<String, List<Long>> billRangeMap = new HashMap<String, List<Long>>(16);
        if (CadEmptyUtils.isEmpty((String)targetEntity)) {
            return billRangeMap;
        }
        switch (targetEntity) {
            case "cad_plannedoutputbill": {
                if ("aca".equals(appNum)) {
                    billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"plancollectrange", (String)appNum, (CollectReport)collectReport);
                    break;
                }
                billRangeMap.put("norange", new ArrayList());
                break;
            }
            case "cad_factnedoutputbill": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"billrange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"matcollectrange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            case "sca_resourceuse": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"resourcerange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            default: {
                billRangeMap.put("norange", new ArrayList());
            }
        }
        return billRangeMap;
    }

    private List<QFilter> getSrcQFilters(DynamicObject config, Map<Long, List<QFilter>> collConfigFilterMap, Map<String, String> fieldMappingMap, Map<String, String> selectValueMappingMap, Map<String, Set<Long>> costCentersourceTypeDataMap, List<Long> mftOrderEntryIds, CollectReport collectReport) {
        List<QFilter> collectParamsFilter;
        List<Object> collConfigFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        QFilter speFilter = new QFilter("1", "!=", (Object)1);
        if (config == null) {
            filters.add(speFilter);
            return filters;
        }
        Long configId = config.getLong("id");
        String sourceBillEntity = config.getString("sourcebill.id");
        String manuOrgField = fieldMappingMap.getOrDefault("manuorg", "");
        String costCenterField = fieldMappingMap.get("costcenter");
        String timeField = "";
        timeField = "cad_plannedoutputbill".equals(this.configContext.getParam().getTargetEntity()) ? fieldMappingMap.get("bizdate") : fieldMappingMap.get("bookdate");
        List<Object> list = collConfigFilter = collConfigFilterMap.get(configId) == null ? new ArrayList(10) : collConfigFilterMap.get(configId);
        if (!CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            QFilter filter = this.dealHasOrderEntryId(mftOrderEntryIds, sourceBillEntity);
            if (filter == null) {
                filters.add(speFilter);
                return filters;
            }
            collConfigFilter.add(filter);
        }
        QFilter ccFilter = null;
        if (costCenterField == null) {
            logger.info("\u914d\u7f6e\u65b9\u6848{}\uff0c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb-\u6210\u672c\u4e2d\u5fc3\u5bf9\u5e94\u6e90\u5355\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u67e5\u8be2\u6e90\u5355\u5931\u8d25\u3002", (Object)config.getString("number"));
            filters.add(speFilter);
            return filters;
        }
        Object[] splitCostCenterField = costCenterField.split(",");
        if (splitCostCenterField.length == 1 && ((String)splitCostCenterField[0]).contains("costcenter")) {
            ccFilter = new QFilter((String)splitCostCenterField[0], "in", (Object)this.configContext.getParam().getCostCenterIds());
        } else if (!CadEmptyUtils.isEmpty((Object[])splitCostCenterField)) {
            Set<Long> workCenterIds = costCentersourceTypeDataMap.get("mpdm_workcentre");
            Set<Long> adminOrgIds = costCentersourceTypeDataMap.get("bos_adminorg");
            Set<Long> bosOrgIds = costCentersourceTypeDataMap.get("bos_org");
            for (Object splitCostCenter : splitCostCenterField) {
                if (CadEmptyUtils.isEmpty((String)splitCostCenter)) continue;
                ccFilter = ccFilter == null ? this.costCenterRelationService.getWcOrOrgOrAoQFByWay(workCenterIds, adminOrgIds, bosOrgIds, (String)splitCostCenter, sourceBillEntity) : ccFilter.or(this.costCenterRelationService.getWcOrOrgOrAoQFByWay(workCenterIds, adminOrgIds, bosOrgIds, (String)splitCostCenter, sourceBillEntity));
                if (!((String)splitCostCenter).contains("costcenter")) continue;
                ccFilter = ccFilter == null ? new QFilter((String)splitCostCenter, "in", (Object)this.configContext.getParam().getCostCenterIds()) : ccFilter.or(new QFilter((String)splitCostCenter, "in", (Object)this.configContext.getParam().getCostCenterIds()));
            }
        }
        if (!"2".equals(selectValueMappingMap.get("costcenter"))) {
            filters.add(ccFilter);
        }
        if (!CadEmptyUtils.isEmpty(costCentersourceTypeDataMap.get("mpdm_workcentre")) && ("pom_mftorder".equals(sourceBillEntity) || "om_mftorder".equals(sourceBillEntity))) {
            HashMap entryIdWorkCenterMap = new HashMap(16);
            Set<Long> workCenter = costCentersourceTypeDataMap.get("mpdm_workcentre");
            String manfethEntity = "pom_mftorder".equals(sourceBillEntity) ? "sfc_manftech" : "om_mfttechnics";
            List entryIds = CostCenterHelper.getOrderEntryIds(new ArrayList<Long>(workCenter), (String)manfethEntity, entryIdWorkCenterMap, mftOrderEntryIds);
            if (CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
                QFilter wcFilter = InFilterHelper.getQFilterByBachSize((String)"treeentryentity.id", new ArrayList(entryIds), (String)"in", (int)20000);
                if ("aca".equals(this.configContext.getParam().getAppnum())) {
                    wcFilter.or(InFilterHelper.getQFilterByBachSize((String)"treeentryentity.pid", new ArrayList(entryIds), (String)"in", (int)20000));
                }
                ccFilter = ccFilter == null ? wcFilter : ccFilter.or(wcFilter);
            }
            this.configContext.getConfigProEntryIdWorkCenterMap().computeIfAbsent(config, p -> new HashMap()).putAll(entryIdWorkCenterMap);
        }
        collConfigFilter.add(ccFilter);
        QFilter manuOrgFilter = null;
        if (!CadEmptyUtils.isEmpty((Object[])this.configContext.getParam().getManuOrgIds()) && !CadEmptyUtils.isEmpty((String)manuOrgField)) {
            manuOrgFilter = new QFilter(manuOrgField, "in", (Object)this.configContext.getParam().getManuOrgIds());
            collConfigFilter.add(manuOrgFilter);
        }
        QFilter importTimeScopeFilter = null;
        if (!CadEmptyUtils.isEmpty((String)timeField)) {
            if ("cad_mfgfeebill".equals(this.configContext.getParam().getTargetEntity())) {
                DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)this.configContext.getParam().getCostAccountId());
                HashSet<Long> periodIds = new HashSet<Long>(2);
                periodIds.add(currentPeriod == null ? 0L : currentPeriod.getLong("id"));
                Map dateByPeriod = PeriodHelper.getDateByPeriod(periodIds);
                if (!CadEmptyUtils.isEmpty((Map)dateByPeriod)) {
                    QFilter timeQFilter = new QFilter(timeField, ">=", dateByPeriod.get("begindate"));
                    timeQFilter.and(new QFilter(timeField, "<=", dateByPeriod.get("enddate")));
                    collConfigFilter.add(timeQFilter);
                }
            } else {
                importTimeScopeFilter = SysParamHelper.getImportTimeScope((Long)this.configContext.getParam().getCalOrgId(), (String)timeField, (String)this.configContext.getParam().getAppnum(), (CollectReport)collectReport);
                collConfigFilter.add(importTimeScopeFilter);
            }
        }
        if (!CadEmptyUtils.isEmpty(collectParamsFilter = this.getCollectParamsQFilter(sourceBillEntity, collectReport))) {
            collConfigFilter.addAll(collectParamsFilter);
        }
        return collConfigFilter;
    }

    private List<QFilter> getCollectParamsQFilter(String sourceBillEntity, CollectReport collectReport) {
        ArrayList<QFilter> collConfigFilter = new ArrayList<QFilter>(10);
        if (CadEmptyUtils.isEmpty((String)sourceBillEntity)) {
            return collConfigFilter;
        }
        if (("cad_costobject".equals(this.configContext.getParam().getTargetEntity()) || "cad_plannedoutputbill".equals(this.configContext.getParam().getTargetEntity())) && ("pom_mftorder".equals(sourceBillEntity) || "om_mftorder".equals(sourceBillEntity))) {
            Set notNeedCollectBillBizIdsForCo = SysParamHelper.getNotNeedCollectBillBizIds((Long)this.configContext.getParam().getCalOrgId(), (String)this.configContext.getParam().getTargetEntity(), (String)sourceBillEntity, (String)"bizsettingentry.transactiontype.fbasedataid.id", (String)this.configContext.getParam().getAppnum());
            QFilter notCollRangeFilter = new QFilter("transactiontype", "not in", (Object)notNeedCollectBillBizIdsForCo);
            collConfigFilter.add(notCollRangeFilter);
            collectReport.setTransactionTypes(notNeedCollectBillBizIdsForCo);
        } else if ("cad_factnedoutputbill".equals(this.configContext.getParam().getTargetEntity()) && ("im_mdc_mftmanuinbill".equals(sourceBillEntity) || "im_mdc_mftreturnbill".equals(sourceBillEntity)) || "im_mdc_omcmplinbill".equals(sourceBillEntity)) {
            Map notNeedCollectBillBizIdsMap = SysParamHelper.getNotNeedCollectBillBizIdsMap((Long)this.configContext.getParam().getCalOrgId(), (String)this.configContext.getParam().getTargetEntity(), (String)sourceBillEntity, (String)"bizsettingentry.biztype.fbasedataid.id,bizsettingentry.invscheme.fbasedataid.id", (String)this.configContext.getParam().getAppnum());
            Set bizTypeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.biztype.fbasedataid.id");
            Set invSchemeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.invscheme.fbasedataid.id");
            if (!CadEmptyUtils.isEmpty((Set)bizTypeIds)) {
                collectReport.setBizTypeIds(bizTypeIds);
                collConfigFilter.add(new QFilter("biztype", "not in", (Object)bizTypeIds));
            }
            if (!CadEmptyUtils.isEmpty((Set)invSchemeIds)) {
                collectReport.setInvSchemeIds(invSchemeIds);
                collConfigFilter.add(new QFilter("invscheme", "not in", (Object)invSchemeIds));
            }
        } else if (("sca_matusecollect".equals(this.configContext.getParam().getTargetEntity()) || "aca_matusecollect".equals(this.configContext.getParam().getTargetEntity())) && ("im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity)) || "im_mdc_mftfeedorder".equals(sourceBillEntity) || "im_mdc_omoutbill".equals(sourceBillEntity) || "im_mdc_omreturnbill".equals(sourceBillEntity) || "im_mdc_omfeedbill".equals(sourceBillEntity) || "im_materialreqoutbill".equals(sourceBillEntity)) {
            Map notNeedCollectBillBizIdsMap = SysParamHelper.getNotNeedCollectBillBizIdsMap((Long)this.configContext.getParam().getCalOrgId(), (String)this.configContext.getParam().getTargetEntity(), (String)sourceBillEntity, (String)"bizsettingentry.biztype.fbasedataid.id,bizsettingentry.invscheme.fbasedataid.id", (String)this.configContext.getParam().getAppnum());
            Set bizTypeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.biztype.fbasedataid.id");
            Set invSchemeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.invscheme.fbasedataid.id");
            if (!CadEmptyUtils.isEmpty((Set)bizTypeIds)) {
                collectReport.setBizTypeIds(bizTypeIds);
                collConfigFilter.add(new QFilter("biztype", "not in", (Object)bizTypeIds));
            }
            if (!CadEmptyUtils.isEmpty((Set)invSchemeIds)) {
                collectReport.setInvSchemeIds(invSchemeIds);
                collConfigFilter.add(new QFilter("invscheme", "not in", (Object)invSchemeIds));
            }
        }
        return collConfigFilter;
    }

    private QFilter dealHasOrderEntryId(List<Long> mftOrderEntryIds, String sourceBillEntity) {
        QFilter filter = null;
        if (!CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            if ("om_mftorder".equals(sourceBillEntity) || "pom_mftorder".equals(sourceBillEntity)) {
                filter = new QFilter("treeentryentity.id", "in", mftOrderEntryIds);
            } else if ("im_mdc_mftmanuinbill".equals(sourceBillEntity) || "im_mdc_omcmplinbill".equals(sourceBillEntity) || "im_mdc_mftreturnbill".equals(sourceBillEntity)) {
                filter = new QFilter("billentry.manuentryid", "in", mftOrderEntryIds);
            } else if ("im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity) || "im_mdc_mftfeedorder".equals(sourceBillEntity) || "im_mdc_omoutbill".equals(sourceBillEntity) || "im_mdc_omreturnbill".equals(sourceBillEntity) || "im_mdc_omfeedbill".equals(sourceBillEntity)) {
                filter = new QFilter("billentry.manuentryid", "in", mftOrderEntryIds);
            } else if ("sfc_processreportbill".equals(sourceBillEntity) || "sfc_reportresource_adjust".equals(sourceBillEntity) || "pom_mftorderreport".equals(sourceBillEntity) || "om_processreport".equals(sourceBillEntity)) {
                if ("pom_mftorderreport".equals(sourceBillEntity)) {
                    ArrayList<String> entryStrIds = new ArrayList<String>(mftOrderEntryIds.size());
                    for (Long id : mftOrderEntryIds) {
                        entryStrIds.add(String.valueOf(id));
                    }
                    filter = new QFilter("sumentry.mftentryid", "in", entryStrIds);
                } else {
                    filter = new QFilter("sumentry.manufactureentryid", "in", mftOrderEntryIds);
                }
            }
        }
        return filter;
    }

    private List<IMatUseAction> initializeActions(String appNum) {
        ArrayList<IMatUseAction> matUseActions = new ArrayList<IMatUseAction>();
        switch (appNum) {
            case "sca": {
                matUseActions.add(new MaterialImportDataConfigAction());
                matUseActions.add(new MaterialImportDataForFPConfigAction());
                matUseActions.add(new MaterialImportDataForCUConfigAction());
                matUseActions.add(new DealMaterialAllocBillAction());
                matUseActions.add(new CompletionSaveAction());
                matUseActions.add(new ScaMaterialWritCostChangeAction());
                break;
            }
            case "aca": {
                matUseActions.add(new MaterialImportDataConfigAction());
                matUseActions.add(new MaterialImportDataForFPConfigAction());
                matUseActions.add(new MaterialImportDataForPZConfigAction());
                matUseActions.add(new MaterialImportDataForFLConfigAction());
                matUseActions.add(new MaterialImportDataForCUConfigAction());
                matUseActions.add(new DealMaterialAllocBillAction());
                matUseActions.add(new CompletionSaveAction());
                break;
            }
        }
        return matUseActions;
    }

    protected int deleteMaterialBillForNoSrource(Map<String, DynamicObject> idEntryIdCompleteMap, String sourceBillEntity, String configNumber) {
        if (CadEmptyUtils.isEmpty(idEntryIdCompleteMap)) {
            return 0;
        }
        String appNum = this.getMatUseContext().getMatUseArgs().getAppNum();
        HashSet<Long> deleteSrcData = new HashSet<Long>(10);
        HashSet<Long> matUseEntryIdSet = new HashSet<Long>(16);
        for (Map.Entry<String, DynamicObject> idEntryIdComplete : idEntryIdCompleteMap.entrySet()) {
            DynamicObject matUse = idEntryIdComplete.getValue();
            deleteSrcData.add(matUse.getLong("id"));
            DynamicObjectCollection entryentity = matUse.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryentity) {
                matUseEntryIdSet.add(row.getLong("id"));
            }
        }
        this.getMatUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u4e2d\uff0c\u662f\u5426\u6709\u9700\u8981\u5220\u9664\u7684\u5355\u636e\uff1f", (String)"MaterialTransferAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), configNumber));
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)this.getEntity(appNum)), (Object[])deleteSrcData.toArray(new Long[0]));
        this.delChangeRecord(deleteSrcData);
        this.getMatUseContext().addDelNum(deleteSrcData.size());
        this.getMatUseContext().getCostChangedRecords().addAll(idEntryIdCompleteMap.values());
        this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"MaterialTransferAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]), deleteSrcData.size()));
        this.getMatUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\uff0c\u5220\u9664\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff08\u5df2\u5220\uff09\u5bf9\u5e94\u7684\u5206\u914d\u5355\u3002", (String)"MaterialTransferAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]), configNumber));
        Set allocBillIds = new HashSet(10);
        if (!matUseEntryIdSet.isEmpty()) {
            QFilter subQFilter = new QFilter("matcollect", "in", matUseEntryIdSet);
            subQFilter.and(new QFilter("appnum", "=", (Object)appNum));
            DynamicObjectCollection allocBills = QueryServiceHelper.query((String)"sca_matalloc", (String)"id", (QFilter[])new QFilter[]{subQFilter});
            allocBillIds = DynamicObjectHelper.getIdSet((DynamicObjectCollection)allocBills, (String)"id");
            if ("sca".equals(appNum)) {
                if (!"im_materialreqoutbill".equals(sourceBillEntity) && allocBillIds != null && allocBillIds.size() > 0) {
                    CostChangeRecHelper.writeCostChangeRecForAllocDel(allocBillIds);
                }
                DeleteServiceHelper.delete((String)"sca_matalloc", (QFilter[])new QFilter[]{subQFilter});
            } else {
                DeleteServiceHelper.delete((String)"aca_matalloc", (QFilter[])new QFilter[]{subQFilter});
            }
        }
        this.getMatUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"MaterialTransferAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]), allocBillIds == null ? 0 : allocBillIds.size()));
        return deleteSrcData.size();
    }

    protected String getEntity(String appNum) {
        if ("sca".equals(appNum)) {
            return "sca_matusecollect";
        }
        if ("aca".equals(appNum)) {
            return "aca_matusecollect";
        }
        return "sca_matusecollect";
    }

    protected void delChangeRecord(Set<Long> srcBillIds) {
        QFilter filter = new QFilter("sourcebill", "in", srcBillIds);
        filter.and("bizstatus", "!=", (Object)"B");
        DeleteServiceHelper.delete((String)"sca_costchangerecord", (QFilter[])new QFilter[]{filter});
    }

    private DataSet getExistsMatUseBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, List<Long> mftOrderEntryIds, Map<String, String> configRuleMappingMap, String srcBillType, String entityId, String appNum, Map<String, Object> collectParamMap, long configId, Set<Long> allCollConfigIds) {
        if (CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            return this.getExistsMatUseBill(org, methodCostCenters, manuOrgs, srcBillType, entityId, appNum, collectParamMap, configId, allCollConfigIds);
        }
        if (CadEmptyUtils.isEmpty((String)configRuleMappingMap.get("probill"))) {
            return null;
        }
        QFilter orgQf = new QFilter("org", "=", (Object)org);
        orgQf.and(new QFilter("costcenter", "in", methodCostCenters));
        if (allCollConfigIds != null) {
            orgQf.and("collconfig", "not in", allCollConfigIds);
        } else {
            orgQf.and("collconfig", "=", (Object)configId);
            orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
        }
        QFilter sourceBillQf = new QFilter("entryentity.costobject.probill", "in", mftOrderEntryIds);
        QFilter appnumQf = new QFilter("appnum", "=", (Object)appNum);
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        return QueryServiceHelper.queryDataSet((String)"MaterialTransferAction_getExistsMatUseBill", (String)entityId, (String)"id,entryentity.sourcebillentryid sourcebillentryid,nsrcauditdate", (QFilter[])new QFilter[]{orgQf, sourceBillQf, bookDateQf, appnumQf}, (String)"id desc");
    }

    protected DataSet getExistsMatUseBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, String srcBillType, String entityId, String appNum, Map<String, Object> collectParamMap, long configId, Set<Long> allCollConfigIds) {
        QFilter orgQf = new QFilter("org", "=", (Object)org);
        orgQf.and(new QFilter("costcenter", "in", methodCostCenters));
        if (allCollConfigIds != null) {
            orgQf.and("collconfig", "not in", allCollConfigIds);
        } else {
            orgQf.and("collconfig", "=", (Object)configId);
            orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
        }
        QFilter appnumQf = new QFilter("appnum", "=", (Object)appNum);
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            orgQf.and(new QFilter("manuorg", "in", manuOrgs));
        }
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        if (!CadEmptyUtils.isEmpty(collectParamMap) && collectParamMap.get("startDate") != null && collectParamMap.get("endDate") != null) {
            QFilter collectTimeQFilter = new QFilter("bookdate", ">=", collectParamMap.get("startDate"));
            collectTimeQFilter.and(new QFilter("bookdate", "<=", collectParamMap.get("endDate")));
            bookDateQf.and(collectTimeQFilter);
        }
        return QueryServiceHelper.queryDataSet((String)"MaterialTransferAction_getExistsMatUseBill", (String)entityId, (String)"id,entryentity.sourcebillentryid sourcebillentryid,nsrcauditdate", (QFilter[])new QFilter[]{orgQf, bookDateQf, appnumQf}, (String)"id desc");
    }

    protected Map<String, DynamicObject> groupEntryIdCompleteMap(DataSet existMatUse, Set<String> existBillNos) {
        HashMap idEntryIdCompleteMap = Maps.newHashMapWithExpectedSize((int)1024);
        if (existMatUse == null || existMatUse.isEmpty()) {
            return idEntryIdCompleteMap;
        }
        ArrayList<Long> sourceBillIds = new ArrayList<Long>();
        for (Row row : existMatUse) {
            sourceBillIds.add(row.getLong("id"));
        }
        Object[] completionList = BusinessDataServiceHelper.load((Object[])sourceBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntity(this.getMatUseContext().getMatUseArgs().getAppNum())));
        if (CadEmptyUtils.isEmpty((Object[])completionList)) {
            return idEntryIdCompleteMap;
        }
        for (Object materialUse : completionList) {
            if (existBillNos != null) {
                existBillNos.add(materialUse.getString("billno"));
            }
            if (CadEmptyUtils.isEmpty((Long)materialUse.getLong("sourcebillid"))) continue;
            idEntryIdCompleteMap.put(materialUse.getString("billno") + "-" + materialUse.get("sourcebillid"), materialUse);
        }
        return idEntryIdCompleteMap;
    }
}

