/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.mfgfee;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.dto.CollectDiff;
import kd.macc.cad.common.dto.MfgFeeImportReport;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.mfgfee.AbstractMfgFeeAction;

public class CompletionSaveAction
extends AbstractMfgFeeAction {
    private static final Log logger = LogFactory.getLog(CompletionSaveAction.class);

    @Override
    protected void doExecute() {
        MfgFeeImportReport report = this.getMfgFeeContext().getReport();
        if (!"cad_planfeebill".equals(this.getMfgFeeContext().getTargetEntity()) && report != null) {
            report.logReportDetail(ResManager.loadKDString((String)"\u68c0\u67e5\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5dee\u5f02", (String)"CompletionSaveAction_29", (String)"macc-cad-mservice", (Object[])new Object[0]));
            Map billNoReasonMap = report.getBillNoReasonMap();
            ArrayList diffs = Lists.newArrayListWithExpectedSize((int)8);
            for (Map.Entry billNoReason : billNoReasonMap.entrySet()) {
                String key = (String)billNoReason.getKey();
                String[] split = key.split("@");
                String value = (String)billNoReason.getValue();
                CollectDiff collectDiff = new CollectDiff(split[0], Integer.valueOf(Integer.parseInt(split[1])), split[2], value);
                collectDiff.setBillType(split[2]);
                if (value.length() > 0) {
                    collectDiff.setReason(value);
                }
                diffs.add(collectDiff);
            }
            if (diffs.size() > 0) {
                report.getCollectDiffs().addAll(diffs);
                report.setError(Boolean.valueOf(true));
            }
            String desc = ResManager.loadKDString((String)"\u5171\u6709\u5dee\u5f02\u6570\u636e\u3010%s\u3011\u6761\u3002", (String)"CompletionSaveAction_30", (String)"macc-cad-mservice", (Object[])new Object[0]);
            report.logCheckDesc(String.format(desc, diffs.size()));
        }
        List<DynamicObject> mfgFeeBills = this.getMfgFeeContext().getMfgFeeBills();
        Set<Long> deleteBillIds = this.getMfgFeeContext().getDeleteMfgBillIds();
        try (TXHandle txHandle = TX.required();){
            if (!CadEmptyUtils.isEmpty(deleteBillIds)) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.getMfgFeeContext().getTargetEntity());
                DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])deleteBillIds.toArray());
                this.getMfgFeeContext().setDeleteNum(deleteBillIds.size());
            }
            if (CadEmptyUtils.isEmpty(mfgFeeBills)) {
                return;
            }
            logger.info("\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5185\u90e8\u7cfb\u7edf\u5f15\u5165-\u5f15\u5165\u7684\u5f52\u96c6\u5355\u6570\u91cf\uff1a{}", (Object)mfgFeeBills.size());
            int saveSize = mfgFeeBills.size();
            int batchSize = 300;
            if (saveSize <= batchSize * 3) {
                this.save(mfgFeeBills);
            } else {
                int batchCount = saveSize / batchSize + 1;
                for (int i = 0; i < batchCount; ++i) {
                    int startCount = i * batchSize;
                    int endCount = (i + 1) * batchSize;
                    if (i == batchCount - 1) {
                        endCount = saveSize;
                    }
                    List<DynamicObject> batchBillList = mfgFeeBills.subList(startCount, endCount);
                    this.save(batchBillList);
                }
            }
        }
        this.getMfgFeeContext().setAddNum(mfgFeeBills.size());
    }

    private void save(List<DynamicObject> mfgFeeBills) {
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)this.getMfgFeeContext().getTargetEntity(), (DynamicObject[])mfgFeeBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!operateResult.isSuccess()) {
            String errorInfo = OperationResultHelper.errorMsgHandle((OperationResult)operateResult);
            logger.error("\u4fdd\u5b58\u5931\u8d25\u3002" + errorInfo);
            throw new KDBizException(errorInfo);
        }
    }
}

