/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.mfgfee;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.dto.MfgFeeImportReport;
import kd.macc.cad.common.dto.MfgFeeReportConfig;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MfgfeeBillImportHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.mfgfee.AbstractMfgFeeAction;
import kd.macc.cad.mservice.mfgfee.MfgFeeArgs;

public class MfgFeeImportDataConfigAction
extends AbstractMfgFeeAction {
    private static final Log logger = LogFactory.getLog(MfgFeeImportDataConfigAction.class);
    private static String selectFields = "id,org,costaccount,manuorg,period,costcenter,expenseitem,totalamount,currency,productgroup,costobject,bookdate,outsourcetype,srcbilltype,srcbillid,srcbillentryid,voucherentry,createtime,sourcetype";
    private static String selectPlanFeeFields = "id,org,costaccount,manuorg,period,costcenter,expenseitem,totalamount,currency,srcbilltype,srcbillid,createtime,sourcetype";
    private static final Integer BATCH_SIZE = 85;

    @Override
    protected void doExecute() {
        DynamicObject[] costCenterArr;
        MfgFeeArgs mfgFeeArgs = this.getMfgFeeContext().getMfgFeeArgs();
        long orgId = mfgFeeArgs.getAccountOrgId();
        String appNum = mfgFeeArgs.getAppNum();
        List<Long> costCenterIds = mfgFeeArgs.getCostCenterIds();
        HashMap<Long, DynamicObject> costCenterDyMap = new HashMap<Long, DynamicObject>(16);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_costcenter");
        for (DynamicObject csDy : costCenterArr = BusinessDataServiceHelper.load((Object[])costCenterIds.toArray(), (DynamicObjectType)dt)) {
            costCenterDyMap.put(csDy.getLong("id"), csDy);
        }
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        Set<Long> allCostCenterIds = new HashSet(16);
        if (enableMulFactory) {
            List manuList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)this.getMfgFeeContext().getTargetEntity(), (String)appNum);
            allCostCenterIds = OrgHelper.getCenterIdsByManuOrgIds((Long)orgId, (List)manuList, (String)appNum);
        } else {
            QFilter qFilter = new QFilter("accountorg", "=", (Object)orgId);
            qFilter.and("status", "=", (Object)"C");
            qFilter.and("enable", "=", (Object)true);
            List costCenterPrimaryIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])qFilter.toArray(), null, (int)-1);
            if (!CadEmptyUtils.isEmpty((List)costCenterPrimaryIds)) {
                for (Object primaryId : costCenterPrimaryIds) {
                    allCostCenterIds.add(Long.parseLong(String.valueOf(primaryId)));
                }
            }
        }
        Map<Long, Long> costAccountPeriodMap = mfgFeeArgs.getCostAccountPeriodMap();
        Map<Long, Long> costAccountCurrencyMap = mfgFeeArgs.getCostAccountCurrencyMap();
        HashMap<String, List> saveMfgFeeBillsMap = new HashMap<String, List>(16);
        HashSet dimensionKeySet = new HashSet(16);
        HashMap<String, String> srcSysMap = new HashMap<String, String>(16);
        Map<Long, Set<String>> costAccountBillTypeMap = this.getMfgFeeContext().getCostAccountBillTypeMap();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getMfgFeeContext().getConfigSrcAndTargetBillsMap();
        if (CadEmptyUtils.isEmpty(configSrcAndTargetBillsMap)) {
            return;
        }
        Map<Long, Map<String, String>> collConfigMappingMap = this.getMfgFeeContext().getCollConfigMappingMap();
        HashSet<String> otherFieldSet = new HashSet<String>(16);
        MfgFeeImportReport report = this.getMfgFeeContext().getReport();
        for (Map<String, String> collConfigs : collConfigMappingMap.values()) {
            Set<String> collConfigKeys = collConfigs.keySet();
            for (String configKey : collConfigKeys) {
                if ("cad_mfgfeebill".equals(this.getMfgFeeContext().getTargetEntity())) {
                    if (selectFields.contains(configKey)) continue;
                    otherFieldSet.add(configKey);
                    continue;
                }
                if (selectPlanFeeFields.contains(configKey)) continue;
                otherFieldSet.add(configKey);
            }
        }
        if (!CadEmptyUtils.isEmpty(otherFieldSet)) {
            StringBuffer otherFields = new StringBuffer();
            otherFieldSet.forEach(s -> otherFields.append(",").append((String)s));
            if ("cad_mfgfeebill".equals(this.getMfgFeeContext().getTargetEntity())) {
                selectFields = selectFields + otherFields;
            } else {
                selectPlanFeeFields = selectPlanFeeFields + otherFields;
            }
        }
        HashSet<String> feeReportRangeSet = new HashSet<String>(16);
        Set<MfgFeeReportConfig> mfgFeeReportConfigSet = new HashSet(10);
        if (report != null) {
            mfgFeeReportConfigSet = report.getMfgFeeReportConfigSet();
            mfgFeeReportConfigSet.forEach(s -> feeReportRangeSet.add(String.format("%s@%s@%s", s.getAccountOrgId(), s.getAccountBook(), s.getSrcBill())));
        }
        Set<Long> costAccountIds = mfgFeeArgs.getCostAccountIds();
        QFilter qf = new QFilter("org", "=", (Object)orgId);
        qf.and("costaccount", "in", costAccountIds);
        qf.and("appnum", "=", (Object)appNum);
        qf.and("period", "in", costAccountPeriodMap.values());
        qf.and("costcenter", "in", costCenterIds);
        qf.and("sourcetype", "in", (Object)new String[]{"SYS", "CONFIG"});
        DynamicObjectCollection existMfgFeeBills = "cad_mfgfeebill".equals(this.getMfgFeeContext().getTargetEntity()) ? QueryServiceHelper.query((String)this.getMfgFeeContext().getTargetEntity(), (String)selectFields, (QFilter[])new QFilter[]{qf}) : QueryServiceHelper.query((String)this.getMfgFeeContext().getTargetEntity(), (String)selectPlanFeeFields, (QFilter[])new QFilter[]{qf});
        HashMap<String, DynamicObject> existMfgMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, Long> needDeleteMfgBillIds = new HashMap<String, Long>(16);
        HashMap existMfgBillDateMap = new HashMap(16);
        HashSet costAccountVouCherIdSet = new HashSet(128);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)existMfgFeeBills)) {
            if ("cad_mfgfeebill".equals(this.getMfgFeeContext().getTargetEntity())) {
                existMfgFeeBills.forEach(s -> {
                    String voucherEntry = s.getString("voucherentry");
                    if (!CadEmptyUtils.isEmpty((String)voucherEntry)) {
                        String costAccount = s.getString("costaccount");
                        String[] voucherEntryArr = voucherEntry.split("@");
                        if (voucherEntryArr != null) {
                            for (String vouCher : voucherEntryArr) {
                                costAccountVouCherIdSet.add(costAccount.concat("@").concat(vouCher));
                                HashMap<Long, Date> billDateMap = new HashMap<Long, Date>(2);
                                billDateMap.put(s.getLong("id"), s.getDate("createtime"));
                                existMfgBillDateMap.put(vouCher, billDateMap);
                            }
                        }
                    }
                    String dimensionBillKey = String.format("%s@%s@%s@%s@%s", s.get("costaccount"), s.get("srcbilltype"), s.get("srcbillid"), s.get("srcbillentryid"), s.get("voucherentry"));
                    if ("CONFIG".equals(s.getString("sourcetype"))) {
                        needDeleteMfgBillIds.put(dimensionBillKey, s.getLong("id"));
                    }
                    existMfgMap.put(dimensionBillKey, (DynamicObject)s);
                });
            } else if ("cad_planfeebill".equals(this.getMfgFeeContext().getTargetEntity())) {
                existMfgFeeBills.forEach(s -> {
                    String dimensionBillKey = String.format("%s@%s@%s@%s@%s@%s", s.get("costaccount"), s.get("period"), s.get("costcenter"), s.get("srcbilltype"), s.get("expenseitem"), s.get("srcbillid"));
                    if ("SYS".equals(s.getString("sourcetype"))) {
                        needDeleteMfgBillIds.put(dimensionBillKey, s.getLong("id"));
                    }
                    existMfgMap.put(dimensionBillKey, (DynamicObject)s);
                });
            }
        }
        ArrayList<DynamicObject> saveMfgFeeBillList = new ArrayList<DynamicObject>();
        Map<Long, Map<String, String>> collConfigRuleMappingMap = this.getMfgFeeContext().getCollConfigRuleMappingMap();
        for (Map.Entry<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
            int collectMfgBillSize = 0;
            DynamicObject config = configSrcAndTargetBill.getKey();
            String sourceBill = config.getString("sourcebill.id");
            if (!srcSysMap.containsKey(sourceBill)) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)sourceBill);
                String sourceSysId = AppMetadataCache.getAppInfo((String)type.getAppId()).getId();
                srcSysMap.put(sourceBill, sourceSysId);
            }
            boolean isAll = false;
            String assgrp = config.getString("assgrp");
            String assgrpCondition = config.getString("assgrpcondition");
            Map assgrpMap = new HashMap(16);
            if (StringUtils.isEmpty((CharSequence)assgrp)) {
                isAll = true;
            } else {
                assgrpMap = (Map)SerializationUtils.fromJsonString((String)assgrp, Map.class);
                if (CadEmptyUtils.isEmpty(assgrpMap)) {
                    isAll = true;
                }
            }
            Map assgrpConditionMap = CadEmptyUtils.isEmpty((String)assgrpCondition) ? new HashMap(8) : (Map)SerializationUtils.fromJsonString((String)assgrpCondition, Map.class);
            long accountOrgId = config.get("costaccount") == null ? 0L : config.getLong("costaccount.id");
            long accountBookId = config.get("accountbook") == null ? 0L : config.getLong("accountbook.id");
            String feeReportRange = String.format("%s@%s@%s", accountOrgId, accountBookId, sourceBill);
            if (feeReportRangeSet.add(feeReportRange)) {
                MfgFeeReportConfig mfgFeeReportConfig = new MfgFeeReportConfig();
                mfgFeeReportConfig.setAccountOrgId(Long.valueOf(accountOrgId));
                mfgFeeReportConfig.setAccountBook(Long.valueOf(accountBookId));
                mfgFeeReportConfig.setPeriodId(costAccountPeriodMap.get(accountOrgId));
                mfgFeeReportConfig.setSrcBill(sourceBill);
                mfgFeeReportConfigSet.add(mfgFeeReportConfig);
            }
            TreeMap<String, String> configRuleMappingMap = null;
            if (!CadEmptyUtils.isEmpty(collConfigRuleMappingMap) && collConfigRuleMappingMap.get(config.getLong("id")) != null) {
                configRuleMappingMap = new TreeMap<String, String>(collConfigRuleMappingMap.get(config.getLong("id")));
            }
            Map existCostObjectMap = new HashMap(16);
            if (configRuleMappingMap != null && !CadEmptyUtils.isEmpty(configRuleMappingMap)) {
                String costObjectFields = String.join((CharSequence)",", configRuleMappingMap.keySet());
                existCostObjectMap = CostObjectHelper.getExistCostObjectMap((Long)orgId, costCenterIds, (String)costObjectFields, (String)appNum);
            }
            Map<DynamicObject, DynamicObject> srcAndTargetBillsMap = configSrcAndTargetBill.getValue();
            if (report != null) {
                report.logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u3010%1$s\u3011\uff0c\u67e5\u8be2\u3010%2$s\u3011", (String)"MfgFeeImportDataConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number"), config.getString("sourcebill.name")));
                report.logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u3010%s\u3011\u6761\u6570\u636e", (String)"MfgFeeImportDataConfigAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), srcAndTargetBillsMap.size()));
            }
            HashSet<String> tempDimensionKeySet = new HashSet<String>(16);
            StringBuilder tipTag = new StringBuilder();
            for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBills : srcAndTargetBillsMap.entrySet()) {
                long costCenterId;
                DynamicObject srcBill = srcAndTargetBills.getKey();
                DynamicObject mfgFeeBill = srcAndTargetBills.getValue();
                long costAccountId = mfgFeeBill.getLong("costaccount");
                String srcBillType = mfgFeeBill.getString("srcbilltype");
                costAccountBillTypeMap.computeIfAbsent(costAccountId, s -> new HashSet(16)).add(srcBillType);
                Object costCenter = mfgFeeBill.get("costcenter");
                if (costCenter instanceof Long) {
                    costCenterId = (Long)costCenter;
                } else {
                    DynamicObject dynamicObject = mfgFeeBill.getDynamicObject("costcenter");
                    if (dynamicObject == null) {
                        if (report != null) {
                            report.logErrorMsg(srcBill.getString("billno").concat("@").concat(this.getEntrySeq(srcBill)).concat("@").concat(srcBill.getString("billtype")), ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e3a\u7a7a", (String)"MfgFeeImportDataConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        }
                        logger.info("\u6210\u672c\u4e2d\u5fc3\u4e3a\u7a7a,\u6e90\u5355\u5355\u53f7:{}", (Object)mfgFeeBill.getString("srcbillnum"));
                        continue;
                    }
                    costCenterId = dynamicObject.getLong("id");
                }
                if (!allCostCenterIds.contains(costCenterId) && report != null) {
                    if (enableMulFactory) {
                        report.logErrorMsg(srcBill.getString("billno").concat("@").concat(this.getEntrySeq(srcBill)).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u3010%1$s\u3011\u884c\u53f7\u3010%2$s\u3011\uff0c\u6210\u672c\u4e2d\u5fc3\u672a\u8bbe\u7f6e\u3010\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u8868\u3011", (String)"MfgFeeImportDataConfigAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), this.getEntrySeq(srcBill)));
                        continue;
                    }
                    report.logErrorMsg(srcBill.getString("billno").concat("@").concat(this.getEntrySeq(srcBill)).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u3010%1$s\u3011\u884c\u53f7\u3010%2$s\u3011\uff0c\u6210\u672c\u4e2d\u5fc3\u4e0d\u5c5e\u4e8e\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7", (String)"MfgFeeImportDataConfigAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), this.getEntrySeq(srcBill)));
                    continue;
                }
                long periodId = costAccountPeriodMap.get(costAccountId);
                long expenseItemId = mfgFeeBill.getLong("expenseitem");
                long sourceBillId = mfgFeeBill.getLong("srcbillid");
                long sourceBillEntryId = 0L;
                String vouCherEntryId = "";
                if (!"cad_planfeebill".equals(this.getMfgFeeContext().getTargetEntity())) {
                    sourceBillEntryId = mfgFeeBill.getLong("srcbillentryid");
                    vouCherEntryId = mfgFeeBill.getString("voucherentry");
                }
                String mergeBillKey = "";
                if ("cad_mfgfeebill".equals(this.getMfgFeeContext().getTargetEntity())) {
                    mergeBillKey = String.format("%s@%s@%s@%s@%s", costAccountId, sourceBill, sourceBillId, sourceBillEntryId, vouCherEntryId);
                    if (costAccountVouCherIdSet.contains(String.valueOf(costAccountId).concat("@").concat(vouCherEntryId))) {
                        Map existBillDateMap = (Map)existMfgBillDateMap.get(vouCherEntryId);
                        if (srcBill.containsProperty("auditdate") && srcBill.get("auditdate") != null && !CadEmptyUtils.isEmpty((Map)existBillDateMap) && srcBill.getDate("auditdate").getTime() > ((Date)existBillDateMap.values().iterator().next()).getTime()) {
                            logger.info("\u5ba1\u6838\u65f6\u95f4\u53d1\u751f\u6539\u53d8\uff0c\u9700\u8981\u91cd\u65b0\u66f4\u65b0\u51ed\u8bc1 ==>{}", (Object)vouCherEntryId);
                        } else {
                            needDeleteMfgBillIds.remove(mergeBillKey);
                            logger.info("\u6210\u672c\u8d26\u7c3f{}\u4e0b\u51ed\u8bc1:{} \u5df2\u5f15\u5165\uff0c\u4e0d\u91cd\u590d\u5f15\u5165", (Object)costAccountId, (Object)vouCherEntryId);
                            tipTag.append(String.format(ResManager.loadKDString((String)"\u6e90\u5355\u3010%1$s\u3011\u884c\u53f7\u3010%2$s\u3011\u5df2\u5f15\u5165\uff0c\u4e0d\u91cd\u590d\u5f15\u5165\u3002", (String)"MfgFeeImportDataConfigAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), this.getEntrySeq(srcBill)));
                            continue;
                        }
                    }
                    if (!isAll && srcBill.containsProperty("assgrpValue")) {
                        boolean filterAssgrp;
                        String assgrpValue = srcBill.getString("assgrpValue");
                        LinkedHashMap vAssgrpValueMap = new LinkedHashMap();
                        if (!CadEmptyUtils.isEmpty((String)assgrpValue)) {
                            vAssgrpValueMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)assgrpValue, Map.class);
                        }
                        if (filterAssgrp = MfgfeeBillImportHelper.isFilterAssgrp(vAssgrpValueMap, assgrpMap, assgrpConditionMap)) {
                            logger.info("\u51ed\u8bc1:{} \u6838\u7b97\u7ef4\u5ea6\u4e0d\u5339\u914d\u5f52\u96c6\u65b9\u6848\u6838\u7b97\u7ef4\u5ea6\u53d6\u503c\u6761\u4ef6\uff0c\u4e0d\u5f15\u5165", (Object)vouCherEntryId);
                            tipTag.append(String.format(ResManager.loadKDString((String)"\u6e90\u5355\u3010%1$s\u3011\u884c\u53f7\u3010%2$s\u3011\u6838\u7b97\u7ef4\u5ea6\u4e0d\u5339\u914d\u5f52\u96c6\u65b9\u6848\u6838\u7b97\u7ef4\u5ea6\u53d6\u503c\u6761\u4ef6\uff0c\u4e0d\u5f15\u5165\u3002", (String)"MfgFeeImportDataConfigAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), this.getEntrySeq(srcBill)));
                            continue;
                        }
                    }
                } else if ("cad_planfeebill".equals(this.getMfgFeeContext().getTargetEntity())) {
                    mergeBillKey = String.format("%s@%s@%s@%s@%s@%s", costAccountId, periodId, costCenterId, sourceBill, expenseItemId, sourceBillId);
                }
                String srcStr = CostObjectHelper.getCostObjectHashCodeBySrcBill((DynamicObject)srcBill, configRuleMappingMap);
                Map matInfoList = (Map)existCostObjectMap.get(String.valueOf(orgId).concat(String.valueOf(costCenterId)));
                DynamicObject costObject = null;
                if (mfgFeeBill.get("costobject") == null) {
                    costObject = matInfoList == null ? null : (DynamicObject)matInfoList.get(srcStr);
                } else {
                    Object mfgCostObject = mfgFeeBill.get("costobject");
                    if (mfgCostObject instanceof DynamicObject) {
                        costObject = (DynamicObject)mfgCostObject;
                    } else if (mfgCostObject instanceof Long) {
                        costObject = BusinessDataServiceHelper.loadSingleFromCache((Object)mfgCostObject, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costobject"));
                    }
                }
                if (costObject != null) {
                    mfgFeeBill.set("costobject", (Object)costObject);
                    long costObjectId = costObject.getLong("id");
                    mfgFeeBill.set("costobject_id", (Object)costObjectId);
                }
                if (dimensionKeySet.contains(mergeBillKey)) {
                    logger.info("\u5f52\u96c6\u914d\u7f6e\u5355:{} \u5bf9\u5e94\u7684\u6e90\u5355\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u914d\u7f6e\u5355\u5f15\u5165\uff0c\u4e0d\u91cd\u590d\u5f15\u5165\uff0c\u5f15\u5165\u7ef4\u5ea6:{}", (Object)config.getString("id"), (Object)mergeBillKey);
                    tipTag.append(String.format(ResManager.loadKDString((String)"\u6e90\u5355\u3010%1$s\u3011\u884c\u53f7\u3010%2$s\u3011\u5df2\u5f15\u5165\uff0c\u4e0d\u91cd\u590d\u5f15\u5165\u3002", (String)"MfgFeeImportDataConfigAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), this.getEntrySeq(srcBill)));
                    continue;
                }
                if (CadEmptyUtils.isEmpty((Long)costCenterId) && report != null) {
                    report.logErrorMsg(srcBill.getString("billno").concat("@").concat(this.getEntrySeq(srcBill)).concat("@").concat(srcBill.getString("billtype")), ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e3a\u7a7a", (String)"MfgFeeImportDataConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    logger.info("\u6210\u672c\u4e2d\u5fc3\u4e3a\u7a7a,\u6e90\u5355\u5355\u53f7:{}", (Object)mfgFeeBill.getString("srcbillnum"));
                    continue;
                }
                if (CadEmptyUtils.isEmpty((Long)expenseItemId) && report != null) {
                    report.logErrorMsg(srcBill.getString("billno").concat("@").concat(this.getEntrySeq(srcBill)).concat("@").concat(srcBill.getString("billtype")), ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u4e3a\u7a7a", (String)"MfgFeeImportDataConfigAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    logger.info("\u8d39\u7528\u9879\u76ee\u4e3a\u7a7a,\u6e90\u5355\u5355\u53f7:{}", (Object)mfgFeeBill.getString("srcbillnum"));
                    continue;
                }
                Map<String, String> collConfigMapping = collConfigMappingMap.get(config.getLong("id"));
                HashSet<String> targetFieldSet = CadEmptyUtils.isEmpty(collConfigMapping) ? new HashSet(16) : collConfigMapping.keySet();
                DynamicObject mfgBill = this.createBills(costCenterId, mergeBillKey, targetFieldSet, existMfgMap, costCenterDyMap, mfgFeeBill, srcBill, tipTag, needDeleteMfgBillIds, this.getMfgFeeContext().getTargetEntity());
                if (mfgBill == null) continue;
                mfgBill.set("org_id", (Object)orgId);
                mfgBill.set("costaccount_id", (Object)costAccountId);
                mfgBill.set("period_id", (Object)periodId);
                mfgBill.set("currency_id", (Object)costAccountCurrencyMap.get(costAccountId));
                mfgBill.set("expenseitem_id", (Object)expenseItemId);
                mfgBill.set("srcsys", srcSysMap.get(sourceBill));
                if (!"cad_planfeebill".equals(this.getMfgFeeContext().getTargetEntity())) {
                    DynamicObjectCollection mulSrcSys = mfgBill.getDynamicObjectCollection("mulsrcsys");
                    DynamicObject srcSys = mulSrcSys.addNew();
                    srcSys.set("fbasedataid", srcSysMap.get(sourceBill));
                }
                saveMfgFeeBillList.add(mfgBill);
                ++collectMfgBillSize;
                saveMfgFeeBillsMap.computeIfAbsent(mergeBillKey, s -> new ArrayList()).add(mfgFeeBill);
                tempDimensionKeySet.add(mergeBillKey);
            }
            if (report != null) {
                report.logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u3010%s\u3011\uff0c\u5904\u7406\u6e90\u5355", (String)"MfgFeeImportDataConfigAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                report.logCheckDesc(String.format(ResManager.loadKDString((String)"\u751f\u6210\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u3010%s\u3011\u6761\u6570\u636e", (String)"MfgFeeImportDataConfigAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), collectMfgBillSize));
                if (!CadEmptyUtils.isEmpty((String)tipTag.toString())) {
                    report.logTip("", tipTag.toString());
                }
            }
            dimensionKeySet.addAll(tempDimensionKeySet);
        }
        if (!CadEmptyUtils.isEmpty(needDeleteMfgBillIds)) {
            if (report != null) {
                report.logReportDetail(ResManager.loadKDString((String)"\u5220\u9664\u6e90\u5355\u4e0d\u5728\u672c\u6b21\u5f52\u96c6\u8303\u56f4\u5185\u7684\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u636e", (String)"MfgFeeImportDataConfigAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]));
                report.logCheckDesc(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u3010%s\u3011\u6761\u6570\u636e", (String)"MfgFeeImportDataConfigAction_11", (String)"macc-cad-mservice", (Object[])new Object[0]), needDeleteMfgBillIds.size()));
            }
            this.getMfgFeeContext().getDeleteMfgBillIds().addAll(needDeleteMfgBillIds.values());
        }
        this.getMfgFeeContext().getMfgFeeBills().addAll(saveMfgFeeBillList);
    }

    private DynamicObject createBills(Long costCenterId, String mergeKey, Set<String> targetFieldSet, Map<String, DynamicObject> existMfgMap, Map<Long, DynamicObject> costCenterDyMap, DynamicObject saveMfgFeeBill, DynamicObject srcBill, StringBuilder tipTag, Map<String, Long> needDeleteMfgBillIds, String targetEntity) {
        String orgDuty;
        MfgFeeImportReport report = this.getMfgFeeContext().getReport();
        if (saveMfgFeeBill.get("totalamount") == null || saveMfgFeeBill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) == 0) {
            report.logErrorMsg(srcBill.getString("billno").concat("@").concat(this.getEntrySeq(srcBill)).concat("@").concat(srcBill.getString("billtype")), ResManager.loadKDString((String)"\u8d39\u7528\u91d1\u989d\u4e3a\u96f6", (String)"MfgFeeImportDataConfigAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]));
            return null;
        }
        String sourceBillNum = "";
        if ("cad_mfgfeebill".equals(targetEntity)) {
            sourceBillNum = saveMfgFeeBill.getString("srcbillnum");
        }
        boolean isNeedChange = true;
        if (existMfgMap.containsKey(mergeKey)) {
            DynamicObject existMfgBill = existMfgMap.get(mergeKey);
            isNeedChange = false;
            for (String fieldKey : targetFieldSet) {
                if (saveMfgFeeBill.get(fieldKey) instanceof DynamicObject) {
                    if (existMfgBill.getLong(fieldKey) == saveMfgFeeBill.getDynamicObject(fieldKey).getLong("id")) continue;
                    isNeedChange = true;
                    break;
                }
                if (saveMfgFeeBill.get(fieldKey) instanceof BigDecimal) {
                    if (existMfgBill.getBigDecimal(fieldKey) == null || existMfgBill.getBigDecimal(fieldKey).compareTo(saveMfgFeeBill.getBigDecimal(fieldKey)) == 0) continue;
                    isNeedChange = true;
                    break;
                }
                if (Objects.equals(existMfgBill.get(fieldKey), saveMfgFeeBill.get(fieldKey))) continue;
                isNeedChange = true;
                break;
            }
        }
        if (!isNeedChange) {
            needDeleteMfgBillIds.remove(mergeKey);
            logger.info("\u6e90\u5355\u5f15\u5165\u6570\u636e\u672a\u53d1\u751f\u6539\u53d8\uff0c\u65e0\u9700\u91cd\u65b0\u5f15\u5165\uff0c\u5f15\u5165\u7ef4\u5ea6:{}", (Object)mergeKey);
            tipTag.append(String.format(ResManager.loadKDString((String)"\u6e90\u5355\u3010%1$s\u3011\u884c\u53f7\u3010%2$s\u3011\u5f15\u5165\u6570\u636e\u672a\u53d1\u751f\u6539\u53d8\uff0c\u4e0d\u91cd\u590d\u5f15\u5165\u3002", (String)"MfgFeeImportDataConfigAction_8", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), this.getEntrySeq(srcBill)));
            return null;
        }
        if ("cad_mfgfeebill".equals(targetEntity)) {
            saveMfgFeeBill.set("srcbillnum", (Object)sourceBillNum);
        }
        saveMfgFeeBill.set("srcbillid", (Object)saveMfgFeeBill.getString("srcbillid"));
        saveMfgFeeBill.set("totalamount", (Object)saveMfgFeeBill.getBigDecimal("totalamount"));
        DynamicObject costCenter = costCenterDyMap.get(costCenterId);
        saveMfgFeeBill.set("costcenter", (Object)costCenter);
        String string = orgDuty = CadEmptyUtils.isEmpty((DynamicObject)costCenter) ? "" : costCenter.getString("orgduty.number");
        if ("4".equals(orgDuty)) {
            saveMfgFeeBill.set("allocmold", (Object)"C");
        } else if ("5".equals(orgDuty)) {
            saveMfgFeeBill.set("allocmold", (Object)"B");
        } else {
            saveMfgFeeBill.set("allocmold", (Object)"A");
        }
        return saveMfgFeeBill;
    }

    private String getEntrySeq(DynamicObject srcBill) {
        if (srcBill == null || !srcBill.containsProperty("entryseq")) {
            return "";
        }
        return srcBill.getString("entryseq");
    }
}

