/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.plannedoutput;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.plannedoutput.IPlannedAction;
import kd.macc.cad.mservice.plannedoutput.PlannedContext;

public abstract class AbstractPlannedAction
implements IPlannedAction {
    private PlannedContext plannedContext;

    protected abstract void doExecute();

    @Override
    public void execute() {
        if (this.plannedContext.isContinueExecute()) {
            this.doExecute();
        }
    }

    public PlannedContext getPlannedContext() {
        return this.plannedContext;
    }

    @Override
    public void setContext(PlannedContext plannedContext) {
        this.plannedContext = plannedContext;
    }

    protected Map<String, List<Long>> getInnerSys(Long accountOrg, List<Long> costCenters, String appNum) {
        ArrayList costCentersCopy = Lists.newArrayList(costCenters);
        HashMap billCostCentersMap = Maps.newHashMapWithExpectedSize((int)8);
        HashMap ccRangeMap = Maps.newHashMapWithExpectedSize((int)8);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter orgQf = new QFilter("accountorg", "=", (Object)accountOrg);
        if (!CadEmptyUtils.isEmpty((Long)accountOrg)) {
            filters.add(orgQf);
        }
        if (!CadEmptyUtils.isEmpty((List)costCentersCopy)) {
            filters.add(new QFilter("costcenter", "in", (Object)costCentersCopy));
        }
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        DynamicObjectCollection sysParams = QueryServiceHelper.query((String)"cad_sysparam", (String)"costcenter,plancollecttype,plancollectrange", (QFilter[])filters.toArray(new QFilter[0]));
        filters.clear();
        filters.add(orgQf);
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        filters.add(new QFilter("costcenter", "=", (Object)0L));
        DynamicObject orgSysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"costcenter,plancollecttype,plancollectrange", (QFilter[])filters.toArray(new QFilter[0]));
        if (sysParams != null && sysParams.size() > 0) {
            for (DynamicObject sysParam : sysParams) {
                String[] planCollectRange = sysParam.getString("plancollectrange");
                long costCenter = sysParam.getLong("costcenter");
                if (kd.bos.login.utils.StringUtils.isNotBlank((String)planCollectRange)) {
                    String[] ranges;
                    ccRangeMap.put(costCenter, planCollectRange);
                    for (String range : ranges = planCollectRange.split(",")) {
                        billCostCentersMap.computeIfAbsent(range, cc -> new ArrayList()).add(costCenter);
                    }
                    costCentersCopy.remove(costCenter);
                    continue;
                }
                ccRangeMap.put(costCenter, planCollectRange);
                billCostCentersMap.computeIfAbsent(planCollectRange, cc -> new ArrayList()).add(costCenter);
                costCentersCopy.remove(costCenter);
            }
            if (!costCentersCopy.isEmpty() && orgSysParam != null) {
                String planCollectRange = orgSysParam.getString("plancollectrange");
                if (kd.bos.login.utils.StringUtils.isNotBlank((String)planCollectRange)) {
                    String[] ranges = planCollectRange.split(",");
                    for (String range : ranges) {
                        billCostCentersMap.computeIfAbsent(range, cc -> new ArrayList()).addAll(costCentersCopy);
                    }
                    for (Long costCenter : costCentersCopy) {
                        ccRangeMap.put(costCenter, planCollectRange);
                    }
                } else {
                    for (Long costCenter : costCentersCopy) {
                        ccRangeMap.put(costCenter, planCollectRange);
                    }
                }
            }
        } else if (!costCentersCopy.isEmpty() && orgSysParam != null) {
            String planCollectRange = orgSysParam.getString("plancollectrange");
            if (kd.bos.login.utils.StringUtils.isNotBlank((String)planCollectRange)) {
                String[] ranges = planCollectRange.split(",");
                for (String range : ranges) {
                    billCostCentersMap.computeIfAbsent(range, cc -> new ArrayList()).addAll(costCentersCopy);
                }
                for (Long costCenter : costCentersCopy) {
                    ccRangeMap.put(costCenter, planCollectRange);
                }
            } else {
                billCostCentersMap.computeIfAbsent(planCollectRange, cc -> new ArrayList()).addAll(costCentersCopy);
                for (Long costCenter : costCentersCopy) {
                    ccRangeMap.put(costCenter, planCollectRange);
                }
            }
        }
        this.getPlannedContext().getCollectReport().getCcRangeMap().putAll(ccRangeMap);
        return billCostCentersMap;
    }

    protected void refreshProgress(String opContent, int nowComplete, int total, Boolean isAddNum) {
        PlannedContext plannedContext = this.getPlannedContext();
        String progressId = plannedContext.getPlannedArgs().getProgressId();
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (isAddNum.booleanValue()) {
            Integer complete = paramDto.getComplete();
            paramDto.setComplete(Integer.valueOf(complete + nowComplete));
        } else {
            paramDto.setComplete(Integer.valueOf(nowComplete));
        }
        if (!CadEmptyUtils.isEmpty((Integer)total)) {
            paramDto.setTotal(Integer.valueOf(total));
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"AbstractPlannedAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        paramDto.setDurationTimes(Integer.valueOf(0));
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam((String)progressId, (ProgressParamDto)paramDto);
        this.setReportPressAndDur(progressId);
    }

    private void setReportPressAndDur(String progressId) {
        Date coldate;
        int progress = this.getProgress(progressId);
        Long id = this.getPlannedContext().getCollectReport().getId();
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_colreport", (String)"coldate", (QFilter[])qFilter.toArray());
        String duration = "";
        if (dynamicObject != null && (coldate = dynamicObject.getDate("coldate")) != null) {
            double time = (double)(System.currentTimeMillis() - coldate.getTime()) / 1000.0;
            if (0.0 < time && time < 1.0) {
                time = 1.0;
            }
            duration = String.valueOf((int)time);
        }
        try (TXHandle handle = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cad_colreport set fprogress=" + progress + ",fduration=" + duration + " where fid =" + id));
        }
    }

    public int getProgress(String progressId) {
        if (StringUtils.isEmpty((CharSequence)progressId)) {
            return 0;
        }
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return 0;
        }
        if (CadEmptyUtils.isEmpty((Integer)paramDto.getTotal()) || CadEmptyUtils.isEmpty((Integer)paramDto.getComplete())) {
            return 0;
        }
        return (int)((double)paramDto.getComplete().intValue() / (double)paramDto.getTotal().intValue() * 100.0);
    }
}

