/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.plannedoutput;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.dto.MftOrderLog;
import kd.macc.cad.common.enums.CollectStatus;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.plannedoutput.BaseImportDataAction;
import kd.macc.cad.mservice.plannedoutput.PlannedArgs;

@Deprecated
public class AcaPlannedImportDataForPZAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(AcaPlannedImportDataForPZAction.class);
    private static final String[] RANGES = new String[]{"SCGD", "WWGD", "WGRK"};

    @Override
    protected void doExecute() {
        Map<Long, Set<Long>> acctOrgCostCentersMap = this.getPlannedContext().getAcctOrgCostCentersMap();
        PlannedArgs plannedArgs = this.getPlannedContext().getPlannedArgs();
        String appNum = plannedArgs.getAppNum();
        List<Long> manuOrgs = plannedArgs.getManuOrgs();
        List<Long> mftOrderEntryIds = plannedArgs.getMftOrderEntryIds();
        Map<String, Object> collectParamMap = plannedArgs.getCollectParamMap();
        acctOrgCostCentersMap.forEach((accountOrgId, costCenters) -> {
            String key = accountOrgId + CostObjectEnum.BIZTYPE_PZ.getValue();
            List<Long> acctOrgPZCostCenters = this.getPlannedContext().getAcctOrgCalmethodCostCenters().get(key);
            if (CadEmptyUtils.isEmpty(acctOrgPZCostCenters)) {
                logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u54c1\u79cd\u6cd5\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u7ed3\u675f\uff01", accountOrgId);
                return;
            }
            this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u83b7\u53d6\u54c1\u79cd\u6cd5\u6210\u672c\u4e2d\u5fc3", (String)"AcaPlannedImportDataForPZAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u54c1\u79cd\u6cd5\u6210\u672c\u4e2d\u5fc3%s\u4e2a\u3002", (String)"AcaPlannedImportDataForPZAction_30", (String)"macc-cad-mservice", (Object[])new Object[0]), acctOrgPZCostCenters.size()));
            this.getPlannedContext().getCollectReport().setPzCostCenters(acctOrgPZCostCenters);
            Map<String, List<Long>> rangeCostCentersMap = this.getInnerSys((Long)accountOrgId, acctOrgPZCostCenters, appNum);
            if (rangeCostCentersMap == null || rangeCostCentersMap.size() == 0) {
                this.getPlannedContext().getCollectReport().logStatusChange(CollectStatus.REMIND, ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u8303\u56f4\uff0c\u54c1\u79cd\u6cd5\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u7ed3\u675f\u3002", (String)"AcaPlannedImportDataForPZAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
                logger.info("\u6838\u7b97\u7ec4\u7ec7{}\uff0c\u6210\u672c\u4e2d\u5fc3{}\uff0c\u672a\u8bbe\u7f6e\u6210\u672c\u5f52\u96c6\u53c2\u6570\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u8303\u56f4", accountOrgId, acctOrgPZCostCenters);
                return;
            }
            String[] ranges = RANGES;
            logger.info("\u54c1\u79cd\u6cd5-\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5f00\u59cb\u3002");
            block10: for (String range : ranges) {
                acctOrgPZCostCenters = rangeCostCentersMap.get(range);
                if (acctOrgPZCostCenters == null || acctOrgPZCostCenters.isEmpty()) continue;
                switch (range) {
                    case "SCGD": {
                        this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5-\u83b7\u53d6\u751f\u4ea7\u5de5\u5355", (String)"AcaPlannedImportDataForPZAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        DynamicObjectCollection manuBills = this.getAllManuBill((Long)accountOrgId, acctOrgPZCostCenters, manuOrgs, appNum, mftOrderEntryIds, collectParamMap);
                        this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5\uff1a\u83b7\u53d6\u751f\u4ea7\u5de5\u5355%s\u6761\u3002", (String)"AcaPlannedImportDataForPZAction_31", (String)"macc-cad-mservice", (Object[])new Object[0]), manuBills.size()));
                        Map manuEntryIdAndWorkCenterMap = CostObjectHelper.getManuEntryIdAndWorkCenterMap((DynamicObjectCollection)manuBills);
                        this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5-\u6839\u636e\u751f\u4ea7\u5de5\u5355\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6", (String)"AcaPlannedImportDataForPZAction_8", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        int mftCount = this.collectImportByPage((Long)accountOrgId, (Set<Long>)new HashSet<Long>(acctOrgPZCostCenters), manuOrgs, manuBills, manuEntryIdAndWorkCenterMap, appNum);
                        this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5\uff1a\u6839\u636e\u751f\u4ea7\u5de5\u5355\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6%s\u6761\u3002", (String)"AcaPlannedImportDataForPZAction_32", (String)"macc-cad-mservice", (Object[])new Object[0]), mftCount));
                        continue block10;
                    }
                    case "WWGD": {
                        this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5-\u83b7\u53d6\u59d4\u5916\u5de5\u5355", (String)"AcaPlannedImportDataForPZAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        DynamicObjectCollection outSourceManuBills = this.getAllOutSourceManuBill((Long)accountOrgId, acctOrgPZCostCenters, manuOrgs, appNum, mftOrderEntryIds, collectParamMap);
                        this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5\uff1a\u83b7\u53d6\u59d4\u5916\u5de5\u5355%s\u6761\u3002", (String)"AcaPlannedImportDataForPZAction_33", (String)"macc-cad-mservice", (Object[])new Object[0]), outSourceManuBills.size()));
                        Map manuEntryIdAndWorkCenterMap = CostObjectHelper.getManuEntryIdAndWorkCenterMap((DynamicObjectCollection)outSourceManuBills);
                        this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5-\u6839\u636e\u59d4\u5916\u5de5\u5355\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6", (String)"AcaPlannedImportDataForPZAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        int outCount = this.collectImportByPage((Long)accountOrgId, (Set<Long>)new HashSet<Long>(acctOrgPZCostCenters), manuOrgs, outSourceManuBills, manuEntryIdAndWorkCenterMap, appNum);
                        this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5\uff1a\u6839\u636e\u59d4\u5916\u5de5\u5355\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6%s\u6761\u3002", (String)"AcaPlannedImportDataForPZAction_34", (String)"macc-cad-mservice", (Object[])new Object[0]), outCount));
                        continue block10;
                    }
                    case "WGRK": {
                        this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5-\u83b7\u53d6\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355", (String)"AcaPlannedImportDataForPZAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        DynamicObjectCollection factnedOutPutBills = this.getAllFactnedOutPutBill((Long)accountOrgId, acctOrgPZCostCenters, manuOrgs, appNum);
                        this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5\uff1a\u83b7\u53d6\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355%s\u6761\u3002", (String)"AcaPlannedImportDataForPZAction_35", (String)"macc-cad-mservice", (Object[])new Object[0]), factnedOutPutBills.size()));
                        HashSet<Long> costCenterIdSet = new HashSet<Long>(acctOrgPZCostCenters);
                        this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5-\u6839\u636e\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6", (String)"AcaPlannedImportDataForPZAction_20", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        int wgCount = this.collectImportByFactnedBills((Long)accountOrgId, (Set<Long>)costCenterIdSet, manuOrgs, factnedOutPutBills, appNum);
                        this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5\uff1a\u6839\u636e\u59d4\u5916\u5de5\u5355\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6%s\u6761\u3002", (String)"AcaPlannedImportDataForPZAction_34", (String)"macc-cad-mservice", (Object[])new Object[0]), wgCount));
                        continue block10;
                    }
                }
            }
            logger.info("\u54c1\u79cd\u6cd5-\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u7ed3\u675f\u3002");
        });
    }

    private int collectImportByPage(Long accountOrg, Set<Long> costCenters, List<Long> manuOrgs, DynamicObjectCollection manuBills, Map<Long, Long> manuEntryIdAndWorkCenterMap, String appNum) {
        Map<String, DynamicObject> matCost;
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u83b7\u53d6\u5230\u751f\u4ea7\u5de5\u5355:{}", manuBills == null ? null : manuBills.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toList()));
        if (manuBills == null || CadEmptyUtils.isEmpty((DynamicObjectCollection)manuBills)) {
            return 0;
        }
        List<Map<String, Date>> importScopeDate = this.getPlannedContext().getOrgImportScopeDate().get(accountOrg);
        Map costInfo = CostObjectHelper.getCenterByManuBill((DynamicObject[])((DynamicObject[])manuBills.toArray((Object[])new DynamicObject[0])), new ArrayList<Long>(costCenters), manuEntryIdAndWorkCenterMap, importScopeDate);
        List<DynamicObject> plannedBill = this.getPlannedBill(accountOrg, costCenters, manuOrgs, (List<DynamicObject>)manuBills, costInfo, matCost = this.getCostObjectMapByManuBillMaterial(accountOrg, costCenters, (List<DynamicObject>)manuBills), manuEntryIdAndWorkCenterMap, appNum);
        if (plannedBill == null || plannedBill.isEmpty()) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u54c1\u79cd\u6cd5\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\u6ca1\u6709\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u7ed3\u675f\uff01", (Object)accountOrg);
            return 0;
        }
        this.getPlannedContext().getCreatePlanDataByLogMap().clear();
        this.getPlannedContext().getPlanOutPutBills().addAll(plannedBill);
        return plannedBill.size();
    }

    private List<DynamicObject> getPlannedBill(Long acctOrg, Set<Long> costCenters, List<Long> manuOrgs, List<DynamicObject> manuBill, Map<String, List<DynamicObject>> costInfo, Map<String, DynamicObject> matCost, Map<Long, Long> manuEntryIdAndWorkCenterMap, String appNum) {
        HashMap<String, DynamicObject> changePlannedMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> changeStatusMap = new HashMap<String, DynamicObject>(16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date date = TimeServiceHelper.now();
        ArrayList<DynamicObject> plannedBill = new ArrayList<DynamicObject>(10);
        ArrayList<String> existBillNos = new ArrayList<String>(10);
        Set<String> existsManu = this.dealExistsManu(acctOrg, costCenters, manuOrgs, manuBill, changePlannedMap, changeStatusMap, existBillNos, appNum);
        logger.info("\u5df2\u7ecf\u5b58\u5728\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", existsManu);
        List<DynamicObject> planOutPutBills = this.getPlannedContext().getPlanOutPutBills();
        Set willSavePlanBillNoSet = planOutPutBills.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
        Map<String, Set<MftOrderLog>> createPlanDataByLogMap = this.getPlannedContext().getCreatePlanDataByLogMap();
        HashSet<Long> materialIds = new HashSet<Long>(10);
        for (DynamicObject manu : manuBill) {
            materialIds.add(manu.getLong("matmasterid"));
        }
        Map materialMap = CostObjectHelper.getAssistMap(materialIds, (Long)acctOrg);
        int updNum = 0;
        int addNum = 0;
        for (DynamicObject manu : manuBill) {
            Date bizDate = manu.getDate("transmittime");
            boolean isOutSource = "WPB".equals(manu.getString("sotype"));
            DynamicObject centerInfo = AcaPlannedImportDataForPZAction.getCostCenterBySrcBillDate(bizDate, costInfo.get(manu.getLong("org") + "@" + "bos_org"));
            boolean isprocedure = manu.getBoolean("isprocedure");
            if (centerInfo == null && !isOutSource) {
                centerInfo = isprocedure ? AcaPlannedImportDataForPZAction.getCostCenterBySrcBillDate(bizDate, costInfo.get(manuEntryIdAndWorkCenterMap.get(manu.getLong("entryId")) + "@" + "mpdm_workcentre")) : AcaPlannedImportDataForPZAction.getCostCenterBySrcBillDate(bizDate, costInfo.get(manu.getLong("workcenter") + "@" + "mpdm_workcentre"));
            }
            if (centerInfo == null) {
                centerInfo = AcaPlannedImportDataForPZAction.getCostCenterBySrcBillDate(bizDate, costInfo.get(manu.getLong("producedept") + "@" + "bos_adminorg"));
            }
            if (centerInfo == null) {
                this.getPlannedContext().logErrorMsg(manu.getString("billno").concat("@").concat(manu.getString("seq")), String.format(ResManager.loadKDString((String)"\u5de5\u5355%1$s\u884c\u53f7%2$s\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"AcaPlannedImportDataForPZAction_43", (String)"macc-cad-mservice", (Object[])new Object[0]), manu.getString("billno"), manu.getString("seq")));
                logger.info("\u5de5\u5355{}\u884c\u53f7{}\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
                continue;
            }
            DynamicObject curCostObject = this.getCostObjectInfo(acctOrg, centerInfo.getLong("costcenter"), manu, matCost, materialMap);
            if (curCostObject == null) {
                this.getPlannedContext().logErrorMsg(manu.getString("billno").concat("@").concat(manu.getString("seq")), String.format(ResManager.loadKDString((String)"\u5de5\u5355\u201c%1$s\u201d\u884c\u53f7%2$s\u6ca1\u6709\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"AcaPlannedImportDataForPZAction_44", (String)"macc-cad-mservice", (Object[])new Object[0]), manu.getString("billno"), manu.getString("seq")));
                logger.info("\u5de5\u5355{}\u884c\u53f7{}\u6ca1\u6709\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
                continue;
            }
            String idAndEntryId = manu.getString("id") + "-" + manu.getString("entryid");
            boolean isNeedChangeData = changePlannedMap.containsKey(idAndEntryId);
            boolean isStatusChangeData = changeStatusMap.containsKey(idAndEntryId);
            DynamicObject plan = BusinessDataServiceHelper.newDynamicObject((String)"cad_plannedoutputbill");
            if ("A".equals(manu.getString("taskstatus"))) {
                this.getPlannedContext().logErrorMsg(manu.getString("billno").concat("@").concat(manu.getString("seq")), String.format(ResManager.loadKDString((String)"\u5de5\u5355\u201c%1$s\u201d\u884c\u53f7%2$s\u4efb\u52a1\u72b6\u6001\u4e3a\u672a\u5f00\u5de5\u72b6\u6001\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"AcaPlannedImportDataForPZAction_45", (String)"macc-cad-mservice", (Object[])new Object[0]), manu.getString("billno"), manu.getString("seq")));
                logger.info("\u5de5\u5355{}\u884c\u53f7{}\u7684\u4efb\u52a1\u72b6\u6001\u4e3a\u672a\u5f00\u5de5\u72b6\u6001\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
                continue;
            }
            Set<MftOrderLog> mftOrderLogs = createPlanDataByLogMap.get(idAndEntryId);
            if (mftOrderLogs != null) {
                for (MftOrderLog mftOrderLog : mftOrderLogs) {
                    String logKey = idAndEntryId + "-" + mftOrderLog.getLogId();
                    String billNo = manu.getString("billno").concat("-").concat(manu.getString("seq")).concat("-").concat(mftOrderLog.getBillNo());
                    if (billNo.length() > 255) {
                        billNo = billNo.substring(0, 255);
                    }
                    if (willSavePlanBillNoSet.contains(billNo)) {
                        this.getPlannedContext().logErrorMsg(manu.getString("billno").concat("@").concat(manu.getString("seq")), String.format(ResManager.loadKDString((String)"\u5de5\u5355\u201c%1$s\u201d\u884c\u53f7%2$s\u65e5\u5fd7id\u201c%3$s\u201d\u5df2\u5b58\u5728\u540c\u6279\u6b21\u5176\u4ed6\u6210\u672c\u4e2d\u5fc3\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u5355\u636e\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"AcaPlannedImportDataForPZAction_46", (String)"macc-cad-mservice", (Object[])new Object[0]), manu.getString("billno"), manu.getString("seq"), mftOrderLog.getLogId()));
                        logger.info("\u5de5\u5355{}\u884c\u53f7{}\u65e5\u5fd7id{}\u5df2\u5b58\u5728\u540c\u6279\u6b21\u5176\u4ed6\u6210\u672c\u4e2d\u5fc3\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u5355\u636e\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", new Object[]{manu.getString("billno"), manu.getString("seq"), mftOrderLog.getLogId()});
                        continue;
                    }
                    boolean existsLogKey = existsManu.contains(logKey);
                    if (existsLogKey && !isNeedChangeData && !isStatusChangeData) {
                        this.getPlannedContext().logErrorMsg(manu.getString("billno").concat("@").concat(manu.getString("seq")), String.format(ResManager.loadKDString((String)"\u5de5\u5355\u201c%1$s\u201d\u884c\u53f7%2$s\u65e5\u5fd7id\u201c%3$s\u201d\u5df2\u5b58\u5728\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"AcaPlannedImportDataForPZAction_47", (String)"macc-cad-mservice", (Object[])new Object[0]), manu.getString("billno"), manu.getString("seq"), mftOrderLog.getLogId()));
                        logger.info("\u5de5\u5355{}\u884c\u53f7{}\u65e5\u5fd7id{}\u5df2\u5b58\u5728\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", new Object[]{manu.getString("billno"), manu.getString("seq"), mftOrderLog.getLogId()});
                        continue;
                    }
                    DynamicObject logPlan = BusinessDataServiceHelper.newDynamicObject((String)"cad_plannedoutputbill");
                    if (!existsLogKey) {
                        ++addNum;
                        logPlan.set("id", (Object)0L);
                    } else {
                        ++updNum;
                        logPlan = (DynamicObject)changePlannedMap.get(logKey);
                    }
                    this.setValuePlanData(appNum, userId, date, manu, isOutSource, curCostObject, logPlan);
                    logPlan.set("billno", (Object)billNo);
                    logPlan.set("qty", (Object)mftOrderLog.getChangeQty());
                    BigDecimal totalinQty = logPlan.getBigDecimal("totalinqty") == null ? BigDecimal.ZERO : logPlan.getBigDecimal("totalinqty");
                    totalinQty = mftOrderLog.getChangeQty().subtract(totalinQty);
                    totalinQty = totalinQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalinQty;
                    logPlan.set("wipqty", (Object)totalinQty);
                    logPlan.set("fromlogid", (Object)mftOrderLog.getLogId());
                    logPlan.set("source", (Object)mftOrderLog.getSource());
                    String billtype = "";
                    if ("6".equals(mftOrderLog.getSource())) {
                        billtype = "pom_xmftorderlog";
                    } else if ("7".equals(mftOrderLog.getSource())) {
                        billtype = "om_xmftorderlog";
                    } else if ("8".equals(mftOrderLog.getSource())) {
                        billtype = "pom_mftorder_splitlog";
                    } else if ("9".equals(mftOrderLog.getSource())) {
                        billtype = "om_mftorder_splitog";
                    }
                    logPlan.set("srcbilltype", (Object)billtype);
                    logPlan.set("bizdate", (Object)mftOrderLog.getBizTime());
                    plannedBill.add(logPlan);
                }
            }
            if (existsManu.contains(idAndEntryId) && !isNeedChangeData && !isStatusChangeData) {
                logger.info("\u5de5\u5355{}\u884c\u53f7{}\u5df2\u5b58\u5728\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
                logger.info("\u5de5\u5355{}\u884c\u53f7{}\u5df2\u5b58\u5728\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
                continue;
            }
            String billNo = manu.getString("billno") + "-" + manu.getString("seq");
            if (!existsManu.contains(idAndEntryId) && existBillNos.contains(billNo)) {
                this.getPlannedContext().logErrorMsg(manu.getString("billno").concat("@").concat(manu.getString("seq")), String.format(ResManager.loadKDString((String)"\u5de5\u5355\u201c%1$s\u201d\u884c\u53f7%2$s\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"AcaPlannedImportDataForPZAction_48", (String)"macc-cad-mservice", (Object[])new Object[0]), manu.getString("billno"), manu.getString("seq")));
                logger.info("\u5de5\u5355{}\u884c\u53f7{}\u7684\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
                continue;
            }
            if (willSavePlanBillNoSet.contains(billNo)) {
                this.getPlannedContext().logErrorMsg(manu.getString("billno").concat("@").concat(manu.getString("seq")), String.format(ResManager.loadKDString((String)"\u5de5\u5355\u201c%1$s\u201d\u884c\u53f7%2$s\u5df2\u5b58\u5728\u540c\u6279\u6b21\u5176\u4ed6\u6210\u672c\u4e2d\u5fc3\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u5355\u636e\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"AcaPlannedImportDataForPZAction_49", (String)"macc-cad-mservice", (Object[])new Object[0]), manu.getString("billno"), manu.getString("seq")));
                logger.info("\u5de5\u5355{}\u884c\u53f7{}\u5df2\u5b58\u5728\u540c\u6279\u6b21\u5176\u4ed6\u6210\u672c\u4e2d\u5fc3\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u5355\u636e\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
                continue;
            }
            if (!isNeedChangeData && !isStatusChangeData) {
                ++addNum;
                plan.set("id", (Object)0L);
            } else if (isNeedChangeData) {
                ++updNum;
                plan = (DynamicObject)changePlannedMap.get(idAndEntryId);
            } else {
                plan = (DynamicObject)changeStatusMap.get(idAndEntryId);
                if (this.checkPlanStatus(manu, curCostObject, plan)) continue;
                ++updNum;
            }
            this.setValuePlanData(appNum, userId, date, manu, isOutSource, curCostObject, plan);
            plannedBill.add(plan);
        }
        this.getPlannedContext().setAddNum(this.getPlannedContext().getAddNum() + addNum);
        this.getPlannedContext().setUpdateNum(this.getPlannedContext().getUpdateNum() + updNum);
        logger.info("\u65b0\u589e\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", (Object)plannedBill.size());
        return plannedBill;
    }

    private static DynamicObject getCostCenterBySrcBillDate(Date bizDate, List<DynamicObject> costCenterSourceList) {
        if (bizDate == null || CadEmptyUtils.isEmpty(costCenterSourceList)) {
            return null;
        }
        for (DynamicObject costCenterSource : costCenterSourceList) {
            if (costCenterSource.getDate("effectdate").getTime() > bizDate.getTime() || costCenterSource.getDate("expdate").getTime() <= bizDate.getTime()) continue;
            return costCenterSource;
        }
        return null;
    }

    private void setValuePlanData(String appNum, Long userId, Date date, DynamicObject manu, boolean isOutSource, DynamicObject curCostObject, DynamicObject plan) {
        plan.set("billno", (Object)manu.getString("billno").concat("-").concat(manu.getString("seq")));
        Date transmittime = manu.getDate("transmittime");
        plan.set("bizdate", (Object)transmittime);
        plan.set("srctransmittime", (Object)transmittime);
        plan.set("planneddate", (Object)manu.getDate("planendtime"));
        plan.set("appnum", (Object)appNum);
        plan.set("accountorg_id", (Object)curCostObject.getLong("org"));
        plan.set("costcenter_id", (Object)curCostObject.getLong("costcenter"));
        plan.set("manuorg_id", (Object)manu.getLong("org"));
        plan.set("creator", (Object)userId);
        plan.set("createtime", (Object)date);
        plan.set("billstatus", (Object)"C");
        plan.set("auditor", (Object)userId);
        plan.set("auditdate", (Object)date);
        if (plan.getBoolean("closestatu") && "C".equals(manu.getString("bizstatus"))) {
            plan.set("closedatetime", (Object)manu.getDate("closetime"));
        } else if ("C".equals(manu.getString("planstatus")) && "C".equals(manu.getString("bizstatus"))) {
            plan.set("closeuser", (Object)userId);
            plan.set("closedatetime", (Object)manu.getDate("closetime"));
            plan.set("closestyle", (Object)"0");
            plan.set("closestatu", (Object)"1");
        } else if ("C".equals(manu.getString("planstatus")) && !"C".equals(manu.getString("bizstatus"))) {
            plan.set("closeuser", (Object)0L);
            plan.set("closedatetime", null);
            plan.set("closestyle", (Object)" ");
            plan.set("closestatu", (Object)"0");
        }
        plan.set("source", (Object)(isOutSource ? "4" : "3"));
        plan.set("srcbilltype", (Object)(!isOutSource ? "pom_mftorder" : "om_mftorder"));
        plan.set("sourcebill", (Object)manu.getLong("id"));
        plan.set("sourcebillentry", (Object)manu.getLong("entryid"));
        plan.set("sourcebiztime", (Object)manu.getDate("transmittime"));
        plan.set("costobject_id", (Object)curCostObject.getLong("id"));
        plan.set("material_id", (Object)manu.getLong("matmasterid"));
        plan.set("baseunit", (Object)manu.getLong("unit"));
        plan.set("auxpty", (Object)curCostObject.getLong("auxpty"));
        plan.set("qty", (Object)(manu.getBigDecimal("qty") == null ? new BigDecimal(0) : manu.getBigDecimal("qty")));
        BigDecimal totalinQty = plan.getBigDecimal("totalinqty") == null ? BigDecimal.ZERO : plan.getBigDecimal("totalinqty");
        totalinQty = plan.getBigDecimal("qty").subtract(totalinQty);
        totalinQty = totalinQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalinQty;
        plan.set("wipqty", (Object)totalinQty);
    }

    @Override
    public boolean checkPlanStatus(DynamicObject manu, DynamicObject curCostObject, DynamicObject plan) {
        if (plan.get("closestatu") != null && plan.getBoolean("closestatu") && !"C".equals(manu.getString("bizstatus")) && CostObjectHelper.isSettlement((Long)curCostObject.getLong("id"))) {
            logger.info("\u5de5\u5355{}\u884c\u53f7{}\u7684\u5bf9\u5e94\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u5df2\u5173\u95ed,\u4f46\u5de5\u5355\u672a\u5173\uff0c\u6838\u7b97\u5bf9\u8c61\u5df2\u7ed3\u7b97\u4e0d\u518d\u5f15\u5165\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
            return true;
        }
        if (plan.get("closestatu") != null && plan.getBoolean("closestatu") && "C".equals(manu.getString("bizstatus")) && CostObjectHelper.isSettlement((Long)curCostObject.getLong("id"))) {
            logger.info("\u5de5\u5355{}\u884c\u53f7{}\u7684\u5bf9\u5e94\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u5df2\u5173\u95ed,\u5de5\u5355\u5173\u95ed\uff0c\u6838\u7b97\u5bf9\u8c61\u5df2\u7ed3\u7b97\u4e0d\u518d\u5f15\u5165\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
            return true;
        }
        return false;
    }

    protected DynamicObject getCostObjectInfo(Long org, Long costCenter, DynamicObject manu, Map<String, DynamicObject> costObjects, Map<Long, Boolean> materialMap) {
        if (CadEmptyUtils.isEmpty(costObjects)) {
            return null;
        }
        String materialId = manu.getString("matmasterid");
        Long version = 0L;
        String billtype = manu.getString("billtype");
        Long auxpty = CostObjectHelper.getEffectCostAuxptyNew((DynamicObject)CostObjectHelper.getMaterialById((Long)Long.parseLong(materialId)), (DynamicObject)CostObjectHelper.getAuxptyByManuBill((String)billtype, (Long)manu.getLong("entryId")), materialMap, (String)CostObjectEnum.BIZTYPE_PZ.getValue());
        boolean isenablematerialversion = manu.getBoolean("isenablematerialversion");
        if (isenablematerialversion) {
            version = manu.getLong("bomversion");
        }
        String key = org + "@" + costCenter + "@" + materialId + "@" + version + "@" + auxpty;
        return costObjects.get(key);
    }

    private Map<String, DynamicObject> getCostObjectMapByManuBillMaterial(Long accountOrg, Set<Long> costCenters, List<DynamicObject> manuBill) {
        HashMap<String, DynamicObject> costObjectMap = new HashMap<String, DynamicObject>();
        HashSet<Long> materialId = new HashSet<Long>(1000);
        for (DynamicObject manu : manuBill) {
            materialId.add(manu.getLong("matmasterid"));
        }
        if (CadEmptyUtils.isEmpty(materialId)) {
            return costObjectMap;
        }
        QFilter qfMat = new QFilter("material", "in", (Object)materialId.toArray());
        QFilter qfOrg = new QFilter("org", "=", (Object)accountOrg);
        QFilter qfCostenters = new QFilter("costcenter", "in", costCenters);
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        DynamicObjectCollection dyCostObject = QueryServiceHelper.query((String)"cad_costobject", (String)"id,srcbillnumber,srcbillrow,org,costcenter,material,bomversion,auxpty", (QFilter[])new QFilter[]{qfMat, qfOrg, qfCostenters, qfBillStatus});
        for (DynamicObject cost : dyCostObject) {
            String key = cost.getLong("org") + "@" + cost.getLong("costcenter") + "@" + cost.getLong("material") + "@" + cost.getLong("bomversion") + "@" + cost.getLong("auxpty");
            costObjectMap.put(key, cost);
        }
        return costObjectMap;
    }
}

