/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.plannedoutput;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.dto.MftOrderLog;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.plannedoutput.BaseImportDataAction;
import kd.macc.cad.mservice.plannedoutput.PlannedArgs;
import kd.macc.cad.mservice.plannedoutput.PlannedContext;

public class AcaPlannedImportDataForPZConfigAction
extends BaseImportDataAction {
    private Log logger = LogFactory.getLog(AcaPlannedImportDataForPZConfigAction.class);

    @Override
    protected void doExecute() {
        Map<Long, Set<Long>> acctOrgCostCentersMap = this.getPlannedContext().getAcctOrgCostCentersMap();
        PlannedArgs plannedArgs = this.getPlannedContext().getPlannedArgs();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getPlannedContext().getConfigSrcAndTargetBillsMap();
        Map<Long, String> dimensionAndRuleMap = this.getPlannedContext().getDimensionAndRuleMap();
        Map<Long, Map<String, String>> collConfigMappingMap = this.getPlannedContext().getCollConfigMappingMap();
        Map<Long, Map<String, String>> collConfigRuleMappingMap = this.getPlannedContext().getCollConfigRuleMappingMap();
        acctOrgCostCentersMap.forEach((accountOrgId, costCenters) -> {
            String key = accountOrgId + CostObjectEnum.BIZTYPE_PZ.getValue();
            List<Long> acctOrgPZCostCenters = this.getPlannedContext().getAcctOrgCalmethodCostCenters().get(key);
            if (CadEmptyUtils.isEmpty(acctOrgPZCostCenters)) {
                this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u54c1\u79cd\u6cd5\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u7ed3\u675f\uff01", accountOrgId);
                return;
            }
            this.getPlannedContext().getCollectReport().setPzCostCenters(acctOrgPZCostCenters);
            for (Map.Entry configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
                DynamicObject config = (DynamicObject)configSrcAndTargetBill.getKey();
                String sourceBill = config.getString("sourcebill.id");
                String sourcebillName = config.getString("sourcebill.name");
                if (!CostObjectEnum.BIZTYPE_PZ.getValue().equals(config.getString("calmethod"))) continue;
                Map srcAndTargetBillsMap = (Map)configSrcAndTargetBill.getValue();
                ArrayList srcBills = new ArrayList(srcAndTargetBillsMap.keySet());
                this.getPlannedContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%s", (String)"AcaPlannedImportDataForPZConfigAction_41", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName));
                this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u201c%1$s\u201d%2$s\u6761\u6570\u636e\u3002", (String)"AcaPlannedImportDataForPZConfigAction_42", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName, srcBills.size()));
                List<Object> plannedBillBySrcBill = new ArrayList(200);
                long costcalcdimension = config.getLong("costcalcdimension.id");
                String dimension = (String)dimensionAndRuleMap.get(costcalcdimension);
                if (CadEmptyUtils.isEmpty((String)dimension)) {
                    this.getPlannedContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"AcaPlannedImportDataForPZConfigAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u6ca1\u6709\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ef4\u5ea6\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"AcaPlannedImportDataForPZConfigAction_21", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                    continue;
                }
                TreeMap<String, String> configRuleMappingMap = new TreeMap<String, String>();
                if (collConfigRuleMappingMap.get(config.getLong("id")) != null) {
                    configRuleMappingMap.putAll((Map)collConfigRuleMappingMap.get(config.getLong("id")));
                }
                HashMap<String, Map<String, DynamicObject>> existCostObjectMap = new HashMap(16);
                if (!CadEmptyUtils.isEmpty(configRuleMappingMap)) {
                    String costObjectFields = String.join((CharSequence)",", configRuleMappingMap.keySet());
                    existCostObjectMap = CostObjectHelper.getExistCostObjectMap((Long)accountOrgId, acctOrgPZCostCenters, (String)costObjectFields, (String)plannedArgs.getAppNum());
                }
                Map configMappingMap = (Map)collConfigMappingMap.get(config.getLong("id"));
                this.getPlannedContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\uff0c\u5904\u7406\u6e90\u5355\u3002", (String)"AcaPlannedImportDataForPZConfigAction_25", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                plannedBillBySrcBill = "pom_mftorder".equals(sourceBill) || "om_mftorder".equals(sourceBill) ? this.getPlannedBill((Long)accountOrgId, acctOrgPZCostCenters, srcAndTargetBillsMap, (Map<String, Map<String, DynamicObject>>)existCostObjectMap, configRuleMappingMap, configMappingMap, this.getPlannedContext().getIdEntryIdCompleteMap(), this.getPlannedContext().getIdentryidMftLogMap(), this.getPlannedContext().getExistBillNos(), sourceBill, plannedArgs.getAppNum()) : this.getPlannedBillBySrcBill((Long)accountOrgId, acctOrgPZCostCenters, srcAndTargetBillsMap, (Map<String, Map<String, DynamicObject>>)existCostObjectMap, configRuleMappingMap, configMappingMap, this.getPlannedContext().getIdEntryIdCompleteMap(), this.getPlannedContext().getExistBillNos(), sourceBill, plannedArgs.getAppNum());
                this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u6570\u636e%s\u6761\u3002", (String)"AcaPlannedImportDataForPZConfigAction_26", (String)"macc-cad-mservice", (Object[])new Object[0]), plannedBillBySrcBill.size()));
            }
        });
    }

    private List<DynamicObject> getPlannedBill(Long acctOrg, List<Long> costCenters, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, Map<String, DynamicObject>> existCostObjectMap, TreeMap<String, String> collConfigRuleMappingMap, Map<String, String> configMappingMap, Map<String, DynamicObject> idEntryIdCompleteMap, Map<String, List<String>> identryidMftLogMap, Set<String> existBillNos, String sourcebill, String appNum) {
        ArrayList<DynamicObject> plannedBill = new ArrayList<DynamicObject>(10);
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return plannedBill;
        }
        HashMap<String, DynamicObject> changePlannedMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> changeStatusMap = new HashMap<String, DynamicObject>(16);
        this.dealExitsData(idEntryIdCompleteMap, srcAndTargetBillsMap, changePlannedMap, changeStatusMap, new HashSet<String>(configMappingMap.keySet()), appNum, null);
        this.logger.info("\u5df2\u7ecf\u5b58\u5728\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", existBillNos);
        Map<String, Set<MftOrderLog>> createPlanDataByLogMap = this.getPlannedContext().getCreatePlanDataByLogMap();
        int updNum = 0;
        int addNum = 0;
        PlannedContext context = this.getPlannedContext();
        List<DynamicObject> planOutPutList = this.getPlannedContext().getPlanOutPutBills();
        Set willSaveBillNoSet = planOutPutList.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
        Set<String> existsIds = idEntryIdCompleteMap.keySet();
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBills : srcAndTargetBillsMap.entrySet()) {
            String cost;
            Boolean ismodifybizdate;
            DynamicObject plan;
            DynamicObject srcBill = srcAndTargetBills.getKey();
            DynamicObject targetBill = srcAndTargetBillsMap.get(srcBill);
            if (!sourcebill.equals(srcBill.getString("billtype"))) continue;
            if (targetBill == null) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u3002", (String)"AcaPlannedImportDataForPZConfigAction_44", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            String idAndEntryId = srcBill.getString("id") + "-" + srcBill.getString("entryId");
            boolean isNeedChangeData = changePlannedMap.containsKey(idAndEntryId);
            boolean isStatusChangeData = changeStatusMap.containsKey(idAndEntryId);
            if (existsIds.contains(idAndEntryId) && !isNeedChangeData && !isStatusChangeData) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"AcaPlannedImportDataForPZConfigAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"AcaPlannedImportDataForPZConfigAction_45", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                this.logger.info("\u6e90\u5355{}\u884c\u53f7{}\u5df2\u5b58\u5728\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"), (Object)srcBill.getString("entryseq"));
                idEntryIdCompleteMap.remove(idAndEntryId);
                if (!"pom_mftorder".equals(sourcebill) && !"om_mftorder".equals(sourcebill)) continue;
                if (identryidMftLogMap != null) {
                    List<String> keys = identryidMftLogMap.get(idAndEntryId);
                    if (keys == null) continue;
                    for (String key : keys) {
                        idEntryIdCompleteMap.remove(key);
                    }
                    continue;
                }
                this.removeExistMftOrderLog(idAndEntryId, idEntryIdCompleteMap);
                continue;
            }
            if (willSaveBillNoSet.contains(srcBill.getString("billno") + "-" + srcBill.getString("entryseq"))) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"AcaPlannedImportDataForPZConfigAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5bfc\u5165\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"AcaPlannedImportDataForPZConfigAction_46", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            if (!existsIds.contains(idAndEntryId) && existBillNos.contains(srcBill.getString("billno") + "-" + srcBill.getString("entryseq"))) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"AcaPlannedImportDataForPZConfigAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"AcaPlannedImportDataForPZConfigAction_47", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                this.logger.info("\u6e90\u5355{}\u884c\u53f7{}\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"), (Object)srcBill.getString("entryseq"));
                continue;
            }
            Long costCenterId = targetBill.getLong("costcenter.id");
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"AcaPlannedImportDataForPZConfigAction_48", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            if (!costCenters.contains(costCenterId)) continue;
            DynamicObject costObject = null;
            if (targetBill.containsProperty("costobject") && targetBill.getDynamicObject("costobject") != null) {
                costObject = targetBill.getDynamicObject("costobject");
            } else {
                String srcStr = CostObjectHelper.getCostObjectHashCodeBySrcBill((DynamicObject)srcBill, collConfigRuleMappingMap);
                Map<String, DynamicObject> matInfoList = existCostObjectMap.get(String.valueOf(acctOrg).concat(String.valueOf(costCenterId)));
                DynamicObject dynamicObject = costObject = matInfoList == null ? null : matInfoList.get(srcStr);
            }
            if (costObject == null) {
                if ("sca".equals(appNum)) {
                    context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u4e14\u672a\u7ed3\u7b97\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"AcaPlannedImportDataForPZConfigAction_49", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                    continue;
                }
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"AcaPlannedImportDataForPZConfigAction_50", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            this.generateMftOrderLogs(acctOrg, costCenterId, costObject, createPlanDataByLogMap, srcBill, targetBill, existsIds, changePlannedMap, plannedBill, configMappingMap, idEntryIdCompleteMap);
            if (!isNeedChangeData && !isStatusChangeData) {
                ++addNum;
                targetBill.set("costcenter_id", (Object)costCenterId);
                targetBill.set("costobject_id", (Object)costObject.getLong("id"));
                targetBill.set("auxpty", (Object)costObject.getLong("auxpty"));
                BigDecimal totalinQty = targetBill.getBigDecimal("totalinqty") == null ? BigDecimal.ZERO : targetBill.getBigDecimal("totalinqty");
                totalinQty = targetBill.getBigDecimal("qty").subtract(totalinQty);
                totalinQty = totalinQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalinQty;
                targetBill.set("wipqty", (Object)totalinQty);
                targetBill.set("creator", (Object)RequestContext.get().getCurrUserId());
                targetBill.set("createtime", (Object)TimeServiceHelper.now());
                targetBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
                targetBill.set("auditdate", (Object)TimeServiceHelper.now());
            } else if (isNeedChangeData) {
                plan = idEntryIdCompleteMap.remove(idAndEntryId);
                ismodifybizdate = plan.getBoolean("ismodifybizdate");
                if (!ismodifybizdate.booleanValue()) {
                    plan.set("bizdate", (Object)targetBill.getDate("bizdate"));
                }
                for (Map.Entry<String, String> configMapping : configMappingMap.entrySet()) {
                    cost = configMapping.getKey();
                    plan.set(cost, targetBill.get(cost));
                }
                plan.set("closestatu", targetBill.get("closestatu"));
                plan.set("closestyle", targetBill.get("closestyle"));
                plan.set("closeuser", targetBill.get("closeuser"));
                targetBill = plan;
                ++updNum;
            } else {
                plan = idEntryIdCompleteMap.remove(idAndEntryId);
                if (this.checkPlanStatus(srcBill, costObject, plan)) continue;
                ismodifybizdate = plan.getBoolean("ismodifybizdate");
                if (!ismodifybizdate.booleanValue()) {
                    plan.set("bizdate", (Object)targetBill.getDate("bizdate"));
                }
                for (Map.Entry<String, String> configMapping : configMappingMap.entrySet()) {
                    cost = configMapping.getKey();
                    plan.set(cost, targetBill.get(cost));
                }
                plan.set("closestatu", targetBill.get("closestatu"));
                plan.set("closestyle", targetBill.get("closestyle"));
                plan.set("closeuser", targetBill.get("closeuser"));
                targetBill = plan;
                ++updNum;
            }
            plannedBill.add(targetBill);
        }
        this.getPlannedContext().setAddNum(this.getPlannedContext().getAddNum() + addNum);
        this.getPlannedContext().setUpdateNum(this.getPlannedContext().getUpdateNum() + updNum);
        this.getPlannedContext().getPlanOutPutBills().addAll(plannedBill);
        this.logger.info("\u65b0\u589e\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", (Object)plannedBill.size());
        this.getPlannedContext().getCreatePlanDataByLogMap().clear();
        return plannedBill;
    }
}

