/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.plannedoutput;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.dto.MftOrderLog;
import kd.macc.cad.common.enums.CollectStatus;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.mservice.plannedoutput.AbstractPlannedAction;
import kd.macc.cad.mservice.plannedoutput.PlannedContext;

public class BaseImportDataAction
extends AbstractPlannedAction {
    private static final Log logger = LogFactory.getLog(BaseImportDataAction.class);
    private static final String[] pomAndLog = new String[]{"pom_mftorder", "pom_xmftorderlog", "pom_mftorder_splitlog"};
    private static final String[] omAndLog = new String[]{"om_mftorder", "om_xmftorderlog", "om_mftorder_splitog"};

    @Override
    protected void doExecute() {
        try {
            MetadataServiceHelper.getDataEntityType((String)"pom_mftorder_f7");
        }
        catch (Exception e) {
            logger.error("\u751f\u4ea7\u5de5\u5355\u6ca1\u6709\u6743\u9650", (Throwable)e);
            this.getPlannedContext().getResponseInfo().put("error", ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u6ca1\u6709\u6743\u9650\u67e5\u770b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseImportDataAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            return;
        }
    }

    protected DynamicObjectCollection getAllManuBill(Long accountOrg, List<Long> costCenters, List<Long> manuOrgs, String appNum, List<Long> mftorderentryids, Map<String, Object> collectParamMap) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List<Map<String, Date>> importScopeDate = this.getPlannedContext().getOrgImportScopeDate().get(accountOrg);
        List workCenter = CostCenterHelper.getWorkCenter(costCenters, importScopeDate, (CollectReport)this.getPlannedContext().getCollectReport());
        List entryIds = CostCenterHelper.getOrderEntryIds((List)workCenter);
        List orgs = CostCenterHelper.getBosOrgs(costCenters, importScopeDate, (CollectReport)this.getPlannedContext().getCollectReport());
        List adminOrgIds = CostCenterHelper.getAdminOrg(costCenters, importScopeDate, (CollectReport)this.getPlannedContext().getCollectReport());
        QFilter wcOrOrgOrAoQF = CostObjectHelper.getWcOrOrgOrAoQFByWay((List)entryIds, (List)orgs, (List)adminOrgIds, (Boolean)true);
        QFilter subQF = new QFilter("treeentryentity.workcenter", "in", (Object)workCenter).and(new QFilter("transactiontype.isprocedure", "=", (Object)Boolean.FALSE));
        if (wcOrOrgOrAoQF == null && (workCenter == null || workCenter.isEmpty())) {
            this.getPlannedContext().getCollectReport().logStatusChange(CollectStatus.REMIND, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u672a\u8bbe\u7f6e\u6765\u6e90\uff0c\u6210\u672c\u4e2d\u5fc3\u83b7\u53d6\u751f\u4ea7\u5de5\u5355\u7ed3\u675f\u3002", (String)"BaseImportDataAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]));
        }
        wcOrOrgOrAoQF = wcOrOrgOrAoQF == null ? subQF : wcOrOrgOrAoQF.or(subQF);
        filters.add(wcOrOrgOrAoQF);
        if (!CadEmptyUtils.isEmpty(mftorderentryids)) {
            filters.add(new QFilter("treeentryentity.id", "in", mftorderentryids));
        }
        if (!CadEmptyUtils.isEmpty(collectParamMap) && collectParamMap.get("startDate") != null && collectParamMap.get("endDate") != null) {
            QFilter collectTimeQFilter = new QFilter("treeentryentity.beginbookdate", ">=", collectParamMap.get("startDate"));
            collectTimeQFilter.and(new QFilter("treeentryentity.beginbookdate", "<=", collectParamMap.get("endDate")));
            filters.add(collectTimeQFilter);
        }
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            filters.add(new QFilter("org", "in", manuOrgs));
        }
        Set notNeedCollectBillBizIdsForCo = SysParamHelper.getNotNeedCollectBillBizIds((Long)accountOrg, (String)"cad_costobject", (String)"pom_mftorder", (String)"bizsettingentry.transactiontype.fbasedataid.id", (String)appNum);
        Set notNeedCollectBillBizIdsForPo = SysParamHelper.getNotNeedCollectBillBizIds((Long)accountOrg, (String)"cad_plannedoutputbill", (String)"pom_mftorder", (String)"bizsettingentry.transactiontype.fbasedataid.id", (String)appNum);
        notNeedCollectBillBizIdsForPo.addAll(notNeedCollectBillBizIdsForCo);
        this.getPlannedContext().getCollectReport().setTransactionTypes(notNeedCollectBillBizIdsForPo);
        if (!CadEmptyUtils.isEmpty((Set)notNeedCollectBillBizIdsForPo)) {
            filters.add(new QFilter("transactiontype", "not in", (Object)notNeedCollectBillBizIdsForPo));
        }
        DynamicObject sysParamDynamicObject = SysParamHelper.getSysParamDynamicObject((Long)accountOrg, (String)appNum);
        QFilter timeQf = SysParamHelper.getImportTimeScope((String)"treeentryentity.beginbookdate", (DynamicObject)sysParamDynamicObject, (CollectReport)this.getPlannedContext().getCollectReport(), (long)accountOrg, (String)appNum);
        filters.add(timeQf);
        this.getPlannedContext().getCollectReport().setTimeQf(timeQf);
        logger.info("\u8ba1\u5212\u6570\u91cf\u5f52\u96c6\u5185\u90e8\u7cfb\u7edf\u5f15\u5165-\u67e5\u627e\u751f\u4ea7\u5de5\u5355\u6761\u4ef6\uff1a" + filters.toArray());
        String selectFields1 = "id,billno,billtype.billformid AS billtype,org,createtime,treeentryentity.id AS nodeId,treeentryentity.pid AS pnodeId,treeentryentity.id AS entryId,treeentryentity.seq AS seq,treeentryentity.seq AS entryseq,treeentryentity.producttype AS producttype,treeentryentity.producedept AS producedept,treeentryentity.material.masterid AS matmasterid,treeentryentity.material.masterid AS material,treeentryentity.material.masterid.number AS materialNumber,treeentryentity.material.masterid.name AS materialName,treeentryentity.material.masterid.modelnum AS materialModelnum,treeentryentity.material.masterid.isenablematerialversion AS isenablematerialversion,treeentryentity.bomid.version AS bom,treeentryentity.bomid.version AS bomversion,treeentryentity.bomid AS bomid,treeentryentity.planendtime AS planendtime,treeentryentity.baseunit AS unit,treeentryentity.auxproperty AS auxpty,treeentryentity.auxproperty AS auxproperty,treeentryentity.planstatus AS planstatus,treeentryentity.bizstatus AS bizstatus,treeentryentity.taskstatus AS taskstatus,treeentryentity.closetime AS closetime,treeentryentity.closebookdate AS closebookdate,treeentryentity.beginbookdate AS transmittime,treeentryentity.planbaseqty AS qty,treeentryentity.workcenter AS workcenter,treeentryentity.configuredcode AS configuredcode,treeentryentity.tracknumber AS tracknumber,'PB' AS sotype,transactiontype.isprocedure AS isprocedure,transactiontype.isrework AS isrework";
        DynamicObjectCollection srcs = QueryServiceHelper.query((String)"pom_mftorder", (String)selectFields1, (QFilter[])filters.toArray(new QFilter[0]));
        Map<String, Set<MftOrderLog>> createPlanDataByLogMap = this.getPlannedContext().getCreatePlanDataByLogMap();
        HashSet<Long> srcIdSet = new HashSet<Long>(srcs.size());
        HashSet<Long> srcEntryIdSet = new HashSet<Long>(srcs.size());
        for (DynamicObject src : srcs) {
            srcIdSet.add(src.getLong("id"));
            srcEntryIdSet.add(src.getLong("entryId"));
        }
        this.getChangeLogDataToCreatePlanDataByLogMap(createPlanDataByLogMap, sysParamDynamicObject, srcIdSet, srcEntryIdSet, "pom_xmftorderlog", manuOrgs, mftorderentryids, accountOrg, appNum, collectParamMap);
        this.getSplitLogDataToCreatePlanDataByLogMap(createPlanDataByLogMap, sysParamDynamicObject, srcIdSet, srcEntryIdSet, "pom_mftorder_splitlog", manuOrgs, mftorderentryids, accountOrg, appNum, collectParamMap);
        return srcs;
    }

    protected DynamicObjectCollection getAllOutSourceManuBill(Long accountOrg, List<Long> costCenters, List<Long> manuOrgs, String appNum, List<Long> mftorderentryids, Map<String, Object> collectParamMap) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List<Map<String, Date>> importScopeDate = this.getPlannedContext().getOrgImportScopeDate().get(accountOrg);
        List workCenter = CostCenterHelper.getWorkCenter(costCenters, importScopeDate);
        List entryIds = CostCenterHelper.getOrderEntryIds((List)workCenter);
        List orgs = CostCenterHelper.getBosOrgs(costCenters, importScopeDate);
        List adminOrgIds = CostCenterHelper.getAdminOrg(costCenters, importScopeDate);
        QFilter wcOrOrgOrAoQF = CostObjectHelper.getWcOrOrgOrAoQFByWay((List)entryIds, (List)orgs, (List)adminOrgIds, (Boolean)true);
        QFilter subQF = new QFilter("treeentryentity.workcenter", "in", (Object)workCenter).and(new QFilter("transactiontype.isprocedure", "=", (Object)Boolean.FALSE));
        if (wcOrOrgOrAoQF == null && (workCenter == null || workCenter.isEmpty())) {
            this.getPlannedContext().getCollectReport().logStatusChange(CollectStatus.REMIND, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u672a\u8bbe\u7f6e\u6765\u6e90\uff0c\u6210\u672c\u4e2d\u5fc3\u83b7\u53d6\u59d4\u5916\u5de5\u5355\u7ed3\u675f\u3002", (String)"BaseImportDataAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
        }
        wcOrOrgOrAoQF = wcOrOrgOrAoQF == null ? subQF : wcOrOrgOrAoQF.or(subQF);
        filters.add(wcOrOrgOrAoQF);
        if (!CadEmptyUtils.isEmpty(mftorderentryids)) {
            filters.add(new QFilter("treeentryentity.id", "in", mftorderentryids));
        }
        if (!CadEmptyUtils.isEmpty(collectParamMap) && collectParamMap.get("startDate") != null && collectParamMap.get("endDate") != null) {
            QFilter collectTimeQFilter = new QFilter("treeentryentity.beginbookdate", ">=", collectParamMap.get("startDate"));
            collectTimeQFilter.and(new QFilter("treeentryentity.beginbookdate", "<=", collectParamMap.get("endDate")));
            filters.add(collectTimeQFilter);
        }
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            filters.add(new QFilter("org", "in", manuOrgs));
        }
        Set notNeedCollectBillBizIdsForCo = SysParamHelper.getNotNeedCollectBillBizIds((Long)accountOrg, (String)"cad_costobject", (String)"om_mftorder", (String)"bizsettingentry.transactiontype.fbasedataid.id", (String)appNum);
        Set notNeedCollectBillBizIdsForPo = SysParamHelper.getNotNeedCollectBillBizIds((Long)accountOrg, (String)"cad_plannedoutputbill", (String)"om_mftorder", (String)"bizsettingentry.transactiontype.fbasedataid.id", (String)appNum);
        notNeedCollectBillBizIdsForPo.addAll(notNeedCollectBillBizIdsForCo);
        this.getPlannedContext().getCollectReport().setTransactionTypes(notNeedCollectBillBizIdsForPo);
        if (!CadEmptyUtils.isEmpty((Set)notNeedCollectBillBizIdsForPo)) {
            filters.add(new QFilter("transactiontype", "not in", (Object)notNeedCollectBillBizIdsForPo));
        }
        filters.add(SysParamHelper.getImportTimeScope((Long)accountOrg, (String)"treeentryentity.beginbookdate", (String)appNum));
        logger.info("\u8ba1\u5212\u6570\u91cf\u5f52\u96c6\u5185\u90e8\u7cfb\u7edf\u5f15\u5165-\u67e5\u627e\u59d4\u5916\u5de5\u5355\u6761\u4ef6\uff1a" + filters.toArray());
        String selectFields2 = "id,billno,billtype.billformid AS billtype,org,createtime,treeentryentity.id AS nodeId,treeentryentity.pid AS pnodeId,treeentryentity.id AS entryId,treeentryentity.seq AS seq,treeentryentity.seq AS entryseq,treeentryentity.producttype AS producttype,treeentryentity.producedept AS producedept,treeentryentity.material.masterid AS matmasterid,treeentryentity.material.masterid AS material,treeentryentity.material.masterid.number AS materialNumber,treeentryentity.material.masterid.name AS materialName,treeentryentity.material.masterid.modelnum AS materialModelnum,treeentryentity.material.masterid.isenablematerialversion AS isenablematerialversion,treeentryentity.bomid.version AS bom,treeentryentity.bomid.version AS bomversion,treeentryentity.bomid AS bomid,treeentryentity.planendtime AS planendtime,treeentryentity.baseunit AS unit,treeentryentity.auxproperty AS auxpty,treeentryentity.auxproperty AS auxproperty,treeentryentity.taskstatus AS taskstatus,treeentryentity.planstatus AS planstatus,treeentryentity.bizstatus AS bizstatus,treeentryentity.closetime AS closetime,treeentryentity.closebookdate AS closebookdate,treeentryentity.beginbookdate AS transmittime,treeentryentity.planbaseqty AS qty,treeentryentity.workcenter AS workcenter,treeentryentity.configuredcode AS configuredcode,treeentryentity.tracknumber AS tracknumber,'WPB' AS sotype,transactiontype.isprocedure AS isprocedure,transactiontype.isrework AS isrework";
        DynamicObjectCollection omsrcs = QueryServiceHelper.query((String)"om_mftorder", (String)selectFields2, (QFilter[])filters.toArray(new QFilter[0]));
        Map<String, Set<MftOrderLog>> createPlanDataByLogMap = this.getPlannedContext().getCreatePlanDataByLogMap();
        DynamicObject sysParamDynamicObject = SysParamHelper.getSysParamDynamicObject((Long)accountOrg, (String)appNum);
        HashSet<Long> srcIdSet = new HashSet<Long>(omsrcs.size());
        HashSet<Long> srcEntryIdSet = new HashSet<Long>(omsrcs.size());
        for (DynamicObject src : omsrcs) {
            srcIdSet.add(src.getLong("id"));
            srcEntryIdSet.add(src.getLong("entryId"));
        }
        this.getChangeLogDataToCreatePlanDataByLogMap(createPlanDataByLogMap, sysParamDynamicObject, srcIdSet, srcEntryIdSet, "om_xmftorderlog", manuOrgs, mftorderentryids, accountOrg, appNum, collectParamMap);
        boolean metaDataExist = MetadataDao.checkNumber((String)"om_mftorder_splitog");
        if (metaDataExist) {
            this.getSplitLogDataToCreatePlanDataByLogMap(createPlanDataByLogMap, sysParamDynamicObject, srcIdSet, srcEntryIdSet, "om_mftorder_splitog", manuOrgs, mftorderentryids, accountOrg, appNum, collectParamMap);
        }
        return omsrcs;
    }

    protected DynamicObjectCollection getAllFactnedOutPutBill(Long accountOrg, List<Long> costCenters, List<Long> manuOrgs, String appNum) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)accountOrg));
        filters.add(new QFilter("costcenter", "in", costCenters));
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            filters.add(new QFilter("manuorg", "in", manuOrgs));
        }
        filters.add(SysParamHelper.getImportTimeScope((Long)accountOrg, (String)"bookdate", (String)appNum));
        filters.add(new QFilter("billstatus", "in", (Object)"C"));
        logger.info("\u8ba1\u5212\u6570\u91cf\u5f52\u96c6\u5185\u90e8\u7cfb\u7edf\u5f15\u5165-\u67e5\u627e\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u6761\u4ef6\uff1a" + filters.toArray());
        String selectFields2 = "id,billno,org,manuorg,costcenter,bookdate,bizdate,material AS matmasterid,baseunit AS unit,auxpty,auditdate,entryentity.costobject AS costobject,entryentity.qty AS qty,1 as seq";
        return QueryServiceHelper.query((String)"cad_factnedoutputbill", (String)selectFields2, (QFilter[])filters.toArray(new QFilter[0]));
    }

    protected int collectImportByFactnedBills(Long accountOrg, Set<Long> costCenters, List<Long> manuOrgs, DynamicObjectCollection factnedOutPutBills, String appNum) {
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u83b7\u53d6\u5230\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355:{}", factnedOutPutBills == null ? null : factnedOutPutBills.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toList()));
        if (CadEmptyUtils.isEmpty((Long)accountOrg)) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7\u672a\u4f20\u5165\uff0c\u6839\u636e\u5b8c\u5de5\u5f15\u5165\u8ba1\u5212\u7ed3\u675f\uff01");
            return 0;
        }
        if (CadEmptyUtils.isEmpty(costCenters)) {
            logger.info("\u6210\u672c\u4e2d\u5fc3\u672a\u4f20\u5165\uff0c\u6839\u636e\u5b8c\u5de5\u5f15\u5165\u8ba1\u5212\u7ed3\u675f\uff01");
            return 0;
        }
        if (CadEmptyUtils.isEmpty((String)appNum)) {
            logger.info("\u4e1a\u52a1\u6807\u8bc6\u672a\u4f20\u5165\uff0c\u6839\u636e\u5b8c\u5de5\u5f15\u5165\u8ba1\u5212\u7ed3\u675f\uff01");
            return 0;
        }
        List<DynamicObject> plannedBill = this.getPlannedBillByFactned(accountOrg, costCenters, manuOrgs, (List<DynamicObject>)factnedOutPutBills, appNum);
        if (plannedBill == null || plannedBill.isEmpty()) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u54c1\u79cd\u6cd5\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\u6ca1\u6709\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u7ed3\u675f\uff01", (Object)accountOrg);
            return 0;
        }
        this.getPlannedContext().getPlanOutPutBills().addAll(plannedBill);
        return plannedBill.size();
    }

    private List<DynamicObject> getPlannedBillByFactned(Long acctOrg, Set<Long> costCenters, List<Long> manuOrgs, List<DynamicObject> manuBill, String appNum) {
        HashMap<String, DynamicObject> changePlannedMap = new HashMap<String, DynamicObject>(16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date date = TimeServiceHelper.now();
        ArrayList<DynamicObject> plannedBill = new ArrayList<DynamicObject>(10);
        ArrayList<String> existBillNos = new ArrayList<String>(10);
        Set<String> existsManu = this.dealExistsFactned(acctOrg, costCenters, manuOrgs, manuBill, changePlannedMap, existBillNos, appNum);
        int updNum = 0;
        int addNum = 0;
        for (DynamicObject manu : manuBill) {
            String srcId = manu.getString("id");
            boolean isNeedChangeData = changePlannedMap.containsKey(srcId);
            DynamicObject plan = BusinessDataServiceHelper.newDynamicObject((String)"cad_plannedoutputbill");
            Long curCostObject = manu.getLong("costobject");
            if (existsManu.contains(srcId) && !isNeedChangeData) {
                logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355{}\u5df2\u5b58\u5728\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"));
                continue;
            }
            if (!existsManu.contains(srcId) && existBillNos.contains(manu.getString("billno") + "-" + manu.getString("seq"))) {
                logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355{}\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"));
                continue;
            }
            if (!isNeedChangeData) {
                ++addNum;
                plan.set("id", (Object)0L);
            } else {
                ++updNum;
                plan = (DynamicObject)changePlannedMap.get(srcId);
            }
            plan.set("billno", (Object)manu.getString("billno").concat("-").concat(manu.getString("seq")));
            Date bookdate = manu.getDate("bookdate");
            plan.set("bizdate", (Object)bookdate);
            plan.set("srctransmittime", (Object)bookdate);
            plan.set("appnum", (Object)appNum);
            plan.set("accountorg_id", (Object)manu.getLong("org"));
            plan.set("costcenter_id", (Object)manu.getLong("costcenter"));
            plan.set("manuorg_id", (Object)manu.getLong("manuorg"));
            plan.set("creator", (Object)userId);
            plan.set("createtime", (Object)date);
            plan.set("billstatus", (Object)"C");
            plan.set("auditor", (Object)userId);
            plan.set("auditdate", (Object)date);
            plan.set("source", (Object)"5");
            plan.set("srcbilltype", (Object)"cad_factnedoutputbill");
            plan.set("sourcebill", (Object)manu.getLong("id"));
            plan.set("sourcebiztime", (Object)manu.getDate("auditdate"));
            plan.set("costobject_id", (Object)curCostObject);
            plan.set("material_id", (Object)manu.getLong("matmasterid"));
            plan.set("baseunit", (Object)manu.getLong("unit"));
            plan.set("auxpty", (Object)manu.getLong("auxpty"));
            plan.set("qty", (Object)manu.getBigDecimal("qty"));
            plannedBill.add(plan);
        }
        this.getPlannedContext().setAddNum(this.getPlannedContext().getAddNum() + addNum);
        this.getPlannedContext().setUpdateNum(this.getPlannedContext().getUpdateNum() + updNum);
        logger.info("\u65b0\u589e\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", (Object)plannedBill.size());
        return plannedBill;
    }

    protected List<DynamicObject> getPlannedBillBySrcBill(Long acctOrg, List<Long> costCenters, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, Map<String, DynamicObject>> existCostObjectMap, TreeMap<String, String> collConfigRuleMappingMap, Map<String, String> configMappingMap, Map<String, DynamicObject> idEntryIdCompleteMap, Set<String> existBillNos, String sourceBill, String appNum) {
        ArrayList<DynamicObject> plannedBill = new ArrayList<DynamicObject>(10);
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return plannedBill;
        }
        HashMap<String, DynamicObject> changePlannedMap = new HashMap<String, DynamicObject>(16);
        this.dealExitsData(idEntryIdCompleteMap, srcAndTargetBillsMap, changePlannedMap, null, new HashSet<String>(configMappingMap.keySet()), appNum, null);
        logger.info("\u5df2\u7ecf\u5b58\u5728\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", existBillNos);
        int updNum = 0;
        int addNum = 0;
        PlannedContext context = this.getPlannedContext();
        List<DynamicObject> planOutPutList = this.getPlannedContext().getPlanOutPutBills();
        Set willSaveBillNoSet = planOutPutList.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
        Set<String> existsIds = idEntryIdCompleteMap.keySet();
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBills : srcAndTargetBillsMap.entrySet()) {
            DynamicObject srcBill = srcAndTargetBills.getKey();
            DynamicObject targetBill = srcAndTargetBillsMap.get(srcBill);
            if (!sourceBill.equals(srcBill.getString("billtype"))) continue;
            if (targetBill == null) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u3002", (String)"BaseImportDataAction_65", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            String idAndEntryId = srcBill.getString("id") + "-" + srcBill.getString("entryId");
            boolean isNeedChangeData = changePlannedMap.containsKey(idAndEntryId);
            if (existsIds.contains(idAndEntryId) && !isNeedChangeData) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_66", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                logger.info("\u6e90\u5355{}\u884c\u53f7{}\u5df2\u5b58\u5728\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"), (Object)srcBill.getString("entryseq"));
                idEntryIdCompleteMap.remove(idAndEntryId);
                continue;
            }
            if (willSaveBillNoSet.contains(srcBill.getString("billno") + "-" + srcBill.getString("entryseq"))) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5bfc\u5165\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_67", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            if (!existsIds.contains(idAndEntryId) && existBillNos.contains(srcBill.getString("billno") + "-" + srcBill.getString("entryseq"))) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_68", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                logger.info("\u6e90\u5355{}\u884c\u53f7{}\u7684\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"), (Object)srcBill.getString("entryseq"));
                continue;
            }
            Long costCenterId = targetBill.getLong("costcenter.id");
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"BaseImportDataAction_59", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            if (!costCenters.contains(costCenterId)) continue;
            DynamicObject costObject = null;
            if (targetBill.containsProperty("costobject") && targetBill.getDynamicObject("costobject") != null) {
                costObject = targetBill.getDynamicObject("costobject");
            } else {
                String srcStr = CostObjectHelper.getCostObjectHashCodeBySrcBill((DynamicObject)srcBill, collConfigRuleMappingMap);
                Map<String, DynamicObject> matInfoList = existCostObjectMap.get(String.valueOf(acctOrg).concat(String.valueOf(costCenterId)));
                DynamicObject dynamicObject = costObject = matInfoList == null ? null : matInfoList.get(srcStr);
            }
            if (costObject == null) {
                if ("sca".equals(appNum)) {
                    context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u4e14\u672a\u7ed3\u7b97\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"BaseImportDataAction_69", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                    continue;
                }
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"BaseImportDataAction_70", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            if (isNeedChangeData) {
                DynamicObject plan = idEntryIdCompleteMap.remove(idAndEntryId);
                for (Map.Entry<String, String> configMapping : configMappingMap.entrySet()) {
                    String cost = configMapping.getKey();
                    plan.set(cost, targetBill.get(cost));
                }
                plan.set("closestatu", targetBill.get("closestatu"));
                plan.set("closestyle", targetBill.get("closestyle"));
                plan.set("closeuser", targetBill.get("closeuser"));
                targetBill = plan;
                ++updNum;
            } else {
                targetBill.set("costcenter_id", (Object)costCenterId);
                targetBill.set("costobject_id", (Object)costObject.getLong("id"));
                long auxptyId = 0L;
                auxptyId = costObject.get("auxpty") != null && costObject.get("auxpty") instanceof DynamicObject ? costObject.getDynamicObject("auxpty").getLong("id") : costObject.getLong("auxpty");
                targetBill.set("auxpty", (Object)auxptyId);
                BigDecimal totalinQty = targetBill.getBigDecimal("totalinqty") == null ? BigDecimal.ZERO : targetBill.getBigDecimal("totalinqty");
                totalinQty = targetBill.getBigDecimal("qty").subtract(totalinQty);
                totalinQty = totalinQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalinQty;
                targetBill.set("wipqty", (Object)totalinQty);
                targetBill.set("creator", (Object)RequestContext.get().getCurrUserId());
                targetBill.set("createtime", (Object)TimeServiceHelper.now());
                targetBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
                targetBill.set("auditdate", (Object)TimeServiceHelper.now());
                ++addNum;
            }
            plannedBill.add(targetBill);
        }
        this.getPlannedContext().setAddNum(this.getPlannedContext().getAddNum() + addNum);
        this.getPlannedContext().setUpdateNum(this.getPlannedContext().getUpdateNum() + updNum);
        this.getPlannedContext().getPlanOutPutBills().addAll(plannedBill);
        logger.info("\u65b0\u589e\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", (Object)plannedBill.size());
        return plannedBill;
    }

    private Set<String> dealExistsFactned(Long acctOrg, Set<Long> costCenters, List<Long> manuOrgs, List<DynamicObject> manuBill, Map<String, DynamicObject> changePlannedMap, List<String> existBillNos, String appNum) {
        HashSet<String> needReturnInfo = new HashSet<String>(16);
        HashSet<Long> ids = new HashSet<Long>(16);
        HashMap<Long, Date> dateMap = new HashMap<Long, Date>(16);
        HashSet<String> srcBillno = new HashSet<String>(16);
        for (DynamicObject manu : manuBill) {
            ids.add(manu.getLong("id"));
            srcBillno.add(manu.getString("billno") + "-" + manu.getString("seq"));
            dateMap.put(manu.getLong("id"), manu.getDate("auditdate"));
        }
        if (ids.size() == 0) {
            this.deleteAll(acctOrg, costCenters, appNum, new String[]{"cad_factnedoutputbill"});
            return needReturnInfo;
        }
        QFilter qfSource = new QFilter("source", "=", (Object)"5");
        QFilter qfSourceBill = new QFilter("sourcebill", "in", ids);
        QFilter qfBillNo = new QFilter("billno", "in", srcBillno);
        qfSourceBill = qfSourceBill.or(qfBillNo);
        QFilter qfOrgAndCostCenter = new QFilter("accountorg", "in", (Object)acctOrg);
        qfOrgAndCostCenter.and(new QFilter("costcenter", "in", costCenters));
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            qfOrgAndCostCenter.and(new QFilter("manuorg", "in", manuOrgs));
        }
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfbizTime = SysParamHelper.getImportTimeScope((Long)acctOrg, (String)"bizdate", (String)appNum);
        qfbizTime = qfbizTime.or(qfSourceBill);
        QFilter[] qFilters = new QFilter[]{qfSource, qfOrgAndCostCenter, qfbizTime, qfAppNum};
        DynamicObjectCollection plannedBill = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"id,accountorg,accountorg accountorg_id,costobject,costobject costobject_id,costcenter,costcenter costcenter_id,billno,billno Seq,bizdate transmittime,sourcebiztime,planneddate planendtime,material matmasterid,baseunit unit,auxpty auxproperty,qty,sourcebill,sourcebillentry,closestatu", (QFilter[])qFilters);
        plannedBill.forEach(p -> existBillNos.add(p.getString("billno")));
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u5df2\u5b58\u5728\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff1a{}", existBillNos);
        if (plannedBill.size() == 0) {
            return needReturnInfo;
        }
        Map<Long, DynamicObject> plannedMap = this.getPlannedMap(plannedBill);
        HashSet<Long> needDeleteIds = new HashSet<Long>(16);
        HashSet<Long> needDeleteSrcIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> costChangeRecords = new ArrayList<DynamicObject>(16);
        for (DynamicObject planned : plannedBill) {
            Long sourcebillId = planned.getLong("sourcebill");
            if (!CadEmptyUtils.isEmpty((Long)planned.getLong("sourcebill")) && !ids.contains(sourcebillId)) {
                needDeleteIds.add(planned.getLong("id"));
                needDeleteSrcIds.add(sourcebillId);
                needReturnInfo.remove(String.valueOf(sourcebillId));
                if (!CostObjectHelper.isSettlement((Long)planned.getLong("costobject"))) continue;
                costChangeRecords.add(planned);
                continue;
            }
            needReturnInfo.add(String.valueOf(sourcebillId));
            if (planned.getDate("sourcebiztime") == null || planned.getDate("sourcebiztime").compareTo((Date)dateMap.get(sourcebillId)) == 0) continue;
            changePlannedMap.put(String.valueOf(sourcebillId), plannedMap.get(planned.getLong("id")));
        }
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u9700\u8981\u5220\u9664\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", needDeleteIds);
        if (needDeleteIds.size() > 0 && needDeleteSrcIds.size() > 0) {
            logger.info("\u9700\u8981\u5220\u9664\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", (Object)JSON.toJSONString(needDeleteIds));
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cad_plannedoutputbill"), (Object[])needDeleteIds.toArray(new Long[0]));
            this.delChangeRecord(needDeleteSrcIds);
            this.getPlannedContext().setDelNum(this.getPlannedContext().getDelNum() + needDeleteIds.size());
        }
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u9700\u8981\u586b\u5199\u53d8\u66f4\u8bb0\u5f55\u7684\u6761\u6570:{}", (Object)costChangeRecords.size());
        if (costChangeRecords.size() > 0) {
            this.getPlannedContext().getChangeRecords().addAll(costChangeRecords);
        }
        return needReturnInfo;
    }

    protected Set<String> dealExistsManu(Long acctOrg, Set<Long> costCenters, List<Long> manuOrgs, List<DynamicObject> manuBill, Map<String, DynamicObject> changePlannedMap, Map<String, DynamicObject> changeStatusMap, List<String> existBillNos, String appNum) {
        HashSet<String> needReturnInfo = new HashSet<String>(16);
        String sign = "-";
        String join = "@";
        HashSet<Long> ids = new HashSet<Long>(16);
        HashSet<Long> entryIds = new HashSet<Long>(16);
        HashSet<String> srcBillno = new HashSet<String>(16);
        HashMap<String, String> newManuInfo = new HashMap<String, String>(16);
        HashMap<String, String> newManuInfoByStatus = new HashMap<String, String>(16);
        String[] sourceType = "PB".equals(manuBill.get(0).getString("sotype")) ? pomAndLog : omAndLog;
        for (DynamicObject manu : manuBill) {
            ids.add(manu.getLong("id"));
            entryIds.add(manu.getLong("entryid"));
            if (!"C".equals(manu.getString("planstatus"))) continue;
            newManuInfo.put(manu.getString("id") + sign + manu.getString("entryid"), this.getJoinManuInfo(manu, join, true));
            newManuInfoByStatus.put(manu.getString("id") + sign + manu.getString("entryid"), this.getJoinManuInfoByStatus(manu, true));
            srcBillno.add(manu.getString("billno") + "-" + manu.getString("seq"));
        }
        if (ids.size() == 0 || entryIds.size() == 0) {
            this.deleteAll(acctOrg, costCenters, appNum, sourceType);
            return needReturnInfo;
        }
        QFilter qfSource = new QFilter("srcbilltype", "in", (Object)sourceType);
        QFilter qfSourceBill = new QFilter("sourcebill", "in", ids);
        qfSourceBill.and(new QFilter("sourcebillentry", "in", entryIds));
        QFilter qfBillNo = new QFilter("billno", "in", srcBillno);
        qfSourceBill = qfSourceBill.or(qfBillNo);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        DynamicObjectCollection existPlans = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"id,sourcebill,sourcebillentry,fromlogid", (QFilter[])new QFilter[]{qfSource, qfSourceBill, qfAppNum});
        existPlans.forEach(p -> {
            Long fromlogid = p.getLong("fromlogid");
            if (CadEmptyUtils.isEmpty((Long)fromlogid)) {
                needReturnInfo.add(p.getString("sourcebill") + sign + p.getString("sourcebillentry"));
            } else {
                needReturnInfo.add(p.getString("sourcebill") + sign + p.getString("sourcebillentry") + sign + fromlogid);
            }
        });
        QFilter qfOrgAndCostCenter = new QFilter("accountorg", "=", (Object)acctOrg);
        if (!CadEmptyUtils.isEmpty(costCenters)) {
            qfOrgAndCostCenter = qfOrgAndCostCenter.and(new QFilter("costcenter", "in", costCenters));
        }
        QFilter manuOrgQf = new QFilter("manuorg", ">=", (Object)0L);
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            manuOrgQf = new QFilter("manuorg", "in", manuOrgs);
        }
        QFilter qfbizTime = SysParamHelper.getImportTimeScope((Long)acctOrg, (String)"bizdate", (String)appNum);
        qfbizTime = qfbizTime.or(qfSourceBill);
        QFilter[] qFilters = new QFilter[]{qfSource, qfOrgAndCostCenter, qfbizTime, qfAppNum, manuOrgQf};
        DynamicObjectCollection plannedBill = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"id,accountorg,accountorg accountorg_id,costobject,costobject costobject_id,costcenter,costcenter costcenter_id,billno,billno Seq,srctransmittime transmittime,sourcebiztime,planneddate planendtime,material matmasterid,baseunit unit,auxpty auxproperty,qty,sourcebill,sourcebillentry,closestatu,fromlogid,ismodifybizdate", (QFilter[])qFilters);
        plannedBill.forEach(p -> existBillNos.add(p.getString("billno")));
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u5df2\u5b58\u5728\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff1a{}", existBillNos);
        if (plannedBill.size() == 0) {
            return needReturnInfo;
        }
        Map<Long, DynamicObject> plannedMap = this.getPlannedMap(plannedBill);
        HashSet<Long> needDeleteIds = new HashSet<Long>(16);
        HashSet<Long> needDeleteSrcIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> costChangeRecords = new ArrayList<DynamicObject>(16);
        for (DynamicObject planned : plannedBill) {
            String key = planned.getString("sourcebill") + sign + planned.getString("sourcebillentry");
            String newVal = (String)newManuInfo.get(key);
            String newStatus = (String)newManuInfoByStatus.get(key);
            Long fromLogId = planned.getLong("fromlogid");
            if (!CadEmptyUtils.isEmpty((Long)fromLogId)) {
                key = key + sign + fromLogId;
            }
            if (CadEmptyUtils.isEmpty((String)newVal)) {
                if (!CadEmptyUtils.isEmpty((Long)planned.getLong("sourcebill")) && !planned.getBoolean("ismodifybizdate")) {
                    needDeleteIds.add(planned.getLong("id"));
                    needDeleteSrcIds.add(planned.getLong("sourcebill"));
                    needReturnInfo.remove(key);
                }
                if (!CostObjectHelper.isSettlement((Long)planned.getLong("costobject"))) continue;
                costChangeRecords.add(planned);
                continue;
            }
            needReturnInfo.add(key);
            String oldVal = this.getJoinManuInfo(planned, join, false);
            String oldStatus = this.getJoinManuInfoByStatus(planned, false);
            if (!CadEmptyUtils.isEmpty((Long)fromLogId) || !newVal.equals(oldVal)) {
                changePlannedMap.put(key, plannedMap.get(planned.getLong("id")));
                continue;
            }
            if (newStatus.equals(oldStatus)) continue;
            changeStatusMap.put(key, plannedMap.get(planned.getLong("id")));
        }
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u9700\u8981\u5220\u9664\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", needDeleteIds);
        if (needDeleteIds.size() > 0 && needDeleteSrcIds.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cad_plannedoutputbill"), (Object[])needDeleteIds.toArray(new Long[0]));
            this.delChangeRecord(needDeleteSrcIds);
            this.getPlannedContext().setDelNum(this.getPlannedContext().getDelNum() + needDeleteIds.size());
        }
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u9700\u8981\u586b\u5199\u53d8\u66f4\u8bb0\u5f55\u7684\u6761\u6570:{}", (Object)costChangeRecords.size());
        if (costChangeRecords.size() > 0) {
            this.getPlannedContext().getChangeRecords().addAll(costChangeRecords);
        }
        return needReturnInfo;
    }

    protected Set<String> dealExistsManu(Long acctOrg, List<Long> costCenters, List<Long> manuOrgs, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Set<String> selectFields, Map<String, DynamicObject> changePlannedMap, Map<String, DynamicObject> changeStatusMap, List<String> existBillNos, String sourcebill, String appNum, List<Long> mftOrderEntryIds) {
        HashSet<String> needReturnInfo = new HashSet<String>(16);
        String sign = "-";
        HashSet<Long> ids = new HashSet<Long>(16);
        HashSet<Long> entryIds = new HashSet<Long>(16);
        HashSet<String> srcBillno = new HashSet<String>(16);
        HashMap<String, String> newManuInfo = new HashMap<String, String>(16);
        HashMap<String, String> newManuInfoByStatus = new HashMap<String, String>(16);
        ArrayList<DynamicObject> manuBill = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
        for (DynamicObject manu : manuBill) {
            DynamicObject targetBill = srcAndTargetBillsMap.get(manu);
            ids.add(manu.getLong("id"));
            entryIds.add(manu.getLong("entryId"));
            if (!"C".equals(manu.getString("planstatus"))) continue;
            newManuInfo.put(manu.getString("id") + sign + manu.getString("entryId"), CommonCollConfigService.getBillInfoBySelectFields((DynamicObject)targetBill, selectFields));
            newManuInfoByStatus.put(manu.getString("id") + sign + manu.getString("entryId"), targetBill.getString("closestatu"));
            srcBillno.add(manu.getString("billno") + "-" + manu.getString("entryseq"));
        }
        if ((ids.size() == 0 || entryIds.size() == 0) && CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            this.deleteAll(acctOrg, new HashSet<Long>(costCenters), appNum, new String[]{sourcebill});
            return needReturnInfo;
        }
        QFilter qfSource = new QFilter("srcbilltype", "=", (Object)sourcebill);
        QFilter qfSourceBill = new QFilter("sourcebill", "in", ids);
        qfSourceBill.and(new QFilter("sourcebillentry", "in", entryIds));
        QFilter qfBillNo = new QFilter("billno", "in", srcBillno);
        qfSourceBill = qfSourceBill.or(qfBillNo);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfOrgAndCostCenter = new QFilter("accountorg", "=", (Object)acctOrg);
        if (!CadEmptyUtils.isEmpty(costCenters)) {
            qfOrgAndCostCenter = qfOrgAndCostCenter.and(new QFilter("costcenter", "in", costCenters));
        }
        QFilter manuOrgQf = new QFilter("manuorg", ">=", (Object)0L);
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            manuOrgQf = new QFilter("manuorg", "in", manuOrgs);
        }
        QFilter qfbizTime = SysParamHelper.getImportTimeScope((Long)acctOrg, (String)"bizdate", (String)appNum);
        qfbizTime = CadEmptyUtils.isEmpty(mftOrderEntryIds) ? qfbizTime.or(qfSourceBill) : new QFilter("sourcebillentry", "in", mftOrderEntryIds);
        HashSet<String> costSelectFields = new HashSet<String>(selectFields);
        costSelectFields.add("id");
        costSelectFields.add("billno");
        costSelectFields.add("costobject");
        costSelectFields.add("sourcebill");
        costSelectFields.add("sourcebillentry");
        costSelectFields.add("closestatu");
        costSelectFields.add("fromlogid");
        costSelectFields.add("ismodifybizdate");
        DynamicObjectCollection plannedBills = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)String.join((CharSequence)",", costSelectFields), (QFilter[])new QFilter[]{qfSource, qfbizTime, qfOrgAndCostCenter, qfAppNum, manuOrgQf});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)plannedBills)) {
            return needReturnInfo;
        }
        Map<Long, DynamicObject> plannedMap = this.getPlannedMap(plannedBills);
        for (DynamicObject planned : plannedBills) {
            existBillNos.add(planned.getString("billno"));
            Long fromlogid = planned.getLong("fromlogid");
            if (CadEmptyUtils.isEmpty((Long)fromlogid)) {
                needReturnInfo.add(planned.getString("sourcebill") + sign + planned.getString("sourcebillentry"));
                continue;
            }
            needReturnInfo.add(planned.getString("sourcebill") + sign + planned.getString("sourcebillentry") + sign + fromlogid);
        }
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u5df2\u5b58\u5728\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff1a{}", existBillNos);
        HashSet<Long> needDeleteIds = new HashSet<Long>(16);
        HashSet<Long> needDeleteSrcIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> costChangeRecords = new ArrayList<DynamicObject>(16);
        for (DynamicObject planned : plannedBills) {
            String key = planned.getString("sourcebill") + sign + planned.getString("sourcebillentry");
            String newVal = (String)newManuInfo.get(key);
            String newStatus = (String)newManuInfoByStatus.get(key);
            Long fromLogId = planned.getLong("fromlogid");
            if (!CadEmptyUtils.isEmpty((Long)fromLogId)) {
                key = key + sign + fromLogId;
            }
            if (CadEmptyUtils.isEmpty((String)newVal)) {
                if (!CadEmptyUtils.isEmpty((Long)planned.getLong("sourcebill")) && !planned.getBoolean("ismodifybizdate")) {
                    needDeleteIds.add(planned.getLong("id"));
                    needDeleteSrcIds.add(planned.getLong("sourcebill"));
                    needReturnInfo.remove(key);
                }
                if (!CostObjectHelper.isSettlement((Long)planned.getLong("costobject"))) continue;
                costChangeRecords.add(planned);
                continue;
            }
            needReturnInfo.add(key);
            String oldVal = CommonCollConfigService.getBillInfoBySelectFields((DynamicObject)planned, selectFields);
            String oldStatus = planned.getString("closestatu");
            if (!CadEmptyUtils.isEmpty((Long)fromLogId) || !newVal.equals(oldVal)) {
                changePlannedMap.put(key, plannedMap.get(planned.getLong("id")));
                continue;
            }
            if (newStatus.equals(oldStatus)) continue;
            changeStatusMap.put(key, plannedMap.get(planned.getLong("id")));
        }
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u9700\u8981\u5220\u9664\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", needDeleteIds);
        if (needDeleteIds.size() > 0 && needDeleteSrcIds.size() > 0 && CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cad_plannedoutputbill"), (Object[])needDeleteIds.toArray(new Long[0]));
            this.delChangeRecord(needDeleteSrcIds);
            this.getPlannedContext().setDelNum(this.getPlannedContext().getDelNum() + needDeleteIds.size());
        }
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u9700\u8981\u586b\u5199\u53d8\u66f4\u8bb0\u5f55\u7684\u6761\u6570:{}", (Object)costChangeRecords.size());
        if (costChangeRecords.size() > 0) {
            this.getPlannedContext().getChangeRecords().addAll(costChangeRecords);
        }
        return needReturnInfo;
    }

    protected Set<String> dealExistBills(Long acctOrg, List<Long> costCenters, List<Long> manuOrgs, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Set<String> selectFields, Map<String, DynamicObject> changePlannedMap, List<String> existBillNos, String sourceBill, String appNum) {
        HashSet<String> needReturnInfo = new HashSet<String>(16);
        String sign = "-";
        HashSet<Long> ids = new HashSet<Long>(16);
        HashSet<Long> entryIds = new HashSet<Long>(16);
        HashSet<String> srcBillno = new HashSet<String>(16);
        HashMap<String, String> newManuInfo = new HashMap<String, String>(16);
        ArrayList<DynamicObject> manuBill = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
        for (DynamicObject manu : manuBill) {
            DynamicObject targetBill = srcAndTargetBillsMap.get(manu);
            ids.add(manu.getLong("id"));
            entryIds.add(manu.getLong("entryId"));
            newManuInfo.put(manu.getString("id") + sign + manu.getString("entryId"), CommonCollConfigService.getBillInfoBySelectFields((DynamicObject)targetBill, selectFields));
            srcBillno.add(manu.getString("billno") + "-" + manu.getString("entryseq"));
        }
        if (ids.size() == 0 || entryIds.size() == 0) {
            this.deleteAll(acctOrg, new HashSet<Long>(costCenters), appNum, new String[]{sourceBill});
            return needReturnInfo;
        }
        QFilter qfSource = new QFilter("srcbilltype", "=", (Object)sourceBill);
        QFilter qfSourceBill = new QFilter("sourcebill", "in", ids);
        qfSourceBill.and(new QFilter("sourcebillentry", "in", entryIds));
        QFilter qfBillNo = new QFilter("billno", "in", srcBillno);
        qfSourceBill = qfSourceBill.or(qfBillNo);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfOrgAndCostCenter = new QFilter("accountorg", "=", (Object)acctOrg);
        if (!CadEmptyUtils.isEmpty(costCenters)) {
            qfOrgAndCostCenter = qfOrgAndCostCenter.and(new QFilter("costcenter", "in", costCenters));
        }
        QFilter manuOrgQf = new QFilter("manuorg", ">=", (Object)0L);
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            manuOrgQf = new QFilter("manuorg", "in", manuOrgs);
        }
        QFilter qfbizTime = SysParamHelper.getImportTimeScope((Long)acctOrg, (String)"bizdate", (String)appNum);
        qfbizTime = qfbizTime.or(qfSourceBill);
        HashSet<String> costSelectFields = new HashSet<String>(selectFields);
        costSelectFields.add("id");
        costSelectFields.add("billno");
        costSelectFields.add("costobject");
        costSelectFields.add("sourcebill");
        costSelectFields.add("sourcebillentry");
        costSelectFields.add("closestatu");
        costSelectFields.add("fromlogid");
        costSelectFields.add("ismodifybizdate");
        DynamicObjectCollection plannedBills = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)String.join((CharSequence)",", costSelectFields), (QFilter[])new QFilter[]{qfSource, qfbizTime, qfOrgAndCostCenter, qfAppNum, manuOrgQf});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)plannedBills)) {
            return needReturnInfo;
        }
        Map<Long, DynamicObject> plannedMap = this.getPlannedMap(plannedBills);
        for (DynamicObject planned : plannedBills) {
            existBillNos.add(planned.getString("billno"));
            plannedMap.put(planned.getLong("id"), planned);
            needReturnInfo.add(planned.getString("sourcebill") + sign + planned.getString("sourcebillentry"));
        }
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u5df2\u5b58\u5728\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff1a{}", existBillNos);
        HashSet<Long> needDeleteIds = new HashSet<Long>(16);
        HashSet<Long> needDeleteSrcIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> costChangeRecords = new ArrayList<DynamicObject>(16);
        for (DynamicObject planned : plannedBills) {
            String key = planned.getString("sourcebill") + sign + planned.getString("sourcebillentry");
            String newVal = (String)newManuInfo.get(key);
            if (CadEmptyUtils.isEmpty((String)newVal)) {
                if (!CadEmptyUtils.isEmpty((Long)planned.getLong("sourcebill")) && !planned.getBoolean("ismodifybizdate")) {
                    needDeleteIds.add(planned.getLong("id"));
                    needDeleteSrcIds.add(planned.getLong("sourcebill"));
                    needReturnInfo.remove(key);
                }
                if (!CostObjectHelper.isSettlement((Long)planned.getLong("costobject"))) continue;
                costChangeRecords.add(planned);
                continue;
            }
            needReturnInfo.add(key);
            String oldVal = CommonCollConfigService.getBillInfoBySelectFields((DynamicObject)planned, selectFields);
            if (newVal.equals(oldVal)) continue;
            changePlannedMap.put(key, plannedMap.get(planned.getLong("id")));
        }
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u9700\u8981\u5220\u9664\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", needDeleteIds);
        if (needDeleteIds.size() > 0 && needDeleteSrcIds.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cad_plannedoutputbill"), (Object[])needDeleteIds.toArray(new Long[0]));
            this.delChangeRecord(needDeleteSrcIds);
            this.getPlannedContext().setDelNum(this.getPlannedContext().getDelNum() + needDeleteIds.size());
        }
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u9700\u8981\u586b\u5199\u53d8\u66f4\u8bb0\u5f55\u7684\u6761\u6570:{}", (Object)costChangeRecords.size());
        if (costChangeRecords.size() > 0) {
            this.getPlannedContext().getChangeRecords().addAll(costChangeRecords);
        }
        return needReturnInfo;
    }

    protected void setChangeAndSplitLog(Long acctOrg, List<Long> manuOrgs, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, String appNum, List<Long> mftorderentryids, Map<String, Object> collectParamMap) {
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return;
        }
        HashSet<Long> ids = new HashSet<Long>(16);
        HashSet<Long> entryIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> manuBill = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
        for (DynamicObject manu : manuBill) {
            ids.add(manu.getLong("id"));
            entryIds.add(manu.getLong("entryId"));
        }
        String sourcebillEntity = ((DynamicObject)manuBill.get(0)).getString("billtype");
        this.setChangeAndSplitLog(acctOrg, manuOrgs, appNum, mftorderentryids, collectParamMap, sourcebillEntity, ids, entryIds);
    }

    protected void setChangeAndSplitLog(Long acctOrg, List<Long> manuOrgs, String appNum, List<Long> mftorderentryids, Map<String, Object> collectParamMap, String sourcebillEntity, Set<Long> ids, Set<Long> entryIds) {
        DynamicObject sysParamDynamicObject = SysParamHelper.getSysParamDynamicObject((Long)acctOrg, (String)appNum);
        if ("pom_mftorder".equals(sourcebillEntity)) {
            this.getChangeLogDataToCreatePlanDataByLogMap(this.getPlannedContext().getCreatePlanDataByLogMap(), sysParamDynamicObject, ids, entryIds, "pom_xmftorderlog", manuOrgs, mftorderentryids, acctOrg, appNum, collectParamMap);
            this.getSplitLogDataToCreatePlanDataByLogMap(this.getPlannedContext().getCreatePlanDataByLogMap(), sysParamDynamicObject, ids, entryIds, "pom_mftorder_splitlog", manuOrgs, mftorderentryids, acctOrg, appNum, collectParamMap);
        } else {
            this.getChangeLogDataToCreatePlanDataByLogMap(this.getPlannedContext().getCreatePlanDataByLogMap(), sysParamDynamicObject, ids, entryIds, "om_xmftorderlog", manuOrgs, mftorderentryids, acctOrg, appNum, collectParamMap);
            boolean metaDataExist = MetadataDao.checkNumber((String)"om_mftorder_splitog");
            if (metaDataExist) {
                this.getSplitLogDataToCreatePlanDataByLogMap(this.getPlannedContext().getCreatePlanDataByLogMap(), sysParamDynamicObject, ids, entryIds, "om_mftorder_splitog", manuOrgs, mftorderentryids, acctOrg, appNum, collectParamMap);
            }
        }
    }

    protected void delChangeRecord(Set<Long> srcBillIds) {
        QFilter filter = new QFilter("sourcebill", "in", srcBillIds);
        filter.and("bizstatus", "!=", (Object)"B");
        DeleteServiceHelper.delete((String)"sca_costchangerecord", (QFilter[])new QFilter[]{filter});
    }

    @Deprecated
    protected Map<Long, DynamicObject> getPlannedMap(DynamicObjectCollection plannedBill) {
        DynamicObject[] planneds;
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(16);
        HashSet ids = new HashSet(16);
        plannedBill.forEach(p -> ids.add(p.getLong("id")));
        for (DynamicObject planned : planneds = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_plannedoutputbill"))) {
            resultMap.put(planned.getLong("id"), planned);
        }
        return resultMap;
    }

    protected void deleteAll(Long acctOrg, Set<Long> costCenters, String appNum, String[] sourceTypes) {
        QFilter qfSource = new QFilter("source", "not in", (Object)new String[]{"0", "1", "2"});
        if (!CadEmptyUtils.isEmpty((Object[])sourceTypes)) {
            qfSource = qfSource.and(new QFilter("srcbilltype", "in", (Object)sourceTypes));
        }
        QFilter qfOrgAndCostCenter = new QFilter("accountorg", "=", (Object)-1L);
        QFilter qfbizTime = SysParamHelper.getImportTimeScope((Long)acctOrg, (String)"bizdate", (String)appNum);
        if (!CadEmptyUtils.isEmpty((Long)acctOrg)) {
            qfOrgAndCostCenter = new QFilter("accountorg", "=", (Object)acctOrg);
        }
        if (!CadEmptyUtils.isEmpty(costCenters)) {
            qfOrgAndCostCenter = qfOrgAndCostCenter.and(new QFilter("costcenter", "in", costCenters));
        }
        QFilter qfIsmodifybizdate = new QFilter("ismodifybizdate", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection plannedBill = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"id", (QFilter[])new QFilter[]{qfSource, qfOrgAndCostCenter, qfbizTime, qfIsmodifybizdate});
        HashSet deleteIds = new HashSet(16);
        plannedBill.forEach(p -> deleteIds.add(p.getLong("id")));
        if (!CadEmptyUtils.isEmpty(deleteIds)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cad_plannedoutputbill"), (Object[])deleteIds.toArray(new Long[0]));
        }
        this.getPlannedContext().setDelNum(this.getPlannedContext().getDelNum() + deleteIds.size());
    }

    private void getSplitLogDataToCreatePlanDataByLogMap(Map<String, Set<MftOrderLog>> createPlanDataByLogMap, DynamicObject sysParamDynamicObject, Set<Long> srcIdSet, Set<Long> srcEntryIdSet, String entity, List<Long> manuOrgs, List<Long> mftorderentryids, long acctOrg, String appNum, Map<String, Object> collectParamMap) {
        Set<String> propertys = this.getPropertys(entity);
        String dateField = "createtime";
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        if (mainEntityType.findProperty("beginbookdate") != null) {
            dateField = "billentry.beginbookdate";
        }
        QFilter changeStatusQf = null;
        if (propertys.contains("orderstatus")) {
            changeStatusQf = new QFilter("orderstatus", "=", (Object)"C");
        }
        QFilter importTimeScopeQf = SysParamHelper.getImportTimeScope((String)dateField, (DynamicObject)sysParamDynamicObject, (long)acctOrg, (String)appNum);
        if (!CadEmptyUtils.isEmpty(mftorderentryids)) {
            importTimeScopeQf.and("orderentryid", "in", mftorderentryids);
        }
        QFilter manuOrgsQf = null;
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            manuOrgsQf = new QFilter("org", "in", manuOrgs);
        }
        QFilter[] orderLogQf = new QFilter[]{changeStatusQf, importTimeScopeQf, manuOrgsQf};
        logger.info("\u67e5\u8be2\u62c6\u5206\u5355\u7684\u6761\u4ef6{}\uff0c{}\uff0c{}", new Object[]{changeStatusQf, importTimeScopeQf, manuOrgsQf});
        DataSet pom_xmftorderlog = QueryServiceHelper.queryDataSet((String)"getSplitLogDataToCreatePlanDataByLogMap", (String)entity, (String)("id,orderid as srcbillid,orderentryid as srcbillentryid,aftsplitqty as aftqty,befsplitqty as befqty,id as xbillno," + dateField + " as biztime"), (QFilter[])orderLogQf, null).distinct();
        String source = "pom_mftorder_splitlog".equals(entity) ? "7" : "9";
        this.setCreatePlanDataByLogMap(pom_xmftorderlog, srcIdSet, srcEntryIdSet, createPlanDataByLogMap, source);
    }

    private void getChangeLogDataToCreatePlanDataByLogMap(Map<String, Set<MftOrderLog>> createPlanDataByLogMap, DynamicObject sysParamDynamicObject, Set<Long> srcIdSet, Set<Long> srcEntryIdSet, String entity, List<Long> manuOrgs, List<Long> mftorderentryids, long acctOrg, String appNum, Map<String, Object> collectParamMap) {
        String dateField = "biztime";
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        if (mainEntityType.findProperty("beginbookdate") != null) {
            dateField = "beginbookdate";
        }
        QFilter changeStatusQf = new QFilter("changestatus", "=", (Object)"B");
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            changeStatusQf.and(new QFilter("org", "in", manuOrgs));
        }
        QFilter importTimeScopeQf = SysParamHelper.getImportTimeScope((String)dateField, (DynamicObject)sysParamDynamicObject, (long)acctOrg, (String)appNum);
        if (!CadEmptyUtils.isEmpty(mftorderentryids)) {
            importTimeScopeQf.and("srcbillentryid", "in", mftorderentryids);
        }
        if (!CadEmptyUtils.isEmpty(collectParamMap) && collectParamMap.get("startDate") != null && collectParamMap.get("endDate") != null) {
            QFilter collectTimeQFilter = new QFilter(dateField, ">=", collectParamMap.get("startDate"));
            collectTimeQFilter.and(new QFilter(dateField, "<=", collectParamMap.get("endDate")));
            importTimeScopeQf.and(collectTimeQFilter);
        }
        QFilter[] orderLogQf = new QFilter[]{changeStatusQf, importTimeScopeQf};
        logger.info("\u67e5\u8be2\u53d8\u66f4\u5355\u7684\u6761\u4ef6{}\uff0c{}", (Object)changeStatusQf, (Object)importTimeScopeQf);
        DataSet pom_xmftorderlog = QueryServiceHelper.queryDataSet((String)"getChangeLogDataToCreatePlanDataByLogMap", (String)entity, (String)("id,xbillno,srcbillid,srcbillentryid," + dateField + " as biztime,entryentity.qty as qty"), (QFilter[])orderLogQf, null);
        boolean metaDataExist = MetadataDao.checkNumber((String)"om_mftorder_splitog");
        if (metaDataExist) {
            String source = "pom_xmftorderlog".equals(entity) ? "6" : "8";
            this.setCreatePlanDataByLogMap(pom_xmftorderlog, srcIdSet, srcEntryIdSet, createPlanDataByLogMap, source);
        }
    }

    private Set<String> getPropertys(String entryName) {
        return EntityMetadataCache.getDataEntityType((String)entryName).getFields().keySet();
    }

    private void setCreatePlanDataByLogMap(DataSet pom_xmftorderlog, Set<Long> srcIdSet, Set<Long> srcEntryIdSet, Map<String, Set<MftOrderLog>> createPlanDataByLogMap, String source) {
        int count = 0;
        int diffDateCount = 0;
        Map<String, Set<MftOrderLog>> createPlanDataDiffDateByLogMap = this.getPlannedContext().getCreatePlanDataDiffDateByLogMap();
        while (pom_xmftorderlog.hasNext()) {
            Set mftOrderLogSet;
            String billNo;
            Row row = pom_xmftorderlog.next();
            BigDecimal changeQty = null;
            if ("6".equals(source) || "8".equals(source)) {
                String qty = row.getString("qty");
                changeQty = this.parseQty(qty);
                billNo = "bg-";
            } else {
                BigDecimal aftqty = row.getBigDecimal("aftqty");
                BigDecimal befqty = row.getBigDecimal("befqty");
                if (aftqty != null && befqty != null) {
                    changeQty = aftqty.subtract(befqty);
                } else {
                    logger.error("\u5b58\u5728\u62c6\u5206\u65e5\u5fd7\u524d\u540e\u6570\u91cf\u4e3a\u7a7a\u7684\u60c5\u51b5 source{},id{}", (Object)source, row.get("id"));
                }
                billNo = "cf-";
            }
            if (CadEmptyUtils.isEmpty((BigDecimal)changeQty)) {
                this.getPlannedContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u62c6\u5206/\u53d8\u66f4\u5355\u53f7\uff1a%s\u6570\u91cf\u65e0\u53d8\u5316\uff0c\u65e0\u9700\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u3002", (String)"BaseImportDataAction_23", (String)"macc-cad-mservice", (Object[])new Object[0]), row.getString("xbillno")));
                continue;
            }
            Long srcbillid = row.getLong("srcbillid");
            Long srcbillentryid = row.getLong("srcbillentryid");
            String xbillno = row.getString("xbillno");
            Long logId = row.getLong("id");
            Date biztime = row.getDate("biztime");
            String key = srcbillid + "-" + srcbillentryid;
            if (srcIdSet.contains(srcbillid) && srcEntryIdSet.contains(srcbillentryid)) {
                mftOrderLogSet = createPlanDataByLogMap.computeIfAbsent(key, t -> new HashSet(10));
                mftOrderLogSet.add(new MftOrderLog(logId, changeQty, source, billNo + xbillno, biztime));
                ++count;
                continue;
            }
            mftOrderLogSet = createPlanDataDiffDateByLogMap.computeIfAbsent(key, t -> new HashSet(10));
            mftOrderLogSet.add(new MftOrderLog(logId, changeQty, source, billNo + xbillno, biztime));
            ++diffDateCount;
        }
    }

    private BigDecimal parseQty(String qty) {
        if (StringUtils.isEmpty((CharSequence)qty)) {
            return null;
        }
        if (!qty.contains("->")) {
            return null;
        }
        String[] split = qty.trim().replace(" ", "").split("->");
        if (split.length != 2) {
            return null;
        }
        String endQtyStr = split[1];
        if (endQtyStr.endsWith("\u2193") || endQtyStr.endsWith("\u2191")) {
            String substring = endQtyStr.substring(0, endQtyStr.length() - 1);
            try {
                BigDecimal endQty = new BigDecimal(substring);
                BigDecimal startQty = new BigDecimal(split[0]);
                return endQty.subtract(startQty);
            }
            catch (Exception e) {
                logger.error("\u6570\u91cf\u5b57\u7b26\u4e32\u89e3\u6790\u5f02\u5e38,\u53ef\u80fd\u5bfc\u81f4\u90e8\u5206\u5dee\u5f02\u5355\u6570\u91cf\u9519\u8bef", (Throwable)e);
            }
        }
        return null;
    }

    protected String getJoinManuInfo(DynamicObject manu, String join, boolean isSourceBill) {
        StringBuilder sg = new StringBuilder();
        if (isSourceBill) {
            sg.append(manu.getString("billno"));
            sg.append("-");
            sg.append(this.getNotNullField(manu.getString("seq")));
        } else {
            sg.append(manu.getString("billno"));
        }
        sg.append(join);
        sg.append(this.getNotNullField(manu.getString("transmittime")));
        sg.append(join);
        sg.append(this.getNotNullField(manu.getString("planendtime")));
        sg.append(join);
        sg.append(this.getNotNullField(manu.getString("matmasterid")));
        sg.append(join);
        sg.append(this.getNotNullField(manu.getString("unit")));
        sg.append(join);
        sg.append(this.getNotNullField(manu.getString("qty")));
        return sg.toString();
    }

    protected String getJoinManuInfoByStatus(DynamicObject manu, boolean isSourceBill) {
        String closeStatus = "";
        closeStatus = isSourceBill ? ("C".equals(this.getNotNullField(manu.getString("bizstatus"))) ? "1" : "0") : ("true".equals(this.getNotNullField(manu.getString("closestatu"))) ? "1" : "0");
        return closeStatus;
    }

    private String getNotNullField(String args) {
        return args == null ? "0" : args;
    }

    protected Map<String, Set<Long>> getExistCostObjectProBillEntryids(Long acctOrgId, Set<Long> costCenterIds) {
        QFilter filter = new QFilter("org", "=", (Object)acctOrgId);
        filter.and(new QFilter("costcenter", "in", costCenterIds));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"cad_costobject", (String)"org,costcenter,probill", (QFilter[])new QFilter[]{filter});
        HashMap<String, Set<Long>> proBIllIds = new HashMap<String, Set<Long>>(16);
        rows.forEach(p -> proBIllIds.computeIfAbsent(p.getString("org") + p.getString("costcenter"), r -> new HashSet()).add(p.getLong("probill")));
        return proBIllIds;
    }

    protected int save(List<DynamicObject> plannedBills, CollectReport report) {
        int size = 0;
        ArrayList<DynamicObject> needSaves = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> needUpdates = new ArrayList<DynamicObject>();
        if (!CadEmptyUtils.isEmpty(plannedBills)) {
            for (DynamicObject plannedBill : plannedBills) {
                long id = plannedBill.getLong("id");
                if (CadEmptyUtils.isEmpty((Long)id)) {
                    needSaves.add(plannedBill);
                    continue;
                }
                needUpdates.add(plannedBill);
            }
        }
        if (!CadEmptyUtils.isEmpty(needUpdates)) {
            SaveServiceHelper.update((DynamicObject[])needUpdates.toArray(new DynamicObject[0]));
            size += needUpdates.size();
        }
        if (!CadEmptyUtils.isEmpty(needSaves)) {
            OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_plannedoutputbill", (DynamicObject[])needSaves.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!operateResult.isSuccess()) {
                QFilter appNumQf;
                Set entryIds;
                QFilter entryIdQf;
                DynamicObjectCollection exists;
                String errorInfo = OperationResultHelper.errorMsgHandle((OperationResult)operateResult);
                ValidateResultCollection validateResult = operateResult.getValidateResult();
                HashSet errorDataIndexs = validateResult.getErrorDataIndexs();
                HashMap<Long, DynamicObject> entryIdErrorDynamicMap = new HashMap<Long, DynamicObject>(16);
                for (Integer errorDataIndex : errorDataIndexs) {
                    long billEntryId;
                    int i;
                    DynamicObject errorDynamic = (DynamicObject)needSaves.get(errorDataIndex);
                    String billno = errorDynamic.getString("billno");
                    Object srcBillTypeObj = errorDynamic.get("srcbilltype");
                    String srcbilltype = "";
                    srcbilltype = srcBillTypeObj instanceof DynamicObject ? ((DynamicObject)srcBillTypeObj).getString("number") : srcBillTypeObj.toString();
                    if (!StringUtils.isEmpty((CharSequence)billno) && (i = billno.lastIndexOf("-")) != -1) {
                        String srcBillNo = billno.substring(0, i);
                        String seq = billno.substring(i + 1);
                        this.getPlannedContext().logErrorMsg(srcBillNo.concat("@").concat(seq).concat("@").concat(srcbilltype), ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5931\u8d25\u3002", (String)"BaseImportDataAction_79", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    }
                    if (CadEmptyUtils.isEmpty((Long)(billEntryId = errorDynamic.getLong("sourcebillentry")))) continue;
                    entryIdErrorDynamicMap.put(billEntryId, errorDynamic);
                }
                if (!entryIdErrorDynamicMap.isEmpty() && (exists = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"bizdate,sourcebillentry", (QFilter[])new QFilter[]{entryIdQf = new QFilter("sourcebillentry", "in", entryIds = entryIdErrorDynamicMap.keySet()), appNumQf = new QFilter("appnum", "=", (Object)report.getAppNum())})) != null && !exists.isEmpty()) {
                    for (DynamicObject exist : exists) {
                        long sourceBillEntry = exist.getLong("sourcebillentry");
                        DynamicObject dynamicObject = (DynamicObject)entryIdErrorDynamicMap.get(sourceBillEntry);
                        String billNo = dynamicObject.getString("billno");
                        int splitIndex = billNo.lastIndexOf("-");
                        String sourceBillNo = billNo.substring(0, splitIndex);
                        String seq = billNo.substring(splitIndex + 1);
                        if (!CadEmptyUtils.isEmpty((String)seq) && seq.length() > 10) {
                            seq = "1";
                        }
                        String srcBillType = "";
                        Object srcbilltypeObj = dynamicObject.get("srcbilltype");
                        srcBillType = srcbilltypeObj instanceof DynamicObject ? ((DynamicObject)srcbilltypeObj).getString("number") : dynamicObject.getString("srcbilltype");
                        Date bizDate = exist.getDate("bizdate");
                        String bizDateStr = "";
                        if (bizDate != null) {
                            bizDateStr = DateUtils.formatDate((Date)bizDate, (String)"yyyy-MM-dd");
                        }
                        this.getPlannedContext().logErrorMsg(sourceBillNo.concat("@").concat(seq).concat("@").concat(srcBillType), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u5df2\u6b63\u5e38\u5f52\u96c6\uff0c\u8bb0\u8d26\u65e5\u671f\u201c%s\u201d\u3002", (String)"BaseImportDataAction_74", (String)"macc-cad-mservice", (Object[])new Object[0]), bizDateStr));
                    }
                }
                logger.error("\u4fdd\u5b58\u5931\u8d25\u3002" + errorInfo);
                this.getPlannedContext().setValidate(true);
                report.setError(true);
                report.logTip(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u53d1\u73b0\u5f02\u5e38\u3002", (String)"BaseImportDataAction_75", (String)"macc-cad-mservice", (Object[])new Object[0]), errorInfo);
            }
            size += operateResult.getSuccessPkIds().size();
        }
        return size;
    }

    protected DataSet getExistsCompletBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, String srcBillType, String appNum, List<Long> closeBillEntryIds, String timeField, long configId, Set<Long> allCollconfigIds) {
        QFilter orgQf = new QFilter("accountorg", "in", (Object)org);
        QFilter collconfigFilter = new QFilter("collconfig", "=", (Object)configId);
        if (allCollconfigIds != null) {
            collconfigFilter = new QFilter("collconfig", "not in", allCollconfigIds);
        } else if ("pom_mftorder".equals(srcBillType)) {
            orgQf.and(new QFilter("srcbilltype", "in", (Object)new String[]{srcBillType, "pom_xmftorderlog", "pom_mftorder_splitlog"}));
        } else if ("om_mftorder".equals(srcBillType)) {
            orgQf.and(new QFilter("srcbilltype", "in", (Object)new String[]{srcBillType, "om_xmftorderlog", "om_mftorder_splitog"}));
        } else {
            orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
        }
        QFilter costObjectQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter appnumQf = new QFilter("appnum", "=", (Object)appNum);
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            orgQf.and(new QFilter("manuorg", "in", manuOrgs));
        }
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bizdate", (String)appNum);
        HashSet<Long> entryIdSet = new HashSet<Long>(32);
        if (!CadEmptyUtils.isEmpty(closeBillEntryIds)) {
            entryIdSet.addAll(closeBillEntryIds);
        }
        logger.info("\u67e5\u8be2\u5df2\u5b58\u5728\u7684\u5355\u636e\u6761\u4ef6\uff1a{},{}.{}.{},{}", new Object[]{orgQf, costObjectQf, bookDateQf, appnumQf, collconfigFilter});
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"plannedoutputbill", (String)"cad_plannedoutputbill", (String)"id,sourcebillentry", (QFilter[])new QFilter[]{orgQf, costObjectQf, bookDateQf, collconfigFilter, appnumQf}, null);
        if (!CadEmptyUtils.isEmpty(entryIdSet)) {
            DataSet resultCopyDs = resultDs.copy();
            HashSet<Long> existIds = new HashSet<Long>(32);
            for (Row dyn : resultCopyDs) {
                existIds.add(dyn.getLong("sourcebillentry"));
            }
            entryIdSet.removeAll(existIds);
            if (!CadEmptyUtils.isEmpty(entryIdSet)) {
                List splitLists = Lists.partition(new ArrayList(entryIdSet), (int)100000);
                for (List list : splitLists) {
                    bookDateQf = new QFilter("sourcebillentry", "in", (Object)list);
                    DataSet existIdDs = QueryServiceHelper.queryDataSet((String)"plannedoutputbill", (String)"cad_plannedoutputbill", (String)"id,sourcebillentry", (QFilter[])new QFilter[]{orgQf, costObjectQf, bookDateQf, appnumQf}, null);
                    resultDs = resultDs.union(existIdDs);
                }
            }
        }
        return resultDs;
    }

    protected List<Long> getExistsCompletBillId(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, List<Long> mftOrderEntryIds, String srcBillType, String appNum, List<Long> srcBills, String timeField, Map<String, Object> collectParamMap, long configId, Set<Long> allCollconfigIds) {
        DataSet resultDs = this.getExistsCompletBill(org, methodCostCenters, manuOrgs, mftOrderEntryIds, srcBillType, appNum, srcBills, timeField, collectParamMap, configId, allCollconfigIds);
        HashSet<Long> ids = new HashSet<Long>(128);
        if (resultDs != null) {
            for (Row row : resultDs) {
                ids.add(row.getLong("id"));
            }
        }
        return new ArrayList<Long>(ids);
    }

    protected DataSet getExistsCompletBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, List<Long> mftOrderEntryIds, String srcBillType, String appNum, List<Long> closeBillEntryIds, String timeField, Map<String, Object> collectParamMap, long configId, Set<Long> allCollconfigIds) {
        QFilter bookDateQf;
        if (timeField == null) {
            timeField = "treeentryentity.beginbookdate";
        }
        if (CadEmptyUtils.isEmpty(mftOrderEntryIds) && CadEmptyUtils.isEmpty(collectParamMap)) {
            return this.getExistsCompletBill(org, methodCostCenters, manuOrgs, srcBillType, appNum, closeBillEntryIds, timeField, configId, allCollconfigIds);
        }
        QFilter orgQf = new QFilter("accountorg", "in", (Object)org);
        QFilter collconfigFilter = new QFilter("collconfig", "=", (Object)configId);
        if (allCollconfigIds != null) {
            collconfigFilter = new QFilter("collconfig", "not in", allCollconfigIds);
        } else if ("pom_mftorder".equals(srcBillType)) {
            orgQf.and(new QFilter("srcbilltype", "in", (Object)new String[]{srcBillType, "pom_xmftorderlog", "pom_mftorder_splitlog"}));
        } else if ("om_mftorder".equals(srcBillType)) {
            orgQf.and(new QFilter("srcbilltype", "in", (Object)new String[]{srcBillType, "om_xmftorderlog", "om_mftorder_splitog"}));
        } else {
            orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
        }
        QFilter costCenterQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter appnumQf = new QFilter("appnum", "=", (Object)appNum);
        HashSet<Long> entryIdSet = new HashSet<Long>(32);
        if (!CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            if (!CadEmptyUtils.isEmpty(closeBillEntryIds)) {
                entryIdSet.addAll(closeBillEntryIds);
            }
            HashSet<Long> billIds = new HashSet<Long>(mftOrderEntryIds);
            billIds.removeAll(entryIdSet);
            bookDateQf = new QFilter("sourcebillentry", "in", billIds);
        } else if (!CadEmptyUtils.isEmpty(collectParamMap) && collectParamMap.get("startDate") != null && collectParamMap.get("endDate") != null) {
            bookDateQf = new QFilter("bizdate", ">=", collectParamMap.get("startDate"));
            bookDateQf.and(new QFilter("bizdate", "<=", collectParamMap.get("endDate")));
        } else {
            bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bizdate", (String)appNum);
        }
        logger.info("\u67e5\u8be2\u5df2\u5b58\u5728\u7684\u5355\u636e\u6761\u4ef6\uff1a{},{}.{}.{},{}", new Object[]{orgQf, costCenterQf, bookDateQf, appnumQf, collconfigFilter});
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"plannedoutputbill", (String)"cad_plannedoutputbill", (String)"id,sourcebillentry", (QFilter[])new QFilter[]{orgQf, costCenterQf, bookDateQf, collconfigFilter, appnumQf}, null);
        if (!CadEmptyUtils.isEmpty(entryIdSet)) {
            DataSet resultCopyDs = resultDs.copy();
            HashSet<Long> existIds = new HashSet<Long>(32);
            for (Row dyn : resultCopyDs) {
                existIds.add(dyn.getLong("sourcebillentry"));
            }
            entryIdSet.removeAll(existIds);
            DataSet existIdDs = QueryServiceHelper.queryDataSet((String)"plannedoutputbill", (String)"cad_plannedoutputbill", (String)"id,sourcebillentry", (QFilter[])new QFilter[]{orgQf, costCenterQf, new QFilter("sourcebillentry", "in", entryIdSet), appnumQf}, null);
            resultDs = resultDs.union(existIdDs);
        }
        return resultDs;
    }

    protected Map<String, DynamicObject> groupEntryIdCompleteMap(List<Long> sourceBillIds, Set<String> existBillNos, Set<String> srcFields, Map<String, List<String>> identryidMftLogMap) {
        HashMap idEntryIdCompleteMap = Maps.newHashMapWithExpectedSize((int)1024);
        if (CadEmptyUtils.isEmpty(sourceBillIds)) {
            return idEntryIdCompleteMap;
        }
        HashSet<String> selectFieldSet = new HashSet<String>(10);
        if (srcFields != null) {
            selectFieldSet.addAll(srcFields);
        }
        HashSet fields = Sets.newHashSet((Object[])new String[]{"id", "billno", "costobject", "costcenter", "sourcebill", "sourcebillentry", "material", "accountorg", "qty", "sourcebiztime", "bizdate", "closestatu", "closestyle", "closeuser", "fromlogid", "appnum", "billstatus", "source", "totalinqty", "creator", "createtime", "wipqty", "modifier", "modifytime", "auditor", "auditdate", "srcbilltype", "collconfig", "ismodifybizdate"});
        selectFieldSet.addAll(fields);
        String selectFields = String.join((CharSequence)",", selectFieldSet);
        List splitLists = Lists.partition(sourceBillIds, (int)100000);
        for (List list : splitLists) {
            Object[] completionList = BusinessDataServiceHelper.load((String)"cad_plannedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)list)});
            if (CadEmptyUtils.isEmpty((Object[])completionList)) continue;
            for (Object plan : completionList) {
                if (existBillNos != null) {
                    existBillNos.add(plan.getString("billno"));
                }
                if (CadEmptyUtils.isEmpty((Long)plan.getLong("sourcebill"))) continue;
                String identryIdKey = plan.getLong("sourcebill") + "-" + plan.get("sourcebillentry");
                if (!CadEmptyUtils.isEmpty((String)plan.getString("fromlogid"))) {
                    String identryIdLogKey = identryIdKey + "-" + plan.get("fromlogid");
                    if (identryidMftLogMap != null) {
                        identryidMftLogMap.computeIfAbsent(identryIdKey, t -> new ArrayList(10)).add(identryIdLogKey);
                    }
                    idEntryIdCompleteMap.put(identryIdLogKey, plan);
                    continue;
                }
                idEntryIdCompleteMap.put(identryIdKey, plan);
            }
        }
        return idEntryIdCompleteMap;
    }

    protected void dealExitsData(Map<String, DynamicObject> idEntryIdCompleteMap, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, DynamicObject> changePlannedMap, Map<String, DynamicObject> changeStatusMap, Set<String> selectFields, String appNum, Map<String, List<String>> statusChangeCants) {
        if (CadEmptyUtils.isEmpty(idEntryIdCompleteMap) || CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return;
        }
        HashMap<String, String> newManuInfo = new HashMap<String, String>(16);
        HashMap<String, String> newManuInfoByStatus = new HashMap<String, String>(16);
        ArrayList<DynamicObject> manuBill = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
        for (DynamicObject manu : manuBill) {
            DynamicObject targetBill = srcAndTargetBillsMap.get(manu);
            newManuInfo.put(manu.getString("id") + "-" + manu.getString("entryId"), CommonCollConfigService.getBillInfoBySelectFields((DynamicObject)targetBill, selectFields));
            newManuInfoByStatus.put(manu.getString("id") + "-" + manu.getString("entryId"), targetBill.getString("closestatu"));
        }
        HashMap cbStatusChangeMaps = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry<String, DynamicObject> idEntryIdComplete : idEntryIdCompleteMap.entrySet()) {
            Long costobjectId;
            String key = idEntryIdComplete.getKey();
            DynamicObject planned = idEntryIdComplete.getValue();
            String newVal = (String)newManuInfo.get(key);
            String newStatus = (String)newManuInfoByStatus.get(key);
            String oldVal = CommonCollConfigService.getBillInfoBySelectFields((DynamicObject)planned, selectFields);
            String oldStatus = planned.getString("closestatu");
            if (newVal != null && !newVal.equals(oldVal)) {
                changePlannedMap.put(key, planned);
            }
            if (changeStatusMap != null && newStatus != null && !newStatus.equals(oldStatus)) {
                changeStatusMap.put(key, planned);
            }
            if (!"sca".equals(appNum) || !"false".equals(newStatus) || !"true".equals(oldStatus) || CadEmptyUtils.isEmpty((Long)(costobjectId = Long.valueOf(planned.getLong("costobject.id"))))) continue;
            cbStatusChangeMaps.computeIfAbsent(costobjectId, t -> new ArrayList(2)).add(key);
        }
        if (statusChangeCants != null) {
            this.planCancelCloseDeal(cbStatusChangeMaps, statusChangeCants);
        }
    }

    private void planCancelCloseDeal(Map<Long, List<String>> cbStatusChangeMaps, Map<String, List<String>> statusChangeCants) {
        Map costaccountPeriodMap;
        if (cbStatusChangeMaps.isEmpty()) {
            return;
        }
        String bgParam = CadBgParamUtils.getCadBgParamForString((String)"cancelCloseDeal", (String)"true");
        if (!"true".equals(bgParam)) {
            return;
        }
        HashSet settleCostobjectIds = Sets.newHashSetWithExpectedSize((int)10);
        if (!cbStatusChangeMaps.isEmpty()) {
            QFilter costAccountFilter = new QFilter("costobject", "in", cbStatusChangeMaps.keySet());
            costAccountFilter.and("bizstatus", "=", (Object)"B");
            DataSet closeCostObjectDs = QueryServiceHelper.queryDataSet((String)"costobjectaccount", (String)"cad_costobjectaccount", (String)"costobject", (QFilter[])costAccountFilter.toArray(), null);
            for (Row row : closeCostObjectDs) {
                Long costobjectId = row.getLong("costobject");
                settleCostobjectIds.add(costobjectId);
            }
        }
        if (settleCostobjectIds.isEmpty()) {
            return;
        }
        HashSet<Long> allocObjects = new HashSet<Long>(cbStatusChangeMaps.keySet());
        allocObjects.removeAll(settleCostobjectIds);
        for (Long costobjectId : allocObjects) {
            cbStatusChangeMaps.remove(costobjectId);
        }
        HashMap costaccountNameMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap costobjectConfirmMap = Maps.newHashMapWithExpectedSize((int)10);
        HashSet costaccountIds = Sets.newHashSetWithExpectedSize((int)10);
        QFilter filter = new QFilter("costobject", "in", cbStatusChangeMaps.keySet());
        filter.and("bizstatus", "=", (Object)"B");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"costconfirm", (String)"sca_costconfirm", (String)"id,costobject,costaccount,costaccount.name costaccountName,period", (QFilter[])new QFilter[]{filter}, null);
        for (Row row : dataSet) {
            Long costobject = row.getLong("costobject");
            Long l = row.getLong("costaccount");
            Long period = row.getLong("period");
            costaccountIds.add(l);
            costaccountPeriodMap = costobjectConfirmMap.computeIfAbsent(costobject, t -> Maps.newHashMapWithExpectedSize((int)2));
            Long minPeriod = (Long)costaccountPeriodMap.get(l);
            if (minPeriod == null || minPeriod > period) {
                minPeriod = period;
                costaccountPeriodMap.put(l, minPeriod);
            }
            costaccountNameMap.put(l, row.getString("costaccountName"));
        }
        Map costaccountCurPeriodMap = PeriodHelper.getAccountCurrentPeriod((Set)costaccountIds);
        HashSet clearCostobjectIds = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry<Long, List<String>> entry : cbStatusChangeMaps.entrySet()) {
            Long costobjectId = entry.getKey();
            costaccountPeriodMap = (Map)costobjectConfirmMap.get(costobjectId);
            if (costaccountCurPeriodMap.isEmpty()) continue;
            boolean isClear = false;
            for (Map.Entry entry2 : costaccountPeriodMap.entrySet()) {
                Long periodId = (Long)costaccountCurPeriodMap.get(entry2.getKey());
                if (((Long)entry2.getValue()).equals(periodId)) continue;
                isClear = true;
                break;
            }
            if (!isClear) continue;
            ArrayList<String> accountNames = new ArrayList<String>(10);
            for (Long account : costaccountPeriodMap.keySet()) {
                String name = (String)costaccountNameMap.get(account);
                if (CadEmptyUtils.isEmpty((String)name)) continue;
                accountNames.add(name);
            }
            for (Object key : entry.getValue()) {
                statusChangeCants.put((String)key, accountNames);
            }
            clearCostobjectIds.add(costobjectId);
        }
        for (Long l : clearCostobjectIds) {
            cbStatusChangeMaps.remove(l);
        }
        if (cbStatusChangeMaps.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, List<String>> entry : costaccountCurPeriodMap.entrySet()) {
            QFilter cffilter = new QFilter("costobject", "in", cbStatusChangeMaps.keySet());
            cffilter.and("costaccount", "=", (Object)entry.getKey());
            cffilter.and("period", "=", entry.getValue());
            DataSet costconfirmdataSet = QueryServiceHelper.queryDataSet((String)"costconfirm", (String)"sca_costconfirm", (String)"id,costobject,costaccount,period", (QFilter[])cffilter.toArray(), null);
            HashSet ids = Sets.newHashSetWithExpectedSize((int)10);
            for (Row row : costconfirmdataSet) {
                ids.add(row.getLong("id"));
            }
            OperateOption operate = OperateOption.create();
            operate.setVariableValue("periodCheck", "false");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"op_unconfirm", (String)"sca_costconfirm", (Object[])ids.toArray(), (OperateOption)operate);
            cffilter = new QFilter("id", "in", (Object)ids);
            costconfirmdataSet = QueryServiceHelper.queryDataSet((String)"costconfirm", (String)"sca_costconfirm", (String)"id,costobject,costaccount,costaccount.name costaccountname,bizstatus,period", (QFilter[])cffilter.toArray(), null);
            ids = Sets.newHashSetWithExpectedSize((int)10);
            for (Row row : costconfirmdataSet) {
                Long costobejct = row.getLong("costobject");
                if ("B".equals(row.getString("bizstatus"))) {
                    List<String> keys = cbStatusChangeMaps.remove(costobejct);
                    if (keys == null) continue;
                    for (String key : keys) {
                        statusChangeCants.computeIfAbsent(key, t -> new ArrayList(10)).add(row.getString("costaccountname"));
                    }
                    continue;
                }
                ids.add(row.getLong("id"));
            }
            if (ids.isEmpty()) continue;
            Object[] pks = ids.toArray();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"sca_costconfirm");
            DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])pks);
        }
    }

    protected void generateMftOrderLogs(Long acctOrg, Long costCenterId, DynamicObject costObject, Map<String, Set<MftOrderLog>> createPlanDataByLogMap, DynamicObject srcBill, DynamicObject targetBill, Set<String> existsIds, Map<String, DynamicObject> changePlannedMap, List<DynamicObject> plannedBill, Map<String, String> configMappingMap, Map<String, DynamicObject> idEntryIdCompleteMap) {
        String idAndEntryId = srcBill.getString("id") + "-" + srcBill.getString("entryId");
        Set<MftOrderLog> mftOrderLogs = createPlanDataByLogMap.get(idAndEntryId);
        if (mftOrderLogs == null) {
            return;
        }
        int updNum = 0;
        int addNum = 0;
        for (MftOrderLog mftOrderLog : mftOrderLogs) {
            String logKey = idAndEntryId + "-" + mftOrderLog.getLogId();
            boolean existsLogKey = existsIds.contains(logKey);
            boolean isNeedChangeData = changePlannedMap.containsKey(idAndEntryId);
            if (existsLogKey && !isNeedChangeData) {
                this.getPlannedContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u65e5\u5fd7id\u201c%3$s\u201d\u5df2\u5b58\u5728\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_71", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq"), mftOrderLog.getLogId()));
                idEntryIdCompleteMap.remove(logKey);
                logger.info("\u5de5\u5355{}\u884c\u53f7{}\u65e5\u5fd7id{}\u5df2\u5b58\u5728\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", new Object[]{srcBill.getString("billno"), srcBill.getString("entryseq"), mftOrderLog.getLogId()});
                continue;
            }
            CloneUtils cloneUtils = new CloneUtils(true, true);
            DynamicObject logPlan = null;
            if (!existsLogKey) {
                logPlan = (DynamicObject)cloneUtils.clone((IDataEntityBase)targetBill);
                logPlan.set("id", (Object)0L);
                logPlan.set("creator", (Object)RequestContext.get().getCurrUserId());
                logPlan.set("creator_id", (Object)RequestContext.get().getCurrUserId());
                logPlan.set("createtime", (Object)TimeServiceHelper.now());
                logPlan.set("auditor", (Object)RequestContext.get().getCurrUserId());
                logPlan.set("auditor_id", (Object)RequestContext.get().getCurrUserId());
                logPlan.set("auditdate", (Object)TimeServiceHelper.now());
                ++addNum;
            } else {
                ++updNum;
                logPlan = idEntryIdCompleteMap.remove(logKey);
                for (Map.Entry<String, String> configMapping : configMappingMap.entrySet()) {
                    String cost = configMapping.getKey();
                    logPlan.set(cost, targetBill.get(cost));
                }
                logPlan.set("closestatu", targetBill.get("closestatu"));
                logPlan.set("closestyle", targetBill.get("closestyle"));
                logPlan.set("closeuser", targetBill.get("closeuser"));
            }
            logPlan.set("accountorg_id", (Object)acctOrg);
            logPlan.set("costcenter_id", (Object)costCenterId);
            logPlan.set("costobject_id", (Object)costObject.getLong("id"));
            logPlan.set("auxpty_id", (Object)targetBill.getLong("auxpty"));
            logPlan.set("baseunit_id", (Object)targetBill.getLong("baseunit"));
            logPlan.set("bizdate", (Object)targetBill.getDate("bizdate"));
            String billNo = srcBill.getString("billno").concat("-").concat(srcBill.getString("entryseq")).concat("-").concat(String.valueOf(mftOrderLog.getBillNo()));
            if (billNo.length() > 255) {
                billNo = billNo.substring(0, 255);
            }
            logPlan.set("billno", (Object)billNo);
            logPlan.set("qty", (Object)mftOrderLog.getChangeQty());
            BigDecimal totalinQty = logPlan.getBigDecimal("totalinqty") == null ? BigDecimal.ZERO : logPlan.getBigDecimal("totalinqty");
            totalinQty = mftOrderLog.getChangeQty().subtract(totalinQty);
            totalinQty = totalinQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalinQty;
            logPlan.set("wipqty", (Object)totalinQty);
            logPlan.set("fromlogid", (Object)mftOrderLog.getLogId());
            String billtype = "";
            if ("6".equals(mftOrderLog.getSource())) {
                billtype = "pom_xmftorderlog";
            } else if ("7".equals(mftOrderLog.getSource())) {
                billtype = "pom_mftorder_splitlog";
            } else if ("8".equals(mftOrderLog.getSource())) {
                billtype = "om_xmftorderlog";
            } else if ("9".equals(mftOrderLog.getSource())) {
                billtype = "om_mftorder_splitog";
            }
            logPlan.set("srcbilltype", (Object)billtype);
            logPlan.set("srcbilltype_id", (Object)billtype);
            logPlan.set("collconfig_id", targetBill.get("collconfig"));
            logPlan.set("bizdate", (Object)mftOrderLog.getBizTime());
            Object manuorg = targetBill.get("manuorg");
            if (manuorg != null) {
                logPlan.set("manuorg_id", manuorg);
            }
            plannedBill.add(logPlan);
        }
        this.getPlannedContext().setAddNum(this.getPlannedContext().getAddNum() + addNum);
        this.getPlannedContext().setUpdateNum(this.getPlannedContext().getUpdateNum() + updNum);
    }

    protected boolean checkPlanStatus(DynamicObject srcBill, DynamicObject curCostObject, DynamicObject plan) {
        if (plan.get("closestatu") != null && plan.getBoolean("closestatu") && !"C".equals(srcBill.getString("bizstatus")) && CostObjectHelper.isSettlement((Long)curCostObject.getLong("id"))) {
            this.getPlannedContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5bf9\u5e94\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u5df2\u5173\u95ed,\u4f46\u5de5\u5355\u672a\u5173\uff0c\u6838\u7b97\u5bf9\u8c61\u5df2\u7ed3\u7b97\u3002", (String)"BaseImportDataAction_72", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
            logger.info("\u5de5\u5355{}\u884c\u53f7{}\u7684\u5bf9\u5e94\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u5df2\u5173\u95ed,\u4f46\u5de5\u5355\u672a\u5173\uff0c\u6838\u7b97\u5bf9\u8c61\u5df2\u7ed3\u7b97\u4e0d\u518d\u5f15\u5165\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"), (Object)srcBill.getString("entryseq"));
            return true;
        }
        if (plan.get("closestatu") != null && plan.getBoolean("closestatu") && "C".equals(srcBill.getString("bizstatus")) && CostObjectHelper.isSettlement((Long)curCostObject.getLong("id"))) {
            this.getPlannedContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5bf9\u5e94\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u5df2\u5173\u95ed,\u5de5\u5355\u5173\u95ed\uff0c\u6838\u7b97\u5bf9\u8c61\u5df2\u7ed3\u7b97\u3002", (String)"BaseImportDataAction_73", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
            logger.info("\u5de5\u5355{}\u884c\u53f7{}\u7684\u5bf9\u5e94\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u5df2\u5173\u95ed,\u5de5\u5355\u5173\u95ed\uff0c\u6838\u7b97\u5bf9\u8c61\u5df2\u7ed3\u7b97\u4e0d\u518d\u5f15\u5165\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"), (Object)srcBill.getString("entryseq"));
            return true;
        }
        return false;
    }

    protected int deletePlannedBillForNoSrource(Map<String, DynamicObject> idEntryIdCompleteMap) {
        if (CadEmptyUtils.isEmpty(idEntryIdCompleteMap)) {
            return 0;
        }
        Collection<DynamicObject> completeCollection = idEntryIdCompleteMap.values();
        ArrayList<Object> ids = new ArrayList<Object>(10);
        for (DynamicObject obj : completeCollection) {
            ids.add(obj.getPkValue());
        }
        int size = 0;
        try (TXHandle handle = TX.notSupported();){
            OperationServiceHelper.executeOperate((String)"enable", (String)"cad_plannedoutputbill", (Object[])ids.toArray(), (OperateOption)OperateOption.create());
            OperationServiceHelper.executeOperate((String)"unaudit", (String)"cad_plannedoutputbill", (Object[])ids.toArray(), (OperateOption)OperateOption.create());
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"cad_plannedoutputbill", (Object[])ids.toArray(), (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                StringBuilder errorInfo = new StringBuilder();
                for (IOperateInfo operateInfo : allErrorOrValidateInfo) {
                    errorInfo.append(operateInfo.getMessage()).append(";");
                }
                logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u5220\u9664\u5931\u8d25:{}", (Object)SerializationUtils.toJsonString((Object)allErrorOrValidateInfo));
                if (errorInfo.length() > 1) {
                    this.getPlannedContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u5220\u9664\u5931\u8d25\u3002", (String)"BaseImportDataAction_80", (String)"macc-cad-mservice", (Object[])new Object[0]), errorInfo.substring(0, errorInfo.length() - 1));
                }
            }
            size = operationResult.getSuccessPkIds().size();
            this.getPlannedContext().setDelNum(this.getPlannedContext().getDelNum() + size);
            this.getPlannedContext().getChangeRecords().addAll(completeCollection);
            HashSet<Long> deleteSrcData = new HashSet<Long>(10);
            completeCollection.forEach(p -> deleteSrcData.add(p.getLong("sourcebill")));
            this.delChangeRecord(deleteSrcData);
        }
        return size;
    }

    protected void removeExistMftOrderLog(String idAndEntryId, Map<String, DynamicObject> idEntryIdCompleteMap) {
        if (CadEmptyUtils.isEmpty(idEntryIdCompleteMap)) {
            return;
        }
        HashSet existMftOrderLogKeys = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<String, DynamicObject> idEntryIdComplete : idEntryIdCompleteMap.entrySet()) {
            String key = idEntryIdComplete.getKey();
            if (!key.contains(idAndEntryId)) continue;
            existMftOrderLogKeys.add(key);
        }
        if (CadEmptyUtils.isEmpty((Set)existMftOrderLogKeys)) {
            return;
        }
        for (String existMftOrderLogKey : existMftOrderLogKeys) {
            idEntryIdCompleteMap.remove(existMftOrderLogKey);
        }
    }
}

