/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.plannedoutput;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.mservice.plannedoutput.BaseImportDataAction;

public class CompletionSaveAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(CompletionSaveAction.class);

    @Override
    protected void doExecute() {
        this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f52\u96c6\u5230\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355", (String)"CompletionSaveAction_8", (String)"macc-cad-mservice", (Object[])new Object[0]));
        String progressId = this.getPlannedContext().getPlannedArgs().getProgressId();
        List<DynamicObject> planOutBills = this.getPlannedContext().getPlanOutPutBills();
        List billNos = planOutBills.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toList());
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5185\u90e8\u7cfb\u7edf\u5f15\u5165-\u5f15\u5165\u7684\u5f52\u96c6\u5355\u7f16\u53f7\uff1a{}", billNos);
        int saveSize = planOutBills.size();
        int batchSize = 300;
        int successSize = 0;
        if (saveSize <= batchSize * 3) {
            successSize += this.save(planOutBills, this.getPlannedContext().getCollectReport());
        } else {
            int batchCount = saveSize / batchSize + 1;
            for (int i = 0; i < batchCount; ++i) {
                int startCount = i * batchSize;
                int endCount = (i + 1) * batchSize;
                if (i == batchCount - 1) {
                    endCount = saveSize;
                }
                List<DynamicObject> batchBillList = planOutBills.subList(startCount, endCount);
                successSize += this.save(batchBillList, this.getPlannedContext().getCollectReport());
            }
        }
        this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"%s\u6761\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u4fdd\u5b58\u6210\u529f\u3002", (String)"CompletionSaveAction_22", (String)"macc-cad-mservice", (Object[])new Object[0]), successSize));
    }
}

