/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.plannedoutput;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.dto.MftOrderLog;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.plannedoutput.AbstractPlannedAction;
import kd.macc.cad.mservice.plannedoutput.PlannedArgs;

public class CreatePlanDataDiffDateByLogAction
extends AbstractPlannedAction {
    private static final Log logger = LogFactory.getLog(CreatePlanDataDiffDateByLogAction.class);
    private Map<String, DynamicObject> idEntryIdCompleteMap;

    public CreatePlanDataDiffDateByLogAction(Map<String, DynamicObject> idEntryIdCompleteMap) {
        this.idEntryIdCompleteMap = idEntryIdCompleteMap;
    }

    @Override
    protected void doExecute() {
        DynamicObject[] existDiffDatePlanDataNoByLogs;
        this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u5904\u7406\u8de8\u671f\u7684\u53d8\u66f4/\u62c6\u5206\u5355\u636e", (String)"CreatePlanDataDiffDateByLogAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        PlannedArgs plannedArgs = this.getPlannedContext().getPlannedArgs();
        Map<String, Set<MftOrderLog>> createPlanDataDiffDateByLogMap = this.getPlannedContext().getCreatePlanDataDiffDateByLogMap();
        if (CadEmptyUtils.isEmpty(createPlanDataDiffDateByLogMap)) {
            this.getPlannedContext().getCollectReport().logCheckDesc(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u65e5\u5fd7\u9700\u8981\u8de8\u671f\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3002", (String)"CreatePlanDataDiffDateByLogAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]));
            logger.info("\u4e0d\u5b58\u5728\u65e5\u5fd7\u9700\u8981\u8de8\u671f\u751f\u6210 \u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355");
            return;
        }
        Long accountOrgId = plannedArgs.getAccountOrgId();
        List<Long> costCenterIds = plannedArgs.getCostCenterIds();
        String appNum = plannedArgs.getAppNum();
        HashSet<Long> idSet = new HashSet<Long>(createPlanDataDiffDateByLogMap.size());
        HashSet<Long> entryIdtSet = new HashSet<Long>(createPlanDataDiffDateByLogMap.size());
        HashSet formLogIdtSet = new HashSet(createPlanDataDiffDateByLogMap.size());
        for (Map.Entry<String, Set<MftOrderLog>> entry : createPlanDataDiffDateByLogMap.entrySet()) {
            String idAndEntryIdKey = entry.getKey();
            String[] splitStr = idAndEntryIdKey.split("-");
            if (splitStr.length == 2) {
                idSet.add(Long.parseLong(splitStr[0]));
                entryIdtSet.add(Long.parseLong(splitStr[1]));
            } else {
                logger.error("key\u503c\u683c\u5f0f\u4e0d\u6b63\u786e {}", (Object)idAndEntryIdKey);
            }
            Set collect = entry.getValue().stream().map(o -> o.getLogId()).collect(Collectors.toSet());
            formLogIdtSet.addAll(collect);
        }
        QFilter accountOrgQf = new QFilter("accountorg", "=", (Object)accountOrgId);
        QFilter costCenterQf = new QFilter("costcenter", "in", costCenterIds);
        QFilter appnumQf = new QFilter("appnum", "=", (Object)appNum);
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter sourceBillQf = new QFilter("sourcebill", "in", idSet);
        QFilter sourceEntryIdtQf = new QFilter("sourcebillentry", "in", entryIdtSet);
        QFilter[] qFilters = new QFilter[]{sourceBillQf, sourceEntryIdtQf, accountOrgQf, costCenterQf, appnumQf, billStatusQf};
        DynamicObject[] existDiffDatePlanData = BusinessDataServiceHelper.load((String)"cad_plannedoutputbill", (String)"id,fromlogid,sourcebill,sourcebillentry", (QFilter[])qFilters);
        idSet.clear();
        for (DynamicObject existDiffDatePlanDatum : existDiffDatePlanData) {
            Long sourcebill = existDiffDatePlanDatum.getLong("sourcebill");
            Long sourcebillentry = existDiffDatePlanDatum.getLong("sourcebillentry");
            Long fromlogid = existDiffDatePlanDatum.getLong("fromlogid");
            String key = sourcebill + "-" + sourcebillentry + "-" + fromlogid;
            if (formLogIdtSet.remove(fromlogid)) {
                logger.info("\u5355\u636e fromlogid {} \u5df2\u7ecf\u751f\u6210 id{} \u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u6570\u636e", (Object)fromlogid, (Object)existDiffDatePlanDatum.getLong("id"));
                this.idEntryIdCompleteMap.remove(key);
                continue;
            }
            if (!CadEmptyUtils.isEmpty((Long)fromlogid)) continue;
            idSet.add(existDiffDatePlanDatum.getLong("id"));
        }
        if (idSet.size() < 1 || formLogIdtSet.size() < 1) {
            this.getPlannedContext().getCollectReport().logCheckDesc(ResManager.loadKDString((String)"\u8de8\u671f\u53d8\u66f4/\u62c6\u5206\u5355\u6e90\u5355\u672a\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3002", (String)"CreatePlanDataDiffDateByLogAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> saveDiffDatePlanDataByLog = new ArrayList<DynamicObject>(idSet.size() * 2);
        List<DynamicObject> planOutPutBills = this.getPlannedContext().getPlanOutPutBills();
        Set<String> willSavePlanBillNoSet = planOutPutBills.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
        for (DynamicObject existDiffDatePlanDataNoByLog : existDiffDatePlanDataNoByLogs = BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_plannedoutputbill"))) {
            Long sourcebill = existDiffDatePlanDataNoByLog.getLong("sourcebill");
            Long sourcebillentry = existDiffDatePlanDataNoByLog.getLong("sourcebillentry");
            String key = sourcebill + "-" + sourcebillentry;
            Set<MftOrderLog> mftOrderLogs = createPlanDataDiffDateByLogMap.get(key);
            if (CadEmptyUtils.isEmpty(mftOrderLogs)) {
                logger.error("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u65e5\u5fd7\u751f\u6210\u6570\u636e {}", (Object)key);
                continue;
            }
            for (MftOrderLog mftOrderLog : mftOrderLogs) {
                DynamicObject plan;
                if (!formLogIdtSet.contains(mftOrderLog.getLogId()) || (plan = this.createDiffDatePlanBill(existDiffDatePlanDataNoByLog, mftOrderLog, willSavePlanBillNoSet)) == null) continue;
                saveDiffDatePlanDataByLog.add(plan);
            }
        }
        if (saveDiffDatePlanDataByLog.size() < 1) {
            this.getPlannedContext().getCollectReport().logCheckDesc(ResManager.loadKDString((String)"\u8de8\u671f\u53d8\u66f4/\u62c6\u5206\u5355\u5171\u751f\u62100\u6761\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3002", (String)"CreatePlanDataDiffDateByLogAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
            logger.info("\u672c\u6b21\u65e5\u5fd7\u672a\u751f\u6210\u8de8\u671f \u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355");
            return;
        }
        this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u8de8\u671f\u53d8\u66f4/\u62c6\u5206\u5355\u5171\u751f\u6210%s\u6761\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3002", (String)"CreatePlanDataDiffDateByLogAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), saveDiffDatePlanDataByLog.size()));
        this.getPlannedContext().getPlanOutPutBills().addAll(saveDiffDatePlanDataByLog);
        this.getPlannedContext().setAddNum(this.getPlannedContext().getAddNum() + saveDiffDatePlanDataByLog.size());
    }

    private DynamicObject createDiffDatePlanBill(DynamicObject existDiffDatePlanDataNoByLog, MftOrderLog mftOrderLog, Set<String> willSavePlanBillNoSet) {
        DynamicObject logPlanBillData = (DynamicObject)OrmUtils.clone((Object)existDiffDatePlanDataNoByLog, (IDataEntityType)existDiffDatePlanDataNoByLog.getDataEntityType(), (boolean)true, (boolean)true);
        String billNo = existDiffDatePlanDataNoByLog.getString("billno");
        if ((billNo = billNo.concat("-").concat(String.valueOf(mftOrderLog.getBillNo()))).length() > 255) {
            billNo = billNo.substring(0, 255);
        }
        if (willSavePlanBillNoSet.contains(billNo)) {
            logger.info("\u8de8\u671f\u5dee\u5f02\u5355\u5355\u636e\u7f16\u53f7{}\u5df2\u5b58\u5728\u540c\u6279\u6b21\u5176\u4ed6\u6210\u672c\u4e2d\u5fc3\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u5355\u636e\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)billNo);
            return null;
        }
        logPlanBillData.set("billno", (Object)billNo);
        logPlanBillData.set("bizdate", (Object)mftOrderLog.getBizTime());
        logPlanBillData.set("qty", (Object)mftOrderLog.getChangeQty());
        BigDecimal totalinQty = logPlanBillData.getBigDecimal("totalinqty") == null ? BigDecimal.ZERO : logPlanBillData.getBigDecimal("totalinqty");
        totalinQty = mftOrderLog.getChangeQty().subtract(totalinQty);
        totalinQty = totalinQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalinQty;
        logPlanBillData.set("wipqty", (Object)totalinQty);
        logPlanBillData.set("fromlogid", (Object)mftOrderLog.getLogId());
        logPlanBillData.set("source", (Object)mftOrderLog.getSource());
        return logPlanBillData;
    }
}

