/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.plannedoutput;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.business.config.service.CostObjectService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.plannedoutput.AbstractPlannedAction;
import kd.macc.cad.mservice.plannedoutput.PlannedArgs;

public class PlannedBuildConditionAction
extends AbstractPlannedAction {
    private static final Log logger = LogFactory.getLog(PlannedBuildConditionAction.class);

    @Override
    protected void doExecute() {
        PlannedArgs plannedArgs = this.getPlannedContext().getPlannedArgs();
        Long accountOrgId = plannedArgs.getAccountOrgId();
        List<Long> costCenterIds = plannedArgs.getCostCenterIds();
        List<Long> mftOrderEntryIds = plannedArgs.getMftOrderEntryIds();
        Map<Long, Set<Long>> acctOrgCostCentersMap = this.getPlannedContext().getAcctOrgCostCentersMap();
        Map<String, List<Long>> acctOrgCalmethodCostCentersMap = this.getPlannedContext().getAcctOrgCalmethodCostCenters();
        String appNum = plannedArgs.getAppNum();
        int totalNum = "aca".equals(appNum) ? 24 : 5;
        this.refreshProgress(ResManager.loadKDString((String)"\u5df2\u6784\u5efa\u6761\u4ef6\uff0c\u5f00\u59cb\u5f52\u96c6\u3002", (String)"PlannedBuildConditionAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, totalNum, false);
        List importScopeDate = SysParamHelper.getImportScopeDate((Long)accountOrgId, (String)appNum);
        this.getPlannedContext().getOrgImportScopeDate().put(accountOrgId, importScopeDate);
        List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)Long.parseLong(RequestContext.get().getUserId()), Collections.singletonList(accountOrgId), (Set)Sets.newHashSet(costCenterIds), (String)"cad_plannedoutputbill", (String)appNum);
        HashSet costCenterSet = new HashSet(enableCostCenters);
        acctOrgCostCentersMap.put(accountOrgId, costCenterSet);
        Map rulesMap = null;
        Map costCenterByRules = null;
        Map dimensionAndRuleMap = null;
        if (ImportServiceHelper.isStartCollConfigScheme().booleanValue()) {
            dimensionAndRuleMap = CostObjectService.getDimensionAndRuleMap();
            rulesMap = CostObjectHelper.getCostObjectRulesMap((Long)accountOrgId, (List)enableCostCenters);
            costCenterByRules = CostObjectHelper.groupCostCenterByRules((List)enableCostCenters, (Map)rulesMap);
            CostCenterHelper.getWorkCenter(costCenterIds, (List)importScopeDate, (CollectReport)this.getPlannedContext().getCollectReport());
            CostCenterHelper.getAdminOrg(costCenterIds, (List)importScopeDate, (CollectReport)this.getPlannedContext().getCollectReport());
            CostCenterHelper.getBosOrgs(costCenterIds, (List)importScopeDate, (CollectReport)this.getPlannedContext().getCollectReport());
        } else {
            rulesMap = CostObjectHelper.getRulesMap((Long)accountOrgId, (List)enableCostCenters);
            costCenterByRules = CostObjectHelper.groupCostCenterByRules((Long)accountOrgId, (List)enableCostCenters, (Map)rulesMap);
        }
        if (CadEmptyUtils.isEmpty((Map)costCenterByRules)) {
            MsgUtils.putMsg2Map((String)"tip", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"PlannedBuildConditionAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), this.getPlannedContext().getResponseInfo());
            this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"PlannedBuildConditionAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
            return;
        }
        acctOrgCalmethodCostCentersMap.putAll(costCenterByRules);
        this.getPlannedContext().getAcctOrgObjRules().putAll(rulesMap);
        if (!CadEmptyUtils.isEmpty((Map)dimensionAndRuleMap)) {
            this.getPlannedContext().getDimensionAndRuleMap().putAll(dimensionAndRuleMap);
        }
        if (CadEmptyUtils.isEmpty(plannedArgs.getCollectParamMap()) && CadEmptyUtils.isEmpty(mftOrderEntryIds) && CostObjectService.containNotOrderTypeRule((Long)accountOrgId, (Map)costCenterByRules) && "1".equals(CadBgParamUtils.getCadBgParamForString((String)"autoGenCostObject", (String)"1"))) {
            CostObjectService.generateCostObject((Long)accountOrgId, costCenterIds, plannedArgs.getManuOrgs(), null, (String)plannedArgs.getAppNum(), (CollectReport)this.getPlannedContext().getCollectReport());
        }
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\uff0c\u83b7\u53d6\u6e90\u5355\u53c2\u6570\u3002\u6838\u7b97\u7ec4\u7ec7\u5bf9\u5e94\u6210\u672c\u4e2d\u5fc3\u6761\u6570", (Object)acctOrgCostCentersMap.size());
    }
}

