/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.plannedoutput;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.CollectDiff;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.DiffHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.costobject.CostObjectDiffAction;
import kd.macc.cad.mservice.plannedoutput.AbstractPlannedAction;

public class PlannedDiffAction
extends AbstractPlannedAction {
    private final Log logger = LogFactory.getLog(PlannedDiffAction.class);
    private List<Long> roCostCenters = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzCostCenters = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> notRoWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> notRoOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> notRoAdmin = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> roWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> roOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> roAdmin = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzAdmin = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> selectedWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> selectedOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> selectedAdminOrg = Lists.newArrayListWithExpectedSize((int)8);
    private Map<Long, String> costCenterNameMap = Maps.newHashMapWithExpectedSize((int)32);

    @Override
    protected void doExecute() {
        String progressId = this.getPlannedContext().getPlannedArgs().getProgressId();
        if (!CollectReportHelper.disableCollectReport() && !kd.bos.orm.util.StringUtils.isEmpty((Object)progressId)) {
            List flmCostCenters;
            List fpmCostCenters;
            List pzmCostCenters;
            Map calMethodCostCenters;
            String appNum;
            CollectReport collectReport = this.getPlannedContext().getCollectReport();
            Long orgId = this.getPlannedContext().getCollectReport().getOrg();
            QFilter timeQf = DiffHelper.getCollectTimeRange((Long)orgId, (String)"treeentryentity.beginbookdate", (String)(appNum = this.getPlannedContext().getPlannedArgs().getAppNum()), (CollectReport)collectReport);
            if (timeQf == null) {
                this.logger.info("\u672a\u83b7\u53d6\u5230\u6838\u7b97\u7ec4\u7ec7\u914d\u7f6e\u7684\u5f52\u96c6\u65f6\u95f4\u8303\u56f4");
                return;
            }
            this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u68c0\u67e5\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02", (String)"PlannedDiffAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            List enableCostCenters = DiffHelper.getEnableCostCenters((Long)orgId, (String)"cad_plannedoutputbill", (String)appNum);
            List<Long> costCenters = this.getPlannedContext().getPlannedArgs().getCostCenterIds();
            List<Map<String, Date>> importScopeDate = this.getPlannedContext().getOrgImportScopeDate().get(orgId);
            if (costCenters != null && !costCenters.isEmpty() && enableCostCenters.size() != costCenters.size()) {
                this.getPlannedContext().setSingleSelected(true);
                this.selectedWc = CostCenterHelper.getWorkCenter(costCenters, importScopeDate);
                this.selectedOrg = CostCenterHelper.getBosOrgs(costCenters, importScopeDate);
                this.selectedAdminOrg = CostCenterHelper.getAdminOrg(costCenters, importScopeDate);
            }
            if ((calMethodCostCenters = DiffHelper.getCalMethodCostCenters((Long)orgId, (String)"cad_plannedoutputbill", (String)appNum)) == null || calMethodCostCenters.isEmpty()) {
                this.logger.info("\u672a\u83b7\u53d6\u5230\u8ba1\u7b97\u65b9\u6cd5\u4e0e\u6210\u672c\u4e2d\u5fc3\u7684\u5bf9\u5e94\u5173\u7cfb");
                return;
            }
            ArrayList allCostCenters = Lists.newArrayListWithExpectedSize((int)32);
            ArrayList fpflCostCenters = Lists.newArrayListWithExpectedSize((int)8);
            List roCostCenters = (List)calMethodCostCenters.get(orgId + CostObjectEnum.BIZTYPE_RO.getValue());
            if (roCostCenters != null && !roCostCenters.isEmpty()) {
                this.roCostCenters.addAll(roCostCenters);
                allCostCenters.addAll(roCostCenters);
                this.roWc = CostCenterHelper.getWorkCenter(this.roCostCenters, importScopeDate, (CollectReport)collectReport);
                this.roOrg = CostCenterHelper.getBosOrgs(this.roCostCenters, importScopeDate, (CollectReport)collectReport);
                this.roAdmin = CostCenterHelper.getAdminOrg(this.roCostCenters, importScopeDate, (CollectReport)collectReport);
            }
            if ((pzmCostCenters = (List)calMethodCostCenters.get(orgId + CostObjectEnum.BIZTYPE_PZ.getValue())) != null && !pzmCostCenters.isEmpty()) {
                this.pzCostCenters.addAll(pzmCostCenters);
                allCostCenters.addAll(pzmCostCenters);
                this.pzWc = CostCenterHelper.getWorkCenter(this.pzCostCenters, importScopeDate, (CollectReport)collectReport);
                this.pzOrg = CostCenterHelper.getBosOrgs(this.pzCostCenters, importScopeDate, (CollectReport)collectReport);
                this.pzAdmin = CostCenterHelper.getAdminOrg(this.pzCostCenters, importScopeDate, (CollectReport)collectReport);
            }
            if ((fpmCostCenters = (List)calMethodCostCenters.get(orgId + CostObjectEnum.BIZTYPE_SO.getValue())) != null && !fpmCostCenters.isEmpty()) {
                fpflCostCenters.addAll(fpmCostCenters);
                allCostCenters.addAll(fpmCostCenters);
            }
            if ((flmCostCenters = (List)calMethodCostCenters.get(orgId + CostObjectEnum.BIZTYPE_FL.getValue())) != null && !flmCostCenters.isEmpty()) {
                fpflCostCenters.addAll(flmCostCenters);
                allCostCenters.addAll(flmCostCenters);
            }
            if (fpflCostCenters != null && !fpflCostCenters.isEmpty()) {
                this.notRoWc = CostCenterHelper.getWorkCenter((Collection)fpflCostCenters, importScopeDate, (CollectReport)collectReport);
                this.notRoOrg = CostCenterHelper.getBosOrgs((Collection)fpflCostCenters, importScopeDate, (CollectReport)collectReport);
                this.notRoAdmin = CostCenterHelper.getAdminOrg((Collection)fpflCostCenters, importScopeDate, (CollectReport)collectReport);
            }
            this.costCenterNameMap = DiffHelper.getCostCenterNameMap((List)allCostCenters);
            collectReport.setTimeQf(timeQf);
            timeQf.or("treeentryentity.beginbookdate", "is null", null);
            HashSet mftTransactions = Sets.newHashSetWithExpectedSize((int)8);
            HashSet outTransactions = Sets.newHashSetWithExpectedSize((int)8);
            Map unNeedBillTransactionsMap = DiffHelper.getUnNeedBillTransactionsMap((Long)orgId, (String)"cad_plannedoutputbill", (String)appNum);
            if (unNeedBillTransactionsMap != null && !unNeedBillTransactionsMap.isEmpty()) {
                for (Map.Entry billTransactions : unNeedBillTransactionsMap.entrySet()) {
                    String billId = (String)billTransactions.getKey();
                    Set transactions = (Set)billTransactions.getValue();
                    if ("pom_mftorder".equals(billId)) {
                        mftTransactions.addAll(transactions);
                    } else {
                        outTransactions.addAll(transactions);
                    }
                    collectReport.getTransactionTypes().addAll(transactions);
                }
            }
            HashSet objMftTransactions = Sets.newHashSetWithExpectedSize((int)8);
            HashSet objOutTransactions = Sets.newHashSetWithExpectedSize((int)8);
            Map unNeedBillObjMap = DiffHelper.getUnNeedBillTransactionsMap((Long)orgId, (String)"cad_costobject", (String)appNum);
            if (unNeedBillObjMap != null && !unNeedBillObjMap.isEmpty()) {
                for (Map.Entry entry : unNeedBillObjMap.entrySet()) {
                    String billId = (String)entry.getKey();
                    Set transactions = (Set)entry.getValue();
                    if ("pom_mftorder".equals(billId)) {
                        objMftTransactions.addAll(transactions);
                        continue;
                    }
                    objOutTransactions.addAll(transactions);
                }
            }
            Map costCenterRangeMap = DiffHelper.getCostCenterRangeBillMap((Long)orgId, (List)allCostCenters, (String)"plancollectrange", (String)appNum);
            if ("sca".equals(appNum) && roCostCenters != null && !roCostCenters.isEmpty()) {
                for (Long roCostCenter : roCostCenters) {
                    collectReport.getCcRangeMap().put(roCostCenter, "SCGD,WWGD");
                }
            }
            int n = this.diffMftOrder(orgId, mftTransactions, objMftTransactions, costCenterRangeMap, appNum);
            int outSize = this.diffOutOrder(orgId, outTransactions, objOutTransactions, costCenterRangeMap, appNum);
            int changeSize = this.diffChangeLog();
            int splitSize = this.diffSplitLog();
            this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u5dee\u5f02%1$s\u6761\u6570\u636e\uff0c\u59d4\u5916\u5de5\u5355\u5dee\u5f02%2$s\u6761\u6570\u636e\u3002\u751f\u4ea7/\u59d4\u5916\u5de5\u5355\u53d8\u66f4\u5355\u5dee\u5f02%3$s\u6761\u6570\u636e\uff0c\u751f\u4ea7/\u59d4\u5916\u5de5\u5355\u62c6\u5206\u5dee\u5f02%4$s\u6761\u6570\u636e\u3002", (String)"PlannedDiffAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]), n, outSize, changeSize, splitSize));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getPlannedContext().getCollectReport().transfer2Dynamic()});
        }
    }

    private int diffSplitLog() {
        DataSet omSplitLogDs;
        ArrayList splitDiffs = Lists.newArrayListWithExpectedSize((int)8);
        Long orgId = this.getPlannedContext().getCollectReport().getOrg();
        QFilter orderStatusQf = new QFilter("orderstatus", "=", (Object)"C");
        QFilter orgQf = new QFilter("org", "in", this.getPermProOrgs());
        QFilter timeQf = SysParamHelper.getImportTimeScope((Long)orgId, (String)"createtime", (String)this.getPlannedContext().getPlannedArgs().getAppNum());
        DataSet pomSplitLogDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pom_mftorder_splitlog", (String)"id,orderid as srcbillid,orderentryid as srcbillentryid,aftsplitqty as aftqty,befsplitqty as befqty,orderno as xbillno,'splitlog' as billtype", (QFilter[])new QFilter[]{orderStatusQf, orgQf, timeQf}, (String)"id desc");
        DataSet splitLogDs = pomSplitLogDs.union(omSplitLogDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"om_mftorder_splitog", (String)"id,orderid as srcbillid,orderentryid as srcbillentryid,aftsplitqty as aftqty,befsplitqty as befqty,orderno as xbillno,'splitlog' as billtype", (QFilter[])new QFilter[]{orderStatusQf, orgQf, timeQf}, (String)"id desc"));
        if (!splitLogDs.isEmpty()) {
            DataSet copy = splitLogDs.copy();
            HashSet ids = Sets.newHashSetWithExpectedSize((int)8);
            for (Row splitLog : copy) {
                ids.add(splitLog.getLong("id"));
            }
            DataSet plannedDataSet = this.getPlannedDataSetByLogId(orgId, ids);
            splitLogDs = splitLogDs.leftJoin(plannedDataSet).on("id", "fromlogid").on("srcbillid", "sourcebill").on("srcbillentryid", "sourcebillentry").select(splitLogDs.getRowMeta().getFieldNames(), plannedDataSet.getRowMeta().getFieldNames()).finish();
            splitLogDs = splitLogDs.filter("fromlogid  is null or fromlogid = 0").orderBy(new String[]{"id desc"});
            for (Row row : splitLogDs) {
                CollectDiff collectDiff;
                String billNo = row.getString("xbillno");
                BigDecimal aftQty = row.getBigDecimal("aftqty");
                BigDecimal befQty = row.getBigDecimal("befqty");
                String billType = row.getString("billtype");
                if (aftQty != null && befQty != null) {
                    collectDiff = new CollectDiff(billNo, billType, ResManager.loadKDString((String)"\u6e90\u5de5\u5355\u672a\u751f\u6210\u5f52\u96c6\u5355\u3002", (String)"PlannedDiffAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    splitDiffs.add(collectDiff);
                    continue;
                }
                collectDiff = new CollectDiff(billNo, billType, ResManager.loadKDString((String)"\u5b58\u5728\u62c6\u5206\u65e5\u5fd7\u524d\u540e\u6570\u91cf\u4e3a\u7a7a\u7684\u60c5\u51b5\u3002", (String)"PlannedDiffAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
                splitDiffs.add(collectDiff);
            }
        }
        return splitDiffs.size();
    }

    private int diffChangeLog() {
        ArrayList changeLogDiffs = Lists.newArrayListWithExpectedSize((int)8);
        Long orgId = this.getPlannedContext().getCollectReport().getOrg();
        ArrayList allOrg = Lists.newArrayList((Object[])new Long[]{orgId});
        QFilter changeStatusQf = new QFilter("changestatus", "=", (Object)"B");
        QFilter orgQf = new QFilter("org", "in", this.getPermProOrgs());
        QFilter timeQf = SysParamHelper.getImportTimeScope((Long)orgId, (String)"createtime", (String)this.getPlannedContext().getPlannedArgs().getAppNum());
        DataSet orderChangeLog = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pom_xmftorderlog", (String)"id,xbillno,srcbillid,srcbillentryid,entryentity.qty as qty,'changelog' as billtype", (QFilter[])new QFilter[]{orgQf, changeStatusQf, timeQf}, (String)"id desc");
        if (!orderChangeLog.isEmpty()) {
            DataSet copy = orderChangeLog.copy();
            HashSet ids = Sets.newHashSetWithExpectedSize((int)8);
            for (Row row : copy) {
                ids.add(row.getLong("id"));
            }
            DataSet plannedDataSet = this.getPlannedDataSetByLogId(orgId, ids);
            orderChangeLog = orderChangeLog.leftJoin(plannedDataSet).on("id", "fromlogid").on("srcbillid", "sourcebill").on("srcbillentryid", "sourcebillentry").select(orderChangeLog.getRowMeta().getFieldNames(), plannedDataSet.getRowMeta().getFieldNames()).finish();
            orderChangeLog = orderChangeLog.filter("fromlogid  is null or fromlogid = 0").orderBy(new String[]{"id desc"});
            for (Row row : orderChangeLog) {
                String billNo = row.getString("xbillno");
                String qty = row.getString("qty");
                String billType = row.getString("billtype");
                BigDecimal changeQty = this.parseQty(qty);
                if (CadEmptyUtils.isEmpty((BigDecimal)changeQty)) continue;
                CollectDiff collectDiff = new CollectDiff(billNo, billType, ResManager.loadKDString((String)"\u6e90\u5de5\u5355\u672a\u751f\u6210\u5f52\u96c6\u5355\u3002", (String)"PlannedDiffAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
                changeLogDiffs.add(collectDiff);
            }
        }
        if (changeLogDiffs.size() > 0) {
            this.getPlannedContext().getCollectReport().getCollectDiffs().addAll(changeLogDiffs);
            this.getPlannedContext().getCollectReport().setError(true);
        }
        return changeLogDiffs.size();
    }

    private BigDecimal parseQty(String qty) {
        if (StringUtils.isEmpty((CharSequence)qty)) {
            return null;
        }
        if (!qty.contains("->")) {
            return null;
        }
        String[] split = qty.trim().replace(" ", "").split("->");
        if (split.length != 2) {
            return null;
        }
        String endQtyStr = split[1];
        if (endQtyStr.endsWith("\u2193") || endQtyStr.endsWith("\u2191")) {
            String substring = endQtyStr.substring(0, endQtyStr.length() - 1);
            try {
                BigDecimal endQty = new BigDecimal(substring);
                BigDecimal startQty = new BigDecimal(split[0]);
                return endQty.subtract(startQty);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u91cf\u5b57\u7b26\u4e32\u89e3\u6790\u5f02\u5e38,\u53ef\u80fd\u5bfc\u81f4\u90e8\u5206\u5dee\u5f02\u5355\u6570\u91cf\u9519\u8bef\u3002", (String)"PlannedDiffAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]));
            }
        }
        return null;
    }

    private int diffMftOrder(Long orgId, Set<Long> mftTransactions, Set<Long> objMftTransactions, Map<Long, String> costCenterRangeMap, String appNum) {
        ArrayList mftDiffs = Lists.newArrayListWithExpectedSize((int)8);
        DataSet mftOrderDs = this.getMftDataSet();
        if (!mftOrderDs.isEmpty()) {
            DataSet mftCopy = mftOrderDs.copy();
            HashSet entryIds = Sets.newHashSetWithExpectedSize((int)8);
            for (Row row : mftCopy) {
                entryIds.add(row.getLong("entryid"));
            }
            DataSet planDs = this.getPlannedDataSet(orgId, entryIds, appNum);
            DataSet result = mftOrderDs.leftJoin(planDs).on("entryid", "sourcebillentry").select(mftOrderDs.getRowMeta().getFieldNames(), planDs.getRowMeta().getFieldNames()).finish().filter("sourcebillentry is null or sourcebillentry = 0").orderBy(new String[]{"id desc"});
            for (Row row : result) {
                Map billNoReasonMap;
                String srcErrorMsg;
                String taskstatus = row.getString("taskstatus");
                Long transactionType = row.getLong("transactiontype");
                StringBuilder reasonStr = new StringBuilder();
                CollectDiff collectDiff = new CollectDiff(row.getString("billno"), row.getInteger("seq"), row.getString("billtype"), row.getDate("transmittime"));
                if ("A".equals(taskstatus)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u4e3a\u672a\u5f00\u5de5\u3002", (String)"PlannedDiffAction_18", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (mftTransactions != null && mftTransactions.contains(transactionType)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5f52\u96c6\u201d\u3002", (String)"PlannedDiffAction_7", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (objMftTransactions != null && objMftTransactions.contains(transactionType)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5f52\u96c6\u201d\u3002", (String)"PlannedDiffAction_8", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (!kd.bos.orm.util.StringUtils.isEmpty((Object)(srcErrorMsg = this.checkCostCenterSrcMft(costCenterRangeMap, row, appNum)))) {
                    reasonStr.append(srcErrorMsg).append("\uff1b");
                }
                if (!(billNoReasonMap = this.getPlannedContext().getErrorInfMap()).isEmpty() && billNoReasonMap.containsKey(row.getString("billno").concat("@").concat(row.getString("seq")))) {
                    reasonStr.append((String)billNoReasonMap.get(row.getString("billno").concat("@").concat(row.getString("seq"))));
                }
                String billType = row.getString("billtype");
                collectDiff.setBillType(billType);
                if (reasonStr.length() > 1) {
                    collectDiff.setReason(reasonStr.toString());
                } else {
                    collectDiff.setReason(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0", (String)"PlannedDiffAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]));
                }
                mftDiffs.add(collectDiff);
            }
        }
        if (mftDiffs.size() > 0) {
            this.getPlannedContext().getCollectReport().getCollectDiffs().addAll(mftDiffs);
            this.getPlannedContext().getCollectReport().setError(true);
        }
        return mftDiffs.size();
    }

    private DataSet getMftDataSet() {
        QFilter orgFilter = new QFilter("org", "in", this.getPermProOrgs());
        QFilter timeQf = this.getPlannedContext().getCollectReport().getTimeQf();
        String selectFields = "id,billno,treeentryentity.id entryid,treeentryentity.seq seq,treeentryentity.material.masterid material,treeentryentity.taskstatus taskstatus,transactiontype,treeentryentity.workcenter workcenter,0 gxworkcenter,org,treeentryentity.producedept producedept,treeentryentity.beginbookdate transmittime,0 as probill,'mftorder' as billtype";
        DataSet mftData = QueryServiceHelper.queryDataSet((String)CostObjectDiffAction.class.getName(), (String)"pom_mftorder", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, timeQf}, (String)"id desc");
        if (!mftData.isEmpty()) {
            DataSet copy = mftData.copy();
            HashSet entryIds = Sets.newHashSetWithExpectedSize((int)8);
            for (Row row : copy) {
                entryIds.add(row.getLong("entryid"));
            }
            DataSet manfTechData = this.getManfTechData(entryIds);
            mftData = mftData.removeFields(new String[]{"gxworkcenter"});
            mftData = mftData.leftJoin(manfTechData).on("entryid", "entryid").select(mftData.getRowMeta().getFieldNames(), new String[]{"gxworkcenter"}).finish().orderBy(new String[]{"id desc"});
        }
        return mftData;
    }

    private DataSet getManfTechData(Set<Long> entryIds) {
        QFilter entryIdQf = new QFilter("mftentryseq.id", "in", entryIds);
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter oprinvalQf = new QFilter("oprentryentity.oprinvalid", "=", (Object)Boolean.FALSE);
        return QueryServiceHelper.queryDataSet((String)CostObjectDiffAction.class.getName(), (String)"sfc_manftech", (String)"mftentryseq.id entryid,oprentryentity.oprworkcenter gxworkcenter", (QFilter[])new QFilter[]{entryIdQf, billStatusQf, oprinvalQf}, (String)"id desc");
    }

    private DataSet getOmManfTechData(Set<Long> entryIds) {
        QFilter entryIdQf = new QFilter("mftentryseq.id", "in", entryIds);
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter oprinvalQf = new QFilter("oprentryentity.oprinvalid", "=", (Object)Boolean.FALSE);
        return QueryServiceHelper.queryDataSet((String)CostObjectDiffAction.class.getName(), (String)"om_mfttechnics", (String)"mftentryseq.id entryid,oprentryentity.oprworkcenter gxworkcenter", (QFilter[])new QFilter[]{entryIdQf, billStatusQf, oprinvalQf}, (String)"id desc");
    }

    private DataSet getRoCostObjDataSet(Long orgId, Set<Long> entryIds) {
        String costObjFields = "probill";
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter bizTypeQf = new QFilter("biztype", "=", (Object)"RO");
        QFilter proBillQf = new QFilter("probill", "in", entryIds);
        return QueryServiceHelper.queryDataSet((String)CostObjectDiffAction.class.getName(), (String)"cad_costobject", (String)costObjFields, (QFilter[])new QFilter[]{orgQf, proBillQf, bizTypeQf}, null);
    }

    private DataSet getMatCostObjDataSet(Long orgId) {
        String costObjFields = "1 as probill,material materialcost";
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter bizTypeQf = new QFilter("biztype", "!=", (Object)"RO");
        return QueryServiceHelper.queryDataSet((String)CostObjectDiffAction.class.getName(), (String)"cad_costobject", (String)costObjFields, (QFilter[])new QFilter[]{orgQf, bizTypeQf}, null);
    }

    private DataSet getPlannedDataSet(Long orgId, Set entryIds, String appNum) {
        String plannedFields = "sourcebill,sourcebillentry,fromlogid";
        QFilter orgQf = new QFilter("accountorg", "=", (Object)orgId);
        QFilter entryIdQf = new QFilter("sourcebillentry", "in", (Object)entryIds);
        QFilter appNumQf = new QFilter("appnum", "=", (Object)appNum);
        return QueryServiceHelper.queryDataSet((String)CostObjectDiffAction.class.getName(), (String)"cad_plannedoutputbill", (String)plannedFields, (QFilter[])new QFilter[]{orgQf, entryIdQf, appNumQf}, null);
    }

    private DataSet getPlannedDataSetByLogId(Long orgId, Set<Long> ids) {
        String plannedFields = "sourcebill,sourcebillentry,fromlogid";
        QFilter orgQf = new QFilter("accountorg", "=", (Object)orgId);
        QFilter logIdQf = new QFilter("fromlogid", "in", ids);
        return QueryServiceHelper.queryDataSet((String)CostObjectDiffAction.class.getName(), (String)"cad_plannedoutputbill", (String)plannedFields, (QFilter[])new QFilter[]{orgQf, logIdQf}, null);
    }

    private int diffOutOrder(Long orgId, Set<Long> outTransactions, Set<Long> objOutTransactions, Map<Long, String> costCenterRangeMap, String appNum) {
        ArrayList outDiffs = Lists.newArrayListWithExpectedSize((int)8);
        DataSet mftOrderDs = this.getOutOrder();
        if (!mftOrderDs.isEmpty()) {
            DataSet mftCopy = mftOrderDs.copy();
            HashSet entryIds = Sets.newHashSetWithExpectedSize((int)8);
            for (Row row : mftCopy) {
                entryIds.add(row.getLong("entryid"));
            }
            DataSet planDs = this.getPlannedDataSet(orgId, entryIds, appNum);
            DataSet result = mftOrderDs.leftJoin(planDs).on("entryid", "sourcebillentry").select(mftOrderDs.getRowMeta().getFieldNames(), planDs.getRowMeta().getFieldNames()).finish().filter("sourcebillentry is null or sourcebillentry = 0").orderBy(new String[]{"id desc"});
            for (Row row : result) {
                Map billNoReasonMap;
                String srcErrorMsg;
                String taskStatus = row.getString("taskstatus");
                Long transactionType = row.getLong("transactiontype");
                StringBuilder reasonStr = new StringBuilder();
                CollectDiff collectDiff = new CollectDiff(row.getString("billno"), row.getInteger("seq"), row.getString("billtype"), row.getDate("transmittime"));
                if ("A".equals(taskStatus)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u4e3a\u672a\u5f00\u5de5\u3002", (String)"PlannedDiffAction_18", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (!kd.bos.orm.util.StringUtils.isEmpty((Object)(srcErrorMsg = this.checkCostCenterSrcOut(costCenterRangeMap, row, appNum)))) {
                    reasonStr.append(srcErrorMsg).append("\uff1b");
                }
                if (outTransactions != null && outTransactions.contains(transactionType)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5f52\u96c6\u201d\u3002", (String)"PlannedDiffAction_7", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (objOutTransactions != null && objOutTransactions.contains(transactionType)) {
                    reasonStr.append(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5f52\u96c6\u201d\u3002", (String)"PlannedDiffAction_8", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                }
                if (!(billNoReasonMap = this.getPlannedContext().getErrorInfMap()).isEmpty() && billNoReasonMap.containsKey(row.getString("billno").concat("@").concat(row.getString("seq")))) {
                    reasonStr.append((String)billNoReasonMap.get(row.getString("billno").concat("@").concat(row.getString("seq"))));
                }
                collectDiff.setBillType(row.getString("billtype"));
                if (reasonStr.length() > 1) {
                    collectDiff.setReason(reasonStr.toString());
                } else {
                    collectDiff.setReason(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0", (String)"PlannedDiffAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]));
                }
                outDiffs.add(collectDiff);
            }
        }
        if (outDiffs.size() > 0) {
            this.getPlannedContext().getCollectReport().getCollectDiffs().addAll(outDiffs);
            this.getPlannedContext().getCollectReport().setError(true);
        }
        return outDiffs.size();
    }

    private DataSet getOutOrder() {
        QFilter orgFilter = new QFilter("org", "in", this.getPermProOrgs());
        QFilter timeQf = this.getPlannedContext().getCollectReport().getTimeQf();
        String selectFields = "id,billno,treeentryentity.id entryid,treeentryentity.seq seq,treeentryentity.material.masterid material,treeentryentity.taskstatus taskstatus,transactiontype,treeentryentity.workcenter workcenter,0 gxworkcenter,org,treeentryentity.producedept producedept,treeentryentity.beginbookdate transmittime,0 as probill,'outorder' as billtype";
        DataSet outOrder = QueryServiceHelper.queryDataSet((String)CostObjectDiffAction.class.getName(), (String)"om_mftorder", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, timeQf}, (String)"billno desc");
        if (!outOrder.isEmpty()) {
            HashSet entryIds = Sets.newHashSetWithExpectedSize((int)8);
            DataSet copy = outOrder.copy();
            for (Row row : copy) {
                entryIds.add(row.getLong("entryid"));
            }
            DataSet omManfTechData = this.getOmManfTechData(entryIds);
            outOrder = outOrder.removeFields(new String[]{"gxworkcenter"});
            outOrder = outOrder.leftJoin(omManfTechData).on("entryid", "entryid").select(outOrder.getRowMeta().getFieldNames(), new String[]{"gxworkcenter"}).finish().orderBy(new String[]{"id desc"});
        }
        return outOrder;
    }

    private String checkCostCenterSrcMft(Map<Long, String> costCenterRangeMap, Row row, String appNum) {
        boolean adminOrgFlag;
        boolean orgFlag;
        boolean workCenterFlag;
        Long gxWorkcenter = row.getLong("gxworkcenter");
        Long workCenter = row.getLong("workcenter");
        Long org = row.getLong("org");
        Long produceDept = row.getLong("producedept");
        boolean bl = workCenterFlag = this.roWc.contains(workCenter) || this.pzWc.contains(workCenter) || this.roWc.contains(gxWorkcenter) || this.pzWc.contains(gxWorkcenter);
        if (!workCenterFlag && (this.notRoWc.contains(workCenter) || this.notRoWc.contains(gxWorkcenter))) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u3002", (String)"PlannedDiffAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean bl2 = orgFlag = this.roOrg.contains(org) || this.pzOrg.contains(org);
        if (!orgFlag && this.notRoOrg.contains(org)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u3002", (String)"PlannedDiffAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean bl3 = adminOrgFlag = this.roAdmin.contains(produceDept) || this.pzAdmin.contains(produceDept);
        if (!adminOrgFlag && this.notRoAdmin.contains(produceDept)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u3002", (String)"PlannedDiffAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        if (workCenterFlag || orgFlag || adminOrgFlag) {
            Map srcCostCenterMap = this.getPlannedContext().getCollectReport().getSrcCostCenterMap();
            Long cc = 0L;
            if (srcCostCenterMap != null && costCenterRangeMap != null) {
                if (srcCostCenterMap.containsKey(gxWorkcenter)) {
                    cc = (Long)srcCostCenterMap.get(gxWorkcenter);
                }
                if (srcCostCenterMap.containsKey(workCenter)) {
                    cc = (Long)srcCostCenterMap.get(workCenter);
                }
                if (srcCostCenterMap.containsKey(org)) {
                    cc = (Long)srcCostCenterMap.get(org);
                }
                if (srcCostCenterMap.containsKey(produceDept)) {
                    cc = (Long)srcCostCenterMap.get(produceDept);
                }
            }
            if (!"sca".equals(appNum) && !CadEmptyUtils.isEmpty((Long)cc) && costCenterRangeMap != null) {
                String range = costCenterRangeMap.get(cc);
                if (CadEmptyUtils.isEmpty(costCenterRangeMap) || !kd.bos.orm.util.StringUtils.isEmpty((Object)range) && range.indexOf("SCGD") == -1) {
                    String ccName = this.costCenterNameMap.get(cc);
                    if (!kd.bos.orm.util.StringUtils.isEmpty((Object)ccName)) {
                        return String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%s\u201d\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6\u751f\u4ea7\u5de5\u5355\u3002", (String)"PlannedDiffAction_11", (String)"macc-cad-mservice", (Object[])new Object[0]), ccName);
                    }
                    return ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6\u751f\u4ea7\u5de5\u5355\u3002", (String)"PlannedDiffAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]);
                }
            }
            if (this.getPlannedContext().isSingleSelected()) {
                if (this.selectedWc.contains(workCenter) || this.selectedOrg.contains(org) || this.selectedAdminOrg.contains(produceDept)) {
                    return null;
                }
                return ResManager.loadKDString((String)"\u672a\u5339\u914d\u4e0a\u9009\u4e2d\u7684\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u8bf7\u9009\u62e9\u4e0d\u9650\u8fdb\u884c\u5bfc\u5165\u3002", (String)"PlannedDiffAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]);
            }
            return null;
        }
        return ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\u5339\u914d\u5931\u8d25\u3002", (String)"PlannedDiffAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]);
    }

    private String checkCostCenterSrcOut(Map<Long, String> costCenterRangeMap, Row row, String appNum) {
        boolean adminOrgFlag;
        boolean orgFlag;
        boolean workCenterFlag;
        Long gxWorkcenter = row.getLong("gxworkcenter");
        Long workCenter = row.getLong("workcenter");
        Long org = row.getLong("org");
        Long produceDept = row.getLong("producedept");
        boolean bl = workCenterFlag = this.roWc.contains(workCenter) || this.pzWc.contains(workCenter) || this.roWc.contains(gxWorkcenter) || this.pzWc.contains(gxWorkcenter);
        if (!workCenterFlag && (this.notRoWc.contains(workCenter) || this.notRoWc.contains(gxWorkcenter))) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u3002", (String)"PlannedDiffAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean bl2 = orgFlag = this.roOrg.contains(org) || this.pzOrg.contains(org);
        if (!orgFlag && this.notRoOrg.contains(org)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u3002", (String)"PlannedDiffAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean bl3 = adminOrgFlag = this.roAdmin.contains(produceDept) || this.pzAdmin.contains(produceDept);
        if (!adminOrgFlag && this.notRoAdmin.contains(produceDept)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u3002", (String)"PlannedDiffAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        if (workCenterFlag || orgFlag || adminOrgFlag) {
            Map srcCostCenterMap = this.getPlannedContext().getCollectReport().getSrcCostCenterMap();
            Long cc = 0L;
            if (srcCostCenterMap != null && costCenterRangeMap != null) {
                if (srcCostCenterMap.containsKey(gxWorkcenter)) {
                    cc = (Long)srcCostCenterMap.get(gxWorkcenter);
                }
                if (srcCostCenterMap.containsKey(workCenter)) {
                    cc = (Long)srcCostCenterMap.get(workCenter);
                }
                if (srcCostCenterMap.containsKey(org)) {
                    cc = (Long)srcCostCenterMap.get(org);
                }
                if (srcCostCenterMap.containsKey(produceDept)) {
                    cc = (Long)srcCostCenterMap.get(produceDept);
                }
            }
            if (!"sca".equals(appNum) && !CadEmptyUtils.isEmpty((Long)cc) && costCenterRangeMap != null) {
                String range = costCenterRangeMap.get(cc);
                if (CadEmptyUtils.isEmpty(costCenterRangeMap) || !kd.bos.orm.util.StringUtils.isEmpty((Object)range) && range.indexOf("WWGD") == -1) {
                    String ccName = this.costCenterNameMap.get(cc);
                    if (kd.bos.orm.util.StringUtils.isEmpty((Object)ccName)) {
                        return String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%s\u201d\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6\u59d4\u5916\u5de5\u5355\u3002", (String)"PlannedDiffAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), ccName);
                    }
                    return ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6\u59d4\u5916\u5de5\u5355\u3002", (String)"PlannedDiffAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]);
                }
            }
            if (this.getPlannedContext().isSingleSelected()) {
                if (this.selectedWc.contains(workCenter) || this.selectedOrg.contains(org) || this.selectedAdminOrg.contains(produceDept)) {
                    return null;
                }
                return ResManager.loadKDString((String)"\u672a\u5339\u914d\u4e0a\u9009\u4e2d\u7684\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u8bf7\u9009\u62e9\u4e0d\u9650\u8fdb\u884c\u5bfc\u5165\u3002", (String)"PlannedDiffAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]);
            }
            return null;
        }
        return ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\u5339\u914d\u5931\u8d25\u3002", (String)"PlannedDiffAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]);
    }

    private Set<Long> getPermProOrgs() {
        Long orgId = this.getPlannedContext().getCollectReport().getOrg();
        List productOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)"cad_plannedoutputbill", (String)this.getPlannedContext().getPlannedArgs().getAppNum());
        if (productOrgs == null || productOrgs.isEmpty()) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        return Sets.newHashSet((Iterable)productOrgs);
    }
}

