/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.plannedoutput;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.business.numcheck.CollNumCheckHelper;
import kd.macc.cad.common.dto.CollectDiff;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.mservice.plannedoutput.AbstractPlannedAction;

public class PlannedDiffForConfigAction
extends AbstractPlannedAction {
    private final Log logger = LogFactory.getLog(PlannedDiffForConfigAction.class);
    private static final String BIZ_TYPE_RO = "RO";

    @Override
    protected void doExecute() {
        String progressId = this.getPlannedContext().getPlannedArgs().getProgressId();
        if (!CollectReportHelper.disableCollectReport()) {
            CollectReport collectReport = this.getPlannedContext().getCollectReport();
            this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u68c0\u67e5\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02", (String)"PlannedDiffForConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            Map billNoReasonMap = this.getPlannedContext().getErrorInfMap();
            ArrayList diffs = Lists.newArrayListWithExpectedSize((int)8);
            for (Map.Entry billNoReason : billNoReasonMap.entrySet()) {
                String key = (String)billNoReason.getKey();
                String[] split = key.split("@");
                String value = (String)billNoReason.getValue();
                int seq = 1;
                try {
                    seq = Integer.parseInt(split[1]);
                }
                catch (Exception ex) {
                    this.logger.error("\u68c0\u67e5\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02{}-\u5f02\u5e38:{}", (Object)key, (Object)ex);
                }
                CollectDiff collectDiff = new CollectDiff(split[0], Integer.valueOf(seq), split[2], value);
                collectDiff.setSrcbillType(split[2]);
                if (value.length() > 0) {
                    collectDiff.setReason(value);
                }
                diffs.add(collectDiff);
            }
            this.getDiffReason(collectReport.getDateRange(), diffs);
            if (diffs.size() > 0) {
                this.getPlannedContext().getCollectReport().getCollectDiffs().addAll(diffs);
                this.getPlannedContext().getCollectReport().setError(true);
            }
            String desc = ResManager.loadKDString((String)"\u5171\u6709\u5dee\u5f02\u6570\u636e\u201c%s\u201d\u6761\u3002", (String)"PlannedDiffForConfigAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]);
            this.getPlannedContext().getCollectReport().logCheckDesc(String.format(desc, diffs.size()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{collectReport.transfer2Dynamic(Boolean.FALSE)});
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f", (String)"PlannedDiffForConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
    }

    private void getDiffReason(String daterange, List<CollectDiff> diffs) {
        Long accountOrgId = this.getPlannedContext().getPlannedArgs().getAccountOrgId();
        String appNum = this.getPlannedContext().getPlannedArgs().getAppNum();
        List<Long> costCenterIds = this.getPlannedContext().getPlannedArgs().getCostCenterIds();
        CollNumCheckHelper.getCostCenterDiff((String)"B", (String)daterange, (Long)accountOrgId, (String)appNum, costCenterIds, diffs, null);
    }
}

