/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.plannedoutput;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.business.config.costcenter.CostCenterRelationService;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.engine.CollConifgContext;
import kd.macc.cad.business.config.engine.CollConifgParam;
import kd.macc.cad.business.config.engine.IBillTransfer;
import kd.macc.cad.business.config.engine.filter.CollConfigFilterService;
import kd.macc.cad.business.config.engine.helper.CollectEngineHelper;
import kd.macc.cad.business.config.engine.mapping.CollConfigMappingService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.BatchUtils;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MaterialPropHelper;
import kd.macc.cad.mservice.plannedoutput.AcaPlannedImportDataForFLConfigAction;
import kd.macc.cad.mservice.plannedoutput.AcaPlannedImportDataForFPConfigAction;
import kd.macc.cad.mservice.plannedoutput.AcaPlannedImportDataForPZConfigAction;
import kd.macc.cad.mservice.plannedoutput.BaseImportDataAction;
import kd.macc.cad.mservice.plannedoutput.CompletionSaveAction;
import kd.macc.cad.mservice.plannedoutput.CreatePlanDataDiffDateByLogAction;
import kd.macc.cad.mservice.plannedoutput.IPlannedAction;
import kd.macc.cad.mservice.plannedoutput.PlannedArgs;
import kd.macc.cad.mservice.plannedoutput.PlannedContext;
import kd.macc.cad.mservice.plannedoutput.PlannedImportDataConfigAction;
import kd.macc.cad.mservice.plannedoutput.PlannedImportDataConfigOtherAction;
import kd.macc.cad.mservice.plannedoutput.PlannedImportDataForCUConfigAction;
import org.apache.commons.lang3.StringUtils;

public class PlannedOutPutTransferAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(PlannedOutPutTransferAction.class);

    @Override
    protected void doExecute() {
        PlannedContext context = this.getPlannedContext();
        Map<Long, Set<Long>> acctOrgCostCentersMap = context.getAcctOrgCostCentersMap();
        List<IPlannedAction> actions = this.initializeActions(context.getPlannedArgs().getAppNum());
        int batchSize = CadBgParamUtils.getCadParamForInt((String)"planoutCollBatch", (int)10000);
        for (Map.Entry<Long, Set<Long>> entry : acctOrgCostCentersMap.entrySet()) {
            this.orgToCollect(entry.getKey(), entry.getValue(), actions, batchSize);
        }
    }

    private void orgToCollect(Long acctOrgId, Set<Long> costCenterIds, List<IPlannedAction> actions, int batchSize) {
        ArrayList<Long> orgCostCenterIds = new ArrayList<Long>(costCenterIds);
        PlannedContext context = this.getPlannedContext();
        PlannedArgs collectionArgs = context.getPlannedArgs();
        CollConifgContext configContext = this.getConfigParam(context, orgCostCenterIds);
        HashSet<Long> allCollconfigIds = new HashSet<Long>(10);
        allCollconfigIds.add(0L);
        List<DynamicObject> collConfigList = this.getValidCollConfigList(context, "cad_plannedoutputbill", allCollconfigIds);
        if (CadEmptyUtils.isEmpty(collConfigList)) {
            return;
        }
        CollConfigMappingService mappingService = new CollConfigMappingService();
        Map collConfigMappingMap = mappingService.getCollConfigMappingMap(collConfigList);
        Map collSelectValueMappingMap = mappingService.getCollSelectValueMappingMap(collConfigList);
        Map collConfigRuleMappingMap = mappingService.getCollConfigRuleMappingMap(collConfigList);
        Map collConfigFilterMap = new CollConfigFilterService().getCollConfigFilterMap(collConfigList);
        boolean isOldUserForSysParamBizRange = ImportServiceHelper.isOldUserForSysParamBizRange();
        Map<String, List<Long>> billRangeMap = isOldUserForSysParamBizRange ? this.getBillRangeMap(acctOrgId, orgCostCenterIds, "cad_plannedoutputbill", collectionArgs.getAppNum(), context.getCollectReport()) : null;
        context.getCollConfigMappingMap().putAll(collConfigMappingMap);
        context.getCollConfigRuleMappingMap().putAll(collConfigRuleMappingMap);
        Map<String, Set<Long>> costCentersourceTypeDataMap = this.getCostCentersourceTypeDataMap(configContext);
        this.delHistoryCollConfigData(collConfigList.get(0), collectionArgs, allCollconfigIds);
        HashMap souCollConfigsMap = Maps.newHashMapWithExpectedSize((int)10);
        for (DynamicObject config2 : collConfigList) {
            String sourcebill = config2.getString("sourcebill.id") + "@" + config2.getString("calmethod");
            souCollConfigsMap.computeIfAbsent(sourcebill, t -> new ArrayList()).add(config2);
        }
        int total = collConfigList.size() + 2;
        this.refreshProgress(ResManager.loadKDString((String)"\u914d\u7f6e\u65b9\u6848\u5f15\u5165\u5904\u7406", (String)"PlannedOutPutTransferAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, total, false);
        for (List cofigList : souCollConfigsMap.values()) {
            cofigList.forEach(config -> {
                String confignumber = config.getString("number");
                this.refreshProgress(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u914d\u7f6e\u65b9\u6848\u5f00\u59cb\u5f15\u5165\u5904\u7406", (String)"PlannedOutPutTransferAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), confignumber), 1, 0, true);
                context.getIdEntryIdCompleteMap().clear();
                context.getExistBillNos().clear();
                context.getCreatePlanDataByLogMap().clear();
                context.getCreatePlanDataDiffDateByLogMap().clear();
                long configId = config.getLong("id");
                String targetBillEntity = config.getString("costbill.id");
                String sourceBillEntity = config.getString("sourcebill.id");
                Map fieldMappingMap = (Map)collConfigMappingMap.get(configId);
                String entryEntityName = this.getSrcEntryEntityName(fieldMappingMap);
                Map selectValueMappingMap = (Map)collSelectValueMappingMap.get(configId);
                Map ruleMappingMap = (Map)collConfigRuleMappingMap.get(configId);
                if (isOldUserForSysParamBizRange && billRangeMap != null && !billRangeMap.containsKey("norange")) {
                    if (!billRangeMap.containsKey(sourceBillEntity)) {
                        logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u4e0d\u5728\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\u8bbe\u7f6e\u7684\u5f52\u96c6\u5355\u636e\u8303\u56f4\u5185");
                        return;
                    }
                    List ccsIds = (List)billRangeMap.get(sourceBillEntity);
                    if (CadEmptyUtils.isEmpty((List)ccsIds)) {
                        logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\uff0c\u6ca1\u6709\u9700\u8981\u5f52\u96c6\u7684\u6210\u672c\u4e2d\u5fc3");
                        return;
                    }
                    configContext.getParam().setCostCenterIds(ccsIds.toArray(new Long[0]));
                }
                List collConfigFilter = ImportServiceHelper.getSrcQFilters((Long)configContext.getParam().getCalOrgId(), (List)orgCostCenterIds, Arrays.asList(configContext.getParam().getManuOrgIds()), (DynamicObject)config, (Map)collConfigFilterMap, (Map)fieldMappingMap, (Map)selectValueMappingMap, (Map)costCentersourceTypeDataMap, collectionArgs.getMftOrderEntryIds(), collectionArgs.getCollectParamMap(), (Long)configContext.getParam().getCostAccountId(), (Long)configContext.getParam().getCurPeriodId(), (String)configContext.getParam().getAppnum(), (Map)configContext.getConfigProEntryIdWorkCenterMap(), (CollectReport)context.getCollectReport());
                String selectFields = CollectEngineHelper.getSrcSelectFields((DynamicObject)config, (Map)fieldMappingMap, (Map)ruleMappingMap);
                if (CadEmptyUtils.isEmpty((String)selectFields)) {
                    return;
                }
                logger.info("\u67e5\u8be2\u6e90\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", (Object)collConfigFilter);
                StringBuilder selectFieldStr = new StringBuilder("id,auditdate");
                if (!"id".equals(entryEntityName)) {
                    selectFieldStr.append(",");
                    selectFieldStr.append(entryEntityName);
                    if ("pom_mftorder".equals(sourceBillEntity) || "om_mftorder".equals(sourceBillEntity)) {
                        selectFieldStr.append(",treeentryentity.closebookdate AS closebookdate");
                    }
                }
                DataSet sourceBills = QueryServiceHelper.queryDataSet((String)"CompeletionTransferAction_doExecute", (String)sourceBillEntity, (String)selectFieldStr.toString(), (QFilter[])collConfigFilter.toArray(new QFilter[0]), (String)"id desc");
                ArrayList<Long> closeSourceEntryIds = new ArrayList<Long>(10);
                if ("pom_mftorder".equals(sourceBillEntity) || "om_mftorder".equals(sourceBillEntity)) {
                    HashSet<Long> sourcebill = new HashSet<Long>(10);
                    HashSet<Long> sourcebillentry = new HashSet<Long>(10);
                    for (Row manu : sourceBills.copy()) {
                        sourcebill.add(manu.getLong("id"));
                        sourcebillentry.add(manu.getLong(entryEntityName));
                        Date closebookdate = manu.getDate("closebookdate");
                        if (closebookdate == null) continue;
                        closeSourceEntryIds.add(manu.getLong(entryEntityName));
                    }
                    this.setChangeAndSplitLog(acctOrgId, collectionArgs.getManuOrgs(), collectionArgs.getAppNum(), collectionArgs.getMftOrderEntryIds(), this.getPlannedContext().getPlannedArgs().getCollectParamMap(), sourceBillEntity, sourcebill, sourcebillentry);
                }
                List partitionIds = BatchUtils.batchDataByEntryId((DataSet)sourceBills, (Integer)batchSize, (String)entryEntityName);
                HashMap identryidMftLogMap = Maps.newHashMapWithExpectedSize((int)10);
                DataSet existsBillDs = this.getExistsCompletBill(collectionArgs.getAccountOrgId(), collectionArgs.getCostCenterIds(), collectionArgs.getManuOrgs(), collectionArgs.getMftOrderEntryIds(), sourceBillEntity, collectionArgs.getAppNum(), closeSourceEntryIds, null, collectionArgs.getCollectParamMap(), config.getLong("id"), null);
                this.setIdEntryIdCompleteMap(context, existsBillDs, fieldMappingMap, identryidMftLogMap);
                logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5206\u6279\uff1a\u65b9\u6848\u7f16\u53f7\uff1a{}\uff0c\u5206\u6279id\u7ed3\u675f\uff0c\u5171:{}\u6279", (Object)config.getString("number"), (Object)partitionIds.size());
                for (int i = 0; i < partitionIds.size(); ++i) {
                    this.refreshProgress(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u65b9\u6848\u6b63\u5728\u5f15\u5165\uff0c\u3010%2$s\u3011/\u3010%3$s\u3011\u6279\u3002", (String)"PlannedOutPutTransferAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), confignumber, i + 1, partitionIds.size()), 0, 0, true);
                    context.getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u3010%s\u3011\u5206\u6279\u5904\u7406", (String)"PlannedOutPutTransferAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                    context.getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c\u3010%1$s\u3011\u6279\uff0c\u5171\u3010%2$s\u3011\u6279\u3002", (String)"PlannedOutPutTransferAction_8", (String)"macc-cad-mservice", (Object[])new Object[0]), i + 1, partitionIds.size()));
                    this.getPlannedContext().getPlanOutPutBills().clear();
                    long start = TimeServiceHelper.now().getTime();
                    List entryIdList = (List)partitionIds.get(i);
                    logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5206\u6279\uff1a\u5f00\u59cb\u5206\u6279\u4f5c\u4e1a:\u7b2c{}\u6279\uff0c\u5355\u636e\u6570\u91cf{}", (Object)i, (Object)entryIdList.size());
                    if (CadEmptyUtils.isEmpty((List)entryIdList)) continue;
                    QFilter entryIdQf = new QFilter(entryEntityName, "in", (Object)entryIdList);
                    DynamicObjectCollection resResults = QueryServiceHelper.query((String)sourceBillEntity, (String)selectFields, (QFilter[])new QFilter[]{entryIdQf});
                    MaterialPropHelper.queryMaterialPropAndSet((DynamicObjectCollection)resResults, (String)selectFields);
                    IBillTransfer billTransfer = IBillTransfer.getTransferInstance((String)"cad_plannedoutputbill", (String)collectionArgs.getAppNum());
                    BillTransferResult result = billTransfer.doTransfer((DynamicObject[])resResults.toArray((Object[])new DynamicObject[0]), config, configContext);
                    logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5206\u6279\uff1a\u8f6c\u6362\u7ed3\u679c\uff1a{},\u8017\u65f6:{}", (Object)context.getConfigSrcAndTargetBillsMap().size(), (Object)(TimeServiceHelper.now().getTime() - start));
                    context.getConfigSrcAndTargetBillsMap().put((DynamicObject)config, result.getSrcAndTargetBillsMap());
                    for (IPlannedAction action : actions) {
                        long actionTime = System.currentTimeMillis();
                        action.setContext(context);
                        action.execute();
                        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5206\u6279\uff1a\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5f15\u5165-action\uff1a{},\u8017\u65f6\uff1a{}ms", (Object)action.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                    }
                    long end = TimeServiceHelper.now().getTime();
                    logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5206\u6279\uff1a\u7b2c{}\u6279\u4f5c\u4e1a\u7ed3\u675f,\u8017\u65f6\uff1a{}", (Object)i, (Object)(end - start));
                }
                if ("pom_mftorder".equals(sourceBillEntity) || "om_mftorder".equals(sourceBillEntity)) {
                    this.getPlannedContext().getPlanOutPutBills().clear();
                    CreatePlanDataDiffDateByLogAction createPlanDataDiffDateByLogAction = new CreatePlanDataDiffDateByLogAction(context.getIdEntryIdCompleteMap());
                    createPlanDataDiffDateByLogAction.setContext(this.getPlannedContext());
                    createPlanDataDiffDateByLogAction.execute();
                    if (!this.getPlannedContext().getPlanOutPutBills().isEmpty()) {
                        CompletionSaveAction saveAction = new CompletionSaveAction();
                        saveAction.setContext(this.getPlannedContext());
                        saveAction.execute();
                    }
                }
                context.getConfigSrcAndTargetBillsMap().clear();
                context.getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u3010%s\u3011,\u6570\u636e\u5904\u7406\u5b8c\u6210", (String)"PlannedOutPutTransferAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                int delNum = this.deletePlannedBillForNoSrource(context.getIdEntryIdCompleteMap());
                context.getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e\u3010%s\u3011\u6761\u3002", (String)"PlannedOutPutTransferAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]), delNum));
            });
        }
    }

    private void setIdEntryIdCompleteMap(PlannedContext context, DataSet existsBillDs, Map<String, String> fieldMappingMap, Map<String, List<String>> identryidMftLogMap) {
        if (context.getIdEntryIdCompleteMap().isEmpty()) {
            ArrayList<Long> sourceBillIds = new ArrayList<Long>();
            for (Row row : existsBillDs) {
                sourceBillIds.add(row.getLong("id"));
            }
            Map<String, DynamicObject> existsEntryIdCompleteMap = this.groupEntryIdCompleteMap(sourceBillIds, context.getExistBillNos(), fieldMappingMap.keySet(), identryidMftLogMap);
            if (!CadEmptyUtils.isEmpty(existsEntryIdCompleteMap)) {
                context.getIdEntryIdCompleteMap().putAll(existsEntryIdCompleteMap);
            }
        }
    }

    private String getSrcEntryEntityName(Map<String, String> fieldMappingMap) {
        String entryEntityName = "";
        if (!CadEmptyUtils.isEmpty(fieldMappingMap)) {
            for (String value : fieldMappingMap.values()) {
                String[] split;
                for (String fieldName : split = StringUtils.split((String)value, (String)",")) {
                    String[] fieldNames = StringUtils.split((String)fieldName, (String)".");
                    if (fieldNames.length <= 1) continue;
                    entryEntityName = fieldNames[0];
                }
            }
        }
        entryEntityName = !CadEmptyUtils.isEmpty((String)entryEntityName) ? entryEntityName.concat(".id") : "id";
        return entryEntityName;
    }

    private Map<String, Set<Long>> getCostCentersourceTypeDataMap(CollConifgContext configContext) {
        HashMap<String, Set<Long>> costCentersourceTypeDataMap = new HashMap<String, Set<Long>>(16);
        configContext.getCostCenterSourceDataMap().forEach((ccs, obj) -> {
            String[] srcDataStr = ccs.split("@");
            if (srcDataStr.length < 2) {
                return;
            }
            String sourceType = srcDataStr[0];
            Long sourceData = Long.parseLong(srcDataStr[1]);
            costCentersourceTypeDataMap.computeIfAbsent(sourceType, p -> new HashSet(10)).add(sourceData);
        });
        return costCentersourceTypeDataMap;
    }

    private Map<String, List<Long>> getBillRangeMap(Long accountOrg, List<Long> costCenters, String targetEntity, String appNum, CollectReport collectReport) {
        Map<String, List<Long>> billRangeMap = new HashMap<String, List<Long>>(16);
        if (CadEmptyUtils.isEmpty((String)targetEntity)) {
            return billRangeMap;
        }
        switch (targetEntity) {
            case "cad_plannedoutputbill": {
                if ("aca".equals(appNum)) {
                    billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"plancollectrange", (String)appNum, (CollectReport)collectReport);
                    break;
                }
                billRangeMap.put("norange", new ArrayList());
                break;
            }
            case "cad_factnedoutputbill": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"billrange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"matcollectrange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            case "sca_resourceuse": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"resourcerange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            default: {
                billRangeMap.put("norange", new ArrayList());
            }
        }
        return billRangeMap;
    }

    public List<DynamicObject> getValidCollConfigList(PlannedContext context, String targetEntity, Set<Long> collconfigIds) {
        ArrayList<DynamicObject> values = new ArrayList<DynamicObject>(context.getAcctOrgObjRules().values());
        HashSet<String> calMethodTypes = new HashSet<String>(10);
        for (Map.Entry<String, DynamicObject> ruleMap : context.getAcctOrgObjRules().entrySet()) {
            String key = ruleMap.getKey();
            String[] split = key.split("@");
            if (split.length == 3) {
                calMethodTypes.add(split[1]);
                continue;
            }
            if (split.length != 4) continue;
            calMethodTypes.add(split[2]);
        }
        HashSet calcDimensionIds = new HashSet(10);
        values.forEach(p -> calcDimensionIds.add(p.getLong("costcalcdimension")));
        return ImportServiceHelper.getCollConfigs((Long)context.getPlannedArgs().getAccountOrgId(), (Long)0L, calMethodTypes, calcDimensionIds, (String)targetEntity, (String)context.getPlannedArgs().getAppNum(), collconfigIds);
    }

    private CollConifgContext getConfigParam(PlannedContext context, List<Long> orgCostCenterIds) {
        PlannedArgs collectionArgs = context.getPlannedArgs();
        CollConifgContext configContext = new CollConifgContext();
        CollConifgParam param = new CollConifgParam();
        param.setAppnum(collectionArgs.getAppNum());
        param.setCalOrgId(collectionArgs.getAccountOrgId());
        param.setCostAccountId(null);
        Long[] manuOrgIds = new Long[]{};
        if (!CadEmptyUtils.isEmpty(collectionArgs.getManuOrgs())) {
            manuOrgIds = collectionArgs.getManuOrgs().toArray(new Long[0]);
        }
        param.setManuOrgIds(manuOrgIds);
        param.setCostCenterIds(orgCostCenterIds.toArray(new Long[0]));
        param.setTargetEntity("cad_plannedoutputbill");
        configContext.setParam(param);
        List importScopeDate = SysParamHelper.getImportScopeDate((Long)collectionArgs.getAccountOrgId(), (String)collectionArgs.getAppNum());
        Map costCenterSourceDataMap = new CostCenterRelationService().getCostCenterSourceDataMap(param.getCostCenterIds(), importScopeDate);
        configContext.setCostCenterSourceDataMap(costCenterSourceDataMap);
        return configContext;
    }

    private List<IPlannedAction> initializeActions(String appNum) {
        ArrayList<IPlannedAction> actionList = new ArrayList<IPlannedAction>();
        switch (appNum) {
            case "sca": {
                actionList.add(new PlannedImportDataConfigAction());
                actionList.add(new PlannedImportDataConfigOtherAction());
                actionList.add(new PlannedImportDataForCUConfigAction());
                actionList.add(new CompletionSaveAction());
                break;
            }
            case "aca": {
                actionList.add(new PlannedImportDataConfigAction());
                actionList.add(new PlannedImportDataConfigOtherAction());
                actionList.add(new AcaPlannedImportDataForPZConfigAction());
                actionList.add(new AcaPlannedImportDataForFLConfigAction());
                actionList.add(new AcaPlannedImportDataForFPConfigAction());
                actionList.add(new PlannedImportDataForCUConfigAction());
                actionList.add(new CompletionSaveAction());
                break;
            }
        }
        return actionList;
    }

    private void delHistoryCollConfigData(DynamicObject config, PlannedArgs collectionArgs, Set<Long> allCollconfigIds) {
        if (config == null) {
            return;
        }
        String sourceBillEntity = config.getString("sourcebill.id");
        List<Long> existsIds = this.getExistsCompletBillId(collectionArgs.getAccountOrgId(), collectionArgs.getCostCenterIds(), collectionArgs.getManuOrgs(), collectionArgs.getMftOrderEntryIds(), sourceBillEntity, collectionArgs.getAppNum(), null, null, collectionArgs.getCollectParamMap(), config.getLong("id"), allCollconfigIds);
        if (existsIds == null || existsIds.isEmpty()) {
            return;
        }
        Map<String, DynamicObject> idEntryIdCompleteMap = this.groupEntryIdCompleteMap(existsIds, null, null, null);
        this.getPlannedContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5386\u53f2\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u662f\u5426\u6709\u9700\u8981\u5220\u9664\u7684\u5355\u636e\uff1f", (String)"PlannedOutPutTransferAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), new Object[0]));
        int delNum = this.deletePlannedBillForNoSrource(idEntryIdCompleteMap);
        this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"PlannedOutPutTransferAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]), delNum));
    }
}

