/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.plannedoutput;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.cad.common.dto.MftOrderLog;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.plannedoutput.BaseImportDataAction;
import kd.macc.cad.mservice.plannedoutput.PlannedArgs;

@Deprecated
public class ScaPlannedImportDataAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(ScaPlannedImportDataAction.class);

    @Override
    protected void doExecute() {
        Map<Long, Set<Long>> acctOrgCostCentersMap = this.getPlannedContext().getAcctOrgCostCentersMap();
        PlannedArgs plannedArgs = this.getPlannedContext().getPlannedArgs();
        String appNum = plannedArgs.getAppNum();
        List<Long> manuOrgs = plannedArgs.getManuOrgs();
        List<Long> mftOrderEntryIds = plannedArgs.getMftOrderEntryIds();
        Map<String, Object> collectParamMap = plannedArgs.getCollectParamMap();
        acctOrgCostCentersMap.forEach((accountOrgId, costCenters) -> {
            String key = accountOrgId + CostObjectEnum.BIZTYPE_RO.getValue();
            List<Long> reProduceCostCenters = this.getPlannedContext().getAcctOrgCalmethodCostCenters().get(key);
            if (CadEmptyUtils.isEmpty(reProduceCostCenters)) {
                logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u5de5\u5355\u6210\u672c\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u7ed3\u675f\uff01", accountOrgId);
                return;
            }
            this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u83b7\u53d6\u5de5\u5355\u6210\u672c\u6cd5\u6210\u672c\u4e2d\u5fc3", (String)"ScaPlannedImportDataAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u5de5\u5355\u6210\u672c\u6cd5\u6210\u672c\u4e2d\u5fc3\u201c%s\u201d\u4e2a\u3002", (String)"ScaPlannedImportDataAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), reProduceCostCenters.size()));
            this.getPlannedContext().getCollectReport().setReProCostCenters(reProduceCostCenters);
            this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u5de5\u5355\u6cd5\u6210\u672c\u4e2d\u5fc3\u83b7\u53d6\u751f\u4ea7\u5de5\u5355\u6570\u636e", (String)"ScaPlannedImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
            DynamicObjectCollection manuBills = this.getAllManuBill((Long)accountOrgId, reProduceCostCenters, manuOrgs, appNum, mftOrderEntryIds, collectParamMap);
            this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5de5\u5355\u6cd5\u6210\u672c\u4e2d\u5fc3\u83b7\u53d6\u5230\u751f\u4ea7\u5de5\u5355\u6570\u636e%s\u6761\u3002", (String)"ScaPlannedImportDataAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), manuBills.size()));
            this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u5de5\u5355\u6cd5\u6210\u672c\u4e2d\u5fc3\u83b7\u53d6\u59d4\u5916\u5de5\u5355\u6570\u636e", (String)"ScaPlannedImportDataAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]));
            DynamicObjectCollection outSourceManuBills = this.getAllOutSourceManuBill((Long)accountOrgId, reProduceCostCenters, manuOrgs, appNum, mftOrderEntryIds, collectParamMap);
            this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5de5\u5355\u6cd5\u6210\u672c\u4e2d\u5fc3\u83b7\u53d6\u5230\u59d4\u5916\u4ea7\u5de5\u5355\u6570\u636e%s\u6761\u3002", (String)"ScaPlannedImportDataAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]), outSourceManuBills.size()));
            manuBills.addAll((Collection)outSourceManuBills);
            HashSet<Long> costCenterIdSet = new HashSet<Long>(reProduceCostCenters);
            this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u751f\u4ea7/\u59d4\u5916\u5de5\u5355\u53ca\u975e\u8de8\u671f\u53d8\u66f4/\u62c6\u5206\u5355\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6", (String)"ScaPlannedImportDataAction_8", (String)"macc-cad-mservice", (Object[])new Object[0]));
            int generateCount = this.collectImportByPage((Long)accountOrgId, (Set<Long>)costCenterIdSet, manuOrgs, manuBills, appNum, mftOrderEntryIds);
            String checkDesc = ResManager.loadKDString((String)"\u5de5\u5355\u6210\u672c\u6cd5\u5f52\u96c6\u5230\u8ba1\u5212\u4ea7\u91cf%s\u4e2a\u3002", (String)"ScaPlannedImportDataAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]);
            this.getPlannedContext().getCollectReport().logCheckDesc(String.format(checkDesc, generateCount));
        });
    }

    private int collectImportByPage(Long accountOrg, Set<Long> costCenters, List<Long> manuOrgs, DynamicObjectCollection manuBills, String appNum, List<Long> mftOrderEntryIds) {
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u83b7\u53d6\u5230\u751f\u4ea7\u5de5\u5355:{}", manuBills == null ? null : manuBills.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toList()));
        if (manuBills == null || CadEmptyUtils.isEmpty((DynamicObjectCollection)manuBills)) {
            return 0;
        }
        Map manuEntryIdAndWorkCenterMap = CostObjectHelper.getManuEntryIdAndWorkCenterMap((DynamicObjectCollection)manuBills);
        List<Map<String, Date>> importScopeDate = this.getPlannedContext().getOrgImportScopeDate().get(accountOrg);
        Map costInfo = CostObjectHelper.getCenterByManuBill((DynamicObject[])((DynamicObject[])manuBills.toArray((Object[])new DynamicObject[0])), new ArrayList<Long>(costCenters), (Map)manuEntryIdAndWorkCenterMap, importScopeDate);
        Map<String, DynamicObject> matCost = this.getCostObjectMapByMaterial(costCenters, (List<DynamicObject>)manuBills);
        List<DynamicObject> plannedBill = this.getPlannedBill(accountOrg, costCenters, manuOrgs, (List<DynamicObject>)manuBills, matCost, costInfo, manuEntryIdAndWorkCenterMap, appNum, mftOrderEntryIds);
        if (plannedBill == null || plannedBill.isEmpty()) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u5de5\u5355\u6210\u672c\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\u6ca1\u6709\u751f\u6210\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u7ed3\u675f\uff01", (Object)accountOrg);
            return 0;
        }
        this.getPlannedContext().getPlanOutPutBills().addAll(plannedBill);
        return plannedBill.size();
    }

    private List<DynamicObject> getPlannedBill(Long acctOrg, Set<Long> costCenters, List<Long> manuOrgs, List<DynamicObject> manuBill, Map<String, DynamicObject> matCost, Map<String, List<DynamicObject>> costInfo, Map<Long, Long> manuEntryIdAndWorkCenterMap, String appNum, List<Long> mftOrderEntryIds) {
        HashMap<String, DynamicObject> changePlannedMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> changeStatusMap = new HashMap<String, DynamicObject>(16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date date = TimeServiceHelper.now();
        ArrayList<DynamicObject> plannedBill = new ArrayList<DynamicObject>(10);
        ArrayList<String> existBillNos = new ArrayList<String>(10);
        Set<String> existsManu = this.dealExistsManu(acctOrg, costCenters, manuOrgs, manuBill, changePlannedMap, changeStatusMap, existBillNos, appNum, mftOrderEntryIds);
        logger.info("\u5df2\u7ecf\u5b58\u5728\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", existsManu);
        Map<String, Set<MftOrderLog>> createPlanDataByLogMap = this.getPlannedContext().getCreatePlanDataByLogMap();
        int updNum = 0;
        int addNum = 0;
        for (DynamicObject manu : manuBill) {
            DynamicObject costCenter = CostObjectHelper.getCostCenter((DynamicObject)manu, costInfo, manuEntryIdAndWorkCenterMap);
            if (costCenter == null) {
                logger.info("\u5de5\u5355{}\u884c\u53f7{}\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
                continue;
            }
            DynamicObject curCostObject = this.getCostObjectInfo(acctOrg, costCenter.getLong("costcenter"), manu, matCost);
            if (curCostObject == null) {
                this.getPlannedContext().logErrorMsg(manu.getString("billno").concat("@").concat(manu.getString("seq")), ResManager.loadKDString((String)"\u672a\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ScaPlannedImportDataAction_11", (String)"macc-cad-mservice", (Object[])new Object[0]));
                logger.info("\u5de5\u5355{}\u884c\u53f7{}\u6ca1\u6709\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
                continue;
            }
            String idAndEntryId = manu.getString("id") + "-" + manu.getString("entryid");
            boolean isNeedChangeData = changePlannedMap.containsKey(idAndEntryId);
            boolean isStatusChangeData = changeStatusMap.containsKey(idAndEntryId);
            DynamicObject plan = BusinessDataServiceHelper.newDynamicObject((String)"cad_plannedoutputbill");
            if ("A".equals(manu.getString("taskstatus"))) {
                logger.info("\u5de5\u5355{}\u884c\u53f7{}\u7684\u4efb\u52a1\u72b6\u6001\u662f\u672a\u5f00\u5de5\u72b6\u6001\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
                continue;
            }
            Set<MftOrderLog> mftOrderLogs = createPlanDataByLogMap.get(idAndEntryId);
            if (mftOrderLogs != null) {
                for (MftOrderLog mftOrderLog : mftOrderLogs) {
                    String logKey = idAndEntryId + "-" + mftOrderLog.getLogId();
                    if (existsManu.contains(logKey) && !isNeedChangeData && !isStatusChangeData) {
                        logger.info("\u5de5\u5355{}\u884c\u53f7{}\u65e5\u5fd7id{}\u5df2\u5b58\u5728\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", new Object[]{manu.getString("billno"), manu.getString("seq"), mftOrderLog.getLogId()});
                        continue;
                    }
                    DynamicObject logPlan = BusinessDataServiceHelper.newDynamicObject((String)"cad_plannedoutputbill");
                    if (!existsManu.contains(logKey)) {
                        ++addNum;
                        logPlan.set("id", (Object)0L);
                    } else {
                        ++updNum;
                        logPlan = (DynamicObject)changePlannedMap.get(logKey);
                    }
                    this.setValuePlanData(appNum, userId, date, manu, curCostObject, logPlan);
                    String billNo = manu.getString("billno").concat("-").concat(manu.getString("seq")).concat("-").concat(String.valueOf(mftOrderLog.getBillNo()));
                    if (billNo.length() > 255) {
                        billNo = billNo.substring(0, 255);
                    }
                    logPlan.set("billno", (Object)billNo);
                    logPlan.set("qty", (Object)mftOrderLog.getChangeQty());
                    BigDecimal totalinQty = logPlan.getBigDecimal("totalinqty") == null ? BigDecimal.ZERO : logPlan.getBigDecimal("totalinqty");
                    totalinQty = mftOrderLog.getChangeQty().subtract(totalinQty);
                    totalinQty = totalinQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalinQty;
                    logPlan.set("wipqty", (Object)totalinQty);
                    logPlan.set("fromlogid", (Object)mftOrderLog.getLogId());
                    logPlan.set("source", (Object)mftOrderLog.getSource());
                    String billtype = "";
                    if ("6".equals(mftOrderLog.getSource())) {
                        billtype = "pom_xmftorderlog";
                    } else if ("7".equals(mftOrderLog.getSource())) {
                        billtype = "om_xmftorderlog";
                    } else if ("8".equals(mftOrderLog.getSource())) {
                        billtype = "pom_mftorder_splitlog";
                    } else if ("9".equals(mftOrderLog.getSource())) {
                        billtype = "om_mftorder_splitog";
                    }
                    logPlan.set("srcbilltype", (Object)billtype);
                    logPlan.set("bizdate", (Object)mftOrderLog.getBizTime());
                    plannedBill.add(logPlan);
                }
            }
            if (existsManu.contains(idAndEntryId) && !isNeedChangeData && !isStatusChangeData) {
                logger.info("\u5de5\u5355{}\u884c\u53f7{}\u5df2\u5b58\u5728\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
                continue;
            }
            if (!existsManu.contains(idAndEntryId) && existBillNos.contains(manu.getString("billno") + "-" + manu.getString("seq"))) {
                logger.info("\u5de5\u5355{}\u884c\u53f7{}\u7684\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
                continue;
            }
            if (!isNeedChangeData && !isStatusChangeData) {
                ++addNum;
                plan.set("id", (Object)0L);
            } else if (isNeedChangeData) {
                ++updNum;
                plan = (DynamicObject)changePlannedMap.get(idAndEntryId);
            } else {
                plan = (DynamicObject)changeStatusMap.get(idAndEntryId);
                if (this.checkPlanStatus(manu, curCostObject, plan)) continue;
                ++updNum;
            }
            this.setValuePlanData(appNum, userId, date, manu, curCostObject, plan);
            plannedBill.add(plan);
        }
        this.getPlannedContext().setAddNum(this.getPlannedContext().getAddNum() + addNum);
        this.getPlannedContext().setUpdateNum(this.getPlannedContext().getUpdateNum() + updNum);
        logger.info("\u65b0\u589e\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", (Object)plannedBill.size());
        this.getPlannedContext().getCreatePlanDataByLogMap().clear();
        return plannedBill;
    }

    private void setValuePlanData(String appNum, Long userId, Date date, DynamicObject manu, DynamicObject curCostObject, DynamicObject plan) {
        plan.set("billno", (Object)manu.getString("billno").concat("-").concat(manu.getString("seq")));
        Date transmittime = manu.getDate("transmittime");
        plan.set("bizdate", (Object)transmittime);
        plan.set("srctransmittime", (Object)transmittime);
        plan.set("planneddate", (Object)manu.getDate("planendtime"));
        plan.set("appnum", (Object)appNum);
        plan.set("accountorg_id", (Object)curCostObject.getLong("org"));
        plan.set("costcenter_id", (Object)curCostObject.getLong("costcenter"));
        plan.set("manuorg_id", (Object)manu.getLong("org"));
        plan.set("creator", (Object)userId);
        plan.set("createtime", (Object)date);
        plan.set("billstatus", (Object)"C");
        plan.set("auditor", (Object)userId);
        plan.set("auditdate", (Object)date);
        plan.set("source", (Object)("PB".equals(manu.getString("sotype")) ? "3" : "4"));
        plan.set("srcbilltype", (Object)("PB".equals(manu.getString("sotype")) ? "pom_mftorder" : "om_mftorder"));
        plan.set("sourcebill", (Object)manu.getLong("id"));
        plan.set("sourcebillentry", (Object)manu.getLong("entryid"));
        plan.set("sourcebiztime", (Object)manu.getDate("transmittime"));
        plan.set("costobject_id", (Object)curCostObject.getLong("id"));
        plan.set("material_id", (Object)manu.getLong("matmasterid"));
        plan.set("baseunit", (Object)manu.getLong("unit"));
        plan.set("auxpty", (Object)curCostObject.getLong("auxpty"));
        plan.set("qty", (Object)(manu.getBigDecimal("qty") == null ? new BigDecimal(0) : manu.getBigDecimal("qty")));
        BigDecimal totalinQty = plan.getBigDecimal("totalinqty") == null ? BigDecimal.ZERO : plan.getBigDecimal("totalinqty");
        totalinQty = plan.getBigDecimal("qty").subtract(totalinQty);
        totalinQty = totalinQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalinQty;
        plan.set("wipqty", (Object)totalinQty);
        if (plan.getBoolean("closestatu") && "C".equals(manu.getString("bizstatus"))) {
            plan.set("closedatetime", (Object)manu.getDate("closebookdate"));
        } else if ("C".equals(manu.getString("planstatus")) && "C".equals(manu.getString("bizstatus"))) {
            plan.set("closeuser", (Object)userId);
            plan.set("closedatetime", (Object)manu.getDate("closebookdate"));
            plan.set("closestyle", (Object)"0");
            plan.set("closestatu", (Object)"1");
            plan.set("wipqty", (Object)BigDecimal.ZERO);
        } else if ("C".equals(manu.getString("planstatus")) && !"C".equals(manu.getString("bizstatus"))) {
            plan.set("closeuser", (Object)0L);
            plan.set("closedatetime", null);
            plan.set("closestyle", (Object)" ");
            plan.set("closestatu", (Object)"0");
        }
    }

    @Override
    public boolean checkPlanStatus(DynamicObject manu, DynamicObject curCostObject, DynamicObject plan) {
        if (plan.get("closestatu") != null && plan.getBoolean("closestatu") && !"C".equals(manu.getString("bizstatus")) && CostObjectHelper.isSettlement((Long)curCostObject.getLong("id"))) {
            logger.info("\u5de5\u5355{}\u884c\u53f7{}\u7684\u5bf9\u5e94\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u5df2\u5173\u95ed,\u4f46\u5de5\u5355\u672a\u5173\uff0c\u6838\u7b97\u5bf9\u8c61\u5df2\u7ed3\u7b97\u4e0d\u518d\u5f15\u5165\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
            return true;
        }
        if (plan.get("closestatu") != null && plan.getBoolean("closestatu") && "C".equals(manu.getString("bizstatus")) && CostObjectHelper.isSettlement((Long)curCostObject.getLong("id"))) {
            logger.info("\u5de5\u5355{}\u884c\u53f7{}\u7684\u5bf9\u5e94\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u5df2\u5173\u95ed,\u5de5\u5355\u5173\u95ed\uff0c\u6838\u7b97\u5bf9\u8c61\u5df2\u7ed3\u7b97\u4e0d\u518d\u5f15\u5165\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)manu.getString("billno"), (Object)manu.getString("seq"));
            return true;
        }
        return false;
    }

    private Set<String> dealExistsManu(Long acctOrg, Set<Long> costCenters, List<Long> manuOrgs, List<DynamicObject> manuBill, Map<String, DynamicObject> changePlannedMap, Map<String, DynamicObject> changeStatusMap, List<String> existBillNos, String appNum, List<Long> mftOrderEntryIds) {
        HashSet<String> needReturnInfo = new HashSet<String>(16);
        String sign = "-";
        String join = "@";
        String comp = "||";
        HashSet<Long> ids = new HashSet<Long>(16);
        HashSet<Long> entryIds = new HashSet<Long>(16);
        HashSet<String> srcBillno = new HashSet<String>(16);
        HashMap<String, String> newManuInfo = new HashMap<String, String>(16);
        HashMap<String, String> newManuInfoByStatus = new HashMap<String, String>(16);
        for (DynamicObject manu : manuBill) {
            ids.add(manu.getLong("id"));
            entryIds.add(manu.getLong("entryid"));
            if (!"C".equals(manu.getString("planstatus"))) continue;
            newManuInfo.put(manu.getString("id") + sign + manu.getString("entryid"), this.getJoinManuInfo(manu, join, true));
            newManuInfoByStatus.put(manu.getString("id") + sign + manu.getString("entryid"), this.getJoinManuInfoByStatus(manu, true));
            srcBillno.add(manu.getString("billno") + "-" + manu.getString("seq"));
        }
        if ((ids.size() == 0 || entryIds.size() == 0) && CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            this.deleteAll(acctOrg, costCenters, appNum, new String[]{"pom_mftorder", "pom_xmftorderlog", "pom_mftorder_splitlog", "om_mftorder", "om_xmftorderlog", "om_mftorder_splitog", "om_mftorder_splitog"});
            return needReturnInfo;
        }
        QFilter qfSourceBill = new QFilter("sourcebill", "in", ids);
        qfSourceBill.and(new QFilter("sourcebillentry", "in", entryIds));
        QFilter qfBillNo = new QFilter("billno", "in", srcBillno);
        qfSourceBill = qfSourceBill.or(qfBillNo);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        DynamicObjectCollection existPlans = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"id,sourcebill,sourcebillentry,fromlogid", (QFilter[])new QFilter[]{qfSourceBill, qfAppNum});
        existPlans.forEach(p -> {
            Long fromlogid = p.getLong("fromlogid");
            if (CadEmptyUtils.isEmpty((Long)fromlogid)) {
                needReturnInfo.add(p.getString("sourcebill") + sign + p.getString("sourcebillentry"));
            } else {
                needReturnInfo.add(p.getString("sourcebill") + sign + p.getString("sourcebillentry") + sign + fromlogid);
            }
        });
        QFilter qfOrgAndCostCenter = new QFilter("accountorg", "=", (Object)-1L);
        if (!CadEmptyUtils.isEmpty((Long)acctOrg)) {
            qfOrgAndCostCenter = new QFilter("accountorg", "in", (Object)acctOrg);
        }
        if (!CadEmptyUtils.isEmpty(costCenters)) {
            qfOrgAndCostCenter = qfOrgAndCostCenter.and(new QFilter("costcenter", "in", costCenters));
        }
        QFilter manuOrgQf = new QFilter("manuorg", ">=", (Object)0L);
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            manuOrgQf = new QFilter("manuorg", "in", manuOrgs);
        }
        QFilter qfbizTime = SysParamHelper.getImportTimeScope((Long)acctOrg, (String)"bizdate", (String)appNum);
        qfbizTime = CadEmptyUtils.isEmpty(mftOrderEntryIds) ? qfbizTime.or(qfSourceBill) : new QFilter("sourcebillentry", "in", mftOrderEntryIds);
        QFilter[] qFilters = new QFilter[]{qfOrgAndCostCenter, qfbizTime, qfAppNum, manuOrgQf};
        DynamicObjectCollection plannedBill = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"id,accountorg,accountorg accountorg_id,costobject,costobject costobject_id,costcenter,costcenter costcenter_id,billno,billno Seq,bizdate transmittime,sourcebiztime,planneddate planendtime,material matmasterid,baseunit unit,auxpty auxproperty,qty,sourcebill,sourcebillentry,closestatu,fromlogid", (QFilter[])qFilters);
        plannedBill.forEach(p -> existBillNos.add(p.getString("billno")));
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u5df2\u5b58\u5728\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff1a{}", existBillNos);
        if (plannedBill.size() == 0) {
            return needReturnInfo;
        }
        Map<Long, DynamicObject> plannedMap = this.getPlannedMap(plannedBill);
        HashSet<Long> needDeleteIds = new HashSet<Long>(16);
        HashSet<Long> needDeleteSrcIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> costChangeRecords = new ArrayList<DynamicObject>(16);
        for (DynamicObject planned : plannedBill) {
            String key = planned.getString("sourcebill") + sign + planned.getString("sourcebillentry");
            String newVal = (String)newManuInfo.get(key);
            String newStatus = (String)newManuInfoByStatus.get(key);
            Long fromLogId = planned.getLong("fromlogid");
            if (!CadEmptyUtils.isEmpty((Long)fromLogId)) {
                key = key + sign + fromLogId;
            }
            if (CadEmptyUtils.isEmpty((String)newVal)) {
                if (!CadEmptyUtils.isEmpty((Long)planned.getLong("sourcebill"))) {
                    needDeleteIds.add(planned.getLong("id"));
                    needDeleteSrcIds.add(planned.getLong("sourcebill"));
                    needReturnInfo.remove(key);
                }
                if (!CostObjectHelper.isSettlement((Long)planned.getLong("costobject"))) continue;
                costChangeRecords.add(planned);
                continue;
            }
            needReturnInfo.add(key);
            String oldVal = this.getJoinManuInfo(planned, join, false);
            String oldStatus = this.getJoinManuInfoByStatus(planned, false);
            if (!CadEmptyUtils.isEmpty((Long)fromLogId) || !newVal.equals(oldVal)) {
                changePlannedMap.put(key, plannedMap.get(planned.getLong("id")));
                continue;
            }
            if (newStatus.equals(oldStatus)) continue;
            changeStatusMap.put(key, plannedMap.get(planned.getLong("id")));
        }
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u9700\u8981\u5220\u9664\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", needDeleteIds);
        if (needDeleteIds.size() > 0 && needDeleteSrcIds.size() > 0 && CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            logger.info("\u9700\u8981\u5220\u9664\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355:{}", (Object)JSON.toJSONString(needDeleteIds));
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cad_plannedoutputbill"), (Object[])needDeleteIds.toArray(new Long[0]));
            this.delChangeRecord(needDeleteSrcIds);
            this.getPlannedContext().setDelNum(this.getPlannedContext().getDelNum() + needDeleteIds.size());
        }
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u9700\u8981\u586b\u5199\u53d8\u66f4\u8bb0\u5f55\u7684\u6761\u6570:{}", (Object)costChangeRecords.size());
        if (costChangeRecords.size() > 0) {
            this.getPlannedContext().getChangeRecords().addAll(costChangeRecords);
        }
        return needReturnInfo;
    }

    private DynamicObject getCostObjectInfo(Long org, Long costCenter, DynamicObject manu, Map<String, DynamicObject> costObjects) {
        if (CadEmptyUtils.isEmpty(costObjects)) {
            return null;
        }
        StringBuilder coKey = new StringBuilder();
        coKey.append(org).append("@").append(costCenter).append("@").append(manu.getString("billno")).append("@").append(manu.getString("entryid")).append("@").append(manu.getString("matmasterid"));
        String key = coKey.toString();
        return costObjects.get(key);
    }

    private Map<String, DynamicObject> getCostObjectMapByMaterial(Set<Long> costCenters, List<DynamicObject> manuBill) {
        HashMap<String, DynamicObject> costObjectMap = new HashMap<String, DynamicObject>();
        HashSet<Long> materialId = new HashSet<Long>(16);
        HashSet<String> billno = new HashSet<String>(16);
        for (DynamicObject manu : manuBill) {
            materialId.add(manu.getLong("matmasterid"));
            billno.add(manu.getString("billno"));
        }
        if (CadEmptyUtils.isEmpty(materialId)) {
            return null;
        }
        QFilter qfBillNo = new QFilter("srcbillnumber", "in", (Object)billno.toArray());
        QFilter qfMat = new QFilter("material", "in", (Object)materialId.toArray());
        QFilter qfCostenters = new QFilter("costcenter", "in", costCenters);
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        DynamicObjectCollection dyCostObject = QueryServiceHelper.query((String)"cad_costobject", (String)"srcbillnumber,srcbillrow,probill,org.id org,costcenter.id costcenter,material.id matid,id,material.isenablematerialversion isenablematerialversion,bomversion,auxpty", (QFilter[])new QFilter[]{qfBillNo, qfMat, qfCostenters, qfBillStatus});
        dyCostObject.forEach(cost -> costObjectMap.put(cost.getString("org") + "@" + cost.getString("costcenter") + "@" + cost.getString("srcbillnumber") + "@" + cost.getString("probill") + "@" + cost.getString("matid"), (DynamicObject)cost));
        return costObjectMap;
    }
}

