/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.plannedoutput;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.mservice.plannedoutput.AbstractPlannedAction;
import org.apache.commons.collections4.CollectionUtils;

public class ScaPlannedWriteCostChangeAction
extends AbstractPlannedAction {
    @Override
    protected void doExecute() {
        List<DynamicObject> changeRecords;
        this.getPlannedContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u5199\u6210\u672c\u53d8\u66f4\u8bb0\u5f55", (String)"ScaPlannedWriteCostChangeAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        int count = 0;
        List<DynamicObject> addRecords = this.getPlannedContext().getPlanOutPutBills();
        if (CollectionUtils.isNotEmpty(addRecords)) {
            int addCount = this.writeToCostChangeRecords(addRecords, false);
            count += addCount;
        }
        if (CollectionUtils.isNotEmpty(changeRecords = this.getPlannedContext().getChangeRecords())) {
            int changeCount = this.writeToCostChangeRecords(changeRecords, true);
            count += changeCount;
        }
        this.getPlannedContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5199\u6210\u672c\u53d8\u66f4\u8bb0\u5f55\u3010%s\u3011\u6761", (String)"ScaPlannedWriteCostChangeAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), count));
    }

    private int writeToCostChangeRecords(List<DynamicObject> plannedBills, boolean isDeleted) {
        ArrayList<DynamicObject> CostChangeRecords = new ArrayList<DynamicObject>(10);
        ArrayList<Long> srcbillIds = new ArrayList<Long>(10);
        ArrayList<Long> exitCostObject = new ArrayList<Long>(10);
        for (DynamicObject plannedBill : plannedBills) {
            exitCostObject.add(plannedBill.getLong("costobject_id"));
            srcbillIds.add(plannedBill.getLong("sourcebill"));
        }
        List<Long> settlChangeRecords = ScaPlannedWriteCostChangeAction.getChangeRecordBySettled(srcbillIds);
        Long matId = 0L;
        List settlCostObjects = CostObjectHelper.getSettlCostObject(exitCostObject);
        for (DynamicObject plannedBill : plannedBills) {
            Object material;
            if (!settlCostObjects.contains(plannedBill.getLong("costobject_id")) || isDeleted && !settlChangeRecords.contains(plannedBill.getLong("sourcebill"))) continue;
            matId = ImportServiceHelper.isStartCollConfigScheme().booleanValue() ? ((material = plannedBill.get("material")) instanceof DynamicObject ? Long.valueOf(((DynamicObject)material).getLong("id")) : Long.valueOf(Long.parseLong(String.valueOf(material)))) : (isDeleted ? Long.valueOf(plannedBill.getLong("matmasterid")) : Long.valueOf(plannedBill.getLong("material_id")));
            DynamicObject costChange = BusinessDataServiceHelper.newDynamicObject((String)"sca_costchangerecord");
            costChange.set("org", (Object)plannedBill.getLong("accountorg_id"));
            costChange.set("costobject", (Object)plannedBill.getLong("costobject_id"));
            costChange.set("costcenter", (Object)plannedBill.getLong("costcenter_id"));
            costChange.set("businessbill", (Object)"cad_plannedoutputbill");
            costChange.set("sourcebiztime", (Object)plannedBill.getDate("bizdate"));
            costChange.set("changecontext", (Object)(plannedBill.getString("billno") + "@" + matId + "@" + plannedBill.getString("qty")));
            costChange.set("sourcebill", (Object)plannedBill.getLong("sourcebill"));
            costChange.set("creator", (Object)RequestContext.get().getUserId());
            costChange.set("createtime", (Object)TimeServiceHelper.now());
            CostChangeRecords.add(costChange);
        }
        SaveServiceHelper.save((DynamicObject[])CostChangeRecords.toArray(new DynamicObject[0]));
        return CostChangeRecords.size();
    }

    private static List<Long> getChangeRecordBySettled(List<Long> srcbillIds) {
        QFilter filter = new QFilter("sourcebill", "in", srcbillIds);
        filter.and("bizstatus", "=", (Object)"B");
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)"sca_costchangerecord", (String)"sourcebill", (QFilter[])new QFilter[]{filter});
        srcbillIds.clear();
        for (DynamicObject sourceBill : sourceBills) {
            srcbillIds.add(sourceBill.getLong("sourcebill"));
        }
        return srcbillIds;
    }
}

