/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.planresource;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.planresource.IPlanResourceAction;
import kd.macc.cad.mservice.planresource.PlanResourceContext;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractPlanResourceAction
implements IPlanResourceAction {
    private Log logger = LogFactory.getLog(AbstractPlanResourceAction.class);
    private PlanResourceContext planResourceContext;

    protected abstract void doExecute();

    @Override
    public void execute() {
        if (this.planResourceContext.isContinueExecute()) {
            this.doExecute();
        }
    }

    public PlanResourceContext getPlanResourceContext() {
        return this.planResourceContext;
    }

    @Override
    public void setContext(PlanResourceContext planResourceContext) {
        this.planResourceContext = planResourceContext;
    }

    protected Map<String, DynamicObject> getExistResourceBills(Long acctOrgId, List<Long> manuOrgs, List<Long> costCenterIds, List<Long> mftorderentryids, Set<String> selectFields, Set<Long> sourceIds, List<String> targetBillNos, String appNum) {
        HashMap<String, DynamicObject> existResourceBillMap = new HashMap<String, DynamicObject>(16);
        HashSet<String> costSelectFields = new HashSet<String>(selectFields);
        costSelectFields.add("id");
        costSelectFields.add("billno");
        costSelectFields.add("srcbillid");
        costSelectFields.add("org");
        costSelectFields.add("entryentity.costobject");
        costSelectFields.add("costcenter");
        costSelectFields.add("bizdate");
        QFilter commonQF = null;
        if (mftorderentryids != null && !mftorderentryids.isEmpty() && sourceIds != null && !sourceIds.isEmpty()) {
            commonQF = new QFilter("srcbillid", "in", sourceIds);
            commonQF = commonQF.or(new QFilter("billno", "in", targetBillNos));
        } else {
            commonQF = SysParamHelper.getImportTimeScope((Long)acctOrgId, (String)"bookdate", (String)appNum);
            if (acctOrgId != null) {
                commonQF.and("org", "=", (Object)acctOrgId);
            }
            if (costCenterIds != null && !costCenterIds.isEmpty()) {
                commonQF.and("costcenter", "in", costCenterIds);
            } else {
                commonQF.and("costcenter", "=", (Object)-1L);
            }
            if (!CadEmptyUtils.isEmpty(manuOrgs)) {
                commonQF.and("manuorg", "in", manuOrgs);
            }
        }
        commonQF.and("appnum", "=", (Object)appNum);
        this.logger.info("\u67e5\u8be2\u5df2\u6709\u7684\u5f52\u96c6\u5355\u53c2\u6570" + commonQF.toString());
        DynamicObjectCollection resUesBills = QueryServiceHelper.query((String)"sca_resourceuse", (String)String.join((CharSequence)",", costSelectFields), (QFilter[])new QFilter[]{commonQF});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)resUesBills)) {
            return existResourceBillMap;
        }
        for (DynamicObject resUesBill : resUesBills) {
            existResourceBillMap.put(resUesBill.getString("billno") + "@" + resUesBill.getString("srcbillid"), resUesBill);
        }
        return existResourceBillMap;
    }

    protected List<Long> getChangeRecordBySettled(List<Long> srcbillIds) {
        QFilter filter = new QFilter("sourcebill", "in", srcbillIds);
        filter.and("bizstatus", "=", (Object)"B");
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)"sca_costchangerecord", (String)"sourcebill", (QFilter[])new QFilter[]{filter});
        srcbillIds.clear();
        sourceBills.forEach(p -> srcbillIds.add(p.getLong("sourcebill")));
        return srcbillIds;
    }

    protected List<Long> getExistsCompletBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, String srcBillType, String appNum) {
        QFilter orgQf = new QFilter("org", "in", (Object)org);
        orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
        QFilter voucherTypeQf = new QFilter("vouchertype", "=", (Object)" ");
        QFilter costObjectQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter AppnumQf = new QFilter("appnum", "=", (Object)appNum);
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            orgQf.and(new QFilter("manuorg", "in", manuOrgs));
        }
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        DynamicObjectCollection completionList = QueryServiceHelper.query((String)"sca_resourceuse", (String)"id", (QFilter[])new QFilter[]{orgQf, costObjectQf, bookDateQf, AppnumQf, voucherTypeQf});
        if (CadEmptyUtils.isEmpty((List)completionList)) {
            return null;
        }
        return completionList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    protected List<Long> getExistsCompletBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, List<Long> mftOrderEntryIds, Map<String, String> configRuleMappingMap, String srcBillType, String appNum) {
        if (CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            return this.getExistsCompletBill(org, methodCostCenters, manuOrgs, srcBillType, appNum);
        }
        if (CadEmptyUtils.isEmpty((String)configRuleMappingMap.get("probill"))) {
            return null;
        }
        QFilter orgQf = new QFilter("org", "in", (Object)org);
        orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
        QFilter costObjectQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter sourceBillQf = new QFilter("entryentity.costobject.probill", "in", mftOrderEntryIds);
        QFilter voucherTypeQf = new QFilter("vouchertype", "=", (Object)" ");
        QFilter AppnumQf = new QFilter("appnum", "=", (Object)appNum);
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        DynamicObjectCollection completionList = QueryServiceHelper.query((String)"sca_resourceuse", (String)"id", (QFilter[])new QFilter[]{orgQf, costObjectQf, sourceBillQf, bookDateQf, AppnumQf, voucherTypeQf});
        if (CadEmptyUtils.isEmpty((List)completionList)) {
            return null;
        }
        return completionList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    protected Map<Long, Long> entryIdResourceMap(DataSet existResourceUse) {
        HashMap idEntryIdResourceMap = Maps.newHashMapWithExpectedSize((int)128);
        if (existResourceUse == null || existResourceUse.isEmpty()) {
            return idEntryIdResourceMap;
        }
        for (Row row : existResourceUse) {
            Long id = row.getLong("id");
            Long srcEntryId = row.getLong("srcentryid");
            idEntryIdResourceMap.put(srcEntryId, id);
        }
        return idEntryIdResourceMap;
    }

    protected void dealExitsData(Map<String, DynamicObject> idEntryIdCompleteMap, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, DynamicObject> changeResourceMap, Set<String> selectFields, String appNum) {
        if (CadEmptyUtils.isEmpty(idEntryIdCompleteMap) || CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return;
        }
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTartgetBill : srcAndTargetBillsMap.entrySet()) {
            String newBillStr;
            String oldBillStr;
            DynamicObject newBill = srcAndTartgetBill.getValue();
            String key = newBill.getString("billno").concat("-").concat(newBill.getString("srcbillid"));
            DynamicObject oldBill = idEntryIdCompleteMap.get(key);
            if (oldBill == null || (oldBillStr = CommonCollConfigService.getBillInfoBySelectFields((DynamicObject)oldBill, selectFields)).equals(newBillStr = CommonCollConfigService.getBillInfoBySelectFields((DynamicObject)newBill, selectFields))) continue;
            changeResourceMap.put(key, newBill);
            this.getPlanResourceContext().getCostChangeContentMap().put(key, oldBillStr + "#" + newBillStr);
        }
    }

    protected int save(List<DynamicObject> sourceBills, CollectReport report) {
        if (CollectionUtils.isEmpty(sourceBills)) {
            return 0;
        }
        List billNos = sourceBills.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toList());
        this.logger.info("\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6-\u5f15\u5165\u7684\u5f52\u96c6\u5355\u7f16\u53f7\uff1a{}", (Object)JSON.toJSONString(billNos));
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_planresource", (DynamicObject[])sourceBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        int successQty = operateResult.getSuccessPkIds() == null ? 0 : operateResult.getSuccessPkIds().size();
        this.getPlanResourceContext().setSuccessNum(successQty);
        if (!operateResult.isSuccess()) {
            String errorInfo = OperationResultHelper.errorMsgHandle((OperationResult)operateResult);
            ValidateResultCollection validateResult = operateResult.getValidateResult();
            HashSet errorDataIndexs = validateResult.getErrorDataIndexs();
            for (Integer errorDataIndex : errorDataIndexs) {
                DynamicObject errorDynamic = sourceBills.get(errorDataIndex);
                String billno = errorDynamic.getString("billno");
                String srcBillNo = errorDynamic.getString("srcbillnum");
                Long srcBillEntryId = errorDynamic.getLong("srcentryid");
                Object srcBillTypeObj = errorDynamic.get("srcbilltype");
                String srcbilltype = "";
                srcbilltype = srcBillTypeObj instanceof DynamicObject ? ((DynamicObject)srcBillTypeObj).getString("number") : srcBillTypeObj.toString();
                if (StringUtils.isEmpty((CharSequence)billno)) continue;
                int seq = this.getPlanResourceContext().getEntryIdAndSeqMap().get(srcBillEntryId);
                this.getPlanResourceContext().logErrorMsg(srcBillNo.concat("@").concat(seq + "").concat("@").concat(srcbilltype), ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5355\u5931\u8d25\u3002", (String)"AbstractPlanResourceAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            }
            this.logger.error("\u4fdd\u5b58\u5931\u8d25\u3002" + errorInfo);
            this.getPlanResourceContext().setValidate(true);
            report.setError(true);
            report.logTip(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u53d1\u73b0\u5f02\u5e38\u3002", (String)"AbstractPlanResourceAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), errorInfo);
        }
        return successQty;
    }

    protected void refreshProgress(String opContent, int nowComplete, int total, Boolean isAddNum) {
        PlanResourceContext planResourceContext = this.getPlanResourceContext();
        String progressId = planResourceContext.getPlanResourceArgs().getProgressId();
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (isAddNum.booleanValue()) {
            Integer complete = paramDto.getComplete();
            paramDto.setComplete(Integer.valueOf(complete + nowComplete));
        } else {
            paramDto.setComplete(Integer.valueOf(nowComplete));
        }
        if (!CadEmptyUtils.isEmpty((Integer)total)) {
            paramDto.setTotal(Integer.valueOf(total));
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"AbstractPlanResourceAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
        paramDto.setDurationTimes(Integer.valueOf(0));
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam((String)progressId, (ProgressParamDto)paramDto);
        this.setReportPressAndDur(progressId);
    }

    private void setReportPressAndDur(String progressId) {
        Date coldate;
        int progress = this.getProgress(progressId);
        Long id = this.getPlanResourceContext().getCollectReport().getId();
        String duration = "";
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_colreport", (String)"coldate", (QFilter[])qFilter.toArray());
        if (dynamicObject != null && (coldate = dynamicObject.getDate("coldate")) != null) {
            double time = (double)(System.currentTimeMillis() - coldate.getTime()) / 1000.0;
            if (0.0 < time && time < 1.0) {
                time = 1.0;
            }
            duration = String.valueOf((int)time);
        }
        try (TXHandle handle = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cad_colreport set fprogress=" + progress + ",fduration=" + duration + " where fid =" + id));
        }
    }

    public int getProgress(String progressId) {
        if (StringUtils.isEmpty((CharSequence)progressId)) {
            return 0;
        }
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return 0;
        }
        if (CadEmptyUtils.isEmpty((Integer)paramDto.getTotal()) || CadEmptyUtils.isEmpty((Integer)paramDto.getComplete())) {
            return 0;
        }
        return (int)((double)paramDto.getComplete().intValue() / (double)paramDto.getTotal().intValue() * 100.0);
    }
}

