/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.planresource;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.mservice.planresource.AbstractPlanResourceAction;

public class CompletionSaveAction
extends AbstractPlanResourceAction {
    private static final Log logger = LogFactory.getLog(CompletionSaveAction.class);

    @Override
    protected void doExecute() {
        this.getPlanResourceContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f52\u96c6\u5230\u7684\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5355\u3002", (String)"CompletionSaveAction_31", (String)"macc-cad-mservice", (Object[])new Object[0]));
        this.refreshProgress(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f52\u96c6\u5230\u7684\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5355\u3002", (String)"CompletionSaveAction_31", (String)"macc-cad-mservice", (Object[])new Object[0]), 5, 7, false);
        List<DynamicObject> resourceBills = this.getPlanResourceContext().getImportBillList();
        List billNos = resourceBills.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toList());
        logger.info("\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5185\u90e8\u7cfb\u7edf\u5f15\u5165-\u5f15\u5165\u7684\u5f52\u96c6\u5355\u7f16\u53f7\uff1a{}", billNos);
        boolean saveValidate = "1".equals(CadBgParamUtils.getCadBgParamForString((String)"resuseImportSaveValid", (String)"1"));
        int saveSize = resourceBills.size();
        int batchSize = 300;
        int successSize = 0;
        if (saveSize <= batchSize * 3) {
            Object[] obj;
            successSize = saveValidate ? (successSize += this.save(resourceBills, this.getPlanResourceContext().getCollectReport())) : (successSize += (obj = SaveServiceHelper.save((DynamicObject[])resourceBills.toArray(new DynamicObject[0]))) == null ? 0 : obj.length);
        } else {
            int batchCount = saveSize / batchSize + 1;
            for (int i = 0; i < batchCount; ++i) {
                int startCount = i * batchSize;
                int endCount = (i + 1) * batchSize;
                if (i == batchCount - 1) {
                    endCount = saveSize;
                }
                List<DynamicObject> batchBillList = resourceBills.subList(startCount, endCount);
                if (saveValidate) {
                    successSize += this.save(batchBillList, this.getPlanResourceContext().getCollectReport());
                    continue;
                }
                Object[] obj = SaveServiceHelper.save((DynamicObject[])batchBillList.toArray(new DynamicObject[0]));
                successSize += obj == null ? 0 : obj.length;
            }
        }
        this.getPlanResourceContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"%s\u6761\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5355\u4fdd\u5b58\u6210\u529f\u3002", (String)"CompletionSaveAction_32", (String)"macc-cad-mservice", (Object[])new Object[0]), successSize));
    }
}

