/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.planresource;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.business.config.service.CostObjectService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.planresource.AbstractPlanResourceAction;
import kd.macc.cad.mservice.planresource.PlanResourceArgs;

public class PlanResourceConditionAction
extends AbstractPlanResourceAction {
    private static final Log logger = LogFactory.getLog(PlanResourceConditionAction.class);

    @Override
    protected void doExecute() {
        this.refreshProgress(ResManager.loadKDString((String)"\u6784\u5efa\u6761\u4ef6\uff0c\u5f52\u96c6\u5f00\u59cb\u3002", (String)"PlanResourceConditionAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, 7, false);
        PlanResourceArgs resourceUseArgs = this.getPlanResourceContext().getPlanResourceArgs();
        String appNum = resourceUseArgs.getAppNum();
        Long accountOrgId = resourceUseArgs.getAcctOrgId();
        List<Long> costCenterIds = resourceUseArgs.getCostCenterIds();
        Map<String, String> responseInfo = this.getPlanResourceContext().getResponseInfo();
        Map<String, List<Long>> acctOrgCalmethodCostCentersMap = this.getPlanResourceContext().getOrgMethodCostCenters();
        if (CadEmptyUtils.isEmpty(costCenterIds)) {
            logger.info("\u6ca1\u6709\u5728\u6210\u672c\u53c2\u6570\u4e2d\u914d\u7f6e\u9700\u8981\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\u7684\u6210\u672c\u4e2d\u5fc3\u3002");
            this.refreshProgress(ResManager.loadKDString((String)"\u6ca1\u6709\u5728\u6210\u672c\u53c2\u6570\u4e2d\u914d\u7f6e\u9700\u8981\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"PlanResourceConditionAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 8, false);
            MsgUtils.putMsg2Map((String)"tip", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u5728\u6210\u672c\u53c2\u6570\u4e2d\u914d\u7f6e\u9700\u8981\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"PlanResourceConditionAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), responseInfo);
            this.getPlanResourceContext().setContinueExecute(false);
            return;
        }
        List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)Long.parseLong(RequestContext.get().getUserId()), Collections.singletonList(accountOrgId), (Set)Sets.newHashSet(costCenterIds), (String)"cad_planresource", (String)appNum);
        Map rulesMap = null;
        Map costCenterByRules = null;
        Map dimensionAndRuleMap = null;
        if (ImportServiceHelper.isStartCollConfigScheme().booleanValue()) {
            List cuCostCenters;
            List flCostCenters;
            List pzCostCenters;
            List fpCostCenters;
            dimensionAndRuleMap = CostObjectService.getDimensionAndRuleMap();
            rulesMap = CostObjectHelper.getCostObjectRulesMap((Long)accountOrgId, (List)enableCostCenters);
            costCenterByRules = CostObjectHelper.groupCostCenterByRules((List)enableCostCenters, (Map)rulesMap);
            List importScopeDate = PlanFeeAllocHelper.getImportScopeDate((Long)resourceUseArgs.getPlanSchemeId());
            CostCenterHelper.getWorkCenter(costCenterIds, (List)importScopeDate, (CollectReport)this.getPlanResourceContext().getCollectReport());
            CostCenterHelper.getAdminOrg(costCenterIds, (List)importScopeDate, (CollectReport)this.getPlanResourceContext().getCollectReport());
            CostCenterHelper.getBosOrgs(costCenterIds, (List)importScopeDate, (CollectReport)this.getPlanResourceContext().getCollectReport());
            String key = accountOrgId + CostObjectEnum.BIZTYPE_RO.getValue();
            List reProduceCostCenters = (List)costCenterByRules.get(key);
            if (!CadEmptyUtils.isEmpty((List)reProduceCostCenters)) {
                this.getPlanResourceContext().getCollectReport().setReProCostCenters(reProduceCostCenters);
            }
            if (!CadEmptyUtils.isEmpty((List)(fpCostCenters = (List)costCenterByRules.get(key = accountOrgId + CostObjectEnum.BIZTYPE_SO.getValue())))) {
                this.getPlanResourceContext().getCollectReport().setFpCostCenters(fpCostCenters);
            }
            if (!CadEmptyUtils.isEmpty((List)(pzCostCenters = (List)costCenterByRules.get(key = accountOrgId + CostObjectEnum.BIZTYPE_PZ.getValue())))) {
                this.getPlanResourceContext().getCollectReport().setPzCostCenters(pzCostCenters);
            }
            if (!CadEmptyUtils.isEmpty((List)(flCostCenters = (List)costCenterByRules.get(key = accountOrgId + CostObjectEnum.BIZTYPE_FL.getValue())))) {
                this.getPlanResourceContext().getCollectReport().setFlCostCenters(flCostCenters);
            }
            if (!CadEmptyUtils.isEmpty((List)(cuCostCenters = (List)costCenterByRules.get(key = accountOrgId + CostObjectEnum.BIZTYPE_CU.getValue())))) {
                this.getPlanResourceContext().getCollectReport().setCuCostCenters(cuCostCenters);
            }
        } else {
            rulesMap = CostObjectHelper.getRulesMap((Long)accountOrgId, (List)enableCostCenters);
            costCenterByRules = CostObjectHelper.groupCostCenterByRules((Long)accountOrgId, (List)enableCostCenters, (Map)rulesMap);
        }
        if (CadEmptyUtils.isEmpty((Map)costCenterByRules)) {
            this.refreshProgress(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"PlanResourceConditionAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 8, false);
            MsgUtils.putMsg2Map((String)"tip", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"PlanResourceConditionAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), responseInfo);
            return;
        }
        acctOrgCalmethodCostCentersMap.putAll(costCenterByRules);
        this.getPlanResourceContext().getRulesMap().putAll(rulesMap);
        if (!CadEmptyUtils.isEmpty((Map)dimensionAndRuleMap)) {
            this.getPlanResourceContext().getDimensionAndRuleMap().putAll(dimensionAndRuleMap);
        }
    }
}

