/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.planresource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.business.numcheck.CollNumCheckHelper;
import kd.macc.cad.common.dto.CollectDiff;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.mservice.planresource.AbstractPlanResourceAction;

public class PlanResourceDiffForConfigAction
extends AbstractPlanResourceAction {
    private final Log logger = LogFactory.getLog(PlanResourceDiffForConfigAction.class);

    @Override
    protected void doExecute() {
        if (!CollectReportHelper.disableCollectReport()) {
            CollectReport collectReport = this.getPlanResourceContext().getCollectReport();
            this.getPlanResourceContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u68c0\u67e5\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5dee\u5f02", (String)"PlanResourceDiffForConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            this.refreshProgress(ResManager.loadKDString((String)"\u68c0\u67e5\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5dee\u5f02", (String)"PlanResourceDiffForConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 7, false);
            Map billNoReasonMap = this.getPlanResourceContext().getErrorInfMap();
            ArrayList diffs = Lists.newArrayListWithExpectedSize((int)8);
            for (Map.Entry billNoReason : billNoReasonMap.entrySet()) {
                String key = (String)billNoReason.getKey();
                String[] split = key.split("@");
                String value = (String)billNoReason.getValue();
                CollectDiff collectDiff = new CollectDiff(split[0], Integer.valueOf(Integer.parseInt(split[1])), split[2], value);
                collectDiff.setSrcbillType(split[2]);
                if (value.length() > 0) {
                    collectDiff.setReason(value);
                }
                diffs.add(collectDiff);
            }
            this.getDiffReason(collectReport.getDateRange(), diffs);
            if (diffs.size() > 0) {
                this.getPlanResourceContext().getCollectReport().getCollectDiffs().addAll(diffs);
                this.getPlanResourceContext().getCollectReport().setError(true);
            }
            String desc = ResManager.loadKDString((String)"\u5171\u6709\u5dee\u5f02\u6570\u636e%s\u6761\u3002", (String)"PlanResourceDiffForConfigAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]);
            this.getPlanResourceContext().getCollectReport().logCheckDesc(String.format(desc, diffs.size()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{collectReport.transfer2Dynamic(Boolean.FALSE)});
        }
    }

    private void getDiffReason(String daterange, List<CollectDiff> diffs) {
        Long accountOrgId = this.getPlanResourceContext().getPlanResourceArgs().getAcctOrgId();
        String appNum = this.getPlanResourceContext().getPlanResourceArgs().getAppNum();
        List<Long> costCenterIds = this.getPlanResourceContext().getPlanResourceArgs().getCostCenterIds();
        CollNumCheckHelper.getCostCenterDiff((String)"PLAN_RESOURCE", (String)daterange, (Long)accountOrgId, (String)appNum, costCenterIds, diffs, (Long)this.getPlanResourceContext().getPlanResourceArgs().getPlanSchemeId());
    }
}

