/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.planresource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.planresource.AbstractPlanResourceAction;
import kd.macc.cad.mservice.planresource.PlanResourceArgs;
import kd.macc.cad.mservice.planresource.PlanResourceContext;

public class PlanResourceImportDataConfigAction
extends AbstractPlanResourceAction {
    private static final Log logger = LogFactory.getLog(PlanResourceImportDataConfigAction.class);

    @Override
    protected void doExecute() {
        PlanResourceArgs resourceUseArgs = this.getPlanResourceContext().getPlanResourceArgs();
        Long accountOrgId = resourceUseArgs.getAcctOrgId();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getPlanResourceContext().getConfigSrcAndTargetBillsMap();
        Map<Long, String> dimensionAndRuleMap = this.getPlanResourceContext().getDimensionAndRuleMap();
        String key = accountOrgId + CostObjectEnum.BIZTYPE_RO.getValue();
        List<Long> reProduceCostCenters = this.getPlanResourceContext().getOrgMethodCostCenters().get(key);
        if (CadEmptyUtils.isEmpty(reProduceCostCenters)) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u5de5\u5355\u6210\u672c\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5f15\u5165\u7ed3\u675f\uff01", (Object)accountOrgId);
            return;
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u5de5\u5355\u6cd5\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5904\u7406", (String)"PlanResourceImportDataConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 3, 7, false);
        this.getPlanResourceContext().getCollectReport().setReProCostCenters(reProduceCostCenters);
        for (Map.Entry<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
            DynamicObject config = configSrcAndTargetBill.getKey();
            String sourceBill = config.getString("sourcebill.id");
            String sourcebillName = config.getString("sourcebill.name");
            if (!CostObjectEnum.BIZTYPE_RO.getValue().equals(config.getString("calmethod"))) continue;
            Map<DynamicObject, DynamicObject> srcAndTargetBillsMap = configSrcAndTargetBill.getValue();
            ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
            this.getPlanResourceContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%s", (String)"PlanResourceImportDataConfigAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName));
            this.getPlanResourceContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u201c%1$s\u201d%2$s\u6761\u6570\u636e\u3002", (String)"PlanResourceImportDataConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName, srcBills.size()));
            long costcalcdimension = config.getLong("costcalcdimension.id");
            String dimension = dimensionAndRuleMap.get(costcalcdimension);
            if (CadEmptyUtils.isEmpty((String)dimension)) {
                this.getPlanResourceContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"PlanResourceImportDataConfigAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u6ca1\u6709\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ef4\u5ea6\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"PlanResourceImportDataConfigAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                continue;
            }
            this.getPlanResourceContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\uff0c\u5904\u7406\u6e90\u5355\u3002", (String)"PlanResourceImportDataConfigAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
            List<DynamicObject> resourceBills = this.getResourceBill(reProduceCostCenters, srcAndTargetBillsMap, this.getPlanResourceContext().getSrcBillIdIdMap(), sourceBill);
            this.getPlanResourceContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u6570\u636e%s\u6761\u3002", (String)"PlanResourceImportDataConfigAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]), resourceBills.size()));
        }
    }

    private List<DynamicObject> getResourceBill(List<Long> costCenters, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<Long, Long> srcBillIdIdMap, String sourceBill) {
        ArrayList<DynamicObject> resourceBills = new ArrayList<DynamicObject>(10);
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return resourceBills;
        }
        int addNum = 0;
        boolean delNum = false;
        PlanResourceContext context = this.getPlanResourceContext();
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBill : srcAndTargetBillsMap.entrySet()) {
            DynamicObject srcBill = srcAndTargetBill.getKey();
            DynamicObject targetBill = srcAndTargetBill.getValue();
            if (!sourceBill.equals(srcBill.getString("billtype"))) continue;
            if (targetBill == null) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u3002", (String)"PlanResourceImportDataConfigAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            Long costCenterId = targetBill.getLong("costcenter.id");
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"PlanResourceImportDataConfigAction_8", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            if (!costCenters.contains(costCenterId)) continue;
            ++addNum;
            targetBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("createtime", (Object)TimeServiceHelper.now());
            targetBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("modifytime", (Object)TimeServiceHelper.now());
            targetBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("auditdate", (Object)TimeServiceHelper.now());
            resourceBills.add(targetBill);
        }
        this.getPlanResourceContext().setAddCount(this.getPlanResourceContext().getAddCount() + addNum);
        this.getPlanResourceContext().getImportBillList().addAll(resourceBills);
        logger.info("\u65b0\u589e\u7684\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5355:{}", (Object)resourceBills.size());
        return resourceBills;
    }
}

