/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.planresource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.cad.business.config.costcenter.CostCenterRelationService;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.engine.CollConifgContext;
import kd.macc.cad.business.config.engine.CollConifgParam;
import kd.macc.cad.business.config.engine.IBillTransfer;
import kd.macc.cad.business.config.engine.filter.CollConfigFilterService;
import kd.macc.cad.business.config.engine.helper.CollectEngineHelper;
import kd.macc.cad.business.config.engine.mapping.CollConfigMappingService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.BgParamEnum;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.utils.BatchUtils;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.planresource.AbstractPlanResourceAction;
import kd.macc.cad.mservice.planresource.CompletionSaveAction;
import kd.macc.cad.mservice.planresource.IPlanResourceAction;
import kd.macc.cad.mservice.planresource.PlanResourceArgs;
import kd.macc.cad.mservice.planresource.PlanResourceContext;
import kd.macc.cad.mservice.planresource.PlanResourceImportDataConfigAction;
import kd.macc.cad.mservice.planresource.PlanResourceImportDataForCUConfigAction;
import org.apache.commons.lang3.StringUtils;

public class PlanResourceTransferAction
extends AbstractPlanResourceAction {
    private static final Log logger = LogFactory.getLog(PlanResourceTransferAction.class);
    private CollConifgContext configContext = new CollConifgContext();
    private List<DynamicObject> collConfigList = new ArrayList<DynamicObject>();
    private CollConfigFilterService filterService;
    private CollConfigMappingService mappingService;
    private CostCenterRelationService costCenterRelationService;

    @Override
    protected void doExecute() {
        PlanResourceContext context = this.getPlanResourceContext();
        PlanResourceArgs collectionArgs = context.getPlanResourceArgs();
        List<Long> manuOrgs = collectionArgs.getManuOrgs();
        CollectReport collectReport = context.getCollectReport();
        Long[] manuOrgIds = new Long[]{};
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            manuOrgIds = manuOrgs.toArray(new Long[0]);
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u6e90\u5355\u8f6c\u6362\u4e3a\u76ee\u6807\u5355\u3002", (String)"PlanResourceTransferAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 2, 7, false);
        List<IPlanResourceAction> resourceUseActions = this.initializeActions(collectionArgs.getAppNum());
        this.configContext = new CollConifgContext();
        CollConifgParam param = new CollConifgParam();
        param.setAppnum(collectionArgs.getAppNum());
        param.setCalOrgId(collectionArgs.getAcctOrgId());
        param.setCostAccountId(collectionArgs.getCostAccountId());
        param.setPlanSchemeId(collectionArgs.getPlanSchemeId());
        param.setPlanSchemeNumber(collectionArgs.getPlanSchemeNumber());
        param.setManuOrgIds(manuOrgIds);
        param.setCostCenterIds(collectionArgs.getCostCenterIds().toArray(new Long[0]));
        param.setTargetEntity("cad_planresource");
        this.configContext.setParam(param);
        HashSet<Long> allCollconfigIds = new HashSet<Long>(10);
        allCollconfigIds.add(0L);
        this.collConfigList = this.getValidCollConfigList(context, "cad_planresource", allCollconfigIds);
        if (!CadEmptyUtils.isEmpty(this.collConfigList)) {
            this.mappingService = new CollConfigMappingService();
            this.filterService = new CollConfigFilterService();
            this.costCenterRelationService = new CostCenterRelationService();
            Map collConfigMappingMap = this.mappingService.getCollConfigMappingMap(this.collConfigList);
            Map collSelectValueMappingMap = this.mappingService.getCollSelectValueMappingMap(this.collConfigList);
            Map collConfigFilterMap = this.filterService.getCollConfigFilterMap(this.collConfigList);
            List importScopeDate = PlanFeeAllocHelper.getImportScopeDate((Long)collectionArgs.getPlanSchemeId());
            collectReport.setDateRange(PlanFeeAllocHelper.getPeriodDateRange((Long)collectionArgs.getPlanSchemeId()));
            Map costCenterSourceDataMap = this.costCenterRelationService.getCostCenterSourceDataMap(context.getPlanResourceArgs().getCostCenterIds().toArray(new Long[0]), importScopeDate);
            this.configContext.setCostCenterSourceDataMap(costCenterSourceDataMap);
            HashMap costCentersourceTypeDataMap = new HashMap(16);
            costCenterSourceDataMap.forEach((ccs, obj) -> {
                String[] srcDataStr = ccs.split("@");
                if (srcDataStr.length < 2) {
                    return;
                }
                String sourceType = srcDataStr[0];
                Long sourceData = Long.parseLong(srcDataStr[1]);
                costCentersourceTypeDataMap.computeIfAbsent(sourceType, p -> new HashSet(10)).add(sourceData);
            });
            context.getCollConfigMappingMap().putAll(collConfigMappingMap);
            boolean disableCollectReport = CollectReportHelper.disableCollectReport();
            this.delHistoryCollConfigData(this.collConfigList, collectionArgs, allCollconfigIds);
            List periodIds = PlanFeeAllocHelper.getPlanSchemeEnableUnclosePeriods((Long)collectionArgs.getPlanSchemeId());
            int allConfigDelNum = 0;
            for (DynamicObject config : this.collConfigList) {
                Map<Long, Long> existsEntryIdResourceMap;
                this.getPlanResourceContext().getNeedDelIdSet().clear();
                this.getPlanResourceContext().getSrcBillIdIdMap().clear();
                this.getPlanResourceContext().getImportBillList().clear();
                long configId = config.getLong("id");
                String targetBillEntity = config.getString("costbill.id");
                String sourceBillEntity = config.getString("sourcebill.id");
                DataSet existsResourceUseBill = this.getExistsPlanResourceBill(collectionArgs.getAcctOrgId(), collectionArgs.getCostAccountId(), periodIds, collectionArgs.getCostCenterIds(), collectionArgs.getManuOrgs(), collectionArgs.getPlanSchemeId(), sourceBillEntity, targetBillEntity, collectionArgs.getAppNum(), configId, null);
                String subEntityName = "";
                String entityName = "";
                Map fieldMappingMap = (Map)collConfigMappingMap.get(configId);
                if (!CadEmptyUtils.isEmpty((Map)fieldMappingMap)) {
                    block12: for (String value : fieldMappingMap.values()) {
                        String[] split = StringUtils.split((String)value, (String)",");
                        if (CadEmptyUtils.isEmpty((String)entityName) && value.contains(".")) {
                            entityName = value.split("\\.")[0];
                        }
                        for (String fieldName : split) {
                            String[] fieldNames = StringUtils.split((String)fieldName, (String)".");
                            if (!CadEmptyUtils.isEmpty((String)subEntityName) || fieldNames.length <= 2 || !fieldNames[1].contains("entry")) continue;
                            subEntityName = fieldNames[0].concat(".").concat(fieldNames[1]);
                            continue block12;
                        }
                    }
                }
                Map selectValueMappingMap = (Map)collSelectValueMappingMap.get(configId);
                List collConfigFilter = ImportServiceHelper.getSrcQFilters((Long)this.configContext.getParam().getCalOrgId(), Arrays.asList(this.configContext.getParam().getCostCenterIds()), Arrays.asList(this.configContext.getParam().getManuOrgIds()), (DynamicObject)config, (Map)collConfigFilterMap, (Map)fieldMappingMap, (Map)selectValueMappingMap, costCentersourceTypeDataMap, null, null, (Long)this.configContext.getParam().getCostAccountId(), (Long)this.configContext.getParam().getCurPeriodId(), (String)this.configContext.getParam().getAppnum(), (Map)this.configContext.getConfigProEntryIdWorkCenterMap(), (CollectReport)collectReport);
                Map dateMap = (Map)importScopeDate.get(0);
                collConfigFilter.add(new QFilter((String)fieldMappingMap.get("bizdate"), ">=", dateMap.get("start")));
                collConfigFilter.add(new QFilter((String)fieldMappingMap.get("bizdate"), "<=", dateMap.get("end")));
                String selectFields = CollectEngineHelper.getSrcSelectFields((DynamicObject)config, (Map)fieldMappingMap, null);
                if (CadEmptyUtils.isEmpty((String)selectFields)) continue;
                logger.info("\u67e5\u8be2\u6e90\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", (Object)collConfigFilter);
                subEntityName = !CadEmptyUtils.isEmpty((String)subEntityName) ? subEntityName.concat(".id") : (!CadEmptyUtils.isEmpty((String)entityName) ? entityName.concat(".id") : "id");
                DataSet sourceBills = QueryServiceHelper.queryDataSet((String)"PlanResourceTransferAction_doExecute", (String)sourceBillEntity, (String)selectFields, (QFilter[])collConfigFilter.toArray(new QFilter[0]), (String)"id desc");
                HashMap<String, Long> existBillDimensionMap = new HashMap<String, Long>(16);
                HashSet<Long> existBillEntryIdSet = new HashSet<Long>(10);
                if (existsResourceUseBill != null) {
                    existsResourceUseBill.copy().forEach(s -> {
                        String dimensionBillKey = String.format("%s@%s@%s@%s@%s@%s@%s", s.getLong("srcentryid"), s.getLong("manuorg"), s.getLong("costcenter"), s.getLong("resource"), s.getLong("resourceunit"), s.getBigDecimal("qty"), s.getDate("bizdate"));
                        existBillDimensionMap.put(dimensionBillKey, s.getLong("id"));
                        existBillEntryIdSet.add(s.getLong("srcentryid"));
                    });
                }
                if (this.getPlanResourceContext().getSrcBillIdIdMap().isEmpty() && !CadEmptyUtils.isEmpty(existsEntryIdResourceMap = this.entryIdResourceMap(existsResourceUseBill))) {
                    this.getPlanResourceContext().getSrcBillIdIdMap().putAll(existsEntryIdResourceMap);
                }
                Integer batchSize = CadBgParamUtils.getCadParamForInt((String)BgParamEnum.RESOURCE_BATCH_SIZE.getKey(), (int)2000);
                List partitionIds = BatchUtils.batchDataByEntryId((DataSet)sourceBills, (Integer)batchSize, (String)"entryId");
                int delNumTotal = 0;
                logger.info("\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5206\u6279\uff1a\u65b9\u6848\u7f16\u53f7\uff1a{}\uff0c\u5206\u6279id\u7ed3\u675f\uff0c\u5171:{}\u6279", (Object)config.getString("number"), (Object)partitionIds.size());
                for (int i = 0; i < partitionIds.size(); ++i) {
                    this.getPlanResourceContext().getImportBillList().clear();
                    this.getPlanResourceContext().getNeedDelIdSet().clear();
                    this.getPlanResourceContext().getConfigSrcAndTargetBillsMap().clear();
                    long start = TimeServiceHelper.now().getTime();
                    List entryIdList = (List)partitionIds.get(i);
                    logger.info("\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5206\u6279\uff1a\u5f00\u59cb\u5206\u6279\u4f5c\u4e1a:\u7b2c{}\u6279\uff0c\u5355\u636e\u6570\u91cf{}", (Object)i, (Object)entryIdList.size());
                    if (CadEmptyUtils.isEmpty((List)entryIdList)) continue;
                    QFilter entryIdQf = new QFilter(subEntityName, "in", (Object)entryIdList);
                    DynamicObjectCollection resResults = QueryServiceHelper.query((String)sourceBillEntity, (String)selectFields, (QFilter[])new QFilter[]{entryIdQf});
                    IBillTransfer billTransfer = IBillTransfer.getTransferInstance((String)"cad_planresource", (String)this.getPlanResourceContext().getPlanResourceArgs().getAppNum());
                    BillTransferResult result = billTransfer.doTransfer((DynamicObject[])resResults.toArray((Object[])new DynamicObject[0]), config, this.configContext);
                    this.getPlanResourceContext().getEntryIdAndSeqMap().putAll(result.getEntryIdAndSeqMap());
                    logger.info("\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5206\u6279\uff1a\u8f6c\u6362\u7ed3\u679c\uff1a{},\u8017\u65f6:{}", (Object)context.getConfigSrcAndTargetBillsMap().size(), (Object)(TimeServiceHelper.now().getTime() - start));
                    logger.info("\u8d44\u6e90\u5dee\u91cf\u5f52\u96c6\u5224\u65ad:\u5f52\u96c6\u62a5\u544a\u5f00\u542f\u72b6\u6001{}", (Object)disableCollectReport);
                    long diffTime = System.currentTimeMillis();
                    if (!disableCollectReport) {
                        boolean isChanged = this.checkConfigChanged(config, targetBillEntity);
                        logger.info("\u8d44\u6e90\u5dee\u91cf\u5f52\u96c6\u5224\u65ad:\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u65b9\u6848:{},\u6539\u53d8\u72b6\u6001:{}", (Object)config.getString("number"), (Object)isChanged);
                        if (!isChanged) {
                            this.remainChangedResult(existBillEntryIdSet, existBillDimensionMap, result.getSrcAndTargetBillsMap());
                        }
                    }
                    logger.info("\u8d44\u6e90\u5dee\u91cf\u5f52\u96c6\u5224\u65ad\uff1a\u5dee\u91cf\u5904\u7406,\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - diffTime));
                    int delNum = this.deleteResourceBillForNoSource(this.getPlanResourceContext().getSrcBillIdIdMap(), config.getString("number"));
                    allConfigDelNum += (delNumTotal += delNum);
                    context.getConfigSrcAndTargetBillsMap().put(config, result.getSrcAndTargetBillsMap());
                    try (TXHandle txHandle = TX.requiresNew();){
                        try {
                            for (IPlanResourceAction resourceUseAction : resourceUseActions) {
                                long actionTime = System.currentTimeMillis();
                                resourceUseAction.setContext(context);
                                resourceUseAction.execute();
                                logger.info("\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5206\u6279\uff1a\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5f15\u5165-action\uff1a{},\u8017\u65f6\uff1a{}ms", (Object)resourceUseAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                            }
                        }
                        catch (Exception e) {
                            txHandle.markRollback();
                            logger.error("\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u6279\u6b21\u4fdd\u5b58\u5931\u8d25\uff0c\u56de\u6eda\u3002\u6279\u6b21:{}", (Object)i);
                            throw e;
                        }
                    }
                    long end = TimeServiceHelper.now().getTime();
                    logger.info("\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5206\u6279\uff1a\u7b2c{}\u6279\u4f5c\u4e1a\u7ed3\u675f,\u8017\u65f6\uff1a{}", (Object)i, (Object)(end - start));
                }
                this.getPlanResourceContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\uff0c\u6570\u636e\u5904\u7406\u5b8c\u6210\u3002", (String)"PlanResourceTransferAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
            }
            this.getPlanResourceContext().setDelCount(allConfigDelNum);
            this.getPlanResourceContext().getImportBillList().clear();
            this.getPlanResourceContext().getConfigSrcAndTargetBillsMap().clear();
            this.getPlanResourceContext().getNeedDelIdSet().clear();
            this.getPlanResourceContext().getSrcBillIdIdMap().clear();
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"PlanResourceTransferAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
    }

    private void remainChangedResult(HashSet<Long> existBillEntryIdSet, Map<String, Long> existBillDimensionMap, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap) {
        Iterator<Map.Entry<DynamicObject, DynamicObject>> iterator = srcAndTargetBillsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<DynamicObject, DynamicObject> srcAndTargetBill = iterator.next();
            DynamicObject targetBill = srcAndTargetBill.getValue();
            String mergeKey = String.format("%s@%s@%s@%s@%s@%s@%s", targetBill.getLong("srcentryid"), targetBill.getLong("manuorg"), targetBill.getLong("costcenter.id"), targetBill.getLong("resource"), targetBill.getLong("resourceunit"), targetBill.getBigDecimal("qty"), targetBill.getDate("bizdate"));
            if (!existBillEntryIdSet.contains(targetBill.getLong("srcentryid")) || !existBillDimensionMap.containsKey(mergeKey)) continue;
            iterator.remove();
            this.getPlanResourceContext().getSrcBillIdIdMap().remove(targetBill.getLong("srcentryid"));
        }
    }

    private void delHistoryCollConfigData(List<DynamicObject> collConfigList, PlanResourceArgs collectionArgs, Set<Long> allCollconfigIds) {
        if (collConfigList.isEmpty()) {
            return;
        }
        DynamicObject config = collConfigList.get(0);
        String targetBillEntity = config.getString("costbill.id");
        String sourceBillEntity = config.getString("sourcebill.id");
        List periodIds = PlanFeeAllocHelper.getPlanSchemeEnableUnclosePeriods((Long)collectionArgs.getPlanSchemeId());
        DataSet existsPlanResourceBill = this.getExistsPlanResourceBill(collectionArgs.getAcctOrgId(), collectionArgs.getCostAccountId(), periodIds, collectionArgs.getCostCenterIds(), collectionArgs.getManuOrgs(), collectionArgs.getPlanSchemeId(), sourceBillEntity, targetBillEntity, collectionArgs.getAppNum(), -1L, allCollconfigIds);
        if (existsPlanResourceBill == null || existsPlanResourceBill.isEmpty()) {
            return;
        }
        Map<Long, Long> existsIdMap = this.entryIdResourceMap(existsPlanResourceBill);
        logger.info("\u9700\u8981\u5220\u9664\u7684\u5386\u53f2\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u7684\u5355\u636e\u6570\u91cf\uff1a{}", (Object)existsIdMap.size());
        if (!CadEmptyUtils.isEmpty(existsIdMap)) {
            this.getPlanResourceContext().getSrcBillIdIdMap().putAll(existsIdMap);
        }
        int delNum = this.deleteResourceBillForNoSource(this.getPlanResourceContext().getSrcBillIdIdMap(), ResManager.loadKDString((String)"\u5386\u53f2\u65b9\u6848", (String)"PlanResourceTransferAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]));
        this.getPlanResourceContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5386\u53f2\u65b9\u6848\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"PlanResourceTransferAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), delNum));
    }

    private List<IPlanResourceAction> initializeActions(String appNum) {
        ArrayList<IPlanResourceAction> resourceUseActions = new ArrayList<IPlanResourceAction>(8);
        switch (appNum) {
            case "sca": {
                resourceUseActions.add(new PlanResourceImportDataConfigAction());
                resourceUseActions.add(new PlanResourceImportDataForCUConfigAction());
                resourceUseActions.add(new CompletionSaveAction());
                break;
            }
        }
        return resourceUseActions;
    }

    public List<DynamicObject> getValidCollConfigList(PlanResourceContext context, String targetEntity, Set<Long> collconfigIds) {
        if (this.collConfigList != null && this.collConfigList.size() > 0) {
            return this.collConfigList;
        }
        ArrayList<DynamicObject> values = new ArrayList<DynamicObject>(context.getRulesMap().values());
        HashSet<String> calMethodTypes = new HashSet<String>(10);
        for (Map.Entry<String, DynamicObject> ruleMap : context.getRulesMap().entrySet()) {
            String key = ruleMap.getKey();
            String[] split = key.split("@");
            if (split.length == 3) {
                calMethodTypes.add(split[1]);
                continue;
            }
            if (split.length != 4) continue;
            calMethodTypes.add(split[2]);
        }
        HashSet calcDimensionIds = new HashSet(10);
        values.forEach(p -> calcDimensionIds.add(p.getLong("costcalcdimension")));
        return ImportServiceHelper.getCollConfigs((Long)context.getPlanResourceArgs().getAcctOrgId(), (Long)context.getPlanResourceArgs().getCostAccountId(), calMethodTypes, calcDimensionIds, (String)targetEntity, (String)context.getPlanResourceArgs().getAppNum(), collconfigIds);
    }

    protected int deleteResourceBillForNoSource(Map<Long, Long> idSrcIdIdCompleteMap, String configNumber) {
        if (CadEmptyUtils.isEmpty(idSrcIdIdCompleteMap)) {
            return 0;
        }
        HashSet<Long> deleteData = new HashSet<Long>(10);
        for (Map.Entry<Long, Long> idSrcIdEntry : idSrcIdIdCompleteMap.entrySet()) {
            Long planResourceId = idSrcIdEntry.getValue();
            deleteData.add(planResourceId);
        }
        this.getPlanResourceContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u4e2d\uff0c\u662f\u5426\u6709\u9700\u8981\u5220\u9664\u7684\u5355\u636e\uff1f", (String)"PlanResourceTransferAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]), configNumber));
        PlanResourceTransferAction.delEntity(deleteData, "cad_planresource");
        this.getPlanResourceContext().setDelCount(deleteData.size());
        this.getPlanResourceContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"PlanResourceTransferAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), deleteData.size()));
        return deleteData.size();
    }

    private static void delEntity(Collection<Long> ids, String entity) {
        List partitions = Lists.partition(new ArrayList<Long>(ids), (int)20000);
        for (List partIds : partitions) {
            QFilter filter = new QFilter("id", "in", (Object)partIds);
            DeleteServiceHelper.delete((String)entity, (QFilter[])new QFilter[]{filter});
        }
    }

    private boolean checkConfigChanged(DynamicObject config, String entityId) {
        QFilter appNumQf;
        QFilter colObjQf;
        if (CadEmptyUtils.isEmpty((String)entityId)) {
            return true;
        }
        Date modifyTime = config.getDate("modifytime");
        String appNum = config.getString("appnum");
        QFilter orgQf = new QFilter("org", "=", (Object)this.getPlanResourceContext().getPlanResourceArgs().getAcctOrgId());
        DynamicObjectCollection collectReports = QueryServiceHelper.query((String)"cad_colreport", (String)"coldate", (QFilter[])new QFilter[]{orgQf, colObjQf = new QFilter("colobj", "=", (Object)"planresource"), appNumQf = new QFilter("appnum", "=", (Object)appNum)}, (String)"coldate desc", (int)1);
        if (collectReports != null && collectReports.size() > 0) {
            return ((DynamicObject)collectReports.get(0)).getDate("coldate").compareTo(modifyTime) <= 0;
        }
        return true;
    }

    protected DataSet getExistsPlanResourceBill(Long org, Long costAccountId, List<Long> periodIds, List<Long> methodCostCenters, List<Long> manuOrgs, Long planSchemeId, String srcBillType, String entityId, String appNum, long configId, Set<Long> allCollconfigIds) {
        QFilter orgQf = new QFilter("org", "=", (Object)org);
        orgQf.and(new QFilter("costaccount", "=", (Object)costAccountId));
        if (allCollconfigIds != null) {
            orgQf.and("collconfig", "not in", allCollconfigIds);
        } else {
            orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
            orgQf.and(new QFilter("collconfig", "=", (Object)configId));
        }
        QFilter costObjectQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter appnumQf = new QFilter("appnum", "=", (Object)appNum);
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            orgQf.and(new QFilter("manuorg", "in", manuOrgs));
        }
        QFilter periodFilter = new QFilter("period", "in", periodIds);
        QFilter planSchemeFilter = new QFilter("planscheme", "=", (Object)planSchemeId);
        return QueryServiceHelper.queryDataSet((String)"PlanResourceTransferAction_getExistsPlanResourceBill", (String)entityId, (String)"id,srcbillid,srcentryid,manuorg,costcenter,resource,resourceunit,qty,bizdate", (QFilter[])new QFilter[]{orgQf, costObjectQf, periodFilter, appnumQf, planSchemeFilter}, (String)"id desc");
    }
}

