/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.resourceuse;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.constants.ElementConstant;
import kd.macc.cad.common.constants.ResourceAbsorbParam;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.mservice.resourceuse.IResourceUseAction;
import kd.macc.cad.mservice.resourceuse.ResourceUseContext;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractResourceUseAction
implements IResourceUseAction {
    private static final String HOUR_UNIT = "10";
    private static final String SECOND_UNIT = "8";
    private Log logger = LogFactory.getLog(AbstractResourceUseAction.class);
    private ResourceUseContext resourceUseContext;

    protected abstract void doExecute();

    @Override
    public void execute() {
        if (this.resourceUseContext.isContinueExecute()) {
            this.doExecute();
        }
    }

    public ResourceUseContext getResourceUseContext() {
        return this.resourceUseContext;
    }

    @Override
    public void setContext(ResourceUseContext resourceUseContext) {
        this.resourceUseContext = resourceUseContext;
    }

    protected Map<String, DynamicObject> getExistResourceBills(Long acctOrgId, List<Long> manuOrgs, List<Long> costCenterIds, List<Long> mftorderentryids, Set<String> selectFields, Set<Long> sourceIds, List<String> targetBillNos, String appNum) {
        HashMap<String, DynamicObject> existResourceBillMap = new HashMap<String, DynamicObject>(16);
        HashSet<String> costSelectFields = new HashSet<String>(selectFields);
        costSelectFields.add("id");
        costSelectFields.add("billno");
        costSelectFields.add("srcbillid");
        costSelectFields.add("org");
        costSelectFields.add("entryentity.costobject");
        costSelectFields.add("costcenter");
        costSelectFields.add("bizdate");
        QFilter commonQF = null;
        if (mftorderentryids != null && !mftorderentryids.isEmpty() && sourceIds != null && !sourceIds.isEmpty()) {
            commonQF = new QFilter("srcbillid", "in", sourceIds);
            commonQF = commonQF.or(new QFilter("billno", "in", targetBillNos));
        } else {
            commonQF = SysParamHelper.getImportTimeScope((Long)acctOrgId, (String)"bookdate", (String)appNum);
            if (acctOrgId != null) {
                commonQF.and("org", "=", (Object)acctOrgId);
            }
            if (costCenterIds != null && !costCenterIds.isEmpty()) {
                commonQF.and("costcenter", "in", costCenterIds);
            } else {
                commonQF.and("costcenter", "=", (Object)-1L);
            }
            if (!CadEmptyUtils.isEmpty(manuOrgs)) {
                commonQF.and("manuorg", "in", manuOrgs);
            }
        }
        commonQF.and("appnum", "=", (Object)appNum);
        this.logger.info("\u67e5\u8be2\u5df2\u6709\u7684\u5f52\u96c6\u5355\u53c2\u6570" + commonQF.toString());
        DynamicObjectCollection resUesBills = QueryServiceHelper.query((String)"sca_resourceuse", (String)String.join((CharSequence)",", costSelectFields), (QFilter[])new QFilter[]{commonQF});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)resUesBills)) {
            return existResourceBillMap;
        }
        for (DynamicObject resUesBill : resUesBills) {
            existResourceBillMap.put(resUesBill.getString("billno") + "@" + resUesBill.getString("srcbillid"), resUesBill);
        }
        return existResourceBillMap;
    }

    protected void delChangeRecord(Set<Long> srcBillIds) {
        QFilter filter = new QFilter("sourcebill", "in", srcBillIds);
        filter.and("bizstatus", "!=", (Object)"B");
        DeleteServiceHelper.delete((String)"sca_costchangerecord", (QFilter[])new QFilter[]{filter});
    }

    protected List<Long> getChangeRecordBySettled(List<Long> srcbillIds) {
        QFilter filter = new QFilter("sourcebill", "in", srcbillIds);
        filter.and("bizstatus", "=", (Object)"B");
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)"sca_costchangerecord", (String)"sourcebill", (QFilter[])new QFilter[]{filter});
        srcbillIds.clear();
        sourceBills.forEach(p -> srcbillIds.add(p.getLong("sourcebill")));
        return srcbillIds;
    }

    protected List<Long> getExistsCompletBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, String srcBillType, String appNum) {
        QFilter orgQf = new QFilter("org", "in", (Object)org);
        orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
        QFilter voucherTypeQf = new QFilter("vouchertype", "=", (Object)" ");
        QFilter costObjectQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter AppnumQf = new QFilter("appnum", "=", (Object)appNum);
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            orgQf.and(new QFilter("manuorg", "in", manuOrgs));
        }
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        DynamicObjectCollection completionList = QueryServiceHelper.query((String)"sca_resourceuse", (String)"id", (QFilter[])new QFilter[]{orgQf, costObjectQf, bookDateQf, AppnumQf, voucherTypeQf});
        if (CadEmptyUtils.isEmpty((List)completionList)) {
            return null;
        }
        return completionList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    protected List<Long> getExistsCompletBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, List<Long> mftOrderEntryIds, Map<String, String> configRuleMappingMap, String srcBillType, String appNum) {
        if (CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            return this.getExistsCompletBill(org, methodCostCenters, manuOrgs, srcBillType, appNum);
        }
        if (CadEmptyUtils.isEmpty((String)configRuleMappingMap.get("probill"))) {
            return null;
        }
        QFilter orgQf = new QFilter("org", "in", (Object)org);
        orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
        QFilter costObjectQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter sourceBillQf = new QFilter("entryentity.costobject.probill", "in", mftOrderEntryIds);
        QFilter voucherTypeQf = new QFilter("vouchertype", "=", (Object)" ");
        QFilter AppnumQf = new QFilter("appnum", "=", (Object)appNum);
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        DynamicObjectCollection completionList = QueryServiceHelper.query((String)"sca_resourceuse", (String)"id", (QFilter[])new QFilter[]{orgQf, costObjectQf, sourceBillQf, bookDateQf, AppnumQf, voucherTypeQf});
        if (CadEmptyUtils.isEmpty((List)completionList)) {
            return null;
        }
        return completionList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    protected Map<Long, Long> entryIdResourceMap(DataSet existResourceUse) {
        HashMap idEntryIdResourceMap = Maps.newHashMapWithExpectedSize((int)128);
        if (existResourceUse == null || existResourceUse.isEmpty()) {
            return idEntryIdResourceMap;
        }
        for (Row row : existResourceUse) {
            Long id = row.getLong("id");
            Long srcEntryId = row.getLong("srcentryid");
            idEntryIdResourceMap.put(srcEntryId, id);
        }
        return idEntryIdResourceMap;
    }

    protected void dealExitsData(Map<String, DynamicObject> idEntryIdCompleteMap, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, DynamicObject> changeResourceMap, Set<String> selectFields, String appNum) {
        if (CadEmptyUtils.isEmpty(idEntryIdCompleteMap) || CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return;
        }
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTartgetBill : srcAndTargetBillsMap.entrySet()) {
            String newBillStr;
            String oldBillStr;
            DynamicObject newBill = srcAndTartgetBill.getValue();
            String key = newBill.getString("billno").concat("-").concat(newBill.getString("srcbillid"));
            DynamicObject oldBill = idEntryIdCompleteMap.get(key);
            if (oldBill == null || (oldBillStr = CommonCollConfigService.getBillInfoBySelectFields((DynamicObject)oldBill, selectFields)).equals(newBillStr = CommonCollConfigService.getBillInfoBySelectFields((DynamicObject)newBill, selectFields))) continue;
            changeResourceMap.put(key, newBill);
            this.getResourceUseContext().getCostChangeContentMap().put(key, oldBillStr + "#" + newBillStr);
        }
    }

    protected void updateMaterialInfo(DynamicObject resourceBill, DynamicObject costObject) {
        if (costObject == null) {
            return;
        }
        long material = 0L;
        material = costObject.get("material") instanceof DynamicObject ? costObject.getLong("material.id") : costObject.getLong("material");
        long auxpty = 0L;
        auxpty = costObject.get("auxpty") instanceof DynamicObject ? costObject.getLong("auxpty.id") : costObject.getLong("auxpty");
        DynamicObjectCollection entryentity = resourceBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            long entryMaterial = 0L;
            entryMaterial = entry.get("material") instanceof DynamicObject ? entry.getLong("material.id") : entry.getLong("material");
            long entryAuxpty = 0L;
            entryAuxpty = entry.get("auxpty") instanceof DynamicObject ? entry.getLong("auxpty.id") : entry.getLong("auxpty");
            if (CadEmptyUtils.isEmpty((Long)entryMaterial)) {
                entry.set("material", (Object)material);
            }
            if (!CadEmptyUtils.isEmpty((Long)entryAuxpty)) continue;
            entry.set("auxpty", (Object)auxpty);
        }
    }

    protected int save(List<DynamicObject> sourceBills, CollectReport report) {
        if (CollectionUtils.isEmpty(sourceBills)) {
            return 0;
        }
        List billNos = sourceBills.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toList());
        this.logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6-\u5f15\u5165\u7684\u5f52\u96c6\u5355\u7f16\u53f7\uff1a{}", (Object)JSON.toJSONString(billNos));
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"sca_resourceuse", (DynamicObject[])sourceBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        int successQty = operateResult.getSuccessPkIds() == null ? 0 : operateResult.getSuccessPkIds().size();
        this.getResourceUseContext().setSuccessNum(successQty);
        if (!operateResult.isSuccess()) {
            String errorInfo = OperationResultHelper.errorMsgHandle((OperationResult)operateResult);
            ValidateResultCollection validateResult = operateResult.getValidateResult();
            HashSet errorDataIndexs = validateResult.getErrorDataIndexs();
            HashMap<Long, DynamicObject> idErrorDynamicMap = new HashMap<Long, DynamicObject>(16);
            HashSet<Long> resourceUseIds = new HashSet<Long>(16);
            for (Integer errorDataIndex : errorDataIndexs) {
                long id;
                long billId;
                int i;
                DynamicObject errorDynamic = sourceBills.get(errorDataIndex);
                String billno = errorDynamic.getString("billno");
                Object srcBillTypeObj = errorDynamic.get("srcbilltype");
                String srcbilltype = "";
                srcbilltype = srcBillTypeObj instanceof DynamicObject ? ((DynamicObject)srcBillTypeObj).getString("number") : srcBillTypeObj.toString();
                if (!StringUtils.isEmpty((CharSequence)billno) && (i = billno.lastIndexOf("-")) != -1) {
                    String srcBillNo = billno.substring(0, i);
                    if (srcBillNo.lastIndexOf("-") != -1) {
                        srcBillNo = srcBillNo.substring(0, srcBillNo.lastIndexOf("-"));
                    }
                    String seq = billno.substring(i + 1);
                    this.getResourceUseContext().logErrorMsg(srcBillNo.concat("@").concat(seq).concat("@").concat(srcbilltype), ResManager.loadKDString((String)"\u751f\u6210\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355\u5931\u8d25\u3002", (String)"AbstractResourceUseAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
                }
                if (!CadEmptyUtils.isEmpty((Long)(billId = errorDynamic.getLong("srcbillid")))) {
                    idErrorDynamicMap.put(billId, errorDynamic);
                }
                if (CadEmptyUtils.isEmpty((Long)(id = errorDynamic.getLong("id")))) continue;
                resourceUseIds.add(id);
            }
            if (!resourceUseIds.isEmpty()) {
                DeleteServiceHelper.delete((String)"sca_resourceabsorb", (QFilter[])new QFilter[]{new QFilter("sourcebill", "in", resourceUseIds)});
            }
            if (!idErrorDynamicMap.isEmpty()) {
                Set ids = idErrorDynamicMap.keySet();
                QFilter entryIdQf = new QFilter("srcbillid", "in", ids);
                QFilter appNumQf = new QFilter("appnum", "=", (Object)report.getAppNum());
                DynamicObjectCollection exists = QueryServiceHelper.query((String)"sca_resourceuse", (String)"bookdate,srcbillid", (QFilter[])new QFilter[]{entryIdQf, appNumQf});
                HashSet<String> keySet = new HashSet<String>(16);
                if (exists != null && !exists.isEmpty()) {
                    for (DynamicObject exist : exists) {
                        String key;
                        long sourceBillEntry = exist.getLong("srcbillid");
                        DynamicObject dynamicObject2 = (DynamicObject)idErrorDynamicMap.get(sourceBillEntry);
                        String billNo = dynamicObject2.getString("billno");
                        if (CadEmptyUtils.isEmpty((String)billNo)) continue;
                        int splitIndex = billNo.lastIndexOf("-");
                        String sourceBillNo = billNo.substring(0, splitIndex);
                        Object srcBillTypeObj = dynamicObject2.get("srcbilltype");
                        String srcBillType = "";
                        srcBillType = srcBillTypeObj instanceof DynamicObject ? ((DynamicObject)srcBillTypeObj).getString("number") : srcBillTypeObj.toString();
                        Date bizDate = exist.getDate("bookdate");
                        String bizDateStr = "";
                        if (bizDate != null) {
                            bizDateStr = DateUtils.formatDate((Date)bizDate, (String)"yyyy-MM-dd");
                        }
                        if (keySet.contains(key = sourceBillNo.concat("@").concat("0").concat("@").concat(srcBillType))) continue;
                        keySet.add(key);
                        this.getResourceUseContext().logErrorMsg(key, String.format(ResManager.loadKDString((String)"\u6e90\u5355\u5df2\u6b63\u5e38\u5f52\u96c6\uff0c\u8bb0\u8d26\u65e5\u671f\u201c%s\u201d\u3002", (String)"AbstractResourceUseAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), bizDateStr));
                    }
                }
            }
            this.logger.error("\u4fdd\u5b58\u5931\u8d25\u3002" + errorInfo);
            this.getResourceUseContext().setValidate(true);
            report.setError(true);
            report.logTip(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u53d1\u73b0\u5f02\u5e38\u3002", (String)"AbstractResourceUseAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), errorInfo);
            if ("sca".equals(this.getResourceUseContext().getResourceUseArgs().getAppNum())) {
                throw new KDBizException(errorInfo);
            }
        }
        return successQty;
    }

    protected void refreshProgress(String opContent, int nowComplete, int total, Boolean isAddNum) {
        ResourceUseContext resourceUseContext = this.getResourceUseContext();
        String progressId = resourceUseContext.getResourceUseArgs().getProgressId();
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (isAddNum.booleanValue()) {
            Integer complete = paramDto.getComplete();
            paramDto.setComplete(Integer.valueOf(complete + nowComplete));
        } else {
            paramDto.setComplete(Integer.valueOf(nowComplete));
        }
        if (!CadEmptyUtils.isEmpty((Integer)total)) {
            paramDto.setTotal(Integer.valueOf(total));
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"AbstractResourceUseAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
        paramDto.setDurationTimes(Integer.valueOf(0));
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam((String)progressId, (ProgressParamDto)paramDto);
        this.setReportPressAndDur(progressId);
    }

    private void setReportPressAndDur(String progressId) {
        Date coldate;
        int progress = this.getProgress(progressId);
        Long id = this.getResourceUseContext().getCollectReport().getId();
        String duration = "";
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_colreport", (String)"coldate", (QFilter[])qFilter.toArray());
        if (dynamicObject != null && (coldate = dynamicObject.getDate("coldate")) != null) {
            double time = (double)(System.currentTimeMillis() - coldate.getTime()) / 1000.0;
            if (0.0 < time && time < 1.0) {
                time = 1.0;
            }
            duration = String.valueOf((int)time);
        }
        try (TXHandle handle = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cad_colreport set fprogress=" + progress + ",fduration=" + duration + " where fid =" + id));
        }
    }

    public int getProgress(String progressId) {
        if (StringUtils.isEmpty((CharSequence)progressId)) {
            return 0;
        }
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return 0;
        }
        if (CadEmptyUtils.isEmpty((Integer)paramDto.getTotal()) || CadEmptyUtils.isEmpty((Integer)paramDto.getComplete())) {
            return 0;
        }
        return (int)((double)paramDto.getComplete().intValue() / (double)paramDto.getTotal().intValue() * 100.0);
    }

    protected boolean createResourceAbsorbBill(ResourceUseContext context, DynamicObject srcBill, DynamicObject targetBill, ResourceAbsorbParam resourceSbsParam) {
        boolean flag = true;
        for (Long costAccount : resourceSbsParam.getCostAccountSet()) {
            BigDecimal qty;
            Long period = (Long)resourceSbsParam.getCostAccountPeriodMap().get(costAccount);
            Date periodStart = (Date)resourceSbsParam.getPeriodTimeMap().get(period);
            Date bookDate = targetBill.getDate("bookdate");
            if (periodStart == null || bookDate.compareTo(periodStart) < 0) {
                if (srcBill == null) continue;
                this.logger.info("\u5355\u636e==>{}\u8bb0\u8d26\u65e5\u671f\u5728\u5f53\u524d\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u4e4b\u524d\uff0c\u4e0d\u751f\u6210\u8d39\u7528\u5438\u6536\u6210\u672c\u5355", (Object)srcBill.getString("billno"));
                continue;
            }
            DynamicObjectCollection res = targetBill.getDynamicObjectCollection("entryentity");
            if (res.isEmpty()) continue;
            DynamicObject resEntry = (DynamicObject)res.get(0);
            DynamicObject resourceObj = (DynamicObject)resourceSbsParam.getResourceMap().get(targetBill.getString("billno"));
            if (resourceObj == null) {
                try {
                    if (srcBill != null) {
                        context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("subentryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u5b50\u5206\u5f55\u884c\u53f7\u201c%2$s\u201d\u5bf9\u5e94\u7684\u8d44\u6e90\u672a\u7ef4\u62a4\u81ea\u5236/\u5916\u534f\u8d44\u6e90\u6807\u51c6\u4ef7\u76ee\u8868\uff0c\u63090\u8d39\u7387\u8ba1\u7b97\u5438\u6536\u8d39\u7528\u3002", (String)"AbstractResourceUseAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("subentryseq")));
                    }
                }
                catch (Exception e) {
                    this.logger.info("\u672a\u914d\u7f6e\u5b50\u5206\u5f55\uff0c\u5199\u62a5\u544a\u62a5\u9519\uff1a" + e);
                }
                flag = false;
                break;
            }
            String calcBasis = resourceObj.getString("calcbasis");
            BigDecimal unitPrice = resourceObj.getBigDecimal("amount");
            String resourceUnit = resourceObj.getString("resourceunit.id");
            if ("001".equals(calcBasis)) {
                unitPrice = resourceObj.getBigDecimal("qty");
                String workHour = "";
                workHour = resEntry.get("workhour") instanceof DynamicObject ? resEntry.getString("workhour.id") : resEntry.getString("workhour");
                BigDecimal factHour = resEntry.getBigDecimal("facthour");
                if (factHour.compareTo(BigDecimal.ZERO) != 0) {
                    switch (workHour) {
                        case "10": {
                            qty = factHour.multiply(new BigDecimal(60));
                            break;
                        }
                        case "8": {
                            qty = factHour.divide(new BigDecimal(60), 10, 4);
                            break;
                        }
                        default: {
                            qty = factHour;
                        }
                    }
                    if (HOUR_UNIT.equals(resourceUnit)) {
                        qty = qty.divide(new BigDecimal(60), 10, RoundingMode.HALF_UP);
                    }
                    if (SECOND_UNIT.equals(resourceUnit)) {
                        qty = qty.multiply(new BigDecimal(60));
                    }
                } else {
                    qty = factHour;
                }
            } else {
                qty = "002".equals(calcBasis) ? resEntry.getBigDecimal("factuse") : resEntry.getBigDecimal("factbatch");
            }
            if (BigDecimal.ZERO.compareTo(qty) == 0) {
                this.logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355==>{}\u5bf9\u5e94\u7684\u5b9e\u9645\u5de5\u65f6\u4e3a0", (Object)targetBill.getString("billno"));
                continue;
            }
            Long currey = (Long)resourceSbsParam.getCostActCurrMap().get(costAccount);
            qty = qty.setScale(10, RoundingMode.HALF_UP);
            int seq = resEntry.getInt("seq") + 1;
            DynamicObject resourceAbsorb = BusinessDataServiceHelper.newDynamicObject((String)"sca_resourceabsorb");
            resourceAbsorb.set("billno", (Object)(targetBill.getString("billno") + "-" + seq));
            resourceAbsorb.set("period", (Object)resourceSbsParam.getPeriodByDate(bookDate, costAccount).getLong("id"));
            resourceAbsorb.set("org", (Object)resourceSbsParam.getAccountOrg());
            resourceAbsorb.set("costaccount", (Object)costAccount);
            resourceAbsorb.set("costcenter", (Object)targetBill.getLong("costcenter.id"));
            resourceAbsorb.set("sourcetype", (Object)"R");
            Object resource = targetBill.get("resource");
            long resourceId = resource instanceof DynamicObject ? ((DynamicObject)resource).getLong("id") : ((Long)resource).longValue();
            resourceAbsorb.set("resource", (Object)resourceId);
            resourceAbsorb.set("bizdate", targetBill.get("bizdate"));
            resourceAbsorb.set("bookdate", (Object)bookDate);
            resourceAbsorb.set("resourceusebillno", targetBill.get("billno"));
            resourceAbsorb.set("resourceuserow", (Object)seq);
            resourceAbsorb.set("costobject", (Object)resourceSbsParam.getCostObject());
            resourceAbsorb.set("opra", resEntry.get("opra"));
            resourceAbsorb.set("currency", (Object)currey);
            resourceAbsorb.set("material", resEntry.get("material"));
            resourceAbsorb.set("auxpty", resEntry.get("auxpty"));
            resourceAbsorb.set("billstatus", (Object)"C");
            resourceAbsorb.set("sourcebill", (Object)targetBill.getLong("id"));
            resourceAbsorb.set("sourcebillentry", (Object)resEntry.getLong("id"));
            resourceAbsorb.set("calcbasis", (Object)calcBasis);
            resourceAbsorb.set("route", targetBill.get("route"));
            resourceAbsorb.set("processseq", targetBill.get("processseq"));
            resourceAbsorb.set("operationno", targetBill.get("operationno"));
            if (resEntry.containsProperty("description")) {
                resourceAbsorb.set("description", (Object)resEntry.getString("description"));
            }
            long currUserId = RequestContext.get().getCurrUserId();
            Date date = new Date();
            resourceAbsorb.set("creator", (Object)currUserId);
            resourceAbsorb.set("modifier", (Object)currUserId);
            resourceAbsorb.set("auditor", (Object)currUserId);
            resourceAbsorb.set("createtime", (Object)date);
            resourceAbsorb.set("modifytime", (Object)date);
            resourceAbsorb.set("auditdate", (Object)date);
            DynamicObjectCollection entryEntity = resourceAbsorb.getDynamicObjectCollection("entryentity");
            DynamicObject dynamicObject = entryEntity.addNew();
            dynamicObject.set("element", resourceObj.get("element"));
            dynamicObject.set("subelement", resourceObj.get("subelement"));
            dynamicObject.set("baseunit", resourceObj.get("resourceunit"));
            dynamicObject.set("qty", (Object)qty.setScale(10, RoundingMode.HALF_UP));
            dynamicObject.set("unitprice", (Object)unitPrice.setScale(((DynamicObject)resourceSbsParam.getCurreyMap().get(currey)).getInt("priceprecision"), RoundingMode.HALF_UP));
            dynamicObject.set("amount", (Object)qty.multiply(unitPrice).setScale(((DynamicObject)resourceSbsParam.getCurreyMap().get(currey)).getInt("amtprecision"), RoundingMode.HALF_UP));
            DynamicObjectCollection objs = resourceObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject obj : objs) {
                DynamicObject subEntry = entryEntity.addNew();
                subEntry.set("element", obj.get("attaelement"));
                subEntry.set("subelement", obj.get("attasubelement"));
                subEntry.set("baseunit", resourceObj.get("resourceunit"));
                subEntry.set("qty", (Object)qty.setScale(10, RoundingMode.HALF_UP));
                BigDecimal price = obj.getBigDecimal("attaqty");
                if (resourceObj.getLong("element.id") == ElementConstant.OUTWORK_ID.longValue()) {
                    price = obj.getBigDecimal("attaamt");
                }
                subEntry.set("unitprice", (Object)price.setScale(((DynamicObject)resourceSbsParam.getCurreyMap().get(currey)).getInt("priceprecision"), RoundingMode.HALF_UP));
                subEntry.set("amount", (Object)qty.multiply(price).setScale(((DynamicObject)resourceSbsParam.getCurreyMap().get(currey)).getInt("amtprecision"), RoundingMode.HALF_UP));
            }
            resourceSbsParam.getSaveList().add(resourceAbsorb);
        }
        return flag;
    }
}

