/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.resourceuse;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.constants.ResourceAbsorbParam;
import kd.macc.cad.common.helper.ResourceAbsorbHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.resourceuse.AbstractResourceUseAction;
import kd.macc.cad.mservice.resourceuse.ResourceUseArgs;

public class ResourceCheckAbsorbAction
extends AbstractResourceUseAction {
    private static final Log logger = LogFactory.getLog(ResourceCheckAbsorbAction.class);
    private DataSet existResource;

    public ResourceCheckAbsorbAction(DataSet existsResourceCopy) {
        this.existResource = existsResourceCopy;
    }

    @Override
    protected void doExecute() {
        ResourceUseArgs resourceUseArgs = this.getResourceUseContext().getResourceUseArgs();
        if ("sca".equals(resourceUseArgs.getAppNum())) {
            Set<Long> resourceUseIds = this.getUnGenAbsorbResource(this.existResource);
            this.genResourceAbsorb(resourceUseIds);
        }
    }

    private void genResourceAbsorb(Set<Long> resourceUseIds) {
        if (!CadEmptyUtils.isEmpty(resourceUseIds)) {
            int resourceUseIdsPartition = CadBgParamUtils.getCadParamForInt((String)"resourceUseIdsPartition", (int)9000);
            List partitions = Lists.partition(new ArrayList<Long>(resourceUseIds), (int)resourceUseIdsPartition);
            ResourceAbsorbParam resourceSbsParam = new ResourceAbsorbParam();
            ResourceAbsorbHelper.buildCostAndPeriod((Long)this.getResourceUseContext().getResourceUseArgs().getAcctOrgId(), (ResourceAbsorbParam)resourceSbsParam);
            for (List partition : partitions) {
                QFilter idQf = new QFilter("id", "in", (Object)partition);
                DynamicObject[] resoureUses = BusinessDataServiceHelper.load((String)"sca_resourceuse", (String)"id,bizdate,costcenter,bookdate,pricedate,description,manuorg,resource,billno,workcenter,entryentity.material,entryentity.auxpty,entryentity.workhour,entryentity.facthour,entryentity.factuse,entryentity.factbatch,entryentity.opra,entryentity.seq,entryentity.costobject,route,processseq,operationno", (QFilter[])new QFilter[]{idQf}, null);
                HashSet<Long> manuOrgs = new HashSet<Long>(5);
                HashSet<Long> resources = new HashSet<Long>(16);
                for (DynamicObject resourceUse : resoureUses) {
                    manuOrgs.add(resourceUse.getLong("manuorg.id"));
                    resources.add(resourceUse.getLong("resource.id"));
                }
                HashSet<Long> costTypes = new HashSet<Long>(5);
                Map<Long, Long> manuOrgCostTypeMap = this.getCostTypeMap(this.getResourceUseContext().getResourceUseArgs().getAcctOrgId(), manuOrgs);
                for (Map.Entry<Long, Long> entry : manuOrgCostTypeMap.entrySet()) {
                    costTypes.add(entry.getValue());
                }
                resourceSbsParam.setCostRulePlan(ResourceAbsorbHelper.getRulePlanByCostTypes(costTypes));
                Map resourceMap = ResourceAbsorbHelper.getResourceMap(costTypes, resources, null);
                HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(16);
                for (DynamicObject resourceUse : resoureUses) {
                    Long costType = manuOrgCostTypeMap.get(resourceUse.getLong("manuorg.id"));
                    if (costType == null) {
                        logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6_\u672a\u6839\u636e\u751f\u4ea7\u7ec4\u7ec7\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b_\u751f\u4ea7\u7ec4\u7ec7==>{},\u6e90\u5355\u7f16\u53f7==>{}", (Object)resourceUse.getLong("manuorg.id"), (Object)resourceUse.getString("billno"));
                        continue;
                    }
                    DynamicObject resourceObj = ResourceAbsorbHelper.getResourceByPriceRule((Long)costType, (DynamicObject)resourceUse, (Map)resourceMap, (ResourceAbsorbParam)resourceSbsParam);
                    if (resourceObj == null) {
                        logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6_\u672a\u6839\u636e\u6e90\u5355\u627e\u5230\u5bf9\u5e94\u7684\u8d44\u6e90\u6807\u51c6\u8d39\u7528\u4ef7\u76ee\u8868,\u6e90\u5355\u7f16\u53f7==>{}", (Object)resourceUse.getString("billno"));
                        continue;
                    }
                    resultMap.put(resourceUse.getString("billno"), resourceObj);
                }
                resourceSbsParam.setResourceMap(resultMap);
                for (DynamicObject resoureUse : resoureUses) {
                    boolean flag;
                    DynamicObjectCollection entryEntity = resoureUse.getDynamicObjectCollection("entryentity");
                    if (entryEntity != null && entryEntity.size() == 1) {
                        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(0);
                        long costObjectId = dynamicObject.getLong("costobject.id");
                        resourceSbsParam.setCostObject(Long.valueOf(costObjectId));
                    }
                    if (flag = this.createResourceAbsorbBill(this.getResourceUseContext(), null, resoureUse, resourceSbsParam)) continue;
                    logger.info("\u8d44\u6e90\u5f52\u96c6\u5355\u7f16\u53f7:{}\u751f\u6210\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u5931\u8d25!", (Object)resoureUse.getString("billno"));
                }
            }
            if (!CadEmptyUtils.isEmpty((List)resourceSbsParam.getSaveList())) {
                SaveServiceHelper.save((DynamicObject[])resourceSbsParam.getSaveList().toArray(new DynamicObject[0]));
            }
        }
    }

    private Map<Long, Long> getCostTypeMap(Long orgId, Set<Long> manuOrgs) {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (Long manuOrg : manuOrgs) {
            DynamicObject dynamicObject = ResourceAbsorbHelper.getCostTypeByOrg((long)orgId, (long)manuOrg);
            if (dynamicObject == null) continue;
            logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u6839\u636e\u751f\u4ea7\u7ec4\u7ec7\u627e\u5230\u6210\u672c\u7c7b\u578b,\u751f\u4ea7\u7ec4\u7ec7==>{},\u6210\u672c\u7c7b\u578b==>{}", (Object)manuOrg, (Object)dynamicObject.getString("name"));
            map.put(manuOrg, dynamicObject.getLong("costType"));
        }
        return map;
    }

    private Set<Long> getUnGenAbsorbResource(DataSet existsResourceCopy) {
        HashSet<Long> unAbsorbResource = new HashSet<Long>(128);
        Set<Long> rangedResourceIds = this.getRangedResource(existsResourceCopy);
        if (!CadEmptyUtils.isEmpty(rangedResourceIds)) {
            List partitions = Lists.partition(new ArrayList<Long>(rangedResourceIds), (int)20000);
            for (List partition : partitions) {
                unAbsorbResource.addAll(ResourceAbsorbHelper.getUnAbsorbResource((List)partition));
            }
        }
        return unAbsorbResource;
    }

    private Set<Long> getRangedResource(DataSet existsResourceCopy) {
        HashSet<Long> resourceUseIds = new HashSet<Long>(32);
        if (existsResourceCopy != null && !existsResourceCopy.isEmpty()) {
            for (Row row : existsResourceCopy) {
                Long resourceUseId = row.getLong("id");
                resourceUseIds.add(resourceUseId);
            }
        }
        return resourceUseIds;
    }
}

