/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.resourceuse;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.business.config.service.CostObjectService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.resourceuse.AbstractResourceUseAction;
import kd.macc.cad.mservice.resourceuse.ResourceUseArgs;

public class ResourceConditionAction
extends AbstractResourceUseAction {
    private static final Log logger = LogFactory.getLog(ResourceConditionAction.class);

    @Override
    protected void doExecute() {
        this.refreshProgress(ResManager.loadKDString((String)"\u6784\u5efa\u6761\u4ef6\uff0c\u5f52\u96c6\u5f00\u59cb\u3002", (String)"ResourceConditionAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, 7, false);
        ResourceUseArgs resourceUseArgs = this.getResourceUseContext().getResourceUseArgs();
        String appNum = resourceUseArgs.getAppNum();
        Long accountOrgId = resourceUseArgs.getAcctOrgId();
        List<Long> costCenterIds = resourceUseArgs.getCostCenterIds();
        List<Long> mftOrderEntryIds = resourceUseArgs.getMftOrderEntryIds();
        Map<String, String> responseInfo = this.getResourceUseContext().getResponseInfo();
        Map<String, List<Long>> acctOrgCalmethodCostCentersMap = this.getResourceUseContext().getOrgMethodCostCenters();
        if (CadEmptyUtils.isEmpty(mftOrderEntryIds) && CadEmptyUtils.isEmpty(costCenterIds)) {
            logger.info("\u6ca1\u6709\u5728\u6210\u672c\u53c2\u6570\u4e2d\u914d\u7f6e\u9700\u8981\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\u7684\u6210\u672c\u4e2d\u5fc3\u3002");
            this.refreshProgress(ResManager.loadKDString((String)"\u6ca1\u6709\u5728\u6210\u672c\u53c2\u6570\u4e2d\u914d\u7f6e\u9700\u8981\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"ResourceConditionAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 8, false);
            MsgUtils.putMsg2Map((String)"tip", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u5728\u6210\u672c\u53c2\u6570\u4e2d\u914d\u7f6e\u9700\u8981\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"ResourceConditionAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), responseInfo);
            this.getResourceUseContext().setContinueExecute(false);
            return;
        }
        List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)Long.parseLong(RequestContext.get().getUserId()), Collections.singletonList(accountOrgId), (Set)Sets.newHashSet(costCenterIds), (String)"sca_resourceuse", (String)appNum);
        Map rulesMap = null;
        Map costCenterByRules = null;
        Map dimensionAndRuleMap = null;
        if (ImportServiceHelper.isStartCollConfigScheme().booleanValue()) {
            List cuCostCenters;
            List flCostCenters;
            List pzCostCenters;
            List fpCostCenters;
            dimensionAndRuleMap = CostObjectService.getDimensionAndRuleMap();
            rulesMap = CostObjectHelper.getCostObjectRulesMap((Long)accountOrgId, (List)enableCostCenters);
            costCenterByRules = CostObjectHelper.groupCostCenterByRules((List)enableCostCenters, (Map)rulesMap);
            List importScopeDate = SysParamHelper.getImportScopeDate((Long)accountOrgId, (String)appNum);
            CostCenterHelper.getWorkCenter(costCenterIds, (List)importScopeDate, (CollectReport)this.getResourceUseContext().getCollectReport());
            CostCenterHelper.getAdminOrg(costCenterIds, (List)importScopeDate, (CollectReport)this.getResourceUseContext().getCollectReport());
            CostCenterHelper.getBosOrgs(costCenterIds, (List)importScopeDate, (CollectReport)this.getResourceUseContext().getCollectReport());
            String key = accountOrgId + CostObjectEnum.BIZTYPE_RO.getValue();
            List reProduceCostCenters = (List)costCenterByRules.get(key);
            if (!CadEmptyUtils.isEmpty((List)reProduceCostCenters)) {
                this.getResourceUseContext().getCollectReport().setReProCostCenters(reProduceCostCenters);
            }
            if (!CadEmptyUtils.isEmpty((List)(fpCostCenters = (List)costCenterByRules.get(key = accountOrgId + CostObjectEnum.BIZTYPE_SO.getValue())))) {
                this.getResourceUseContext().getCollectReport().setFpCostCenters(fpCostCenters);
            }
            if (!CadEmptyUtils.isEmpty((List)(pzCostCenters = (List)costCenterByRules.get(key = accountOrgId + CostObjectEnum.BIZTYPE_PZ.getValue())))) {
                this.getResourceUseContext().getCollectReport().setPzCostCenters(pzCostCenters);
            }
            if (!CadEmptyUtils.isEmpty((List)(flCostCenters = (List)costCenterByRules.get(key = accountOrgId + CostObjectEnum.BIZTYPE_FL.getValue())))) {
                this.getResourceUseContext().getCollectReport().setFlCostCenters(flCostCenters);
            }
            if (!CadEmptyUtils.isEmpty((List)(cuCostCenters = (List)costCenterByRules.get(key = accountOrgId + CostObjectEnum.BIZTYPE_CU.getValue())))) {
                this.getResourceUseContext().getCollectReport().setCuCostCenters(cuCostCenters);
            }
        } else {
            rulesMap = CostObjectHelper.getRulesMap((Long)accountOrgId, (List)enableCostCenters);
            costCenterByRules = CostObjectHelper.groupCostCenterByRules((Long)accountOrgId, (List)enableCostCenters, (Map)rulesMap);
        }
        if (CadEmptyUtils.isEmpty((Map)costCenterByRules)) {
            this.refreshProgress(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"ResourceConditionAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 8, false);
            MsgUtils.putMsg2Map((String)"tip", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"ResourceConditionAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), responseInfo);
            return;
        }
        acctOrgCalmethodCostCentersMap.putAll(costCenterByRules);
        this.getResourceUseContext().getRulesMap().putAll(rulesMap);
        if (!CadEmptyUtils.isEmpty((Map)dimensionAndRuleMap)) {
            this.getResourceUseContext().getDimensionAndRuleMap().putAll(dimensionAndRuleMap);
        }
        if (CadEmptyUtils.isEmpty(resourceUseArgs.getCollectParamMap()) && CadEmptyUtils.isEmpty(mftOrderEntryIds) && CostObjectService.containNotOrderTypeRule((Long)accountOrgId, (Map)costCenterByRules) && "1".equals(CadBgParamUtils.getCadBgParamForString((String)"autoGenCostObject", (String)"1"))) {
            CostObjectService.generateCostObject((Long)accountOrgId, costCenterIds, resourceUseArgs.getManuOrgs(), null, (String)appNum, (CollectReport)this.getResourceUseContext().getCollectReport());
        }
    }
}

