/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.resourceuse;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.business.numcheck.CollNumCheckHelper;
import kd.macc.cad.common.dto.CollectDiff;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.resourceuse.AbstractResourceUseAction;

public class ResourceDiffForConfigAction
extends AbstractResourceUseAction {
    private final Log logger = LogFactory.getLog(ResourceDiffForConfigAction.class);

    @Override
    protected void doExecute() {
        if (!CollectReportHelper.disableCollectReport()) {
            CollectReport collectReport = this.getResourceUseContext().getCollectReport();
            this.getResourceUseContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u68c0\u67e5\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5dee\u5f02", (String)"ResourceDiffForConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            this.refreshProgress(ResManager.loadKDString((String)"\u68c0\u67e5\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5dee\u5f02", (String)"ResourceDiffForConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 7, false);
            Map billNoReasonMap = this.getResourceUseContext().getErrorInfMap();
            ArrayList diffs = Lists.newArrayListWithExpectedSize((int)8);
            for (Map.Entry billNoReason : billNoReasonMap.entrySet()) {
                String key = (String)billNoReason.getKey();
                String[] split = key.split("@");
                String value = (String)billNoReason.getValue();
                CollectDiff collectDiff = new CollectDiff(split[0], Integer.valueOf(CadEmptyUtils.isEmpty((String)split[1]) ? 0 : Integer.parseInt(split[1])), split[2], value);
                collectDiff.setSrcbillType(split[2]);
                if (value.length() > 0) {
                    collectDiff.setReason(value);
                }
                diffs.add(collectDiff);
            }
            this.getDiffReason(collectReport.getDateRange(), diffs);
            if (diffs.size() > 0) {
                this.getResourceUseContext().getCollectReport().getCollectDiffs().addAll(diffs);
                this.getResourceUseContext().getCollectReport().setError(true);
            }
            String desc = ResManager.loadKDString((String)"\u5171\u6709\u5dee\u5f02\u6570\u636e%s\u6761\u3002", (String)"ResourceDiffForConfigAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]);
            this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(desc, diffs.size()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{collectReport.transfer2Dynamic(Boolean.FALSE)});
        }
    }

    private void getDiffReason(String daterange, List<CollectDiff> diffs) {
        Long accountOrgId = this.getResourceUseContext().getResourceUseArgs().getAcctOrgId();
        String appNum = this.getResourceUseContext().getResourceUseArgs().getAppNum();
        List<Long> costCenterIds = this.getResourceUseContext().getResourceUseArgs().getCostCenterIds();
        CollNumCheckHelper.getCostCenterDiff((String)"D", (String)daterange, (Long)accountOrgId, (String)appNum, costCenterIds, diffs, null);
    }
}

