/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.resourceuse;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.MultiPartCcHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.resourceuse.AbstractResourceUseAction;

public class ResourceHandleBillAction
extends AbstractResourceUseAction {
    @Override
    protected void doExecute() {
        String key;
        this.getResourceUseContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f52\u96c6\u5230\u7684\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355", (String)"ResourceHandleBillAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        DynamicObjectCollection oldBillList = this.getResourceUseContext().getOldBillList();
        Map<String, List<DynamicObject>> sourceBillMap = this.getResourceUseContext().getSourceBillMap();
        Map<Long, DynamicObject> costObjectMap = this.getResourceUseContext().getCostObjectMap();
        List<DynamicObject> importBillList = this.getResourceUseContext().getImportBillList();
        String appNum = this.getResourceUseContext().getResourceUseArgs().getAppNum();
        int addCount = 0;
        int updateCount = 0;
        int delCount = 0;
        ArrayList<Long> srcbillIds = new ArrayList<Long>(10);
        Set<Long> confirmedCostObjectIds = new HashSet<Long>();
        HashMap<String, DynamicObject> oldBillMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject resourceBill : oldBillList) {
            confirmedCostObjectIds.add(resourceBill.getLong("costobject"));
            if (CadEmptyUtils.isEmpty((Long)resourceBill.getLong("srcbillid"))) continue;
            oldBillMap.put(resourceBill.getString("billno") + "@" + resourceBill.getString("srcbillid"), resourceBill);
            srcbillIds.add(resourceBill.getLong("srcbillid"));
        }
        confirmedCostObjectIds = this.getCostConfirmCostObject(confirmedCostObjectIds, sourceBillMap, costObjectMap);
        ArrayList<DynamicObject> coverBillListByAdd = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> coverBillListByUpdate = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> costChangedBillForUpdate = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> costChangedBillForDel = new ArrayList<DynamicObject>(10);
        HashSet<Long> delBillIds = new HashSet<Long>(16);
        HashSet<Long> delSrcBillIds = new HashSet<Long>(16);
        HashMap<String, DynamicObject> newBillMap = new HashMap<String, DynamicObject>(16);
        String split = "@";
        StringBuilder keySb = new StringBuilder();
        for (DynamicObject newBill : importBillList) {
            DynamicObjectCollection entrys;
            keySb.setLength(0);
            keySb.append(newBill.get("billno")).append(split).append(newBill.get("srcbillid"));
            key = keySb.toString();
            DynamicObject oldBill = (DynamicObject)oldBillMap.get(key);
            DynamicObject coverBill = null;
            newBillMap.put(key, newBill);
            if (oldBill == null) {
                coverBill = newBill;
                coverBillListByAdd.add(newBill);
                ++addCount;
            } else if (oldBill != null && (this.isDataChanged(newBill, oldBill) || this.isPriceDateChanged(newBill, oldBill))) {
                this.resetBillCreatData(newBill, oldBill);
                coverBill = newBill;
                coverBillListByUpdate.add(newBill);
                ++updateCount;
            }
            if (!"sca".equalsIgnoreCase(appNum) || CadEmptyUtils.isEmpty(confirmedCostObjectIds) || coverBill == null || (entrys = coverBill.getDynamicObjectCollection("entryentity")).size() <= 0 || !confirmedCostObjectIds.contains(((DynamicObject)entrys.get(0)).get("costobject"))) continue;
            costChangedBillForUpdate.add(coverBill);
        }
        for (Object oldBill : oldBillList) {
            keySb.setLength(0);
            keySb.append(oldBill.get("billno")).append(split).append(oldBill.get("srcbillid"));
            key = keySb.toString();
            DynamicObject newBill = (DynamicObject)newBillMap.get(key);
            if (newBill != null) continue;
            delBillIds.add(oldBill.getLong("id"));
            delSrcBillIds.add(oldBill.getLong("srcbillid"));
            if (confirmedCostObjectIds.contains(oldBill.get("costobject"))) {
                costChangedBillForDel.add((DynamicObject)oldBill);
            }
            ++delCount;
        }
        if (!CadEmptyUtils.isEmpty(delBillIds) && !CadEmptyUtils.isEmpty(delSrcBillIds)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sca_resourceuse"), (Object[])delBillIds.toArray(new Long[0]));
            if ("sca".equalsIgnoreCase(appNum)) {
                this.delChangeRecord(delSrcBillIds);
            }
        }
        List addLists = Lists.partition(coverBillListByAdd, (int)1000);
        for (Object tempList : addLists) {
            SaveServiceHelper.save((DynamicObject[])tempList.toArray(new DynamicObject[0]));
        }
        List coverLists = Lists.partition(coverBillListByUpdate, (int)1000);
        for (List tempList : coverLists) {
            SaveServiceHelper.update((DynamicObject[])tempList.toArray(new DynamicObject[0]));
        }
        MultiPartCcHelper.resolveMultipartCc(this.getResourceUseContext().getCostObjCcSet());
        this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e%1$s\u6761\uff0c\u66f4\u65b0\u6570\u636e%2$s\u6761\u3002", (String)"ResourceHandleBillAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), coverBillListByAdd.size(), coverBillListByUpdate.size()));
        this.getResourceUseContext().setAddCount(this.getResourceUseContext().getAddCount() + addCount);
        this.getResourceUseContext().setDelCount(this.getResourceUseContext().getDelCount() + delCount);
        this.getResourceUseContext().setUpdateCount(this.getResourceUseContext().getUpdateCount() + updateCount);
        if ("sca".equalsIgnoreCase(appNum)) {
            List<DynamicObject> costChangedRecords = this.generateRecs(costChangedBillForUpdate, costChangedBillForDel, oldBillMap, srcbillIds);
            this.getResourceUseContext().getCostChangedRecords().addAll(costChangedRecords);
        }
    }

    private boolean isPriceDateChanged(DynamicObject newBill, DynamicObject oldBill) {
        Date priceDate = oldBill.getDate("pricedate");
        Date auditDate = newBill.getDate("pricedate");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(auditDate);
        auditDate = calendar.getTime();
        if (priceDate == null) {
            return false;
        }
        return priceDate.compareTo(auditDate) != 0;
    }

    private Set<Long> getCostConfirmCostObject(Set<Long> costConfirmCostObjectIds, Map<String, List<DynamicObject>> importBillMap, Map<Long, DynamicObject> costObjectMap) {
        for (Map.Entry<String, List<DynamicObject>> reportBillEntry : importBillMap.entrySet()) {
            List<DynamicObject> reportBillSubEntrys = reportBillEntry.getValue();
            DynamicObject reportBillSE = reportBillSubEntrys.get(0);
            DynamicObject costObject = costObjectMap.get(reportBillSE.getLong("probillentryid"));
            if (costObject == null) continue;
            costConfirmCostObjectIds.add(costObject.getLong("id"));
        }
        QFilter costObjectQf = new QFilter("costobject", "in", costConfirmCostObjectIds);
        costObjectQf.and("bizstatus", "=", (Object)"B");
        DynamicObjectCollection costConfirms = QueryServiceHelper.query((String)"sca_costconfirm", (String)"costobject", (QFilter[])new QFilter[]{costObjectQf});
        HashSet<Long> confirmedCostObjectIds = new HashSet<Long>(costConfirms.size());
        costConfirms.forEach(s -> confirmedCostObjectIds.add(s.getLong("costobject")));
        return confirmedCostObjectIds;
    }

    private boolean isDataChanged(DynamicObject newBill, DynamicObject oldBill) {
        String split = "@";
        StringBuilder newKey = new StringBuilder();
        DynamicObjectCollection entryEntity = newBill.getDynamicObjectCollection("entryentity");
        DynamicObject row = (DynamicObject)entryEntity.get(0);
        newKey.append(newBill.get("resource")).append(split).append(row.get("workhour")).append(split).append(row.get("facthour")).append(split).append(row.get("factuse")).append(split).append(row.get("costobject")).append(split);
        StringBuilder oldKey = new StringBuilder();
        oldKey.append(oldBill.getLong("resource")).append(split).append(oldBill.getLong("workhour")).append(split).append(oldBill.getBigDecimal("facthour")).append(split).append(oldBill.getBigDecimal("factuse")).append(split).append(oldBill.getLong("costobject")).append(split);
        String newValue = newKey.toString();
        String oldValue = oldKey.toString();
        return !newValue.equals(oldValue);
    }

    private void resetBillCreatData(DynamicObject newBill, DynamicObject oldBill) {
        newBill.set("id", (Object)oldBill.getLong("id"));
        newBill.set("createtime", oldBill.get("createtime"));
        newBill.set("creator", oldBill.get("creator"));
        DynamicObjectCollection newEntry = newBill.getDynamicObjectCollection("entryentity");
        ((DynamicObject)newEntry.get(0)).set("id", oldBill.get("entryid"));
    }

    private List<DynamicObject> generateRecs(List<DynamicObject> costChangedBillForUpdate, List<DynamicObject> costChangedBillForDel, Map<String, DynamicObject> resourceBillMap, List<Long> srcbillIds) {
        ArrayList<DynamicObject> costChangedRecs = new ArrayList<DynamicObject>(10);
        StringBuilder sb = new StringBuilder();
        String split2 = "||";
        List<Long> settlChangeRecords = this.getChangeRecordBySettled(srcbillIds);
        for (DynamicObject changeBill : costChangedBillForUpdate) {
            sb.setLength(0);
            DynamicObject costChange = this.getCostChange(changeBill);
            String newChangeText = this.getChangeText(changeBill, true);
            sb.append(newChangeText).append(split2);
            String key = changeBill.getString("billno") + "@" + changeBill.get("srcbillid");
            DynamicObject oldBill = resourceBillMap.get(key);
            if (oldBill != null) {
                sb.append(this.getChangeText(oldBill, false));
            }
            costChange.set("changecontext", (Object)sb.toString());
            Long costObjectId = ((DynamicObject)changeBill.getDynamicObjectCollection("entryentity").get(0)).getLong("costobject");
            costChange.set("costobject", (Object)costObjectId);
            costChangedRecs.add(costChange);
        }
        for (DynamicObject changeBill : costChangedBillForDel) {
            if (!settlChangeRecords.contains(changeBill.getLong("srcbillid"))) continue;
            sb.setLength(0);
            String oldChangeText = this.getChangeText(changeBill, false);
            sb.append(split2).append(oldChangeText);
            DynamicObject costChange = this.getCostChange(changeBill);
            costChange.set("changecontext", (Object)sb.toString());
            costChange.set("costobject", changeBill.get("costobject"));
            costChangedRecs.add(costChange);
        }
        return costChangedRecs;
    }

    @Override
    protected List<Long> getChangeRecordBySettled(List<Long> srcbillIds) {
        QFilter filter = new QFilter("sourcebill", "in", srcbillIds);
        filter.and("bizstatus", "=", (Object)"B");
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)"sca_costchangerecord", (String)"sourcebill", (QFilter[])new QFilter[]{filter});
        srcbillIds.clear();
        sourceBills.forEach(p -> srcbillIds.add(p.getLong("sourcebill")));
        return srcbillIds;
    }

    private String getChangeText(DynamicObject bill, boolean isAdd) {
        StringBuilder sg = new StringBuilder(bill.getString("billno"));
        String join = "@";
        sg.append(join);
        sg.append(bill.getString("resource"));
        sg.append(join);
        DynamicObject row = bill;
        if (isAdd) {
            DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
            row = (DynamicObject)entryentity.get(0);
        }
        sg.append(row.getString("workhour"));
        sg.append(join);
        sg.append(row.getString("facthour"));
        sg.append(join);
        sg.append(row.getString("factuse"));
        return sg.toString();
    }

    private DynamicObject getCostChange(DynamicObject newBill) {
        DynamicObject costChange = BusinessDataServiceHelper.newDynamicObject((String)"sca_costchangerecord");
        costChange.set("org", newBill.get("org"));
        costChange.set("costcenter", newBill.get("costcenter"));
        costChange.set("sourcebill", (Object)newBill.getLong("srcbillid"));
        costChange.set("businessbill", (Object)"sca_resourceuse");
        costChange.set("creator", (Object)RequestContext.get().getUserId());
        costChange.set("createtime", (Object)TimeServiceHelper.now());
        costChange.set("sourcebiztime", newBill.get("bookdate"));
        return costChange;
    }
}

