/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.resourceuse;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.business.config.service.CostObjectService;
import kd.macc.cad.common.constants.ResourceAbsorbParam;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ResourceAbsorbHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.resourceuse.AbstractResourceUseAction;
import kd.macc.cad.mservice.resourceuse.ResourceUseArgs;
import kd.macc.cad.mservice.resourceuse.ResourceUseContext;
import org.apache.commons.lang3.StringUtils;

public class ResourceImportDataConfigAction
extends AbstractResourceUseAction {
    private static final Log logger = LogFactory.getLog(ResourceImportDataConfigAction.class);

    @Override
    protected void doExecute() {
        ResourceUseArgs resourceUseArgs = this.getResourceUseContext().getResourceUseArgs();
        Long accountOrgId = resourceUseArgs.getAcctOrgId();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getResourceUseContext().getConfigSrcAndTargetBillsMap();
        Map<Long, String> dimensionAndRuleMap = this.getResourceUseContext().getDimensionAndRuleMap();
        Map<Long, Map<String, String>> collConfigMappingMap = this.getResourceUseContext().getCollConfigMappingMap();
        Map<Long, Map<String, String>> collConfigRuleMappingMap = this.getResourceUseContext().getCollConfigRuleMappingMap();
        String key = accountOrgId + CostObjectEnum.BIZTYPE_RO.getValue();
        List<Long> reProduceCostCenters = this.getResourceUseContext().getOrgMethodCostCenters().get(key);
        if (CadEmptyUtils.isEmpty(reProduceCostCenters)) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u5de5\u5355\u6210\u672c\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5f15\u5165\u7ed3\u675f\uff01", (Object)accountOrgId);
            return;
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u5de5\u5355\u6cd5\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5904\u7406", (String)"ResourceImportDataConfigAction_44", (String)"macc-cad-mservice", (Object[])new Object[0]), 3, 7, false);
        this.getResourceUseContext().getCollectReport().setReProCostCenters(reProduceCostCenters);
        for (Map.Entry<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
            DynamicObject config = configSrcAndTargetBill.getKey();
            String sourceBill = config.getString("sourcebill.id");
            String sourcebillName = config.getString("sourcebill.name");
            if (!CostObjectEnum.BIZTYPE_RO.getValue().equals(config.getString("calmethod"))) continue;
            Map<DynamicObject, DynamicObject> srcAndTargetBillsMap = configSrcAndTargetBill.getValue();
            ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
            this.getResourceUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%s", (String)"ResourceImportDataConfigAction_33", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName));
            this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u201c%1$s\u201d%2$s\u6761\u6570\u636e\u3002", (String)"ResourceImportDataConfigAction_34", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName, srcBills.size()));
            long costcalcdimension = config.getLong("costcalcdimension.id");
            String dimension = dimensionAndRuleMap.get(costcalcdimension);
            if (CadEmptyUtils.isEmpty((String)dimension)) {
                this.getResourceUseContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"ResourceImportDataConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u6ca1\u6709\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ef4\u5ea6\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"ResourceImportDataConfigAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                continue;
            }
            List<Long> costcenterIds = this.getResourceUseContext().getOrgMethodCostCenters().get(String.valueOf(accountOrgId).concat(CostObjectEnum.BIZTYPE_RO.getValue()));
            TreeMap<String, String> configRuleMappingMap = new TreeMap<String, String>(collConfigRuleMappingMap.get(config.getLong("id")));
            Set<Long> manuIds = this.getCollectManuEntryIds(configRuleMappingMap, srcBills);
            if (CadEmptyUtils.isEmpty(resourceUseArgs.getMftOrderEntryIds())) {
                CostObjectService.autoGenerateCostobject((Long)accountOrgId, costcenterIds != null ? costcenterIds : resourceUseArgs.getCostCenterIds(), resourceUseArgs.getManuOrgs(), (CollectReport)this.getResourceUseContext().getCollectReport(), (String)resourceUseArgs.getAppNum(), manuIds);
            }
            String costObjectFields = "probill";
            Map existCostObjectMap = CostObjectHelper.getExistCostObjectMap((Long)accountOrgId, null, (String)costObjectFields, (String)resourceUseArgs.getAppNum(), new ArrayList<Long>(manuIds));
            Map<String, String> configMappingMap = collConfigMappingMap.get(config.getLong("id"));
            this.getResourceUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\uff0c\u5904\u7406\u6e90\u5355\u3002", (String)"ResourceImportDataConfigAction_19", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
            List<DynamicObject> resourceBills = this.getResourceBill(accountOrgId, reProduceCostCenters, srcAndTargetBillsMap, existCostObjectMap, configRuleMappingMap, configMappingMap, this.getResourceUseContext().getEntryIdIdMap(), sourceBill, resourceUseArgs.getAppNum());
            this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u6570\u636e%s\u6761\u3002", (String)"ResourceImportDataConfigAction_20", (String)"macc-cad-mservice", (Object[])new Object[0]), resourceBills.size()));
        }
    }

    private Set<Long> getCollectManuEntryIds(Map<String, String> configRuleMappingMap, List<DynamicObject> srcBills) {
        HashSet manuIds = Sets.newHashSetWithExpectedSize((int)10);
        String srcBillField = configRuleMappingMap.get("probill");
        if (StringUtils.isEmpty((CharSequence)srcBillField)) {
            return manuIds;
        }
        for (DynamicObject dyn : srcBills) {
            manuIds.add(dyn.getLong(srcBillField));
        }
        return manuIds;
    }

    private List<DynamicObject> getResourceBill(Long acctOrg, List<Long> costCenters, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, Map<String, DynamicObject>> existCostObjectMap, TreeMap<String, String> collConfigRuleMappingMap, Map<String, String> configMappingMap, Map<Long, Long> entryIdIdMap, String sourceBill, String appNum) {
        ArrayList<DynamicObject> resourceBills = new ArrayList<DynamicObject>(10);
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return resourceBills;
        }
        int addNum = 0;
        int delNum = 0;
        ResourceUseContext context = this.getResourceUseContext();
        ResourceAbsorbParam resourceSbsParam = this.getResourceUseContext().getResourceAbsorbParam();
        resourceSbsParam.getSaveList().clear();
        if ("sca".equals(appNum)) {
            this.getResourcePriceMap(srcAndTargetBillsMap, resourceSbsParam);
        }
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBill : srcAndTargetBillsMap.entrySet()) {
            DynamicObject srcBill = srcAndTargetBill.getKey();
            DynamicObject targetBill = srcAndTargetBill.getValue();
            if (!sourceBill.equals(srcBill.getString("billtype"))) continue;
            if (targetBill == null) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("subentryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u5b50\u5206\u5f55\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355\u636e\u3002", (String)"ResourceImportDataConfigAction_45", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("subentryseq")));
                continue;
            }
            Long costCenterId = targetBill.getLong("costcenter.id");
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("subentryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u5b50\u5206\u5f55\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"ResourceImportDataConfigAction_46", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("subentryseq")));
                continue;
            }
            if (!costCenters.contains(costCenterId)) continue;
            DynamicObject costObject = null;
            if (targetBill.containsProperty("costobject") && !CadEmptyUtils.isEmpty((DynamicObjectCollection)targetBill.getDynamicObjectCollection("entryentity")) && ((DynamicObject)targetBill.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("costobject") != null) {
                costObject = ((DynamicObject)targetBill.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("costobject");
            } else {
                String srcStr = srcBill.getString(collConfigRuleMappingMap.get("probill"));
                Map<String, DynamicObject> matInfoList = existCostObjectMap.get(String.valueOf(acctOrg));
                DynamicObject dynamicObject = costObject = matInfoList == null ? null : matInfoList.get(srcStr);
            }
            if (costObject == null) {
                if ("sca".equals(appNum)) {
                    context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("subentryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u5b50\u5206\u5f55\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u4e14\u672a\u7ed3\u7b97\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ResourceImportDataConfigAction_47", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("subentryseq")));
                    continue;
                }
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("subentryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u5b50\u5206\u5f55\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ResourceImportDataConfigAction_48", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("subentryseq")));
                continue;
            }
            long entryId = srcBill.getLong("subentryId");
            Boolean isNeedChange = entryIdIdMap.containsKey(entryId);
            if (isNeedChange.booleanValue()) {
                Long resourceId = entryIdIdMap.remove(entryId);
                ++delNum;
                this.getResourceUseContext().getNeedDelIdSet().add(resourceId);
            }
            this.generateResourceUseAbsorb(targetBill, costObject, sourceBill, srcBill, resourceSbsParam);
            resourceBills.add(targetBill);
            ++addNum;
        }
        this.getResourceUseContext().setAddCount(this.getResourceUseContext().getAddCount() + addNum);
        this.getResourceUseContext().setDelCount(this.getResourceUseContext().getDelCount() + delNum);
        this.getResourceUseContext().getImportBillList().addAll(resourceBills);
        this.getResourceUseContext().getResourceAbsorbList().addAll(resourceSbsParam.getSaveList());
        logger.info("\u65b0\u589e\u7684\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355:{}", (Object)resourceBills.size());
        return resourceBills;
    }

    private void generateResourceUseAbsorb(DynamicObject targetBill, DynamicObject costObject, String sourceBill, DynamicObject srcBill, ResourceAbsorbParam resourceSbsParam) {
        long id = targetBill.getLong("id");
        if (CadEmptyUtils.isEmpty((Long)id)) {
            targetBill.set("id", (Object)ID.genLongId());
        }
        DynamicObjectCollection entryentity = targetBill.getDynamicObjectCollection("entryentity");
        DynamicObject entity = null;
        entity = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity) ? entryentity.addNew() : (DynamicObject)entryentity.get(0);
        entity.set("costobject", (Object)costObject.getLong("id"));
        entity.set("costobject_id", (Object)costObject.getLong("id"));
        long entryId = entity.getLong("id");
        if (CadEmptyUtils.isEmpty((Long)entryId)) {
            entity.set("id", (Object)ID.genLongId());
        }
        if ("sfc_reportresource_adjust".equals(sourceBill)) {
            this.updateMaterialInfo(targetBill, costObject);
        }
        if ("sca".equals(this.getResourceUseContext().getResourceUseArgs().getAppNum())) {
            resourceSbsParam.setCostObject(Long.valueOf(costObject.getLong("id")));
            if (!this.createResourceAbsorbBill(this.getResourceUseContext(), srcBill, targetBill, resourceSbsParam)) {
                logger.info("\u5355\u636e\u7f16\u53f7:{}\u672a\u53d6\u5230\u81ea\u5236/\u59d4\u5916\u8d44\u6e90\u6807\u51c6\u4ef7\u76ee\u8868\uff0c\u65e0\u9700\u521b\u5efa\u8d39\u7528\u5438\u6536\u6210\u672c\u5355", (Object)targetBill.getString("billno"));
            }
        }
        targetBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        targetBill.set("createtime", (Object)TimeServiceHelper.now());
        targetBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
        targetBill.set("modifytime", (Object)TimeServiceHelper.now());
        targetBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
        targetBill.set("auditdate", (Object)TimeServiceHelper.now());
    }

    private void getResourcePriceMap(Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, ResourceAbsorbParam resourceSbsParam) {
        ResourceAbsorbHelper.buildCostAndPeriod((Long)this.getResourceUseContext().getResourceUseArgs().getAcctOrgId(), (ResourceAbsorbParam)resourceSbsParam);
        HashSet<Long> manuOrgs = new HashSet<Long>(5);
        HashSet<Long> resources = new HashSet<Long>(16);
        for (Map.Entry<DynamicObject, DynamicObject> entry : srcAndTargetBillsMap.entrySet()) {
            manuOrgs.add(entry.getValue().getLong("manuorg"));
            resources.add(entry.getValue().getLong("resource"));
        }
        HashSet<Long> costTypes = new HashSet<Long>(5);
        Map<Long, Long> manuOrgCostTypeMap = this.getCostTypeMap(this.getResourceUseContext().getResourceUseArgs().getAcctOrgId(), manuOrgs);
        for (Map.Entry<Long, Long> entry : manuOrgCostTypeMap.entrySet()) {
            costTypes.add(entry.getValue());
        }
        resourceSbsParam.setCostRulePlan(ResourceAbsorbHelper.getRulePlanByCostTypes(costTypes));
        Map resourceMap = ResourceAbsorbHelper.getResourceMap(costTypes, resources, null);
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(16);
        for (Map.Entry<DynamicObject, DynamicObject> entry : srcAndTargetBillsMap.entrySet()) {
            DynamicObject dynamicObject = entry.getValue();
            DynamicObject srcObj = entry.getKey();
            Long costType = manuOrgCostTypeMap.get(dynamicObject.getLong("manuorg"));
            if (costType == null) {
                logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6_\u672a\u6839\u636e\u751f\u4ea7\u7ec4\u7ec7\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b_\u751f\u4ea7\u7ec4\u7ec7==>{},\u6e90\u5355\u7f16\u53f7==>{}", (Object)dynamicObject.getLong("manuorg"), (Object)srcObj.getString("billno"));
                continue;
            }
            DynamicObject resourceObj = ResourceAbsorbHelper.getResourceByPriceRule((Long)costType, (DynamicObject)dynamicObject, (Map)resourceMap, (ResourceAbsorbParam)resourceSbsParam);
            if (resourceObj == null) {
                logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6_\u672a\u6839\u636e\u6e90\u5355\u627e\u5230\u5bf9\u5e94\u7684\u8d44\u6e90\u6807\u51c6\u8d39\u7528\u4ef7\u76ee\u8868,\u6e90\u5355\u7f16\u53f7==>{}", (Object)srcObj.getString("billno"));
                continue;
            }
            resultMap.put(dynamicObject.getString("billno"), resourceObj);
        }
        resourceSbsParam.setResourceMap(resultMap);
    }

    private Map<Long, Long> getCostTypeMap(Long orgId, Set<Long> manuOrgs) {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (Long manuOrg : manuOrgs) {
            DynamicObject dynamicObject = ResourceAbsorbHelper.getCostTypeByOrg((long)orgId, (long)manuOrg);
            if (dynamicObject == null) continue;
            logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u6839\u636e\u751f\u4ea7\u7ec4\u7ec7\u627e\u5230\u6210\u672c\u7c7b\u578b,\u751f\u4ea7\u7ec4\u7ec7==>{},\u6210\u672c\u7c7b\u578b==>{}", (Object)manuOrg, (Object)dynamicObject.getString("name"));
            map.put(manuOrg, dynamicObject.getLong("costType"));
        }
        return map;
    }
}

