/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.resourceuse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.resourceuse.AbstractResourceUseAction;
import kd.macc.cad.mservice.resourceuse.ResourceUseArgs;
import kd.macc.cad.mservice.resourceuse.ResourceUseContext;

public class ResourceImportDataForCUConfigAction
extends AbstractResourceUseAction {
    private static final Log logger = LogFactory.getLog(ResourceImportDataForCUConfigAction.class);

    @Override
    protected void doExecute() {
        ResourceUseArgs resourceUseArgs = this.getResourceUseContext().getResourceUseArgs();
        Long accountOrgId = resourceUseArgs.getAcctOrgId();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getResourceUseContext().getConfigSrcAndTargetBillsMap();
        Map<Long, Map<String, String>> collConfigMappingMap = this.getResourceUseContext().getCollConfigMappingMap();
        Map<Long, Map<String, String>> collConfigRuleMappingMap = this.getResourceUseContext().getCollConfigRuleMappingMap();
        String key = accountOrgId + CostObjectEnum.BIZTYPE_CU.getValue();
        List<Long> cuProduceCostCenters = this.getResourceUseContext().getOrgMethodCostCenters().get(key);
        if (CadEmptyUtils.isEmpty(cuProduceCostCenters)) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u81ea\u5b9a\u4e49\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5f15\u5165\u7ed3\u675f\uff01", (Object)accountOrgId);
            return;
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u65b9\u6cd5\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5904\u7406", (String)"ResourceImportDataForCUConfigAction_42", (String)"macc-cad-mservice", (Object[])new Object[0]), 4, 7, false);
        this.getResourceUseContext().getCollectReport().setCuCostCenters(cuProduceCostCenters);
        for (Map.Entry<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
            DynamicObject config = configSrcAndTargetBill.getKey();
            String sourceBill = config.getString("sourcebill.id");
            String sourcebillName = config.getString("sourcebill.name");
            if (!CostObjectEnum.BIZTYPE_CU.getValue().equals(config.getString("calmethod"))) continue;
            Map<DynamicObject, DynamicObject> srcAndTargetBillsMap = configSrcAndTargetBill.getValue();
            ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
            this.getResourceUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%s", (String)"ResourceImportDataForCUConfigAction_32", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName));
            this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u201c%1$s\u201d%2$s\u6761\u6570\u636e\u3002", (String)"ResourceImportDataForCUConfigAction_33", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName, srcBills.size()));
            DynamicObject costCalcDimension = config.getDynamicObject("costcalcdimension");
            String dimension = costCalcDimension.getString("calcrule");
            DynamicObjectCollection entryentity = costCalcDimension.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                dimension = dimension.concat(entry.getString("field")).concat(",");
            }
            if (CadEmptyUtils.isEmpty((String)dimension)) {
                this.getResourceUseContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"ResourceImportDataForCUConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u6ca1\u6709\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ef4\u5ea6\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"ResourceImportDataForCUConfigAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                continue;
            }
            TreeMap<String, String> configRuleMappingMap = new TreeMap<String, String>(collConfigRuleMappingMap.get(config.getLong("id")));
            String costObjectFields = String.join((CharSequence)",", configRuleMappingMap.keySet());
            Map existCostObjectMap = CostObjectHelper.getExistCostObjectMap((Long)accountOrgId, cuProduceCostCenters, (String)costObjectFields, (String)resourceUseArgs.getAppNum());
            Map<String, String> configMappingMap = collConfigMappingMap.get(config.getLong("id"));
            this.getResourceUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d,\u5904\u7406\u6e90\u5355\u3002", (String)"ResourceImportDataForCUConfigAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
            List<DynamicObject> resourceBills = this.getResourceBill(accountOrgId, cuProduceCostCenters, srcAndTargetBillsMap, existCostObjectMap, configRuleMappingMap, configMappingMap, this.getResourceUseContext().getEntryIdIdMap(), sourceBill, resourceUseArgs.getAppNum());
            this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u6570\u636e%s\u6761\u3002", (String)"ResourceImportDataForCUConfigAction_19", (String)"macc-cad-mservice", (Object[])new Object[0]), resourceBills.size()));
        }
    }

    private List<DynamicObject> getResourceBill(Long acctOrg, List<Long> costCenters, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, Map<String, DynamicObject>> existCostObjectMap, TreeMap<String, String> collConfigRuleMappingMap, Map<String, String> configMappingMap, Map<Long, Long> entryIdIdMap, String sourceBill, String appNum) {
        ArrayList<DynamicObject> resourceBills = new ArrayList<DynamicObject>(10);
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return resourceBills;
        }
        int addNum = 0;
        int delNum = 0;
        ResourceUseContext context = this.getResourceUseContext();
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBill : srcAndTargetBillsMap.entrySet()) {
            DynamicObject srcBill = srcAndTargetBill.getKey();
            DynamicObject targetBill = srcAndTargetBill.getValue();
            if (!sourceBill.equals(srcBill.getString("billtype"))) continue;
            if (targetBill == null) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u3002", (String)"ResourceImportDataForCUConfigAction_35", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            long subEntryId = srcBill.getLong("subentryId");
            boolean isNeedChangeData = entryIdIdMap.containsKey(subEntryId);
            Long costCenterId = targetBill.getLong("costcenter.id");
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"ResourceImportDataForCUConfigAction_39", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            if (!costCenters.contains(costCenterId)) continue;
            DynamicObject costObject = null;
            if (targetBill.containsProperty("costobject") && !CadEmptyUtils.isEmpty((DynamicObjectCollection)targetBill.getDynamicObjectCollection("entryentity")) && ((DynamicObject)targetBill.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("costobject") != null) {
                costObject = ((DynamicObject)targetBill.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("costobject");
            } else {
                String srcStr = CostObjectHelper.getCostObjectHashCodeBySrcBill((DynamicObject)srcBill, collConfigRuleMappingMap);
                Map<String, DynamicObject> matInfoList = existCostObjectMap.get(String.valueOf(acctOrg).concat(String.valueOf(costCenterId)));
                DynamicObject dynamicObject = costObject = matInfoList == null ? null : matInfoList.get(srcStr);
            }
            if (costObject == null) {
                if ("sca".equals(appNum)) {
                    context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u4e14\u672a\u7ed3\u7b97\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ResourceImportDataForCUConfigAction_40", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                    continue;
                }
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ResourceImportDataForCUConfigAction_41", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            if (isNeedChangeData) {
                Long resourceId = entryIdIdMap.remove(subEntryId);
                ++delNum;
                this.getResourceUseContext().getNeedDelIdSet().add(resourceId);
            }
            DynamicObjectCollection entryentity = targetBill.getDynamicObjectCollection("entryentity");
            DynamicObject entity = null;
            entity = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity) ? entryentity.addNew() : (DynamicObject)entryentity.get(0);
            entity.set("costobject", (Object)costObject.getLong("id"));
            entity.set("costobject_id", (Object)costObject.getLong("id"));
            ++addNum;
            if ("sfc_reportresource_adjust".equals(sourceBill)) {
                this.updateMaterialInfo(targetBill, costObject);
            }
            targetBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("createtime", (Object)TimeServiceHelper.now());
            targetBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("modifytime", (Object)TimeServiceHelper.now());
            targetBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("auditdate", (Object)TimeServiceHelper.now());
            resourceBills.add(targetBill);
        }
        this.getResourceUseContext().setAddCount(this.getResourceUseContext().getAddCount() + addNum);
        this.getResourceUseContext().setDelCount(this.getResourceUseContext().getDelCount() + delNum);
        this.getResourceUseContext().getImportBillList().addAll(resourceBills);
        logger.info("\u65b0\u589e\u7684\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355:{}", (Object)resourceBills.size());
        return resourceBills;
    }
}

