/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.resourceuse;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.resourceuse.AbstractResourceUseAction;
import kd.macc.cad.mservice.resourceuse.ResourceUseArgs;
import kd.macc.cad.mservice.resourceuse.ResourceUseContext;

public class ResourceImportDataForPZConfigAction
extends AbstractResourceUseAction {
    private static final Log logger = LogFactory.getLog(ResourceImportDataForPZConfigAction.class);

    @Override
    protected void doExecute() {
        ResourceUseArgs resourceUseArgs = this.getResourceUseContext().getResourceUseArgs();
        Long accountOrgId = resourceUseArgs.getAcctOrgId();
        Map<Long, Long> manuToMaterialMap = resourceUseArgs.getManuToMaterialMap();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getResourceUseContext().getConfigSrcAndTargetBillsMap();
        Map<Long, Map<String, String>> collConfigRuleMappingMap = this.getResourceUseContext().getCollConfigRuleMappingMap();
        String key = accountOrgId + CostObjectEnum.BIZTYPE_PZ.getValue();
        List<Long> pzCostCenters = this.getResourceUseContext().getOrgMethodCostCenters().get(key);
        if (CadEmptyUtils.isEmpty(pzCostCenters)) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u54c1\u79cd\u6cd5\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5f15\u5165\u7ed3\u675f\uff01", (Object)accountOrgId);
            return;
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5904\u7406\u3002", (String)"ResourceImportDataForPZConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 4, 7, false);
        this.getResourceUseContext().getCollectReport().setPzCostCenters(pzCostCenters);
        for (Map.Entry<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
            DynamicObject config = configSrcAndTargetBill.getKey();
            String sourceBill = config.getString("sourcebill.id");
            String sourcebillName = config.getString("sourcebill.name");
            if (!CostObjectEnum.BIZTYPE_PZ.getValue().equals(config.getString("calmethod"))) continue;
            Map<DynamicObject, DynamicObject> srcAndTargetBillsMap = configSrcAndTargetBill.getValue();
            ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
            this.getResourceUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%s", (String)"ResourceImportDataForPZConfigAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName));
            this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u201c%1$s\u201d%2$s\u6761\u6570\u636e\u3002", (String)"ResourceImportDataForPZConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName, srcBills.size()));
            DynamicObject costCalcDimension = config.getDynamicObject("costcalcdimension");
            String dimension = costCalcDimension.getString("calcrule");
            DynamicObjectCollection entryentity = costCalcDimension.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                dimension = dimension.concat(entry.getString("field")).concat(",");
            }
            if (CadEmptyUtils.isEmpty((String)dimension)) {
                this.getResourceUseContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"ResourceImportDataForPZConfigAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u6ca1\u6709\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ef4\u5ea6\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"ResourceImportDataForPZConfigAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                continue;
            }
            TreeMap<String, String> configRuleMappingMap = new TreeMap<String, String>(collConfigRuleMappingMap.get(config.getLong("id")));
            String costObjectFields = String.join((CharSequence)",", configRuleMappingMap.keySet());
            Map existCostObjectMap = CostObjectHelper.getExistCostObjectMap((Long)accountOrgId, pzCostCenters, (String)costObjectFields, (String)resourceUseArgs.getAppNum());
            this.getResourceUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\uff0c\u5904\u7406\u6e90\u5355\u3002", (String)"ResourceImportDataForPZConfigAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
            List<DynamicObject> resourceBills = this.getResourceBill(accountOrgId, pzCostCenters, srcAndTargetBillsMap, existCostObjectMap, configRuleMappingMap, this.getResourceUseContext().getEntryIdIdMap(), sourceBill, resourceUseArgs.getAppNum(), manuToMaterialMap);
            this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u6570\u636e%s\u6761\u3002", (String)"ResourceImportDataForPZConfigAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]), resourceBills.size()));
        }
    }

    private List<DynamicObject> getResourceBill(Long acctOrg, List<Long> costCenters, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, Map<String, DynamicObject>> existCostObjectMap, TreeMap<String, String> collConfigRuleMappingMap, Map<Long, Long> entryIdIdMap, String sourceBill, String appNum, Map<Long, Long> manuToMaterialMap) {
        ArrayList<DynamicObject> resourceBills = new ArrayList<DynamicObject>(10);
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return resourceBills;
        }
        int addNum = 0;
        int delNum = 0;
        ResourceUseContext context = this.getResourceUseContext();
        Map<Long, Boolean> materialMap = ResourceImportDataForPZConfigAction.getMaterialMap(acctOrg, srcAndTargetBillsMap, collConfigRuleMappingMap, manuToMaterialMap);
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBill : srcAndTargetBillsMap.entrySet()) {
            DynamicObjectCollection entryentity;
            String entrySeq;
            DynamicObject srcBill = srcAndTargetBill.getKey();
            DynamicObject targetBill = srcAndTargetBill.getValue();
            if (!sourceBill.equals(srcBill.getString("billtype"))) continue;
            String string = entrySeq = srcBill.containsProperty("entryseq") ? srcBill.getString("entryseq") : "";
            if (targetBill == null) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(entrySeq).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355\u636e\u3002", (String)"ResourceImportDataForPZConfigAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), entrySeq));
                continue;
            }
            long subEntryId = srcBill.containsProperty("subentryId") ? srcBill.getLong("subentryId") : (srcBill.containsProperty("entryId") ? srcBill.getLong("entryId") : srcBill.getLong("id"));
            boolean isNeedChangeData = entryIdIdMap.containsKey(subEntryId);
            Long costCenterId = targetBill.getLong("costcenter.id");
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(entrySeq).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"ResourceImportDataForPZConfigAction_8", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), entrySeq));
                continue;
            }
            if (!costCenters.contains(costCenterId)) continue;
            DynamicObject costObject = null;
            if (targetBill.containsProperty("costobject") && !CadEmptyUtils.isEmpty((DynamicObjectCollection)targetBill.getDynamicObjectCollection("entryentity")) && ((DynamicObject)targetBill.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("costobject") != null) {
                costObject = ((DynamicObject)targetBill.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("costobject");
            } else {
                String srcStr = !CadEmptyUtils.isEmpty(collConfigRuleMappingMap) && sourceBill.equals("sfc_reportresource_adjust") ? ResourceImportDataForPZConfigAction.getCostObjectHashCodeBySrcBillForPz(srcBill, collConfigRuleMappingMap, manuToMaterialMap, materialMap) : CostObjectHelper.getCostObjectHashCodeBySrcBill((DynamicObject)srcBill, collConfigRuleMappingMap);
                Map<String, DynamicObject> matInfoList = existCostObjectMap.get(String.valueOf(acctOrg).concat(String.valueOf(costCenterId)));
                DynamicObject dynamicObject = costObject = matInfoList == null ? null : matInfoList.get(srcStr);
            }
            if (costObject == null) {
                if ("sca".equals(appNum)) {
                    context.logErrorMsg(srcBill.getString("billno").concat("@").concat(entrySeq).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u4e14\u672a\u7ed3\u7b97\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ResourceImportDataForPZConfigAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), entrySeq));
                    continue;
                }
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(entrySeq).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ResourceImportDataForPZConfigAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), entrySeq));
                continue;
            }
            if (isNeedChangeData) {
                Long resourceId = entryIdIdMap.remove(subEntryId);
                ++delNum;
                this.getResourceUseContext().getNeedDelIdSet().add(resourceId);
            }
            DynamicObject entity = CadEmptyUtils.isEmpty((DynamicObjectCollection)(entryentity = targetBill.getDynamicObjectCollection("entryentity"))) ? entryentity.addNew() : (DynamicObject)entryentity.get(0);
            entity.set("costobject", (Object)costObject.getLong("id"));
            entity.set("costobject_id", (Object)costObject.getLong("id"));
            ++addNum;
            if ("sfc_reportresource_adjust".equals(sourceBill)) {
                this.updateMaterialInfo(targetBill, costObject);
            }
            targetBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("createtime", (Object)TimeServiceHelper.now());
            targetBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("modifytime", (Object)TimeServiceHelper.now());
            targetBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("auditdate", (Object)TimeServiceHelper.now());
            resourceBills.add(targetBill);
        }
        this.getResourceUseContext().setAddCount(this.getResourceUseContext().getAddCount() + addNum);
        this.getResourceUseContext().setDelCount(this.getResourceUseContext().getDelCount() + delNum);
        this.getResourceUseContext().getImportBillList().addAll(resourceBills);
        logger.info("\u65b0\u589e\u7684\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355:{}", (Object)resourceBills.size());
        return resourceBills;
    }

    private static Map<Long, Boolean> getMaterialMap(Long acctOrg, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, TreeMap<String, String> collConfigRuleMappingMap, Map<Long, Long> manuToMaterialMap) {
        HashSet<Long> materialIds = new HashSet<Long>(10);
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBills : srcAndTargetBillsMap.entrySet()) {
            DynamicObject srcBillDyn = srcAndTargetBills.getKey();
            DynamicObject targetBillDyn = srcAndTargetBills.getValue();
            Long materialId = 0L;
            if (targetBillDyn.containsProperty("costobject") && !CadEmptyUtils.isEmpty((DynamicObjectCollection)targetBillDyn.getDynamicObjectCollection("entryentity")) && ((DynamicObject)targetBillDyn.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("costobject") != null || !collConfigRuleMappingMap.containsKey("material") || CadEmptyUtils.isEmpty((String)collConfigRuleMappingMap.get("material"))) continue;
            String material1Field = collConfigRuleMappingMap.get("material");
            materialId = "sumentry.manufactureentryid".equals(collConfigRuleMappingMap.get("material")) ? manuToMaterialMap.get(srcBillDyn.get(material1Field)) : Long.valueOf(Long.parseLong(srcBillDyn.get(material1Field).toString()));
            materialIds.add(materialId);
        }
        Map materialMap = CostObjectHelper.getAssistMap(materialIds, (Long)acctOrg);
        return materialMap;
    }

    private static String getCostObjectHashCodeBySrcBillForPz(DynamicObject srcBill, TreeMap<String, String> collConfigRuleMappingMap, Map<Long, Long> manuToMaterialMap, Map<Long, Boolean> materialMap) {
        String material1Field;
        String strRes = "";
        if (CadEmptyUtils.isEmpty(collConfigRuleMappingMap)) {
            return strRes;
        }
        Long materialId = 0L;
        Long version = 0L;
        Long auxpty = 0L;
        if (collConfigRuleMappingMap.containsKey("material") && !CadEmptyUtils.isEmpty((String)(material1Field = collConfigRuleMappingMap.get("material")))) {
            materialId = material1Field.equals("sumentry.manufactureentryid") ? manuToMaterialMap.get(srcBill.get(material1Field)) : Long.valueOf(Long.parseLong(srcBill.get(material1Field).toString()));
            String versionField = collConfigRuleMappingMap.get("bomversion");
            String auxptyField = collConfigRuleMappingMap.get("auxpty");
            DynamicObject material = CostObjectHelper.getMaterialById((Long)materialId);
            if (material != null) {
                boolean isenablematerialversion;
                boolean isuseauxpty = material.getBoolean("isuseauxpty");
                if (isuseauxpty && !CadEmptyUtils.isEmpty((String)auxptyField)) {
                    long auxId = srcBill.getLong(auxptyField);
                    DynamicObject auxptyObj = BusinessDataServiceHelper.loadSingleFromCache((Object)auxId, (String)"bd_flexauxprop");
                    auxpty = CostObjectHelper.getEffectCostAuxptyNew((DynamicObject)material, (DynamicObject)auxptyObj, materialMap, (String)CostObjectEnum.BIZTYPE_PZ.getValue());
                }
                if ((isenablematerialversion = material.getBoolean("isenablematerialversion")) && !CadEmptyUtils.isEmpty((String)versionField)) {
                    version = srcBill.getLong(versionField);
                }
            }
        }
        for (Map.Entry<String, String> configRule : collConfigRuleMappingMap.entrySet()) {
            String costField = configRule.getKey();
            String srcField = configRule.getValue();
            if (CadEmptyUtils.isEmpty((String)strRes)) {
                if ("material".equals(costField)) {
                    strRes = String.valueOf(materialId);
                    continue;
                }
                if ("bomversion".equals(costField)) {
                    strRes = String.valueOf(version);
                    continue;
                }
                if ("auxpty".equals(costField)) {
                    strRes = String.valueOf(auxpty);
                    continue;
                }
                strRes = srcBill.getString(srcField);
                continue;
            }
            if ("material".equals(costField)) {
                strRes = strRes + "@" + materialId;
                continue;
            }
            if ("bomversion".equals(costField)) {
                strRes = strRes + "@" + version;
                continue;
            }
            if ("auxpty".equals(costField)) {
                strRes = strRes + "@" + auxpty;
                continue;
            }
            strRes = strRes + "@" + srcBill.getString(srcField);
        }
        return strRes;
    }
}

