/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.resourceuse;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.config.costcenter.CostCenterRelationService;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.engine.CollConifgContext;
import kd.macc.cad.business.config.engine.CollConifgParam;
import kd.macc.cad.business.config.engine.IBillTransfer;
import kd.macc.cad.business.config.engine.filter.CollConfigFilterService;
import kd.macc.cad.business.config.engine.helper.CollectEngineHelper;
import kd.macc.cad.business.config.engine.mapping.CollConfigMappingService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.BgParamEnum;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.ResourceAbsorbHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.BatchUtils;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MaterialPropHelper;
import kd.macc.cad.mservice.resourceuse.AbstractResourceUseAction;
import kd.macc.cad.mservice.resourceuse.CompletionSaveAction;
import kd.macc.cad.mservice.resourceuse.IResourceUseAction;
import kd.macc.cad.mservice.resourceuse.ResourceCheckAbsorbAction;
import kd.macc.cad.mservice.resourceuse.ResourceImportDataConfigAction;
import kd.macc.cad.mservice.resourceuse.ResourceImportDataForCUConfigAction;
import kd.macc.cad.mservice.resourceuse.ResourceImportDataForPZConfigAction;
import kd.macc.cad.mservice.resourceuse.ResourceUseArgs;
import kd.macc.cad.mservice.resourceuse.ResourceUseContext;
import kd.macc.cad.mservice.resourceuse.ScaResourceWriteCostChangeConfigAction;

public class ResourceTransferAction
extends AbstractResourceUseAction {
    private static final Log logger = LogFactory.getLog(ResourceTransferAction.class);
    private CollConifgContext configContext = new CollConifgContext();
    private List<DynamicObject> collConfigList = new ArrayList<DynamicObject>();
    private CollConfigFilterService filterService;
    private CollConfigMappingService mappingService;
    private CostCenterRelationService costCenterRelationService;

    @Override
    protected void doExecute() {
        ResourceUseContext context = this.getResourceUseContext();
        ResourceUseArgs collectionArgs = context.getResourceUseArgs();
        List<Long> manuOrgs = collectionArgs.getManuOrgs();
        CollectReport collectReport = context.getCollectReport();
        Long[] manuOrgIds = new Long[]{};
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            manuOrgIds = manuOrgs.toArray(new Long[0]);
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u6e90\u5355\u8f6c\u6362\u4e3a\u76ee\u6807\u5355\u3002", (String)"ResourceTransferAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), 2, 7, false);
        List<IResourceUseAction> resourceUseActions = this.initializeActions(collectionArgs.getAppNum());
        this.configContext = new CollConifgContext();
        CollConifgParam param = new CollConifgParam();
        param.setAppnum(collectionArgs.getAppNum());
        param.setCalOrgId(collectionArgs.getAcctOrgId());
        param.setCostAccountId(null);
        param.setManuOrgIds(manuOrgIds);
        param.setCostCenterIds(collectionArgs.getCostCenterIds().toArray(new Long[0]));
        param.setTargetEntity("sca_resourceuse");
        this.configContext.setParam(param);
        HashSet<Long> allCollconfigIds = new HashSet<Long>(10);
        allCollconfigIds.add(0L);
        this.collConfigList = this.getValidCollConfigList(context, "sca_resourceuse", allCollconfigIds);
        if (!CadEmptyUtils.isEmpty(this.collConfigList)) {
            this.mappingService = new CollConfigMappingService();
            this.filterService = new CollConfigFilterService();
            this.costCenterRelationService = new CostCenterRelationService();
            Map collConfigMappingMap = this.mappingService.getCollConfigMappingMap(this.collConfigList);
            Map collSelectValueMappingMap = this.mappingService.getCollSelectValueMappingMap(this.collConfigList);
            Map collConfigRuleMappingMap = this.mappingService.getCollConfigRuleMappingMap(this.collConfigList);
            Map collConfigFilterMap = this.filterService.getCollConfigFilterMap(this.collConfigList);
            List importScopeDate = SysParamHelper.getImportScopeDate((Long)context.getResourceUseArgs().getAcctOrgId(), (String)context.getResourceUseArgs().getAppNum());
            Map costCenterSourceDataMap = this.costCenterRelationService.getCostCenterSourceDataMap(context.getResourceUseArgs().getCostCenterIds().toArray(new Long[0]), importScopeDate);
            this.configContext.setCostCenterSourceDataMap(costCenterSourceDataMap);
            HashMap costCentersourceTypeDataMap = new HashMap(16);
            costCenterSourceDataMap.forEach((ccs, obj) -> {
                String[] srcDataStr = ccs.split("@");
                if (srcDataStr.length < 2) {
                    return;
                }
                String sourceType = srcDataStr[0];
                Long sourceData = Long.parseLong(srcDataStr[1]);
                costCentersourceTypeDataMap.computeIfAbsent(sourceType, p -> new HashSet(10)).add(sourceData);
            });
            Boolean isOldUserForSysParamBizRange = ImportServiceHelper.isOldUserForSysParamBizRange();
            Map<String, List<Long>> billRangeMap = isOldUserForSysParamBizRange != false ? this.getBillRangeMap(context.getResourceUseArgs().getAcctOrgId(), context.getResourceUseArgs().getCostCenterIds(), "sca_resourceuse", context.getResourceUseArgs().getAppNum(), context.getCollectReport()) : null;
            context.getCollConfigMappingMap().putAll(collConfigMappingMap);
            context.getCollConfigRuleMappingMap().putAll(collConfigRuleMappingMap);
            boolean disableCollectReport = CollectReportHelper.disableCollectReport();
            this.delHistoryCollConfigData(this.collConfigList, collectionArgs, collConfigRuleMappingMap, allCollconfigIds);
            for (DynamicObject config : this.collConfigList) {
                Map<Long, Long> existsEntryIdResourceMap;
                String selectField;
                this.getResourceUseContext().getNeedDelIdSet().clear();
                this.getResourceUseContext().getEntryIdIdMap().clear();
                this.getResourceUseContext().getImportBillList().clear();
                this.getResourceUseContext().getResourceAbsorbList().clear();
                long configId = config.getLong("id");
                String targetBillEntity = config.getString("costbill.id");
                String sourceBillEntity = config.getString("sourcebill.id");
                DataSet existsResourceUseBill = this.getExistsResourceUseBill(collectionArgs.getAcctOrgId(), collectionArgs.getCostCenterIds(), collectionArgs.getManuOrgs(), collectionArgs.getMftOrderEntryIds(), (Map)collConfigRuleMappingMap.get(config.getLong("id")), sourceBillEntity, targetBillEntity, collectionArgs.getAppNum(), collectionArgs.getCollectParamMap(), configId, null);
                if (existsResourceUseBill != null && !existsResourceUseBill.isEmpty()) {
                    ResourceCheckAbsorbAction resourceCheckAbsorbAction = new ResourceCheckAbsorbAction(existsResourceUseBill.copy());
                    resourceCheckAbsorbAction.setContext(context);
                    resourceCheckAbsorbAction.execute();
                }
                String subEntityName = "";
                String entityName = "";
                Map fieldMappingMap = (Map)collConfigMappingMap.get(configId);
                if (!CadEmptyUtils.isEmpty((Map)fieldMappingMap)) {
                    block12: for (String value : fieldMappingMap.values()) {
                        String[] split = org.apache.commons.lang3.StringUtils.split((String)value, (String)",");
                        if (CadEmptyUtils.isEmpty((String)entityName) && value.contains(".")) {
                            entityName = value.split("\\.")[0];
                        }
                        for (String fieldName : split) {
                            String[] fieldNames = org.apache.commons.lang3.StringUtils.split((String)fieldName, (String)".");
                            if (!CadEmptyUtils.isEmpty((String)subEntityName) || fieldNames.length <= 2 || !fieldNames[1].contains("entry")) continue;
                            subEntityName = fieldNames[0].concat(".").concat(fieldNames[1]);
                            continue block12;
                        }
                    }
                }
                Map selectValueMappingMap = (Map)collSelectValueMappingMap.get(configId);
                Map ruleMappingMap = (Map)collConfigRuleMappingMap.get(configId);
                if (isOldUserForSysParamBizRange.booleanValue() && billRangeMap != null && !billRangeMap.containsKey("norange")) {
                    if (!billRangeMap.containsKey(sourceBillEntity)) {
                        logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u4e0d\u5728\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\u8bbe\u7f6e\u7684\u5f52\u96c6\u5355\u636e\u8303\u56f4\u5185");
                        continue;
                    }
                    List<Long> ccsIds = billRangeMap.get(sourceBillEntity);
                    if (CadEmptyUtils.isEmpty(ccsIds)) {
                        logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\uff0c\u6ca1\u6709\u9700\u8981\u5f52\u96c6\u7684\u6210\u672c\u4e2d\u5fc3");
                        continue;
                    }
                    this.configContext.getParam().setCostCenterIds(ccsIds.toArray(new Long[0]));
                }
                List collConfigFilter = ImportServiceHelper.getSrcQFilters((Long)this.configContext.getParam().getCalOrgId(), Arrays.asList(this.configContext.getParam().getCostCenterIds()), Arrays.asList(this.configContext.getParam().getManuOrgIds()), (DynamicObject)config, (Map)collConfigFilterMap, (Map)fieldMappingMap, (Map)selectValueMappingMap, costCentersourceTypeDataMap, collectionArgs.getMftOrderEntryIds(), collectionArgs.getCollectParamMap(), (Long)this.configContext.getParam().getCostAccountId(), (Long)this.configContext.getParam().getCurPeriodId(), (String)this.configContext.getParam().getAppnum(), (Map)this.configContext.getConfigProEntryIdWorkCenterMap(), (CollectReport)collectReport);
                String selectFields = CollectEngineHelper.getSrcSelectFields((DynamicObject)config, (Map)fieldMappingMap, (Map)ruleMappingMap);
                if (CadEmptyUtils.isEmpty((String)selectFields)) continue;
                logger.info("\u67e5\u8be2\u6e90\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", (Object)collConfigFilter);
                if (!CadEmptyUtils.isEmpty((String)subEntityName)) {
                    subEntityName = subEntityName.concat(".id");
                    selectField = "id,auditdate,".concat(subEntityName);
                } else if (!CadEmptyUtils.isEmpty((String)entityName)) {
                    subEntityName = entityName.concat(".id");
                    selectField = "id,auditdate,".concat(subEntityName);
                } else {
                    subEntityName = "id";
                    selectField = "id,auditdate";
                }
                DataSet sourceBills = QueryServiceHelper.queryDataSet((String)"ResourceTransferAction_doExecute", (String)sourceBillEntity, (String)selectField, (QFilter[])collConfigFilter.toArray(new QFilter[0]), (String)"id desc");
                logger.info("\u8d44\u6e90\u5dee\u91cf\u5f52\u96c6\u5224\u65ad:\u5f52\u96c6\u62a5\u544a\u5f00\u542f\u72b6\u6001{}", (Object)disableCollectReport);
                long diffTime = System.currentTimeMillis();
                if (!disableCollectReport) {
                    DataSet notChangeDs;
                    boolean isChanged = this.checkConfigChanged(config, targetBillEntity);
                    logger.info("\u8d44\u6e90\u5dee\u91cf\u5f52\u96c6\u5224\u65ad:\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u65b9\u6848:{},\u6539\u53d8\u72b6\u6001:{}", (Object)config.getString("number"), (Object)isChanged);
                    if (!(isChanged || existsResourceUseBill == null || existsResourceUseBill.isEmpty() || (notChangeDs = sourceBills.copy().join(existsResourceUseBill.copy(), JoinType.INNER).on(subEntityName, "srcentryid").on("auditdate", "nsrcauditdate").select(new String[]{subEntityName}, new String[]{"id as resourceUseId"}).finish()) == null || notChangeDs.isEmpty())) {
                        final HashSet<Long> sourceEntryIds = new HashSet<Long>(512);
                        final HashSet<Long> targetIds = new HashSet<Long>(512);
                        for (Row notChangeD : notChangeDs) {
                            sourceEntryIds.add(notChangeD.getLong(subEntityName));
                            targetIds.add(notChangeD.getLong("resourceUseId"));
                        }
                        logger.info("\u8d44\u6e90\u5dee\u91cf\u5f52\u96c6\u5224\u65ad\uff1a\u65b9\u6848\uff1a{}\u6709{}\u6761\u5206\u5f55\u6570\u636e\u672a\u6539\u53d8\uff0c\u5254\u9664", (Object)config.getString("number"), (Object)sourceEntryIds.size());
                        if (!sourceEntryIds.isEmpty()) {
                            final String finalEntryEntityName = subEntityName;
                            sourceBills = sourceBills.filter(new FilterFunction(){

                                public boolean test(Row row) {
                                    return !sourceEntryIds.contains(row.getLong(finalEntryEntityName));
                                }
                            });
                        }
                        if (!targetIds.isEmpty()) {
                            existsResourceUseBill = existsResourceUseBill.filter(new FilterFunction(){

                                public boolean test(Row row) {
                                    return !targetIds.contains(row.getLong("id"));
                                }
                            });
                        }
                    }
                }
                logger.info("\u8d44\u6e90\u5dee\u91cf\u5f52\u96c6\u5224\u65ad\uff1a\u5dee\u91cf\u5904\u7406,\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - diffTime));
                if (this.getResourceUseContext().getEntryIdIdMap().isEmpty() && !CadEmptyUtils.isEmpty(existsEntryIdResourceMap = this.entryIdResourceMap(existsResourceUseBill))) {
                    this.getResourceUseContext().getEntryIdIdMap().putAll(existsEntryIdResourceMap);
                }
                Integer batchSize = CadBgParamUtils.getCadParamForInt((String)BgParamEnum.RESOURCE_BATCH_SIZE.getKey(), (int)2000);
                List partitionIds = BatchUtils.batchDataByEntryId((DataSet)sourceBills, (Integer)batchSize, (String)subEntityName);
                logger.info("\u8d44\u6e90\u8017\u7528\u5f52\u96c6\u5206\u6279\uff1a\u65b9\u6848\u7f16\u53f7\uff1a{}\uff0c\u5206\u6279id\u7ed3\u675f\uff0c\u5171:{}\u6279", (Object)config.getString("number"), (Object)partitionIds.size());
                HashMap manuToMaterialMap = new HashMap(128);
                for (int i = 0; i < partitionIds.size(); ++i) {
                    this.getResourceUseContext().getImportBillList().clear();
                    this.getResourceUseContext().getResourceAbsorbList().clear();
                    this.getResourceUseContext().getNeedDelIdSet().clear();
                    this.getResourceUseContext().getConfigSrcAndTargetBillsMap().clear();
                    long start = TimeServiceHelper.now().getTime();
                    List entryIdList = (List)partitionIds.get(i);
                    logger.info("\u8d44\u6e90\u8017\u7528\u5f52\u96c6\u5206\u6279\uff1a\u5f00\u59cb\u5206\u6279\u4f5c\u4e1a:\u7b2c{}\u6279\uff0c\u5355\u636e\u6570\u91cf{}", (Object)i, (Object)entryIdList.size());
                    if (CadEmptyUtils.isEmpty((List)entryIdList)) continue;
                    QFilter entryIdQf = new QFilter(subEntityName, "in", (Object)entryIdList);
                    DynamicObjectCollection resResults = QueryServiceHelper.query((String)sourceBillEntity, (String)selectFields, (QFilter[])new QFilter[]{entryIdQf});
                    MaterialPropHelper.queryMaterialPropAndSet((DynamicObjectCollection)resResults, (String)selectFields);
                    if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)resResults) && sourceBillEntity.equals("sfc_reportresource_adjust") && CostObjectEnum.BIZTYPE_PZ.getValue().equals(config.getString("calmethod")) && selectFields.contains("sumentry.manufactureentryid")) {
                        HashSet manuEntryIds = new HashSet(128);
                        resResults.forEach(s -> {
                            if (s.containsProperty("sumentry.manufactureentryid")) {
                                manuEntryIds.add(s.getLong("sumentry.manufactureentryid"));
                            }
                        });
                        if (!CadEmptyUtils.isEmpty(manuEntryIds)) {
                            QFilter filter = new QFilter("treeentryentity.id", "in", manuEntryIds);
                            DataSet pomDs = QueryServiceHelper.queryDataSet((String)"getPomInfo", (String)"pom_mftorder", (String)"treeentryentity.id entryid,treeentryentity.material.masterid as material", (QFilter[])filter.toArray(), null);
                            pomDs.forEach(s -> manuToMaterialMap.put(s.getLong("entryid"), s.getLong("material")));
                            this.configContext.getManuToMaterialMap().putAll(manuToMaterialMap);
                            collectionArgs.getManuToMaterialMap().putAll(manuToMaterialMap);
                        }
                    }
                    IBillTransfer billTransfer = IBillTransfer.getTransferInstance((String)"sca_resourceuse", (String)this.getResourceUseContext().getResourceUseArgs().getAppNum());
                    BillTransferResult result = billTransfer.doTransfer((DynamicObject[])resResults.toArray((Object[])new DynamicObject[0]), config, this.configContext);
                    logger.info("\u8d44\u6e90\u8017\u7528\u5f52\u96c6\u5206\u6279\uff1a\u8f6c\u6362\u7ed3\u679c\uff1a{},\u8017\u65f6:{}", (Object)context.getConfigSrcAndTargetBillsMap().size(), (Object)(TimeServiceHelper.now().getTime() - start));
                    context.getConfigSrcAndTargetBillsMap().put(config, result.getSrcAndTargetBillsMap());
                    try (TXHandle txHandle = TX.requiresNew();){
                        try {
                            for (IResourceUseAction resourceUseAction : resourceUseActions) {
                                long actionTime = System.currentTimeMillis();
                                resourceUseAction.setContext(context);
                                resourceUseAction.execute();
                                logger.info("\u8d44\u6e90\u8017\u7528\u5f52\u96c6\u5206\u6279\uff1a\u8d44\u6e90\u8017\u7528\u5f52\u96c6\u5f15\u5165-action\uff1a{},\u8017\u65f6\uff1a{}ms", (Object)resourceUseAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                            }
                        }
                        catch (Exception e) {
                            txHandle.markRollback();
                            logger.error("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u6279\u6b21\u4fdd\u5b58\u5931\u8d25\uff0c\u56de\u6eda\u3002\u6279\u6b21:{}", (Object)i);
                            throw e;
                        }
                    }
                    long end = TimeServiceHelper.now().getTime();
                    logger.info("\u8d44\u6e90\u8017\u7528\u5f52\u96c6\u5206\u6279\uff1a\u7b2c{}\u6279\u4f5c\u4e1a\u7ed3\u675f,\u8017\u65f6\uff1a{}", (Object)i, (Object)(end - start));
                }
                this.getResourceUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\uff0c\u6570\u636e\u5904\u7406\u5b8c\u6210\u3002", (String)"ResourceTransferAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                int delNum = this.deleteResourceBillForNoSource(this.getResourceUseContext().getEntryIdIdMap(), config.getString("number"));
                this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"ResourceTransferAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]), delNum));
            }
            this.getResourceUseContext().getImportBillList().clear();
            this.getResourceUseContext().getConfigSrcAndTargetBillsMap().clear();
            this.getResourceUseContext().getResourceAbsorbList().clear();
            this.getResourceUseContext().getNeedDelIdSet().clear();
            this.getResourceUseContext().getEntryIdIdMap().clear();
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"ResourceTransferAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
    }

    private void delHistoryCollConfigData(List<DynamicObject> collConfigList, ResourceUseArgs collectionArgs, Map<Long, Map<String, String>> collConfigRuleMappingMap, Set<Long> allCollconfigIds) {
        if (collConfigList.isEmpty()) {
            return;
        }
        DynamicObject config = collConfigList.get(0);
        String targetBillEntity = config.getString("costbill.id");
        String sourceBillEntity = config.getString("sourcebill.id");
        DataSet existsMatUseBill = this.getExistsResourceUseBill(collectionArgs.getAcctOrgId(), collectionArgs.getCostCenterIds(), collectionArgs.getManuOrgs(), collectionArgs.getMftOrderEntryIds(), collConfigRuleMappingMap.get(config.getLong("id")), sourceBillEntity, targetBillEntity, collectionArgs.getAppNum(), collectionArgs.getCollectParamMap(), -1L, allCollconfigIds);
        if (existsMatUseBill == null || existsMatUseBill.isEmpty()) {
            return;
        }
        Map<Long, Long> existsEntryIdCompleteMap = this.entryIdResourceMap(existsMatUseBill);
        logger.info("\u9700\u8981\u5220\u9664\u7684\u5386\u53f2\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u7684\u5355\u636e\u6570\u91cf\uff1a{}", (Object)existsEntryIdCompleteMap.size());
        if (!CadEmptyUtils.isEmpty(existsEntryIdCompleteMap)) {
            this.getResourceUseContext().getEntryIdIdMap().putAll(existsEntryIdCompleteMap);
        }
        int delNum = this.deleteResourceBillForNoSource(this.getResourceUseContext().getEntryIdIdMap(), ResManager.loadKDString((String)"\u5386\u53f2\u65b9\u6848", (String)"ResourceTransferAction_8", (String)"macc-cad-mservice", (Object[])new Object[0]));
        this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5386\u53f2\u65b9\u6848\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"ResourceTransferAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]), delNum));
    }

    private List<IResourceUseAction> initializeActions(String appNum) {
        ArrayList<IResourceUseAction> resourceUseActions = new ArrayList<IResourceUseAction>(8);
        switch (appNum) {
            case "sca": {
                resourceUseActions.add(new ResourceImportDataConfigAction());
                resourceUseActions.add(new ResourceImportDataForCUConfigAction());
                resourceUseActions.add(new ScaResourceWriteCostChangeConfigAction());
                resourceUseActions.add(new CompletionSaveAction());
                break;
            }
            case "aca": {
                resourceUseActions.add(new ResourceImportDataConfigAction());
                resourceUseActions.add(new ResourceImportDataForPZConfigAction());
                resourceUseActions.add(new ResourceImportDataForCUConfigAction());
                resourceUseActions.add(new CompletionSaveAction());
                break;
            }
        }
        return resourceUseActions;
    }

    public List<DynamicObject> getValidCollConfigList(ResourceUseContext context, String targetEntity, Set<Long> collconfigIds) {
        if (this.collConfigList != null && this.collConfigList.size() > 0) {
            return this.collConfigList;
        }
        ArrayList<DynamicObject> values = new ArrayList<DynamicObject>(context.getRulesMap().values());
        HashSet<String> calMethodTypes = new HashSet<String>(10);
        for (Map.Entry<String, DynamicObject> ruleMap : context.getRulesMap().entrySet()) {
            String key = ruleMap.getKey();
            String[] split = key.split("@");
            if (split.length == 3) {
                calMethodTypes.add(split[1]);
                continue;
            }
            if (split.length != 4) continue;
            calMethodTypes.add(split[2]);
        }
        HashSet calcDimensionIds = new HashSet(10);
        values.forEach(p -> calcDimensionIds.add(p.getLong("costcalcdimension")));
        return ImportServiceHelper.getCollConfigs((Long)context.getResourceUseArgs().getAcctOrgId(), null, calMethodTypes, calcDimensionIds, (String)targetEntity, (String)context.getResourceUseArgs().getAppNum(), collconfigIds);
    }

    private Map<String, List<Long>> getBillRangeMap(Long accountOrg, List<Long> costCenters, String targetEntity, String appNum, CollectReport collectReport) {
        Map<String, List<Long>> billRangeMap = new HashMap<String, List<Long>>(16);
        if (CadEmptyUtils.isEmpty((String)targetEntity)) {
            return billRangeMap;
        }
        switch (targetEntity) {
            case "cad_plannedoutputbill": {
                if ("aca".equals(appNum)) {
                    billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"plancollectrange", (String)appNum, (CollectReport)collectReport);
                    break;
                }
                billRangeMap.put("norange", new ArrayList());
                break;
            }
            case "cad_factnedoutputbill": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"billrange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"matcollectrange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            case "sca_resourceuse": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"resourcerange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            default: {
                billRangeMap.put("norange", new ArrayList());
            }
        }
        return billRangeMap;
    }

    protected int deleteResourceBillForNoSource(Map<Long, Long> idEntryIdCompleteMap, String configNumber) {
        if (CadEmptyUtils.isEmpty(idEntryIdCompleteMap)) {
            return 0;
        }
        HashSet<Long> deleteSrcData = new HashSet<Long>(10);
        for (Map.Entry<Long, Long> entryIdIdEntry : idEntryIdCompleteMap.entrySet()) {
            Long resourceUseId = entryIdIdEntry.getValue();
            deleteSrcData.add(resourceUseId);
        }
        this.getResourceUseContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u4e2d\uff0c\u662f\u5426\u6709\u9700\u8981\u5220\u9664\u7684\u5355\u636e\uff1f", (String)"ResourceTransferAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]), configNumber));
        Set delIds = ResourceAbsorbHelper.delOrRevertEntity(deleteSrcData, (String)"sca_resourceuse", (String)this.getResourceUseContext().getResourceUseArgs().getAppNum(), new HashSet(0), (Set)Sets.newHashSet((Object[])new String[]{"facthour", "factuse"}));
        this.getResourceUseContext().setDelCount(this.getResourceUseContext().getDelCount() + delIds.size());
        this.delChangeRecord(deleteSrcData);
        this.getResourceUseContext().setDelCount(delIds.size());
        this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"ResourceTransferAction_11", (String)"macc-cad-mservice", (Object[])new Object[0]), delIds.size()));
        return delIds.size();
    }

    private boolean checkConfigChanged(DynamicObject config, String entityId) {
        QFilter appNumQf;
        QFilter colObjQf;
        if (StringUtils.isEmpty((String)entityId)) {
            return true;
        }
        Date modifyTime = config.getDate("modifytime");
        String appNum = config.getString("appnum");
        QFilter orgQf = new QFilter("org", "=", (Object)this.getResourceUseContext().getResourceUseArgs().getAcctOrgId());
        DynamicObjectCollection collectReports = QueryServiceHelper.query((String)"cad_colreport", (String)"coldate", (QFilter[])new QFilter[]{orgQf, colObjQf = new QFilter("colobj", "=", (Object)"resource"), appNumQf = new QFilter("appnum", "=", (Object)appNum)}, (String)"coldate desc", (int)1);
        if (collectReports != null && collectReports.size() > 0) {
            return ((DynamicObject)collectReports.get(0)).getDate("coldate").compareTo(modifyTime) <= 0;
        }
        return true;
    }

    private DataSet getExistsResourceUseBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, List<Long> mftOrderEntryIds, Map<String, String> configRuleMappingMap, String srcBillType, String entityId, String appNum, Map<String, Object> collectParamMap, long configId, Set<Long> allCollconfigIds) {
        if (CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            return this.getExistsResourceUseBill(org, methodCostCenters, manuOrgs, srcBillType, entityId, appNum, collectParamMap, configId, allCollconfigIds);
        }
        if (CadEmptyUtils.isEmpty((String)configRuleMappingMap.get("probill"))) {
            return null;
        }
        QFilter orgQf = new QFilter("org", "in", (Object)org);
        if (allCollconfigIds != null) {
            orgQf.and("collconfig", "not in", allCollconfigIds);
        } else {
            orgQf.and("collconfig", "=", (Object)configId);
            orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
        }
        QFilter costObjectQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter sourceBillQf = new QFilter("entryentity.costobject.probill", "in", mftOrderEntryIds);
        QFilter appnumQf = new QFilter("appnum", "=", (Object)appNum);
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        QFilter voucherTypeQf = new QFilter("vouchertype", "=", (Object)" ");
        QFilter createDateQf = new QFilter("createtime", "<", (Object)this.getResourceUseContext().getCollectReport().getCollectDate());
        return QueryServiceHelper.queryDataSet((String)"ResourceTransferAction_getExistsResourceUseBill", (String)entityId, (String)"id,srcbillid,srcentryid,nsrcauditdate", (QFilter[])new QFilter[]{orgQf, costObjectQf, sourceBillQf, bookDateQf, appnumQf, createDateQf, voucherTypeQf}, (String)"id desc");
    }

    protected DataSet getExistsResourceUseBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, String srcBillType, String entityId, String appNum, Map<String, Object> collectParamMap, long configId, Set<Long> allCollconfigIds) {
        QFilter orgQf = new QFilter("org", "in", (Object)org);
        if (allCollconfigIds != null) {
            orgQf.and("collconfig", "not in", allCollconfigIds);
        } else {
            orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
            orgQf.and(new QFilter("collconfig", "=", (Object)configId));
        }
        QFilter costObjectQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter voucherTypeQf = new QFilter("vouchertype", "=", (Object)" ");
        QFilter appnumQf = new QFilter("appnum", "=", (Object)appNum);
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            orgQf.and(new QFilter("manuorg", "in", manuOrgs));
        }
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        if (!CadEmptyUtils.isEmpty(collectParamMap) && collectParamMap.get("startDate") != null && collectParamMap.get("endDate") != null) {
            QFilter collectTimeQFilter = new QFilter("bookdate", ">=", collectParamMap.get("startDate"));
            collectTimeQFilter.and(new QFilter("bookdate", "<=", collectParamMap.get("endDate")));
            bookDateQf.and(collectTimeQFilter);
        }
        QFilter createDateQf = new QFilter("createtime", "<", (Object)this.getResourceUseContext().getCollectReport().getCollectDate());
        return QueryServiceHelper.queryDataSet((String)"ResourceTransferAction_getExistsResourceUseBill", (String)entityId, (String)"id,srcbillid,srcentryid,nsrcauditdate", (QFilter[])new QFilter[]{orgQf, costObjectQf, bookDateQf, appnumQf, createDateQf, voucherTypeQf}, (String)"id desc");
    }
}

