/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.resourceuse;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.CollectDiff;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.DiffHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.resourceuse.AbstractResourceUseAction;

public class ResourceUseDiffAction
extends AbstractResourceUseAction {
    private final Log logger = LogFactory.getLog(ResourceUseDiffAction.class);
    private List<Long> roCostCenters = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzCostCenters = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> notRoWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> notRoOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> notRoAdmin = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> roWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> roOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> roAdmin = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzAdmin = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> selectedWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> selectedOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> selectedAdminOrg = Lists.newArrayListWithExpectedSize((int)8);
    private Map<Long, String> costCenterNameMap = Maps.newHashMapWithExpectedSize((int)32);

    @Override
    protected void doExecute() {
        if (!CollectReportHelper.disableCollectReport() && CadEmptyUtils.isEmpty(this.getResourceUseContext().getResourceUseArgs().getMftOrderEntryIds())) {
            List flmCostCenters;
            List fpmCostCenters;
            List pzmCostCenters;
            Map calMethodCostCenters;
            String appNum;
            CollectReport collectReport = this.getResourceUseContext().getCollectReport();
            Long orgId = this.getResourceUseContext().getCollectReport().getOrg();
            QFilter timeQf = DiffHelper.getCollectTimeRange((Long)orgId, (String)"bookdate", (String)(appNum = this.getResourceUseContext().getCollectReport().getAppNum()), (CollectReport)collectReport);
            if (timeQf == null) {
                this.logger.info("\u672a\u83b7\u53d6\u5230\u6838\u7b97\u7ec4\u7ec7\u914d\u7f6e\u7684\u5f52\u96c6\u65f6\u95f4\u8303\u56f4");
                return;
            }
            this.getResourceUseContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u68c0\u67e5\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5dee\u5f02", (String)"ResourceUseDiffAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            List enableCostCenters = DiffHelper.getEnableCostCenters((Long)orgId, (String)"cad_costobject", (String)appNum);
            List<Long> costCenters = this.getResourceUseContext().getResourceUseArgs().getCostCenterIds();
            List importScopeDate = SysParamHelper.getImportScopeDate((Long)orgId, (String)appNum);
            if (costCenters != null && !costCenters.isEmpty() && enableCostCenters.size() != costCenters.size()) {
                this.getResourceUseContext().setSingleSelected(true);
                this.selectedWc = CostCenterHelper.getWorkCenter(costCenters, (List)importScopeDate);
                this.selectedOrg = CostCenterHelper.getBosOrgs(costCenters, (List)importScopeDate);
                this.selectedAdminOrg = CostCenterHelper.getAdminOrg(costCenters, (List)importScopeDate);
            }
            if ((calMethodCostCenters = DiffHelper.getCalMethodCostCenters((Long)orgId, (String)"sca_matusecollect", (String)appNum)) == null || calMethodCostCenters.isEmpty()) {
                this.logger.info("\u672a\u83b7\u53d6\u5230\u8ba1\u7b97\u65b9\u6cd5\u4e0e\u6210\u672c\u4e2d\u5fc3\u7684\u5bf9\u5e94\u5173\u7cfb");
                return;
            }
            ArrayList allCostCenters = Lists.newArrayListWithExpectedSize((int)32);
            ArrayList fpflCostCenters = Lists.newArrayListWithExpectedSize((int)8);
            List roCostCenters = (List)calMethodCostCenters.get(orgId + CostObjectEnum.BIZTYPE_RO.getValue());
            if (roCostCenters != null && !roCostCenters.isEmpty()) {
                this.roCostCenters.addAll(roCostCenters);
                allCostCenters.addAll(roCostCenters);
                this.roWc = CostCenterHelper.getWorkCenter(this.roCostCenters, (List)importScopeDate, (CollectReport)collectReport);
                this.roOrg = CostCenterHelper.getBosOrgs(this.roCostCenters, (List)importScopeDate, (CollectReport)collectReport);
                this.roAdmin = CostCenterHelper.getAdminOrg(this.roCostCenters, (List)importScopeDate, (CollectReport)collectReport);
            }
            if ((pzmCostCenters = (List)calMethodCostCenters.get(orgId + CostObjectEnum.BIZTYPE_PZ.getValue())) != null && !pzmCostCenters.isEmpty()) {
                this.pzCostCenters.addAll(pzmCostCenters);
                allCostCenters.addAll(pzmCostCenters);
                this.pzWc = CostCenterHelper.getWorkCenter(this.pzCostCenters, (List)importScopeDate, (CollectReport)collectReport);
                this.pzOrg = CostCenterHelper.getBosOrgs(this.pzCostCenters, (List)importScopeDate, (CollectReport)collectReport);
                this.pzAdmin = CostCenterHelper.getAdminOrg(this.pzCostCenters, (List)importScopeDate, (CollectReport)collectReport);
            }
            if ((fpmCostCenters = (List)calMethodCostCenters.get(orgId + CostObjectEnum.BIZTYPE_SO.getValue())) != null && !fpmCostCenters.isEmpty()) {
                fpflCostCenters.addAll(fpmCostCenters);
                allCostCenters.addAll(fpmCostCenters);
            }
            if ((flmCostCenters = (List)calMethodCostCenters.get(orgId + CostObjectEnum.BIZTYPE_FL.getValue())) != null && !flmCostCenters.isEmpty()) {
                fpflCostCenters.addAll(flmCostCenters);
                allCostCenters.addAll(flmCostCenters);
            }
            if (fpflCostCenters != null && !fpflCostCenters.isEmpty()) {
                this.notRoWc = CostCenterHelper.getWorkCenter((Collection)fpflCostCenters, (List)importScopeDate, (CollectReport)collectReport);
                this.notRoOrg = CostCenterHelper.getBosOrgs((Collection)fpflCostCenters, (List)importScopeDate, (CollectReport)collectReport);
                this.notRoAdmin = CostCenterHelper.getAdminOrg((Collection)fpflCostCenters, (List)importScopeDate, (CollectReport)collectReport);
            }
            this.costCenterNameMap = DiffHelper.getCostCenterNameMap((List)allCostCenters);
            collectReport.setTimeQf(timeQf);
            Map costCenterRangeMap = DiffHelper.getCostCenterRangeBillMap((Long)orgId, (List)allCostCenters, (String)"resourcerange", (String)appNum);
            int gxhbDiff = this.diffGxhbData(costCenterRangeMap, appNum);
            int wwgxhbDiff = this.diffWwgxhbData(costCenterRangeMap, appNum);
            int hbzytzDiff = this.diffHbzytzData(costCenterRangeMap, appNum);
            int gdhbDiff = this.diffGdhbData(costCenterRangeMap, appNum);
            this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6c47\u62a5\u5355\u5dee\u5f02%1$s\u6761\u6570\u636e\uff0c\u6c47\u62a5\u8d44\u6e90\u8c03\u6574\u5355\u5dee\u5f02%2$s\u6761\u6570\u636e\u3002\u59d4\u5916\u5de5\u5e8f\u6c47\u62a5\u5355\u5dee\u5f02%3$s\u6761\u6570\u636e\uff0c\u5de5\u5355\u6c47\u62a5\u5355\u5dee\u5f02%4$s\u6761\u6570\u636e\u3002", (String)"ResourceUseDiffAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]), gxhbDiff, hbzytzDiff, wwgxhbDiff, gdhbDiff));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getResourceUseContext().getCollectReport().transfer2Dynamic()});
        }
    }

    private int diffWwgxhbData(Map<Long, String> costCenterRangeMap, String appNum) {
        ArrayList wwgxhbDiffs = Lists.newArrayListWithExpectedSize((int)8);
        DataSet wwgxhbData = this.getWwGxhbData();
        if (wwgxhbData != null && !wwgxhbData.isEmpty()) {
            HashSet ids = Sets.newHashSetWithExpectedSize((int)8);
            HashSet sourceBillEntryIds = Sets.newHashSetWithExpectedSize((int)8);
            DataSet copy = wwgxhbData.copy();
            for (Row row : copy) {
                ids.add(row.getLong("id"));
                sourceBillEntryIds.add(row.getLong("probillentryid"));
            }
            DataSet resourceData = this.getResourceUseData(ids, appNum);
            DataSet allData = wwgxhbData.leftJoin(resourceData).on("id", "srcbillid").select(wwgxhbData.getRowMeta().getFieldNames(), resourceData.getRowMeta().getFieldNames()).finish();
            DataSet unMatchedData = allData.filter("srcbillid is null or srcbillid=0").orderBy(new String[]{"id desc"});
            if (!unMatchedData.isEmpty()) {
                DataSet costObjDataSet = this.getCostObjDataSet(sourceBillEntryIds);
                if (!costObjDataSet.isEmpty()) {
                    unMatchedData = unMatchedData.removeFields(new String[]{"probill"});
                    unMatchedData = unMatchedData.leftJoin(costObjDataSet).on("probillentryid", "probill").select(unMatchedData.getRowMeta().getFieldNames(), costObjDataSet.getRowMeta().getFieldNames()).finish();
                }
                for (Row row : unMatchedData) {
                    Map billNoReasonMap;
                    String srcErrorMsg;
                    String billStatus = row.getString("billstatus");
                    Long proBill = row.getLong("probill");
                    StringBuilder reasonStr = new StringBuilder();
                    CollectDiff collectDiff = new CollectDiff(row.getString("billno"), row.getInteger("seq"), row.getString("billtype"), row.getDate("bookdate"));
                    if (!"C".equals(billStatus)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"ResourceUseDiffAction_2", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (CadEmptyUtils.isEmpty((Long)proBill)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ResourceUseDiffAction_3", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (!StringUtils.isEmpty((Object)(srcErrorMsg = this.checkCostCenterSrc(costCenterRangeMap, row, "WGXHB", ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5e8f\u6c47\u62a5", (String)"ResourceUseDiffAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]))))) {
                        reasonStr.append(srcErrorMsg).append("\uff1b");
                    }
                    if (!(billNoReasonMap = this.getResourceUseContext().getErrorInfMap()).isEmpty() && billNoReasonMap.containsKey(row.getString("billno").concat("@").concat(row.getString("seq")))) {
                        reasonStr.append((String)billNoReasonMap.get(row.getString("billno").concat("@").concat(row.getString("seq"))));
                    }
                    collectDiff.setBillType(row.getString("billtype"));
                    if (reasonStr.length() > 0) {
                        collectDiff.setReason(reasonStr.toString());
                    } else {
                        collectDiff.setReason(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0", (String)"ResourceUseDiffAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    }
                    wwgxhbDiffs.add(collectDiff);
                }
            }
        }
        if (wwgxhbDiffs.size() > 0) {
            this.getResourceUseContext().getCollectReport().getCollectDiffs().addAll(wwgxhbDiffs);
            this.getResourceUseContext().getCollectReport().setError(true);
        }
        return wwgxhbDiffs.size();
    }

    private DataSet getWwGxhbData() {
        String appNum;
        Long orgId = this.getResourceUseContext().getResourceUseArgs().getAcctOrgId();
        List proOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)"sca_resourceuse", (String)(appNum = this.getResourceUseContext().getResourceUseArgs().getAppNum()));
        if (proOrgs == null || proOrgs.isEmpty()) {
            return null;
        }
        QFilter orgQf = new QFilter("org", "in", (Object)proOrgs);
        QFilter timeQf = this.getResourceUseContext().getCollectReport().getTimeQf();
        String selectFileds = "id, billno,-1 workcenter,org,productworkshop adminorg , billstatus, bookdate,sumentry.seq AS seq,sumentry.manufactureentryid AS probillentryid,0 probill,'wwgxhb' billtype";
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"om_processreport", (String)selectFileds, (QFilter[])new QFilter[]{orgQf, timeQf}, (String)"id asc");
    }

    private int diffGdhbData(Map<Long, String> costCenterRangeMap, String appNum) {
        ArrayList gdhbDiffs = Lists.newArrayListWithExpectedSize((int)8);
        DataSet gdhbData = this.getGdhbData();
        if ((gdhbData = gdhbData.select("id, billno,workcenter,org,adminorg,billstatus, bookdate,seq,cast(probillentryid as Long) probillentryid,probill,billtype")) != null && !gdhbData.isEmpty()) {
            HashSet ids = Sets.newHashSetWithExpectedSize((int)8);
            HashSet sourceBillEntryIds = Sets.newHashSetWithExpectedSize((int)8);
            DataSet copy = gdhbData.copy();
            for (Row row : copy) {
                ids.add(row.getLong("id"));
                sourceBillEntryIds.add(row.getLong("probillentryid"));
            }
            DataSet resourceData = this.getResourceUseData(ids, appNum);
            DataSet allData = gdhbData.leftJoin(resourceData).on("id", "srcbillid").select(gdhbData.getRowMeta().getFieldNames(), resourceData.getRowMeta().getFieldNames()).finish();
            DataSet unMatchedData = allData.filter("srcbillid is null or srcbillid=0").orderBy(new String[]{"id desc"});
            if (!unMatchedData.isEmpty()) {
                DataSet costObjDataSet = this.getCostObjDataSet(sourceBillEntryIds);
                if (!costObjDataSet.isEmpty()) {
                    unMatchedData = unMatchedData.removeFields(new String[]{"probill"});
                    unMatchedData = unMatchedData.leftJoin(costObjDataSet).on("probillentryid", "probill").select(unMatchedData.getRowMeta().getFieldNames(), costObjDataSet.getRowMeta().getFieldNames()).finish();
                }
                for (Row row : unMatchedData) {
                    Map billNoReasonMap;
                    String srcErrorMsg;
                    String billStatus = row.getString("billstatus");
                    Long proBill = row.getLong("probill");
                    StringBuilder reasonStr = new StringBuilder();
                    CollectDiff collectDiff = new CollectDiff(row.getString("billno"), row.getInteger("seq"), row.getString("billtype"), row.getDate("bookdate"));
                    if (!"C".equals(billStatus)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"ResourceUseDiffAction_2", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (CadEmptyUtils.isEmpty((Long)proBill)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ResourceUseDiffAction_3", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (!StringUtils.isEmpty((Object)(srcErrorMsg = this.checkCostCenterSrc(costCenterRangeMap, row, "MFTORDERREPORT", ResManager.loadKDString((String)"\u5de5\u5355\u6c47\u62a5\u5355", (String)"ResourceUseDiffAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]))))) {
                        reasonStr.append(srcErrorMsg).append("\uff1b");
                    }
                    if (!(billNoReasonMap = this.getResourceUseContext().getErrorInfMap()).isEmpty() && billNoReasonMap.containsKey(row.getString("billno").concat("@").concat(row.getString("seq")))) {
                        reasonStr.append((String)billNoReasonMap.get(row.getString("billno").concat("@").concat(row.getString("seq"))));
                    }
                    collectDiff.setBillType(row.getString("billtype"));
                    if (reasonStr.length() > 0) {
                        collectDiff.setReason(reasonStr.toString());
                    } else {
                        collectDiff.setReason(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0", (String)"ResourceUseDiffAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    }
                    gdhbDiffs.add(collectDiff);
                }
            }
        }
        if (gdhbDiffs.size() > 0) {
            this.getResourceUseContext().getCollectReport().getCollectDiffs().addAll(gdhbDiffs);
            this.getResourceUseContext().getCollectReport().setError(true);
        }
        return gdhbDiffs.size();
    }

    private int diffHbzytzData(Map<Long, String> costCenterRangeMap, String appNum) {
        ArrayList hbzytzDiffs = Lists.newArrayListWithExpectedSize((int)8);
        DataSet hbzytzData = this.getHbzytzData();
        if (hbzytzData != null && !hbzytzData.isEmpty()) {
            HashSet ids = Sets.newHashSetWithExpectedSize((int)8);
            HashSet sourceBillEntryIds = Sets.newHashSetWithExpectedSize((int)8);
            DataSet copy = hbzytzData.copy();
            for (Row row : copy) {
                ids.add(row.getLong("id"));
                sourceBillEntryIds.add(row.getLong("probillentryid"));
            }
            DataSet resourceData = this.getResourceUseData(ids, appNum);
            DataSet allData = hbzytzData.leftJoin(resourceData).on("id", "srcbillid").select(hbzytzData.getRowMeta().getFieldNames(), resourceData.getRowMeta().getFieldNames()).finish();
            DataSet unMatchedData = allData.filter("srcbillid is null or srcbillid=0").orderBy(new String[]{"id desc"});
            if (!unMatchedData.isEmpty()) {
                DataSet costObjDataSet = this.getCostObjDataSet(sourceBillEntryIds);
                if (!costObjDataSet.isEmpty()) {
                    unMatchedData = unMatchedData.removeFields(new String[]{"probill"});
                    unMatchedData = unMatchedData.leftJoin(costObjDataSet).on("probillentryid", "probill").select(unMatchedData.getRowMeta().getFieldNames(), costObjDataSet.getRowMeta().getFieldNames()).finish();
                }
                for (Row row : unMatchedData) {
                    Map billNoReasonMap;
                    String srcErrorMsg;
                    String billStatus = row.getString("billstatus");
                    Long proBill = row.getLong("probill");
                    Date compareDate = row.getDate("bookdate");
                    StringBuilder reasonStr = new StringBuilder();
                    CollectDiff collectDiff = new CollectDiff(row.getString("billno"), row.getInteger("seq"), row.getString("billtype"), row.getDate("bookdate"));
                    if (!"C".equals(billStatus)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"ResourceUseDiffAction_2", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (CadEmptyUtils.isEmpty((Long)proBill)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ResourceUseDiffAction_3", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (!StringUtils.isEmpty((Object)(srcErrorMsg = this.checkCostCenterSrc(costCenterRangeMap, row, "PROCESSADJUST", ResManager.loadKDString((String)"\u6c47\u62a5\u8d44\u6e90\u8c03\u6574\u5355", (String)"ResourceUseDiffAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]))))) {
                        reasonStr.append(srcErrorMsg).append("\uff1b");
                    }
                    if (!(billNoReasonMap = this.getResourceUseContext().getErrorInfMap()).isEmpty() && billNoReasonMap.containsKey(row.getString("billno").concat("@").concat(row.getString("seq")))) {
                        reasonStr.append((String)billNoReasonMap.get(row.getString("billno").concat("@").concat(row.getString("seq"))));
                    }
                    collectDiff.setBillType(row.getString("billtype"));
                    if (reasonStr.length() > 0) {
                        collectDiff.setReason(reasonStr.toString());
                    } else {
                        collectDiff.setReason(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0", (String)"ResourceUseDiffAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    }
                    hbzytzDiffs.add(collectDiff);
                }
            }
        }
        if (hbzytzDiffs.size() > 0) {
            this.getResourceUseContext().getCollectReport().getCollectDiffs().addAll(hbzytzDiffs);
            this.getResourceUseContext().getCollectReport().setError(true);
        }
        return hbzytzDiffs.size();
    }

    private int diffGxhbData(Map<Long, String> costCenterRangeMap, String appNum) {
        ArrayList gxhbDiffs = Lists.newArrayListWithExpectedSize((int)8);
        DataSet gxhbData = this.getGxhbData();
        if (gxhbData != null && !gxhbData.isEmpty()) {
            HashSet ids = Sets.newHashSetWithExpectedSize((int)8);
            HashSet sourceBillEntryIds = Sets.newHashSetWithExpectedSize((int)8);
            DataSet copy = gxhbData.copy();
            for (Row row : copy) {
                ids.add(row.getLong("id"));
                sourceBillEntryIds.add(row.getLong("probillentryid"));
            }
            DataSet resourceData = this.getResourceUseData(ids, appNum);
            DataSet allData = gxhbData.leftJoin(resourceData).on("id", "srcbillid").select(gxhbData.getRowMeta().getFieldNames(), resourceData.getRowMeta().getFieldNames()).finish();
            DataSet unMatchedData = allData.filter("srcbillid is null or srcbillid=0").orderBy(new String[]{"id desc"});
            if (!unMatchedData.isEmpty()) {
                DataSet costObjDataSet = this.getCostObjDataSet(sourceBillEntryIds);
                if (!costObjDataSet.isEmpty()) {
                    unMatchedData = unMatchedData.removeFields(new String[]{"probill"});
                    unMatchedData = unMatchedData.leftJoin(costObjDataSet).on("probillentryid", "probill").select(unMatchedData.getRowMeta().getFieldNames(), costObjDataSet.getRowMeta().getFieldNames()).finish();
                }
                for (Row row : unMatchedData) {
                    Map billNoReasonMap;
                    String srcErrorMsg;
                    String billStatus = row.getString("billstatus");
                    Long proBill = row.getLong("probill");
                    Date compareDate = row.getDate("bookdate");
                    StringBuilder reasonStr = new StringBuilder();
                    CollectDiff collectDiff = new CollectDiff(row.getString("billno"), row.getInteger("seq"), row.getString("billtype"), row.getDate("bookdate"));
                    if (!"C".equals(billStatus)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"ResourceUseDiffAction_2", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (CadEmptyUtils.isEmpty((Long)proBill)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ResourceUseDiffAction_3", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (!StringUtils.isEmpty((Object)(srcErrorMsg = this.checkCostCenterSrc(costCenterRangeMap, row, "PROCESSREPORT", ResManager.loadKDString((String)"\u5de5\u5e8f\u6c47\u62a5\u5355", (String)"ResourceUseDiffAction_8", (String)"macc-cad-mservice", (Object[])new Object[0]))))) {
                        reasonStr.append(srcErrorMsg).append("\uff1b");
                    }
                    if (!(billNoReasonMap = this.getResourceUseContext().getErrorInfMap()).isEmpty() && billNoReasonMap.containsKey(row.getString("billno").concat("@").concat(row.getString("seq")))) {
                        reasonStr.append((String)billNoReasonMap.get(row.getString("billno").concat("@").concat(row.getString("seq"))));
                    }
                    collectDiff.setBillType(row.getString("billtype"));
                    if (reasonStr.length() > 0) {
                        collectDiff.setReason(reasonStr.toString());
                    } else {
                        collectDiff.setReason(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0", (String)"ResourceUseDiffAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    }
                    gxhbDiffs.add(collectDiff);
                }
            }
        }
        if (gxhbDiffs.size() > 0) {
            this.getResourceUseContext().getCollectReport().getCollectDiffs().addAll(gxhbDiffs);
            this.getResourceUseContext().getCollectReport().setError(true);
        }
        return gxhbDiffs.size();
    }

    private String checkCostCenterSrc(Map<Long, String> costCenterRangeMap, Row row, String billId, String billName) {
        Long workCenter = row.getLong("workcenter");
        Long org = row.getLong("org");
        Long produceDept = row.getLong("adminorg");
        boolean workCenterFlag = this.roWc.contains(workCenter);
        if (!workCenterFlag && (this.pzWc.contains(workCenter) || this.notRoWc.contains(workCenter))) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u975e\u5de5\u5355\u5de5\u5355\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u4ec5\u652f\u6301\u5de5\u5355\u6cd5\u3002", (String)"ResourceUseDiffAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean orgFlag = this.roOrg.contains(org);
        if (!orgFlag && (this.pzOrg.contains(workCenter) || this.notRoOrg.contains(workCenter))) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u975e\u5de5\u5355\u5de5\u5355\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u4ec5\u652f\u6301\u5de5\u5355\u6cd5\u3002", (String)"ResourceUseDiffAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean adminOrgFlag = this.roAdmin.contains(produceDept);
        if (!adminOrgFlag && (this.pzAdmin.contains(workCenter) || this.notRoAdmin.contains(workCenter))) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u975e\u5de5\u5355\u5de5\u5355\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u4ec5\u652f\u6301\u5de5\u5355\u6cd5\u3002", (String)"ResourceUseDiffAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        if (workCenterFlag || orgFlag || adminOrgFlag) {
            Map srcCostCenterMap = this.getResourceUseContext().getCollectReport().getSrcCostCenterMap();
            Long cc = 0L;
            if (srcCostCenterMap != null && costCenterRangeMap != null) {
                if (srcCostCenterMap.containsKey(workCenter)) {
                    cc = (Long)srcCostCenterMap.get(workCenter);
                }
                if (srcCostCenterMap.containsKey(org)) {
                    cc = (Long)srcCostCenterMap.get(org);
                }
                if (srcCostCenterMap.containsKey(produceDept)) {
                    cc = (Long)srcCostCenterMap.get(produceDept);
                }
            }
            if (!CadEmptyUtils.isEmpty((Long)cc) && costCenterRangeMap != null) {
                String range = costCenterRangeMap.get(cc);
                if (CadEmptyUtils.isEmpty(costCenterRangeMap) || !StringUtils.isEmpty((Object)range) && range.indexOf(billId) == -1) {
                    String ccName = this.costCenterNameMap.get(cc);
                    if (!StringUtils.isEmpty((Object)ccName)) {
                        return String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6%2$s\u3002", (String)"ResourceUseDiffAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), ccName, billName);
                    }
                    return String.format(ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6%s\u3002", (String)"ResourceUseDiffAction_11", (String)"macc-cad-mservice", (Object[])new Object[0]), billName);
                }
            }
            if (this.getResourceUseContext().isSingleSelected()) {
                if (this.selectedWc.contains(workCenter) || this.selectedOrg.contains(org) || this.selectedAdminOrg.contains(produceDept)) {
                    return null;
                }
                return ResManager.loadKDString((String)"\u672a\u5339\u914d\u4e0a\u9009\u4e2d\u7684\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u8bf7\u9009\u62e9\u4e0d\u9650\u8fdb\u884c\u5bfc\u5165\u3002", (String)"ResourceUseDiffAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]);
            }
            return null;
        }
        return ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\u5339\u914d\u5931\u8d25\u3002", (String)"ResourceUseDiffAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]);
    }

    private DataSet getCostObjDataSet(Set<Long> entryIds) {
        String costObjFields = "probill";
        QFilter orgQf = new QFilter("org", "=", (Object)this.getResourceUseContext().getResourceUseArgs().getAcctOrgId());
        QFilter bizTypeQf = new QFilter("probill", "in", entryIds);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_costobject", (String)costObjFields, (QFilter[])new QFilter[]{orgQf, bizTypeQf}, null);
    }

    private DataSet getResourceUseData(Set<Long> ids, String appNum) {
        QFilter orgQf = new QFilter("org", "=", (Object)this.getResourceUseContext().getResourceUseArgs().getAcctOrgId());
        QFilter sourceIdQF = new QFilter("srcbillid", "in", ids);
        QFilter appNumQf = new QFilter("appnum", "=", (Object)appNum);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sca_resourceuse", (String)"srcbillid", (QFilter[])new QFilter[]{orgQf, sourceIdQF, appNumQf}, null);
    }

    private DataSet getHbzytzData() {
        String appNum;
        Long orgId = this.getResourceUseContext().getResourceUseArgs().getAcctOrgId();
        List proOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)"sca_resourceuse", (String)(appNum = this.getResourceUseContext().getResourceUseArgs().getAppNum()));
        if (proOrgs == null || proOrgs.isEmpty()) {
            return null;
        }
        QFilter orgQf = new QFilter("org", "in", (Object)proOrgs);
        QFilter timeQf = this.getResourceUseContext().getCollectReport().getTimeQf();
        String selectFileds = "id, billno,sumentry.workcenter workcenter,org,productworkshop adminorg , billstatus, bookdate,sumentry.seq AS seq,sumentry.manufactureentryid AS probillentryid,0 probill,'hbzytz' billtype";
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sfc_reportresource_adjust", (String)selectFileds, (QFilter[])new QFilter[]{orgQf, timeQf}, (String)"id asc");
    }

    private DataSet getGdhbData() {
        String appNum;
        Long orgId = this.getResourceUseContext().getResourceUseArgs().getAcctOrgId();
        List proOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)"sca_resourceuse", (String)(appNum = this.getResourceUseContext().getResourceUseArgs().getAppNum()));
        if (proOrgs == null || proOrgs.isEmpty()) {
            return null;
        }
        QFilter orgQf = new QFilter("org", "in", (Object)proOrgs);
        QFilter timeQf = this.getResourceUseContext().getCollectReport().getTimeQf();
        String selectFileds = "id, billno,sumentry.workcenter workcenter,org,sumentry.producedept adminorg,billstatus, bookdate,sumentry.seq AS seq,sumentry.mftentryid AS probillentryid,0 probill,'gdhb' billtype";
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pom_mftorderreport", (String)selectFileds, (QFilter[])new QFilter[]{orgQf, timeQf}, (String)"id asc");
    }

    private DataSet getGxhbData() {
        String appNum;
        Long orgId = this.getResourceUseContext().getResourceUseArgs().getAcctOrgId();
        List proOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)"sca_resourceuse", (String)(appNum = this.getResourceUseContext().getResourceUseArgs().getAppNum()));
        if (proOrgs == null || proOrgs.isEmpty()) {
            proOrgs = Lists.newArrayListWithExpectedSize((int)0);
        }
        QFilter orgQf = new QFilter("org", "in", (Object)proOrgs);
        QFilter timeQf = this.getResourceUseContext().getCollectReport().getTimeQf();
        String selectFileds = "id, billno,sumentry.workcenter workcenter,org,productworkshop adminorg , billstatus, bookdate,sumentry.seq AS seq,sumentry.manufactureentryid AS probillentryid,0 probill,'gxhb' billtype";
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sfc_processreportbill", (String)selectFileds, (QFilter[])new QFilter[]{orgQf, timeQf}, (String)"id asc");
    }

    @Override
    public void execute() {
        this.doExecute();
    }
}

